/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicity;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameterableElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.ReportTask;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.openide.util.NbBundle;

public class ClassData
extends ElementDataObject {
    IClassifier element;

    public ClassData() {
    }

    public ClassData(IClassifier iClassifier) {
        this.element = iClassifier;
    }

    public void setElement(IElement iElement) {
        if (iElement instanceof IClassifier) {
            this.element = (IClassifier)iElement;
        }
    }

    public IClassifier getElement() {
        return this.element;
    }

    public String getElementName() {
        return this.getElement().getName();
    }

    public IClassifier[] getSuperClasses() {
        ArrayList<IClassifier> arrayList = new ArrayList<IClassifier>();
        ETList eTList = this.getElement().getGeneralizations();
        for (int i = 0; i < eTList.size(); ++i) {
            IGeneralization iGeneralization = (IGeneralization)eTList.get(i);
            arrayList.add(iGeneralization.getGeneral());
        }
        IClassifier[] iClassifierArray = new IClassifier[arrayList.size()];
        return arrayList.toArray(iClassifierArray);
    }

    public IInterface[] getImplementedInterfaces() {
        ArrayList<IInterface> arrayList = new ArrayList<IInterface>();
        ETList eTList = this.getElement().getImplementations();
        for (int i = 0; i < eTList.size(); ++i) {
            arrayList.add(((IImplementation)eTList.get(i)).getContract());
        }
        IInterface[] iInterfaceArray = new IInterface[arrayList.size()];
        return arrayList.toArray(iInterfaceArray);
    }

    public IClassifier[] getNestedClasses() {
        ArrayList<IClassifier> arrayList = new ArrayList<IClassifier>();
        ETList eTList = this.getElement().getOwnedElements();
        for (int i = 0; i < eTList.size(); ++i) {
            INamedElement iNamedElement = (INamedElement)eTList.get(i);
            if (!iNamedElement.getElementType().equals("Class") && !iNamedElement.getElementType().equals("Interface") && !iNamedElement.getElementType().equals("Enumeration")) continue;
            arrayList.add((IClassifier)iNamedElement);
        }
        IClassifier[] iClassifierArray = new IClassifier[arrayList.size()];
        return arrayList.toArray(iClassifierArray);
    }

    public String getEnclosingClassSection() {
        StringBuilder stringBuilder = new StringBuilder();
        IElement iElement = this.getElement().getOwner();
        if (iElement instanceof IClassifier) {
            stringBuilder.append("<DL>\r\n");
            stringBuilder.append("<DT><B>" + NbBundle.getMessage(ClassData.class, (String)"Enclosing_class") + ":</B><DD><A HREF=\"" + this.getLinkTo(iElement) + "\" >" + ((IClassifier)iElement).getName() + "</A></DD>\r\n");
            stringBuilder.append("</DL>\r\n");
        }
        return stringBuilder.toString();
    }

    public IOperation[] getConstructors() {
        ArrayList<IOperation> arrayList = new ArrayList<IOperation>();
        ETList eTList = this.getElement().getOperations();
        for (int i = 0; i < eTList.size(); ++i) {
            IOperation iOperation = (IOperation)eTList.get(i);
            if (iOperation.getReturnType() != null) continue;
            arrayList.add(iOperation);
        }
        IOperation[] iOperationArray = new IOperation[arrayList.size()];
        return arrayList.toArray(iOperationArray);
    }

    public IOperation[] getOperations() {
        ArrayList<IOperation> arrayList = new ArrayList<IOperation>();
        ETList eTList = this.getElement().getOperations();
        for (int i = 0; i < eTList.size(); ++i) {
            IOperation iOperation = (IOperation)eTList.get(i);
            if (iOperation.getReturnType() == null) continue;
            arrayList.add(iOperation);
        }
        IOperation[] iOperationArray = new IOperation[arrayList.size()];
        return arrayList.toArray(iOperationArray);
    }

    public String getOperationSummary(IOperation[] iOperationArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iOperationArray.length; ++i) {
            IOperation iOperation = iOperationArray[i];
            ETList eTList = iOperationArray[i].getParameters();
            IParameter iParameter = iOperation.getReturnType();
            stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
            if (iParameter == null) {
                stringBuilder.append("<TD><CODE><B><A HREF=\"#" + iOperationArray[i].getName() + "\">" + iOperationArray[i].getName() + "</A></B>(");
            } else {
                stringBuilder.append("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\r\n");
                if (iParameter.getType() != null) {
                    stringBuilder.append("<CODE><A HREF=\"" + this.getLinkTo((IElement)iParameter.getType()) + "\">" + iParameter.getType().getName() + "</A>");
                    IMultiplicity iMultiplicity = iParameter.getMultiplicity();
                    if (iMultiplicity != null) {
                        stringBuilder.append(iMultiplicity.getRangeAsString(true));
                    }
                    stringBuilder.append("</CODE></FONT></TD>\r\n");
                } else {
                    stringBuilder.append("<CODE>&nbsp;</CODE></FONT></TD>\r\n");
                    Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidType", (Object)iParameter.getElementType(), (Object)iParameter.getName()));
                }
                stringBuilder.append("<TD><CODE><B><A HREF=\"#" + iOperation.getName() + "\">" + iOperation.getName() + "</A></B>(");
            }
            for (int j = 0; j < eTList.size(); ++j) {
                IParameter iParameter2 = (IParameter)eTList.get(j);
                if (iParameter2.getDirection() == 3) continue;
                if (iParameter2.getType() != null) {
                    stringBuilder.append("<A HREF=\"" + this.getLinkTo((IElement)iParameter2.getType()) + "\">" + iParameter2.getType().getName() + "</A>");
                } else {
                    Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidType", (Object)iParameter2.getElementType(), (Object)iParameter2.getName()));
                }
                stringBuilder.append("&nbsp;" + iParameter2.getName());
                IMultiplicity iMultiplicity = iParameter2.getMultiplicity();
                if (iMultiplicity != null) {
                    stringBuilder.append(iMultiplicity.getRangeAsString(true));
                }
                if (j == eTList.size() - 1) continue;
                stringBuilder.append(",&nbsp;");
            }
            stringBuilder.append(")</CODE>");
            stringBuilder.append("<BR>\r\n");
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getBriefDocumentation(iOperationArray[i].getDocumentation()) + "</TD>\r\n");
            stringBuilder.append("</TR>\r\n");
        }
        stringBuilder.append("</TABLE>\r\n&nbsp;\r\n");
        return stringBuilder.toString();
    }

    public String getTemplateParameterSummary() {
        ETList eTList = this.getElement().getTemplateParameters();
        StringBuilder stringBuilder = new StringBuilder();
        if (eTList.size() > 0) {
            int n;
            stringBuilder.append("<!-- =========== TEMPLATE PARAMETER SUMMARY =========== -->\r\n\r\n");
            stringBuilder.append("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\r\n");
            stringBuilder.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\r\n");
            stringBuilder.append("<TH ALIGN=\"left\" COLSPAN=\"5\"><FONT SIZE=\"+2\">\r\n");
            stringBuilder.append("<B>" + NbBundle.getMessage(ClassData.class, (String)"Template_Parameter_Summary") + "</B></FONT></TH>\r\n");
            stringBuilder.append("</TR>\r\n");
            String[] stringArray = new String[]{NbBundle.getMessage(ClassData.class, (String)"TemplateParameter_Name"), NbBundle.getMessage(ClassData.class, (String)"TemplateParameter_Alias"), NbBundle.getMessage(ClassData.class, (String)"TemplateParameter_Visibility"), NbBundle.getMessage(ClassData.class, (String)"TemplateParameter_DefaultElement"), NbBundle.getMessage(ClassData.class, (String)"TemplateParameter_TypeConstraint")};
            stringBuilder.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\r\n");
            for (n = 0; n < stringArray.length; ++n) {
                stringBuilder.append("<TD ALIGN=\"left\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"+1\">");
                stringBuilder.append(stringArray[n] + "</TD>\r\n");
            }
            stringBuilder.append("</TR>\r\n");
            for (n = 0; n < eTList.size(); ++n) {
                IParameterableElement iParameterableElement = (IParameterableElement)eTList.get(n);
                IParameterableElement iParameterableElement2 = iParameterableElement.getDefaultElement();
                stringBuilder.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                String[] stringArray2 = new String[]{iParameterableElement.getName(), iParameterableElement.getAlias(), this.getVisibility((INamedElement)iParameterableElement), iParameterableElement2 == null ? "&nbsp;" : iParameterableElement2.getName(), iParameterableElement.getTypeConstraint()};
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string = stringArray2[i];
                    if (string.equals("")) {
                        string = "&nbsp;";
                    }
                    stringBuilder.append("<TD ALIGN=\"left\" VALIGN=\"top\" WIDTH=\"1%\">");
                    stringBuilder.append(string + "</TD>\r\n");
                }
                stringBuilder.append("</TR>\r\n");
            }
            stringBuilder.append("</TABLE>\r\n&nbsp;\r\n");
        }
        return stringBuilder.toString();
    }

    public String getOperationDetail(IOperation[] iOperationArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iOperationArray.length; ++i) {
            IOperation iOperation = iOperationArray[i];
            stringBuilder.append("<A NAME=\"" + iOperation.getName() + "\"></A><H3>" + iOperation.getName() + "</H3>\r\n");
            stringBuilder.append("<PRE>\r\n");
            stringBuilder.append(this.formatOperation(iOperation) + " " + "<B>" + iOperation.getName() + "</B>(");
            ETList eTList = iOperation.getParameters();
            for (int j = 0; j < eTList.size(); ++j) {
                IParameter iParameter = (IParameter)eTList.get(j);
                if (iParameter.getDirection() == 3) continue;
                if (iParameter.getType() != null) {
                    stringBuilder.append("<A HREF=\"" + this.getLinkTo((IElement)iParameter.getType()) + "\">" + iParameter.getType().getName() + "</A>");
                } else {
                    Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidType", (Object)iParameter.getElementType(), (Object)iParameter.getName()));
                }
                stringBuilder.append("&nbsp;" + iParameter.getName());
                IMultiplicity iMultiplicity = iParameter.getMultiplicity();
                if (iMultiplicity != null) {
                    stringBuilder.append(iMultiplicity.getRangeAsString(true));
                }
                if (j == eTList.size() - 1) continue;
                stringBuilder.append(",&nbsp;");
            }
            stringBuilder.append(")</PRE>\r\n");
            stringBuilder.append("<DL>\r\n");
            stringBuilder.append("<DD>" + iOperation.getDocumentation() + "\r\n");
            stringBuilder.append("<P>\r\n</DD></DL>\r\n");
            if (i < iOperationArray.length - 1) {
                stringBuilder.append("<HR>\r\n");
                continue;
            }
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public String formatAttribute(IAttribute iAttribute) {
        if (iAttribute.getType() != null) {
            return this.getVisibility((INamedElement)iAttribute) + " " + "<A HREF=\"" + this.getLinkTo((IElement)iAttribute.getType()) + "\">" + iAttribute.getType().getName() + "</A>" + " ";
        }
        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidType", (Object)iAttribute.getElementType(), (Object)iAttribute.getName()));
        return this.getVisibility((INamedElement)iAttribute) + " ";
    }

    public String formatOperation(IOperation iOperation) {
        String string = this.getVisibility((INamedElement)iOperation);
        String string2 = iOperation.getIsStatic() ? " static" : "";
        String string3 = iOperation.getIsFinal() ? " final" : "";
        String string4 = iOperation.getIsAbstract() ? " abstract" : "";
        String string5 = "";
        if (iOperation.getReturnType() != null) {
            if (iOperation.getReturnType().getType() == null) {
                Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidType", (Object)iOperation.getReturnType().getElementType(), (Object)iOperation.getReturnType().getName()));
            } else {
                string5 = " <A HREF=\"" + this.getLinkTo((IElement)iOperation.getReturnType().getType()) + "\">" + iOperation.getReturnType().getType().getName() + "</A>";
                IMultiplicity iMultiplicity = iOperation.getReturnType().getMultiplicity();
                if (iMultiplicity != null) {
                    string5 = string5 + iMultiplicity.getRangeAsString(true);
                }
            }
        }
        return string + string2 + string3 + string4 + string5;
    }

    public String formatClass(IClass iClass) {
        String string = this.getVisibility((INamedElement)iClass);
        return string + " class";
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Final, Property_Transient, Property_Abstract, Property_Leaf};
    }

    protected Object[] getPropertyValues() {
        Boolean bl = new Boolean(this.getElement().getIsFinal());
        Boolean bl2 = new Boolean(this.getElement().getIsTransient());
        Boolean bl3 = new Boolean(this.getElement().getIsAbstract());
        Boolean bl4 = new Boolean(this.getElement().getIsLeaf());
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), bl, bl2, bl3, bl4};
    }

    protected String getAssociations() {
        StringBuilder stringBuilder = new StringBuilder();
        ETList eTList = this.getElement().getAssociations();
        if (eTList.size() > 0) {
            stringBuilder.append("<DL>\r\n");
            stringBuilder.append("<DT><B>" + NbBundle.getMessage(ClassData.class, (String)"All_Known_Associations") + ": </B>");
            for (int i = 0; i < eTList.size(); ++i) {
                IAssociation iAssociation = (IAssociation)eTList.get(i);
                String string = iAssociation.getExpandedElementType();
                String string2 = CommonResourceManager.instance().getIconDetailsForElementType(string);
                if (string2.lastIndexOf("/") > -1) {
                    string2 = string2.substring(string2.lastIndexOf("/") + 1);
                }
                ReportTask.addToImageList(string2);
                stringBuilder.append("<DD><IMG SRC=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/" + string2 + "\" ALT=\"" + "(" + string + ") \"> " + "<A HREF=\"" + this.getLinkTo((IElement)iAssociation) + "\">" + string + "</A>: ");
                ETList eTList2 = iAssociation.getAllParticipants();
                eTList2.remove((Object)this.getElement());
                for (int j = 0; j < eTList2.size(); ++j) {
                    IElement iElement = (IElement)eTList2.get(j);
                    if (!iAssociation.getIsReflexive() && iElement.getXMIID().equals(this.getElement().getXMIID())) continue;
                    if (this.displayLink(iElement) && iElement instanceof INamedElement) {
                        if (iElement.getOwningPackage() != null) {
                            stringBuilder.append("<A HREF=\"" + this.getLinkTo(iElement) + "\" title=\"association in " + iElement.getOwningPackage().getFullyQualifiedName(false) + "\">" + ((INamedElement)iElement).getName() + "</A>");
                        } else {
                            stringBuilder.append(((INamedElement)iElement).getName());
                            Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidPackage", (Object)iElement.getElementType(), (Object)iElement.toString()));
                        }
                    } else {
                        stringBuilder.append(iElement.getElementType());
                    }
                    if (j >= eTList2.size() - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("</DD>\r\n");
            }
            stringBuilder.append("</DL>\r\n");
        }
        return stringBuilder.toString();
    }

    public String getSpecifications() {
        StringBuilder stringBuilder = new StringBuilder();
        ETList eTList = this.getElement().getSpecializations();
        if (eTList.size() > 0) {
            stringBuilder.append("<DL>\r\n");
            stringBuilder.append("<DT><B>" + NbBundle.getMessage(ClassData.class, (String)"All_Specifications") + ": </B> <DD>");
            for (int i = 0; i < eTList.size(); ++i) {
                IClassifier iClassifier = ((IGeneralization)eTList.get(i)).getSpecific();
                if (iClassifier.getOwningPackage() != null) {
                    stringBuilder.append("<A HREF=\"" + this.getLinkTo((IElement)iClassifier) + "\" title=\"specifications in " + iClassifier.getOwningPackage().getFullyQualifiedName(false) + "\">" + iClassifier.getName() + "</A>");
                } else {
                    stringBuilder.append(iClassifier.getName());
                    Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidPackage", (Object)iClassifier.getElementType(), (Object)iClassifier.getName()));
                }
                if (i >= eTList.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("</DD>\r\n");
            stringBuilder.append("</DL>\r\n");
        }
        return stringBuilder.toString();
    }

    public String getGeneralizations() {
        StringBuilder stringBuilder = new StringBuilder();
        ETList eTList = this.getElement().getGeneralizations();
        if (eTList.size() > 0) {
            stringBuilder.append("<DL>\r\n");
            stringBuilder.append("<DT><B>" + NbBundle.getMessage(ClassData.class, (String)"All_Generalizations") + ": </B> <DD>");
            for (int i = 0; i < eTList.size(); ++i) {
                IClassifier iClassifier = ((IGeneralization)eTList.get(i)).getGeneral();
                if (iClassifier.getOwningPackage() != null) {
                    stringBuilder.append("<A HREF=\"" + this.getLinkTo((IElement)iClassifier) + "\" title=\"specifications in " + iClassifier.getOwningPackage().getFullyQualifiedName(false) + "\">" + iClassifier.getName() + "</A>");
                } else {
                    stringBuilder.append(iClassifier.getName());
                    Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidPackage", (Object)iClassifier.getElementType(), (Object)iClassifier.getName()));
                }
                if (i >= eTList.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("</DD>\r\n");
            stringBuilder.append("</DL>\r\n");
        }
        return stringBuilder.toString();
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        try {
            IOperation[] iOperationArray;
            IMultiplicity iMultiplicity;
            IClassifier iClassifier;
            ETList eTList;
            IClassifier iClassifier2;
            IClassifier iClassifier3;
            ETList eTList2;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElementName() + "</H2>\r\n");
            outputStreamWriter.write("<PRE>\r\n");
            IClassifier[] iClassifierArray = this.getSuperClasses();
            if (this.getSuperClasses().length > 0) {
                for (int i = 0; i < iClassifierArray.length; ++i) {
                    IClassifier iClassifier4 = iClassifierArray[i];
                    if (iClassifier4 == null) {
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidSuperClass", (Object)this.getElementType(), (Object)this.getElementName()));
                        continue;
                    }
                    outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iClassifier4) + "\" title=\"" + this.getElementType() + " in" + this.getOwningPackageName() + "\">" + iClassifier4.getName() + "</A>");
                    if (i >= iClassifierArray.length - 1) continue;
                    outputStreamWriter.write(", ");
                }
                outputStreamWriter.write("\r\n");
                outputStreamWriter.write("  <IMG SRC=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/inherit.gif\" ALT=\"extended by \">");
            }
            outputStreamWriter.write("<B>" + this.getElement().getFullyQualifiedName(false) + "</B>\r\n");
            outputStreamWriter.write("</PRE>\r\n");
            IInterface[] iInterfaceArray = this.getImplementedInterfaces();
            if (iInterfaceArray.length > 0) {
                outputStreamWriter.write("<DL>\r\n");
                outputStreamWriter.write("<DT><B>" + NbBundle.getMessage(ClassData.class, (String)"All_Implemented_Interfaces") + ":</B> <DD>");
                for (int i = 0; i < iInterfaceArray.length; ++i) {
                    IInterface iInterface = iInterfaceArray[i];
                    if (iInterface == null) {
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidSuperClass", (Object)this.getElementType(), (Object)this.getElementName()));
                        continue;
                    }
                    if (iInterface.getOwningPackage() != null) {
                        outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iInterface) + "\" title=\"interface in " + iInterface.getOwningPackage().getFullyQualifiedName(false) + "\">" + iInterface.getName() + "</A>");
                    } else {
                        outputStreamWriter.write(iInterface.getName());
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidPackage", (Object)iInterface.getElementType(), (Object)iInterface.getName()));
                    }
                    if (i >= iInterfaceArray.length - 1) continue;
                    outputStreamWriter.write(", ");
                }
                outputStreamWriter.write("</DD>\r\n");
                outputStreamWriter.write("</DL>\r\n");
            }
            if ((eTList2 = this.getElement().getSpecializations()).size() > 0) {
                outputStreamWriter.write("<DL>\r\n");
                outputStreamWriter.write("<DT><B>" + NbBundle.getMessage(ClassData.class, (String)"All_Known_Subclasses") + ":</B> <DD>");
                for (int i = 0; i < eTList2.size(); ++i) {
                    iClassifier3 = ((IGeneralization)eTList2.get(i)).getSpecific();
                    if (iClassifier3 == null) {
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidSubClass", (Object)this.getElementType(), (Object)this.getElementName()));
                        continue;
                    }
                    if (iClassifier3.getOwningPackage() != null) {
                        outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iClassifier3) + "\" title=\"subclass in " + iClassifier3.getOwningPackage().getFullyQualifiedName(false) + "\">" + iClassifier3.getName() + "</A>");
                    } else {
                        outputStreamWriter.write(iClassifier3.getName());
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidPackage", (Object)iClassifier3.getElementType(), (Object)iClassifier3.getName()));
                    }
                    if (i >= eTList2.size() - 1) continue;
                    outputStreamWriter.write(", ");
                }
                outputStreamWriter.write("</DD>\r\n");
                outputStreamWriter.write("</DL>\r\n");
            }
            outputStreamWriter.write(this.getDependencies());
            outputStreamWriter.write(this.getAssociations());
            outputStreamWriter.write(this.getEnclosingClassSection());
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<DL>\r\n");
            outputStreamWriter.write("<DT><PRE>" + this.getVisibility((INamedElement)this.getElement()) + " " + this.getElementType().toLowerCase() + " <B>" + this.getElementName() + "</B></DT>");
            if (iClassifierArray.length > 0) {
                outputStreamWriter.write("<DT>extends ");
                for (int i = 0; i < iClassifierArray.length; ++i) {
                    iClassifier3 = iClassifierArray[i];
                    if (iClassifier3 == null) {
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidSuperClass", (Object)this.getElementType(), (Object)this.getElementName()));
                        continue;
                    }
                    outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iClassifier3) + "\" title=\"" + this.getElementType() + " in" + this.getOwningPackageName() + "\">" + iClassifier3.getName() + "</A>");
                    if (i >= iClassifierArray.length - 1) continue;
                    outputStreamWriter.write(", ");
                }
            }
            if (iInterfaceArray.length > 0) {
                outputStreamWriter.write("<DT>implements ");
                for (int i = 0; i < iInterfaceArray.length; ++i) {
                    iClassifier3 = iInterfaceArray[i];
                    if (iClassifier3 == null) {
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidSuperClass", (Object)this.getElementType(), (Object)this.getElementName()));
                        continue;
                    }
                    if (iClassifier3.getOwningPackage() != null) {
                        outputStreamWriter.write("<A HREF=\"" + this.getLinkTo((IElement)iClassifier3) + "\" title=\"interface in " + iClassifier3.getOwningPackage().getFullyQualifiedName(false) + "\">" + iClassifier3.getName() + "</A>");
                    } else {
                        outputStreamWriter.write(iClassifier3.getName());
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidPackage", (Object)iClassifier3.getElementType(), (Object)iClassifier3.getName()));
                    }
                    if (i >= iInterfaceArray.length - 1) continue;
                    outputStreamWriter.write(", ");
                }
            }
            outputStreamWriter.write("</DL>\r\n</PRE>\r\n\r\n");
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            IClassifier[] iClassifierArray2 = this.getNestedClasses();
            if (iClassifierArray2.length > 0) {
                outputStreamWriter.write("<!-- =========== NESTED CLASS SUMMARY =========== -->\r\n");
                outputStreamWriter.write(this.getSummaryHeader("nested_class_summary", NbBundle.getMessage(ClassData.class, (String)"Nested_Class_Summary")));
                for (int i = 0; i < iClassifierArray2.length; ++i) {
                    iClassifier2 = iClassifierArray2[i];
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\r\n");
                    outputStreamWriter.write("<CODE>" + this.getVisibility((INamedElement)iClassifier2) + " " + this.getElementType().toLowerCase() + "</CODE></FONT></TD>\r\n");
                    outputStreamWriter.write("<TD><CODE><B><A HREF=\"" + this.getLinkTo((IElement)iClassifier2) + "\">" + iClassifier2.getName() + "</A></B></CODE>\r\n");
                    outputStreamWriter.write("<BR>\r\n");
                    outputStreamWriter.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getBriefDocumentation(iClassifier2.getDocumentation()) + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            if ((eTList = this.getElement().getAttributes()).size() > 0) {
                outputStreamWriter.write("<!-- =========== ATTRIBUTE SUMMARY =========== -->\r\n");
                outputStreamWriter.write(this.getSummaryHeader("attribute_summary", NbBundle.getMessage(ClassData.class, (String)"Attribute_Summary")));
                for (int i = 0; i < eTList.size(); ++i) {
                    iClassifier2 = (IAttribute)eTList.get(i);
                    iClassifier = iClassifier2.getType();
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">\r\n");
                    if (iClassifier != null) {
                        outputStreamWriter.write("<CODE><A HREF=\"" + this.getLinkTo((IElement)iClassifier) + "\">" + iClassifier.getName() + "</A></CODE></FONT></TD>\r\n");
                    } else {
                        outputStreamWriter.write("<CODE>&nbsp;</CODE></FONT></TD>\r\n");
                        Logger.getLogger(ClassData.class.getName()).log(Level.WARNING, NbBundle.getMessage(ClassData.class, (String)"MSG_InvalidType", (Object)iClassifier2.getElementType(), (Object)iClassifier2.getName()));
                    }
                    outputStreamWriter.write("<TD><CODE><B><A HREF=\"#" + iClassifier2.getName() + "\">" + iClassifier2.getName() + "</A></B>");
                    iMultiplicity = iClassifier2.getMultiplicity();
                    if (iMultiplicity != null) {
                        outputStreamWriter.write(iMultiplicity.getRangeAsString(true));
                    }
                    outputStreamWriter.write("</CODE>\r\n");
                    outputStreamWriter.write("<BR>\r\n");
                    outputStreamWriter.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + this.getBriefDocumentation(iClassifier2.getDocumentation()) + "</TD>\r\n</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            if ((iOperationArray = this.getConstructors()).length > 0) {
                outputStreamWriter.write("<!-- =========== CONSTRUCTOR SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("constructor_summary", NbBundle.getMessage(ClassData.class, (String)"Constructor_Summary")));
                outputStreamWriter.write(this.getOperationSummary(iOperationArray));
            }
            if (((IOperation[])(iMultiplicity = this.getOperations())).length > 0) {
                outputStreamWriter.write("<!-- =========== OPERATION SUMMARY =========== -->\r\n");
                outputStreamWriter.write(this.getSummaryHeader("operation_summary", NbBundle.getMessage(ClassData.class, (String)"Operation_Summary")));
                outputStreamWriter.write(this.getOperationSummary((IOperation[])iMultiplicity));
            }
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            outputStreamWriter.write(this.getTemplateParameterSummary());
            outputStreamWriter.write(this.getDiagramSummary());
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== ATTRIBUTE DETAIL =========== -->\r\n");
                outputStreamWriter.write(this.getDetailHeader("attribute_detail", NbBundle.getMessage(ClassData.class, (String)"Attribute_Detail")));
                for (int i = 0; i < eTList.size(); ++i) {
                    iClassifier2 = (IAttribute)eTList.get(i);
                    iClassifier = iClassifier2.getType();
                    outputStreamWriter.write("<A NAME=\"" + iClassifier2.getName() + "\"></A><H3>" + iClassifier2.getName() + "</H3>\r\n");
                    outputStreamWriter.write("<PRE>" + this.formatAttribute((IAttribute)iClassifier2) + "<B>" + iClassifier2.getName() + "</B>");
                    IMultiplicity iMultiplicity2 = iClassifier2.getMultiplicity();
                    if (iMultiplicity2 != null) {
                        outputStreamWriter.write(iMultiplicity2.getRangeAsString(true));
                    }
                    outputStreamWriter.write("</PRE>");
                    outputStreamWriter.write("<DL>\r\n");
                    outputStreamWriter.write("<DD>" + iClassifier2.getDocumentation() + "\r\n<P>\r\n</DD>\r\n</DL>\r\n");
                    if (i < eTList.size() - 1) {
                        outputStreamWriter.write("<HR>\r\n\r\n");
                        continue;
                    }
                    outputStreamWriter.write("\r\n");
                }
            }
            if (iOperationArray.length > 0) {
                outputStreamWriter.write("<!-- =========== CONSTRUCTOR DETAIL =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getDetailHeader("constructor_detail", NbBundle.getMessage(ClassData.class, (String)"Constructor_Detail")));
                outputStreamWriter.write(this.getOperationDetail(iOperationArray));
            }
            if (((IOperation[])iMultiplicity).length > 0) {
                outputStreamWriter.write("<!-- =========== OPERATION DETAIL =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getDetailHeader("operationr_detail", NbBundle.getMessage(ClassData.class, (String)"Operation_Detail")));
                outputStreamWriter.write(this.getOperationDetail((IOperation[])iMultiplicity));
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

