/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.INavigableEnd;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.dataobjects.AssociationEndData;
import org.netbeans.modules.uml.reporting.dataobjects.ClassData;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.reporting.dataobjects.NavigableEndData;
import org.openide.util.NbBundle;

public class AssociationData
extends ClassData {
    private IAssociation element;

    public void setElement(IElement iElement) {
        if (iElement instanceof IAssociation) {
            this.element = (IAssociation)iElement;
        }
    }

    public IAssociation getElement() {
        return this.element;
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Final, Property_Transient, Property_Abstract, Property_Leaf, Property_Derived, Property_Reflexive};
    }

    protected Object[] getPropertyValues() {
        Boolean bl = new Boolean(this.getElement().getIsFinal());
        Boolean bl2 = new Boolean(this.getElement().getIsTransient());
        Boolean bl3 = new Boolean(this.getElement().getIsAbstract());
        Boolean bl4 = new Boolean(this.getElement().getIsLeaf());
        Boolean bl5 = new Boolean(this.getElement().getIsDerived());
        Boolean bl6 = new Boolean(this.getElement().getIsReflexive());
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), bl, bl2, bl3, bl4, bl5, bl6};
    }

    protected String getEndDetails() {
        StringBuilder stringBuilder = new StringBuilder();
        ETList eTList = this.getElement().getEnds();
        if (eTList.size() > 0) {
            stringBuilder.append("<!-- =========== ASSOCIATION END DETAIL =========== -->\r\n");
            stringBuilder.append(this.getDetailHeader("association_end_detail", NbBundle.getMessage(AssociationData.class, (String)"Association_End_Detail")));
            for (int i = 0; i < eTList.size(); ++i) {
                AssociationEndData associationEndData;
                IAssociationEnd iAssociationEnd = (IAssociationEnd)eTList.get(i);
                String string = iAssociationEnd.getName();
                if (string.equals("")) {
                    string = iAssociationEnd.getParticipant().getName();
                }
                if (iAssociationEnd instanceof INavigableEnd) {
                    associationEndData = new NavigableEndData();
                    stringBuilder.append("<A NAME=\"" + string + "\"></A><H3>" + NbBundle.getMessage(AssociationEndData.class, (String)"NavigableEnd") + "&nbsp;" + string + "</H3>\r\n");
                } else {
                    associationEndData = new AssociationEndData();
                    stringBuilder.append("<A NAME=\"" + string + "\"></A><H3>" + NbBundle.getMessage(AssociationEndData.class, (String)"AssociationEnd") + "&nbsp;" + string + "</H3>\r\n");
                }
                associationEndData.setElement((IElement)iAssociationEnd);
                stringBuilder.append(associationEndData.getDocumentation());
                stringBuilder.append(associationEndData.getProperties(false));
                stringBuilder.append(associationEndData.getStereoTypesSummary());
                stringBuilder.append(associationEndData.getTaggedValueSummary());
                stringBuilder.append(associationEndData.getConstraintsSummary());
                if (i < eTList.size() - 1) {
                    stringBuilder.append("<HR>\r\n\r\n");
                    continue;
                }
                stringBuilder.append("\r\n");
            }
        }
        return stringBuilder.toString();
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElementName() + "</H2>\r\n");
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            ETList eTList = this.getElement().getEnds();
            if (eTList.size() > 0) {
                outputStreamWriter.write("<!-- =========== ASSOCIATION END SUMMARY =========== -->\r\n");
                outputStreamWriter.write(this.getSummaryHeader("association_end_summary", NbBundle.getMessage(AssociationData.class, (String)"Association_End_Summary")));
                for (int i = 0; i < eTList.size(); ++i) {
                    IAssociationEnd iAssociationEnd = (IAssociationEnd)eTList.get(i);
                    String string = iAssociationEnd.getName();
                    if (string.equals("")) {
                        string = iAssociationEnd.getParticipant().getName();
                    }
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B><A HREF=\"#" + string + "\">" + string + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + this.getBriefDocumentation(iAssociationEnd.getDocumentation()) + "</TD>\r\n</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            outputStreamWriter.write(this.getTemplateParameterSummary());
            outputStreamWriter.write(this.getDiagramSummary());
            outputStreamWriter.write(this.getEndDetails());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

