/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.reporting.dataobjects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IActivityNode;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IActivityPartition;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.reporting.ReportTask;
import org.netbeans.modules.uml.reporting.dataobjects.ActivityGroupData;
import org.netbeans.modules.uml.reporting.dataobjects.ElementDataObject;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.openide.util.NbBundle;

public class ActivityPartitionData
extends ActivityGroupData {
    private IActivityPartition element;

    public void setElement(IElement iElement) {
        if (iElement instanceof IActivityPartition) {
            this.element = (IActivityPartition)iElement;
        }
    }

    public IActivityPartition getElement() {
        return this.element;
    }

    protected String[] getPropertyNames() {
        return new String[]{Property_Alias, Property_Visibility, Property_Activity, Property_External, Property_Dimension};
    }

    protected Object[] getPropertyValues() {
        Boolean bl = new Boolean(this.getElement().getIsExternal());
        Boolean bl2 = new Boolean(this.getElement().getIsDimension());
        return new Object[]{this.getElement().getAlias(), this.getVisibility((INamedElement)this.getElement()), this.getElement().getActivity(), bl, bl2};
    }

    public boolean toReport(File file) {
        if (this.getElement() == null) {
            return false;
        }
        boolean bl = false;
        try {
            ETList eTList;
            Object object;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            String string = "";
            outputStreamWriter.write(this.getHTMLHeader());
            outputStreamWriter.write("<BODY BGCOLOR=\"white\">\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write("<H2>\r\n");
            outputStreamWriter.write("<FONT SIZE=\"-1\">" + this.getOwningPackageName() + "</FONT>\r\n");
            outputStreamWriter.write("<BR>\r\n");
            outputStreamWriter.write(this.getElementType() + " " + this.getElement().getName() + "</H2>\r\n");
            outputStreamWriter.write(this.getDependencies());
            IElement iElement = this.getElement().getOwner();
            if (iElement instanceof IActivityPartition && iElement != null) {
                outputStreamWriter.write("<DL>\r\n");
                outputStreamWriter.write("<DT><B>" + NbBundle.getMessage(ActivityPartitionData.class, (String)"Super_Partition") + ": </B><DD><A HREF=\"" + this.getLinkTo(iElement) + "\" >" + ((IActivityPartition)iElement).getName() + "</A></DD>\r\n");
                outputStreamWriter.write("</DL>\r\n");
            }
            outputStreamWriter.write(this.getEnclosingDiagrams());
            outputStreamWriter.write(this.getDocumentation());
            outputStreamWriter.write(this.getProperties());
            outputStreamWriter.write(this.getStereoTypesSummary());
            outputStreamWriter.write(this.getTaggedValueSummary());
            outputStreamWriter.write(this.getConstraintsSummary());
            ETList eTList2 = this.getElement().getNodeContents();
            if (eTList2.size() > 0) {
                outputStreamWriter.write("<!-- =========== ACTIVITY NODE SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("contained_node_summary", NbBundle.getMessage(ActivityPartitionData.class, (String)"Contained_Node_Summary")));
                for (int i = 0; i < eTList2.size(); ++i) {
                    IActivityNode iActivityNode = (IActivityNode)eTList2.get(i);
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    string = this.getBriefDocumentation(iActivityNode.getDocumentation());
                    if (string == null || string.trim().equals("")) {
                        string = "&nbsp;";
                    }
                    if ((object = iActivityNode.getName()) == null || ((String)object).equals("")) {
                        object = iActivityNode.getElementType();
                    }
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    String string2 = CommonResourceManager.instance().getIconDetailsForElementType(iActivityNode.getElementType());
                    if (string2.lastIndexOf("/") > -1) {
                        string2 = string2.substring(string2.lastIndexOf("/") + 1);
                    }
                    ReportTask.addToImageList(string2);
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><img src=\"" + ReportTask.getPathToReportRoot((IElement)this.getElement()) + "images/" + string2 + "\" border=n>&nbsp<B><A HREF=\"" + this.getLinkTo((IElement)iActivityNode) + "\" title=\"" + iActivityNode.getElementType() + " in " + (String)object + "\">" + (String)object + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + string + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            if ((eTList = this.getElement().getSubPartitions()).size() > 0) {
                outputStreamWriter.write("<!-- =========== SUB PARTITION SUMMARY =========== -->\r\n\r\n");
                outputStreamWriter.write(this.getSummaryHeader("sub_partition_summary", NbBundle.getMessage(ActivityPartitionData.class, (String)"Sub_Partition_Summary")));
                for (int i = 0; i < eTList.size(); ++i) {
                    object = (IActivityPartition)eTList.get(i);
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    string = this.getBriefDocumentation(object.getDocumentation());
                    if (string == null || string.trim().equals("")) {
                        string = "&nbsp;";
                    }
                    outputStreamWriter.write("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\r\n");
                    outputStreamWriter.write("<TD WIDTH=\"15%\"><B><A HREF=\"" + this.getLinkTo((IElement)object) + "\" title=\"" + object.getName() + " in " + this.getElement().getName() + "\">" + object.getName() + "</A></B></TD>\r\n");
                    outputStreamWriter.write("<TD>" + string + "</TD>\r\n");
                    outputStreamWriter.write("</TR>\r\n");
                }
                outputStreamWriter.write("</TABLE>\r\n&nbsp;\r\n");
            }
            outputStreamWriter.write("<HR>\r\n");
            outputStreamWriter.write(this.getNavBar());
            outputStreamWriter.write("</BODY>\r\n</HTML>");
            outputStreamWriter.close();
            bl = true;
        }
        catch (Exception exception) {
            Logger.getLogger(ElementDataObject.class.getName()).log(Level.SEVERE, this.getElement().getElementType() + " - " + this.getElement().getNameWithAlias(), exception);
            bl = false;
        }
        return bl;
    }
}

