/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output.antutils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.junit.output.antutils.FileSet;
import org.netbeans.modules.junit.output.antutils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSetScanner {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final String[] EMPTY_STRING_ARR = new String[0];
    private final FileSet fileSet;
    private File baseDir;
    private boolean caseSensitive;
    private boolean followSymlinks;
    private AntPattern[] includePatterns;
    private AntPattern[] excludePatterns;
    private Collection<File> matchingFiles;

    static Collection<File> listFiles(FileSet fileSet) {
        return new FileSetScanner(fileSet).getMatchingFiles();
    }

    FileSetScanner(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    Collection<File> getMatchingFiles() {
        File file = this.fileSet.getFile();
        if (file != null) {
            file = FileUtils.resolveFile(this.fileSet.getBaseDir(), file.getName());
            if (file.exists()) {
                return Collections.singleton(file);
            }
            return Collections.emptyList();
        }
        this.baseDir = this.fileSet.getBaseDir();
        this.caseSensitive = this.fileSet.isCaseSensitive();
        this.followSymlinks = this.fileSet.isFollowSymlinks();
        this.preparePatterns();
        this.findMatchingFiles();
        return this.matchingFiles;
    }

    private void findMatchingFiles() {
        this.matchingFiles = new ArrayList<File>(32);
        this.findMatchingFiles(this.baseDir, FileSetScanner.createPatternTests(this.includePatterns, this.excludePatterns));
    }

    private void findMatchingFiles(File file, Collection<PatternTest> collection) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            ArrayList<PatternTest> arrayList;
            boolean bl;
            boolean bl2 = file2.isFile();
            boolean bl3 = file2.isDirectory();
            if (!bl2 && !bl3 || !(bl = this.checkFileAgainstPatterns(file2, collection, arrayList = bl3 ? new ArrayList<PatternTest>(collection.size()) : null))) continue;
            if (bl2) {
                this.matchingFiles.add(file2);
                continue;
            }
            this.findMatchingFiles(file2, arrayList);
        }
    }

    private boolean checkFileAgainstPatterns(File file, Collection<PatternTest> collection, Collection<PatternTest> collection2) {
        assert (!collection.isEmpty());
        assert (collection.iterator().next().includePattern);
        boolean bl = collection2 != null;
        boolean bl2 = !bl;
        boolean bl3 = false;
        for (PatternTest patternTest : collection) {
            boolean bl4;
            AntPattern antPattern = patternTest.pattern;
            boolean bl5 = patternTest.includePattern;
            int n = patternTest.patternPartIndex;
            AntPattern.PatternPartType patternPartType = antPattern.patternPartTypes[n];
            boolean bl6 = antPattern.isLastPart(n);
            if (bl5 && bl6 && patternPartType == AntPattern.PatternPartType.DOUBLE_STAR) {
                bl3 = true;
                if (collection2 == null) continue;
                collection2.add(patternTest);
                continue;
            }
            if (bl2 && (!bl6 || bl3 && bl5) || bl && bl6 && patternPartType != AntPattern.PatternPartType.DOUBLE_STAR || !(bl4 = patternPartType == AntPattern.PatternPartType.DOUBLE_STAR || this.isMatchingFile(file, antPattern, n))) continue;
            if (!bl6) {
                assert (bl);
                if (bl5) {
                    bl3 = true;
                }
                int n2 = n + 1;
                AntPattern.PatternPartType patternPartType2 = antPattern.patternPartTypes[n2];
                if (patternPartType != AntPattern.PatternPartType.DOUBLE_STAR && patternPartType2 == AntPattern.PatternPartType.DOUBLE_STAR && antPattern.isLastPart(n2)) {
                    if (bl5) {
                        collection2.clear();
                        collection2.add(new PatternTest(antPattern, bl5, n2));
                        continue;
                    }
                    bl3 = false;
                    break;
                }
                collection2.add(new PatternTest(antPattern, bl5, n + 1));
                if (patternPartType != AntPattern.PatternPartType.DOUBLE_STAR) continue;
                collection2.add(patternTest);
                continue;
            }
            if (bl5) {
                assert (!bl);
                bl3 = true;
                continue;
            }
            bl3 = false;
            break;
        }
        return bl3;
    }

    private boolean isMatchingFile(File file, AntPattern antPattern, int n) {
        assert (file.isDirectory() || file.isFile());
        String string = file.getName();
        AntPattern.PatternPartType patternPartType = antPattern.patternPartTypes[n];
        assert (patternPartType == AntPattern.PatternPartType.PLAIN || patternPartType == AntPattern.PatternPartType.REGEXP);
        if (patternPartType == AntPattern.PatternPartType.PLAIN) {
            String string2 = antPattern.patternParts[n];
            return this.caseSensitive ? string.equals(string2) : string.equalsIgnoreCase(string2);
        }
        Pattern pattern = antPattern.getPatternPartMatcher(n, this.caseSensitive);
        assert (antPattern.patternPartMatchers[n] != null);
        return antPattern.patternPartMatchers[n].matcher(string).matches();
    }

    private static Collection<PatternTest> createPatternTests(AntPattern[] antPatternArray, AntPattern[] antPatternArray2) {
        ArrayList<PatternTest> arrayList = new ArrayList<PatternTest>(antPatternArray.length + antPatternArray2.length);
        for (AntPattern antPattern : antPatternArray) {
            if (antPattern.patternPartTypes[0] == AntPattern.PatternPartType.DOUBLE_STAR) {
                if (antPattern.isLastPart(0)) {
                    arrayList.clear();
                    arrayList.add(new PatternTest(antPattern, true, 0));
                    break;
                }
                arrayList.add(new PatternTest(antPattern, true, 1));
            }
            arrayList.add(new PatternTest(antPattern, true, 0));
        }
        for (AntPattern antPattern : antPatternArray2) {
            if (antPattern.patternPartTypes[0] == AntPattern.PatternPartType.DOUBLE_STAR) {
                if (antPattern.isLastPart(0)) {
                    return Collections.emptyList();
                }
                arrayList.add(new PatternTest(antPattern, false, 1));
            }
            arrayList.add(new PatternTest(antPattern, false, 0));
        }
        return arrayList;
    }

    private void preparePatterns() {
        Collection<String> collection = this.fileSet.getIncludePatterns();
        if (collection.isEmpty()) {
            collection = Collections.singletonList("**");
        }
        this.includePatterns = this.parsePatternStrings(collection);
        collection = this.fileSet.getExcludesPatterns();
        if (this.fileSet.isDefaultExcludes()) {
            List<String> list = Arrays.asList(DEFAULT_EXCLUDES);
            if (collection.isEmpty()) {
                collection = list;
            } else {
                collection.addAll(list);
            }
        }
        this.excludePatterns = this.parsePatternStrings(collection);
    }

    private AntPattern[] parsePatternStrings(Collection<String> collection) {
        AntPattern[] antPatternArray = new AntPattern[collection.size()];
        Iterator<String> iterator = collection.iterator();
        for (int i = 0; i < antPatternArray.length; ++i) {
            antPatternArray[i] = this.parsePatternString(iterator.next());
        }
        return antPatternArray;
    }

    AntPattern parsePatternString(String string) {
        String string2;
        if (string.length() != 0 && string.charAt(0) == File.separatorChar) assert (false) : "corner case - not implemented";
        ArrayList<String> arrayList = new ArrayList<String>(6);
        boolean bl = false;
        int n = 0;
        int n2 = string.indexOf(File.separatorChar);
        while (n2 != -1) {
            string2 = string.substring(n, n2);
            boolean bl2 = string2.equals("**");
            if (!bl2 || !bl) {
                arrayList.add(string.substring(n, n2));
            }
            bl = bl2;
            n = n2 + 1;
            n2 = string.indexOf(File.separatorChar, n);
        }
        string2 = n == string.length() ? "**" : string.substring(n);
        if (!bl || !string2.equals("**")) {
            arrayList.add(string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return new AntPattern(stringArray);
    }

    static final class AntPattern {
        private static final int CASE_SENSITIVE_FLAGS = 0;
        private static final int CASE_INSENSITIVE_FLAGS = 66;
        final String[] patternParts;
        final PatternPartType[] patternPartTypes;
        private final Pattern[] patternPartMatchers;

        AntPattern(String[] stringArray) {
            if (stringArray == null) {
                throw new IllegalArgumentException("patternParts: null");
            }
            this.patternParts = stringArray;
            this.patternPartTypes = new PatternPartType[stringArray.length];
            this.patternPartMatchers = new Pattern[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                PatternPartType patternPartType = string.equals("**") ? PatternPartType.DOUBLE_STAR : (string.indexOf(42) != -1 || string.indexOf(63) != -1 ? PatternPartType.REGEXP : PatternPartType.PLAIN);
                this.patternPartTypes[i] = patternPartType;
            }
        }

        Pattern getPatternPartMatcher(int n, boolean bl) {
            Pattern pattern = this.patternPartMatchers[n];
            if (pattern == null) {
                this.patternPartMatchers[n] = pattern = Pattern.compile(AntPattern.makeJdkPattern(this.patternParts[n]), bl ? 0 : 66);
            }
            return pattern;
        }

        static String makeJdkPattern(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "*?", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0) continue;
                if (string2.equals("?")) {
                    stringBuilder.append(string2);
                    continue;
                }
                if (string2.equals("*")) {
                    stringBuilder.append(".*");
                    continue;
                }
                stringBuilder.append(AntPattern.quote(string2));
            }
            return stringBuilder.toString();
        }

        static String quote(String string) {
            StringBuilder stringBuilder = null;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if ("\\.[](){}+^$|?*".indexOf(c) != -1) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length() + 10);
                        stringBuilder.append(string.substring(0, i));
                    }
                    stringBuilder.append('\\');
                }
                if (stringBuilder == null) continue;
                stringBuilder.append(c);
            }
            return stringBuilder != null ? stringBuilder.toString() : string;
        }

        boolean isLastPart(int n) {
            return n == this.patternParts.length - 1;
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == AntPattern.class && Arrays.equals(this.patternParts, ((AntPattern)object).patternParts);
        }

        public String toString() {
            String string;
            if (this.patternParts.length == 0) {
                string = "[]";
            } else {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append('[');
                stringBuilder.append(this.patternParts[0]);
                for (int i = 1; i < this.patternParts.length; ++i) {
                    stringBuilder.append(',').append(this.patternParts[i]);
                }
                stringBuilder.append(']');
                string = stringBuilder.toString();
            }
            return super.toString() + string;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum PatternPartType {
            DOUBLE_STAR,
            REGEXP,
            PLAIN;

        }
    }

    static final class PatternTest {
        final AntPattern pattern;
        final boolean includePattern;
        int patternPartIndex;

        PatternTest(AntPattern antPattern, boolean bl, int n) {
            this.pattern = antPattern;
            this.includePattern = bl;
            this.patternPartIndex = n;
        }
    }
}

