/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.TestsuiteNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class TestsuiteNode
extends AbstractNode {
    private String suiteName;
    private Report report;
    private boolean filtered;

    TestsuiteNode(String string, boolean bl) {
        this(null, string, bl);
    }

    TestsuiteNode(Report report, boolean bl) {
        this(report, null, bl);
    }

    private TestsuiteNode(Report report, String string, boolean bl) {
        super((Children)(report != null ? new TestsuiteNodeChildren(report, bl) : Children.LEAF));
        this.report = report;
        this.suiteName = report != null ? report.suiteClassName : string;
        this.filtered = bl;
        assert (this.suiteName != null);
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/class.gif");
    }

    void displayReport(Report report) {
        assert (this.report == null && report != null);
        assert (report.suiteClassName.equals(this.suiteName) || this.suiteName == ResultDisplayHandler.ANONYMOUS_SUITE);
        this.report = report;
        this.suiteName = report.suiteClassName;
        this.setDisplayName();
        this.setChildren((Children)new TestsuiteNodeChildren(report, this.filtered));
    }

    Report getReport() {
        return this.report;
    }

    private void setDisplayName() {
        boolean bl;
        String string = this.report == null ? (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning", (Object)this.suiteName) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunningNoname")) : ((bl = this.containsFailed()) ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteFailed", (Object)this.suiteName) : this.suiteName);
        this.setDisplayName(string);
    }

    public String getHtmlDisplayName() {
        assert (this.suiteName != null);
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.suiteName != ResultDisplayHandler.ANONYMOUS_SUITE) {
            stringBuffer.append(this.suiteName);
            stringBuffer.append("&nbsp;&nbsp;");
        } else {
            stringBuffer.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteNoname"));
            stringBuffer.append("&nbsp;");
        }
        if (this.report != null) {
            boolean bl = this.containsFailed();
            stringBuffer.append("<font color='#");
            stringBuffer.append(bl ? "FF0000'>" : "00CC00'>");
            stringBuffer.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(bl ? "MSG_TestsuiteFailed_HTML" : "MSG_TestsuitePassed_HTML")));
            stringBuffer.append("</font>");
        } else {
            stringBuffer.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_TestsuiteRunning_HTML"));
        }
        return stringBuffer.toString();
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        Children children = this.getChildren();
        if (children != Children.LEAF) {
            ((TestsuiteNodeChildren)children).setFiltered(bl);
        }
    }

    private boolean containsFailed() {
        return this.report != null && this.report.failures + this.report.errors != 0;
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }
}

