/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultPanelTree;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatisticsPanel
extends JPanel
implements ItemListener {
    private final ResultPanelTree treePanel;
    private JToggleButton btnFilter;
    private String tooltipShowAll;
    private String tooltipShowFailures;

    public StatisticsPanel(ResultDisplayHandler resultDisplayHandler) {
        super(new BorderLayout(0, 0));
        JComponent jComponent = this.createToolbar();
        this.treePanel = new ResultPanelTree(resultDisplayHandler);
        this.treePanel.setFiltered(this.btnFilter.isSelected());
        this.add((Component)jComponent, "West");
        this.add((Component)this.treePanel, "Center");
    }

    private JComponent createToolbar() {
        this.createFilterButton();
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setLayout(new BoxLayout(jToolBar, 1));
        jToolBar.add(this.btnFilter);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.setFocusable(false);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        return jToolBar;
    }

    private void createFilterButton() {
        this.btnFilter = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/junit/output/res/filter.png", (boolean)true)));
        this.btnFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_FilterButton"));
        this.btnFilter.addItemListener(this);
        this.updateFilterButtonLabel();
    }

    private void updateFilterButtonLabel() {
        if (this.tooltipShowAll == null) {
            this.tooltipShowAll = NbBundle.getMessage(this.getClass(), (String)"MultiviewPanel.btnFilter.showAll.tooltip");
            this.tooltipShowFailures = NbBundle.getMessage(this.getClass(), (String)"MultiviewPanel.btnFilter.showFailures.tooltip");
        }
        this.btnFilter.setToolTipText(this.btnFilter.isSelected() ? this.tooltipShowAll : this.tooltipShowFailures);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.treePanel.setFiltered(this.btnFilter.isSelected());
        this.updateFilterButtonLabel();
    }

    void displayReport(Report report) {
        this.treePanel.displayReport(report);
        this.btnFilter.setEnabled(this.treePanel.getSuccessDisplayedLevel() != 0);
    }

    void displayReports(List<Report> list) {
        if (list.isEmpty()) {
            return;
        }
        this.treePanel.displayReports(list);
        this.btnFilter.setEnabled(this.treePanel.getSuccessDisplayedLevel() != 0);
    }

    void displaySuiteRunning(String string) {
        this.treePanel.displaySuiteRunning(string);
    }

    void displayMsg(String string) {
        this.treePanel.displayMsg(string);
    }
}

