/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.ClassNameTextField;
import org.netbeans.modules.junit.GuiUtils;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.MessageStack;
import org.netbeans.modules.junit.SelfResizingPanel;
import org.netbeans.modules.junit.TestUtil;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class JUnitCfgOfCreate
extends SelfResizingPanel
implements ChangeListener {
    private static final String TEST_CLASS_SUFFIX = "Test";
    private final Node[] nodes;
    private final boolean multipleClasses;
    private boolean singlePackage;
    private boolean singleClass;
    private String testClassName;
    private List<ChangeListener> changeListeners;
    private String initialMessage;
    private boolean hasTargetFolders = false;
    private boolean classNameValid;
    private boolean isAcceptable;
    private static final int MSG_TYPE_NO_TARGET_FOLDERS = 0;
    private static final int MSG_TYPE_CLASSNAME_INVALID = 1;
    private static final int MSG_TYPE_CLASSNAME_NOT_DEFAULT = 2;
    private MessageStack msgStack = new MessageStack(3);
    public ResourceBundle bundle;
    private JLabel lblClassToTestValue;
    private ClassNameTextField tfClassName;
    private JTextComponent txtAreaMessage;
    private JComboBox cboxLocation;
    private JCheckBox chkAbstractImpl;
    private JCheckBox chkComments;
    private JCheckBox chkContent;
    private JCheckBox chkExceptions;
    private JCheckBox chkGenerateSuites;
    private JCheckBox chkJavaDoc;
    private JCheckBox chkPackage;
    private JCheckBox chkPackagePrivateClasses;
    private JCheckBox chkProtected;
    private JCheckBox chkPublic;
    private JCheckBox chkSetUp;
    private JCheckBox chkTearDown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JUnitCfgOfCreate(Node[] nodeArray) {
        assert (nodeArray != null && nodeArray.length != 0);
        this.nodes = nodeArray;
        this.multipleClasses = this.checkMultipleClasses();
        this.initBundle();
        try {
            this.initComponents();
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
            this.addAccessibleDescriptions();
            this.initializeCheckBoxStates();
            this.fillFormData();
            this.checkAcceptability();
            this.setupUserInteraction();
        }
        finally {
            this.unlinkBundle();
        }
    }

    private void addAccessibleDescriptions() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.AD"));
        if (this.tfClassName != null) {
            this.tfClassName.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.clsName.toolTip"));
            this.tfClassName.getAccessibleContext().setAccessibleName(this.bundle.getString("JUnitCfgOfCreate.clsName.AN"));
            this.tfClassName.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.clsName.AD"));
        }
        this.cboxLocation.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.location.toolTip"));
        this.cboxLocation.getAccessibleContext().setAccessibleName(this.bundle.getString("JUnitCfgOfCreate.location.AN"));
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.location.AD"));
        this.chkPublic.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkPublic.toolTip"));
        this.chkPublic.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkPublic.AD"));
        this.chkProtected.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkProtected.toolTip"));
        this.chkProtected.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkProtected.AD"));
        this.chkPackage.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkPackage.toolTip"));
        this.chkPackage.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkPackage.AD"));
        this.chkComments.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkComments.toolTip"));
        this.chkComments.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkComments.AD"));
        this.chkContent.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkContent.toolTip"));
        this.chkContent.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkContent.AD"));
        this.chkJavaDoc.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkJavaDoc.toolTip"));
        this.chkJavaDoc.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkJavaDoc.AD"));
        if (this.multipleClasses) {
            this.chkExceptions.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkExceptions.toolTip"));
            this.chkExceptions.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkExceptions.AD"));
            this.chkAbstractImpl.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkAbstractImpl.toolTip"));
            this.chkAbstractImpl.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkAbstractImpl.AD"));
            this.chkPackagePrivateClasses.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkPackagePrivateClasses.toolTip"));
            this.chkPackagePrivateClasses.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkPackagePrivateClasses.AD"));
            this.chkGenerateSuites.setToolTipText(this.bundle.getString("JUnitCfgOfCreate.chkGenerateSuites.toolTip"));
            this.chkGenerateSuites.getAccessibleContext().setAccessibleDescription(this.bundle.getString("JUnitCfgOfCreate.chkGenerateSuites.AD"));
        }
    }

    private boolean checkMultipleClasses() {
        if (this.nodes.length > 1) {
            return true;
        }
        Lookup lookup = this.nodes[0].getLookup();
        if (lookup.lookup(DataObject.Container.class) != null) {
            this.singlePackage = lookup.lookup(DataFolder.class) != null;
            return true;
        }
        this.singleClass = false;
        DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
        if (dataObject == null) {
            return true;
        }
        this.singleClass = dataObject.getPrimaryFile().isData();
        return !this.singleClass;
    }

    boolean configure() {
        String string = NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"JUnitCfgOfCreate.Title");
        final JButton jButton = new JButton(NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"LBL_OK"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"AN_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JUnitCfgOfCreate.class, (String)"AD_OK"));
        jButton.setEnabled(this.isAcceptable());
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jButton.setEnabled(JUnitCfgOfCreate.this.isAcceptable());
            }
        };
        this.addChangeListener(changeListener);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)this, string, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx(JUnitCfgOfCreate.class), (ActionListener)null));
        this.removeChangeListener(changeListener);
        if (object == jButton) {
            this.rememberCheckBoxStates();
            this.testClassName = this.tfClassName != null ? this.tfClassName.getText() : null;
            return true;
        }
        return false;
    }

    boolean isSingleClass() {
        return this.singleClass;
    }

    String getTestClassName() {
        return this.testClassName;
    }

    private void initializeCheckBoxStates() {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        this.chkPublic.setSelected(jUnitSettings.isMembersPublic());
        this.chkProtected.setSelected(jUnitSettings.isMembersProtected());
        this.chkPackage.setSelected(jUnitSettings.isMembersPackage());
        this.chkComments.setSelected(jUnitSettings.isBodyComments());
        this.chkContent.setSelected(jUnitSettings.isBodyContent());
        this.chkJavaDoc.setSelected(jUnitSettings.isJavaDoc());
        if (this.multipleClasses) {
            this.chkGenerateSuites.setSelected(jUnitSettings.isGenerateSuiteClasses());
            this.chkPackagePrivateClasses.setSelected(jUnitSettings.isIncludePackagePrivateClasses());
            this.chkAbstractImpl.setSelected(jUnitSettings.isGenerateAbstractImpl());
            this.chkExceptions.setSelected(jUnitSettings.isGenerateExceptionClasses());
        }
        this.chkSetUp.setSelected(jUnitSettings.isGenerateSetUp());
        this.chkTearDown.setSelected(jUnitSettings.isGenerateTearDown());
    }

    private void rememberCheckBoxStates() {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        jUnitSettings.setMembersPublic(this.chkPublic.isSelected());
        jUnitSettings.setMembersProtected(this.chkProtected.isSelected());
        jUnitSettings.setMembersPackage(this.chkPackage.isSelected());
        jUnitSettings.setBodyComments(this.chkComments.isSelected());
        jUnitSettings.setBodyContent(this.chkContent.isSelected());
        jUnitSettings.setJavaDoc(this.chkJavaDoc.isSelected());
        if (this.multipleClasses) {
            jUnitSettings.setGenerateSuiteClasses(this.chkGenerateSuites.isSelected());
            jUnitSettings.setIncludePackagePrivateClasses(this.chkPackagePrivateClasses.isSelected());
            jUnitSettings.setGenerateAbstractImpl(this.chkAbstractImpl.isSelected());
            jUnitSettings.setGenerateExceptionClasses(this.chkExceptions.isSelected());
        }
        jUnitSettings.setGenerateSetUp(this.chkSetUp.isSelected());
        jUnitSettings.setGenerateTearDown(this.chkTearDown.isSelected());
    }

    private void initBundle() {
        this.bundle = NbBundle.getBundle(JUnitCfgOfCreate.class);
    }

    private void unlinkBundle() {
        this.bundle = null;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 12));
        this.add(this.createNameAndLocationPanel(), "North");
        this.add(this.createMessagePanel(), "Center");
        this.add(this.createCodeGenPanel(), "South");
    }

    private void setupUserInteraction() {
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        this.chkPublic.addItemListener(checkBoxListener);
        this.chkProtected.addItemListener(checkBoxListener);
        this.chkPackage.addItemListener(checkBoxListener);
    }

    private Component createNameAndLocationPanel() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        boolean bl = this.singleClass;
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = bl ? new JLabel() : null;
        JLabel jLabel3 = new JLabel();
        String string = this.singlePackage ? "LBL_PackageToTest" : (this.singleClass ? "LBL_ClassToTest" : "LBL_MultipleClassesSelected");
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(this.getClass(), (String)string));
        if (bl) {
            Mnemonics.setLocalizedText((JLabel)jLabel2, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_ClassName"));
        }
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)NbBundle.getMessage(this.getClass(), (String)"LBL_Location"));
        if (this.singlePackage || this.singleClass) {
            this.lblClassToTestValue = new JLabel();
        }
        if (bl) {
            this.tfClassName = new ClassNameTextField();
            this.tfClassName.setChangeListener(this);
        }
        this.cboxLocation = new JComboBox();
        if (bl) {
            jLabel2.setLabelFor(this.tfClassName);
        }
        jLabel3.setLabelFor(this.cboxLocation);
        if (this.lblClassToTestValue != null && (serializable = UIManager.getDefaults().getFont("TextField.font")) != null) {
            this.lblClassToTestValue.setFont((Font)serializable);
        }
        jPanel.setLayout(new GridBagLayout());
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).insets.bottom = 12;
        ((GridBagConstraints)serializable).insets.right = 6;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        if (this.lblClassToTestValue != null) {
            jPanel.add((Component)jLabel, serializable);
            jPanel.add((Component)this.lblClassToTestValue, gridBagConstraints);
        } else {
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        if (bl) {
            jPanel.add((Component)jLabel2, serializable);
            jPanel.add((Component)this.tfClassName, gridBagConstraints);
        }
        ((GridBagConstraints)serializable).insets.bottom = 0;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)jLabel3, serializable);
        jPanel.add((Component)this.cboxLocation, gridBagConstraints);
        return jPanel;
    }

    private void checkClassNameValidity() {
        if (this.tfClassName == null) {
            this.classNameValid = true;
            return;
        }
        String string = null;
        int n = this.tfClassName.getStatus();
        switch (n) {
            case 1: {
                string = "MSG_ClassnameMustNotBeEmpty";
                break;
            }
            case 2: {
                string = "MSG_InvalidClassName";
                break;
            }
            case 3: {
                string = "MSG_ClassNameNotDefault";
            }
        }
        if (n != 3) {
            this.setMessage(null, 2);
        }
        this.setMessage(string != null ? NbBundle.getMessage(this.getClass(), (String)string) : null, 1);
        this.classNameValid = n == 0 || n == 3;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkClassNameValidity();
        this.checkAcceptability();
    }

    private void checkAcceptability() {
        boolean bl = this.isAcceptable;
        boolean bl2 = this.isAcceptable = this.hasTargetFolders && this.classNameValid;
        if (this.isAcceptable != bl) {
            this.fireStateChange();
        }
    }

    private boolean isAcceptable() {
        return this.isAcceptable;
    }

    protected void paintedFirstTime(Graphics graphics) {
        if (this.initialMessage != null) {
            this.displayMessage(this.initialMessage);
            this.initialMessage = null;
        }
    }

    private void setMessage(String string, int n) {
        String string2 = this.msgStack.setMessage(n, string);
        if (string2 == null) {
            return;
        }
        if (!this.isPainted()) {
            this.initialMessage = string2;
        } else {
            this.displayMessage(string2);
        }
    }

    private void displayMessage(String string) {
        if (string == null) {
            string = "";
        }
        this.txtAreaMessage.setText(string);
        this.adjustWindowSize();
    }

    private Component createMessagePanel() {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(89, 79, 191);
        }
        this.txtAreaMessage = GuiUtils.createMultilineLabel("", color);
        return this.txtAreaMessage;
    }

    private Component createCodeGenPanel() {
        String[] stringArray = this.multipleClasses ? new String[]{"Public", "Protected", "Package", "PackagePrivateClasses", "AbstractImpl", "Exceptions", "GenerateSuites", "SetUp", "TearDown", "Content", "JavaDoc", "Comments"} : new String[]{"Public", "Protected", "Package", null, null, null, null, "SetUp", "TearDown", "Content", "JavaDoc", "Comments"};
        JCheckBox[] jCheckBoxArray = GuiUtils.createCheckBoxes(stringArray);
        int n = 0;
        this.chkPublic = jCheckBoxArray[n++];
        this.chkProtected = jCheckBoxArray[n++];
        this.chkPackage = jCheckBoxArray[n++];
        this.chkPackagePrivateClasses = jCheckBoxArray[n++];
        this.chkAbstractImpl = jCheckBoxArray[n++];
        this.chkExceptions = jCheckBoxArray[n++];
        this.chkGenerateSuites = jCheckBoxArray[n++];
        this.chkSetUp = jCheckBoxArray[n++];
        this.chkTearDown = jCheckBoxArray[n++];
        this.chkContent = jCheckBoxArray[n++];
        this.chkJavaDoc = jCheckBoxArray[n++];
        this.chkComments = jCheckBoxArray[n++];
        JComponent jComponent = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupAccessLevels"), new JCheckBox[]{this.chkPublic, this.chkProtected, this.chkPackage});
        JComponent jComponent2 = null;
        JComponent jComponent3 = null;
        if (this.multipleClasses) {
            jComponent2 = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupClassTypes"), new JCheckBox[]{this.chkPackagePrivateClasses, this.chkAbstractImpl, this.chkExceptions});
            jComponent3 = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupOptClasses"), new JCheckBox[]{this.chkGenerateSuites});
        }
        JComponent jComponent4 = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupOptCode"), new JCheckBox[]{this.chkSetUp, this.chkTearDown, this.chkContent});
        JComponent jComponent5 = GuiUtils.createChkBoxGroup(this.bundle.getString("JUnitCfgOfCreate.groupOptComments"), new JCheckBox[]{this.chkJavaDoc, this.chkComments});
        Box box = Box.createVerticalBox();
        box.add(jComponent);
        if (this.multipleClasses) {
            box.add(Box.createVerticalStrut(11));
            box.add(jComponent2);
        } else {
            box.add(Box.createVerticalStrut(0));
        }
        box.add(Box.createVerticalGlue());
        Box box2 = Box.createVerticalBox();
        if (this.multipleClasses) {
            box2.add(jComponent3);
            box2.add(Box.createVerticalStrut(11));
        }
        box2.add(jComponent4);
        box2.add(Box.createVerticalStrut(11));
        box2.add(jComponent5);
        box2.add(Box.createVerticalGlue());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(box);
        jPanel.add(Box.createHorizontalStrut(24));
        jPanel.add(box2);
        JUnitCfgOfCreate.addTitledBorder(jPanel, new Insets(12, 12, 11, 12), this.bundle.getString("JUnitCfgOfCreate.jpCodeGen.title"));
        jComponent.setAlignmentX(0.0f);
        if (this.multipleClasses) {
            jComponent2.setAlignmentX(0.0f);
            jComponent3.setAlignmentX(0.0f);
        }
        jComponent4.setAlignmentX(0.0f);
        jComponent5.setAlignmentX(0.0f);
        return jPanel;
    }

    private static void addTitledBorder(JComponent jComponent, Insets insets, String string) {
        Border border = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), string);
        jComponent.setBorder(new CompoundBorder(titledBorder, border));
    }

    FileObject getTargetFolder() {
        Object object = this.cboxLocation.getSelectedItem();
        if (object == null) {
            return null;
        }
        if (object instanceof SourceGroup) {
            return ((SourceGroup)object).getRootFolder();
        }
        assert (object instanceof FileObject);
        return (FileObject)object;
    }

    private void fillFormData() {
        DataObject dataObject = (DataObject)this.nodes[0].getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.singleClass) {
            assert (this.nodes.length == 1);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string = classPath.getResourceName(fileObject, '.', false);
            this.lblClassToTestValue.setText(string);
            if (this.tfClassName != null) {
                String string2 = string + TEST_CLASS_SUFFIX;
                this.tfClassName.setText(string2);
                this.tfClassName.setDefaultText(string2);
                this.tfClassName.setCaretPosition(string2.length());
            }
        } else if (this.singlePackage) {
            assert (this.nodes.length == 1);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            String string = classPath.getResourceName(fileObject, '.', true);
            if (string.length() == 0) {
                string = NbBundle.getMessage(this.getClass(), (String)"DefaultPackageName");
            }
            this.lblClassToTestValue.setText(string);
        }
        this.setupLocationChooser(fileObject);
        this.checkClassNameValidity();
    }

    private void setupLocationChooser(FileObject fileObject) {
        Object[] objectArray = TestUtil.getTestTargets(fileObject);
        if (objectArray.length != 0) {
            this.hasTargetFolders = true;
            this.cboxLocation.setModel(new DefaultComboBoxModel<Object>(objectArray));
            this.cboxLocation.setRenderer(new LocationChooserRenderer());
        } else {
            this.hasTargetFolders = false;
            String string = NbBundle.getMessage(this.getClass(), (String)(fileObject.isFolder() ? "MSG_NoTestTarget_Fo" : "MSG_NoTestTarget_Fi"), (Object)fileObject.getNameExt());
            this.setMessage(string, 0);
            this.disableComponents();
        }
    }

    private void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(3);
        }
        this.changeListeners.add(changeListener);
    }

    private void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null && this.changeListeners.remove(changeListener) && this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }

    private void fireStateChange() {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator<ChangeListener> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().stateChanged(changeEvent);
            }
        }
    }

    private void disableComponents() {
        Stack<Container> stack = new Stack<Container>();
        stack.push(this);
        while (!stack.empty()) {
            Container container = (Container)stack.pop();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Container container2;
                Component component = componentArray[i];
                if (component == this.txtAreaMessage) continue;
                if (component instanceof JPanel) {
                    container2 = (JPanel)component;
                    stack.push(container2);
                    Border border = ((JComponent)container2).getBorder();
                    if (border == null) continue;
                    JUnitCfgOfCreate.disableBorderTitles(border);
                    continue;
                }
                component.setEnabled(false);
                if (!(component instanceof Container) || (container2 = (Container)component).getComponentCount() == 0) continue;
                stack.push(container2);
            }
        }
    }

    private static void disableBorderTitles(Border border) {
        if (border instanceof TitledBorder) {
            JUnitCfgOfCreate.disableBorderTitle((TitledBorder)border);
            return;
        }
        if (!(border instanceof CompoundBorder)) {
            return;
        }
        Stack<CompoundBorder> stack = new Stack<CompoundBorder>();
        stack.push((CompoundBorder)border);
        while (!stack.empty()) {
            CompoundBorder compoundBorder = (CompoundBorder)stack.pop();
            Border border2 = compoundBorder.getOutsideBorder();
            if (border2 instanceof CompoundBorder) {
                stack.push((CompoundBorder)border2);
            } else if (border2 instanceof TitledBorder) {
                JUnitCfgOfCreate.disableBorderTitle((TitledBorder)border2);
            }
            border2 = compoundBorder.getInsideBorder();
            if (border2 instanceof CompoundBorder) {
                stack.push((CompoundBorder)border2);
                continue;
            }
            if (!(border2 instanceof TitledBorder)) continue;
            JUnitCfgOfCreate.disableBorderTitle((TitledBorder)border2);
        }
    }

    private static void disableBorderTitle(TitledBorder titledBorder) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            titledBorder.setTitleColor(color);
        }
    }

    private final class LocationChooserRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public LocationChooserRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = object instanceof SourceGroup ? ((SourceGroup)object).getDisplayName() : (object instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)object)) : object.toString());
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    private final class CheckBoxListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            assert (object == JUnitCfgOfCreate.this.chkPublic || object == JUnitCfgOfCreate.this.chkProtected || object == JUnitCfgOfCreate.this.chkPackage);
            JUnitCfgOfCreate.this.checkAcceptability();
        }
    }
}

