/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassMap {
    private static final int SETUP_POS_INDEX = 0;
    private static final int TEARDOWN_POS_INDEX = 1;
    private static final int FIRST_METHOD_POS_INDEX = 2;
    private static final int LAST_INIT_POS_INDEX = 3;
    private static final int FIRST_NESTED_POS_INDEX = 4;
    private static final int BEFORE_POS_INDEX = 5;
    private static final int AFTER_POS_INDEX = 6;
    private static final int BEFORE_CLASS_POS_INDEX = 7;
    private static final int AFTER_CLASS_POS_INDEX = 8;
    private static final String JUNIT4_PKG_PREFIX = "org.junit.";
    private final List<String> signatures;
    private final int[] positions = new int[9];

    private ClassMap(List<String> list) {
        for (int i = 0; i < this.positions.length; ++i) {
            this.positions[i] = -1;
        }
        this.signatures = list;
    }

    static ClassMap forClass(ClassTree classTree, TreePath treePath, Trees trees) {
        if (classTree == null) {
            throw new IllegalArgumentException("ClassTree: null");
        }
        if (treePath == null) {
            throw new IllegalArgumentException("TreePath: null");
        }
        if (treePath.getLeaf() != classTree) {
            throw new IllegalArgumentException("given ClassTree is not leaf of the given TreePath");
        }
        List<? extends Tree> list = classTree.getMembers();
        if (list.isEmpty()) {
            return new ClassMap(new ArrayList<String>());
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        ClassMap classMap = new ClassMap(arrayList);
        int n = 0;
        for (Tree tree : list) {
            String string;
            switch (tree.getKind()) {
                case BLOCK: {
                    string = "* ";
                    classMap.setLastInitializerIndex(n);
                    break;
                }
                case VARIABLE: {
                    string = "- ";
                    break;
                }
                case CLASS: {
                    string = "[ ";
                    if (classMap.getFirstNestedClassIndex() != -1) break;
                    classMap.setFirstNestedClassIndex(n);
                    break;
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    boolean bl = !methodTree.getParameters().isEmpty();
                    Name name = methodTree.getName();
                    if (name.contentEquals("<init>")) {
                        string = bl ? "*+" : "* ";
                        classMap.setLastInitializerIndex(n);
                        break;
                    }
                    if (!bl) {
                        if (classMap.getSetUpIndex() == -1 && name.contentEquals("setUp")) {
                            classMap.setSetUpIndex(n);
                        }
                        if (classMap.getTearDownIndex() == -1 && name.contentEquals("tearDown")) {
                            classMap.setTearDownIndex(n);
                        }
                    }
                    string = (bl ? "!+" : "! ") + name.toString();
                    if (classMap.getFirstMethodIndex() == -1) {
                        classMap.setFirstMethodIndex(n);
                    }
                    if (methodTree.getModifiers().getAnnotations().isEmpty()) break;
                    TreePath treePath2 = new TreePath(treePath, methodTree);
                    Element element = trees.getElement(treePath2);
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        int n2;
                        Element element2 = annotationMirror.getAnnotationType().asElement();
                        String string2 = ((TypeElement)element2).getQualifiedName().toString();
                        if (!string2.startsWith(JUNIT4_PKG_PREFIX)) continue;
                        String string3 = string2.substring(JUNIT4_PKG_PREFIX.length());
                        if (string3.equals("Before")) {
                            n2 = 5;
                        } else if (string3.equals("After")) {
                            n2 = 6;
                        } else if (string3.equals("BeforeClass")) {
                            n2 = 7;
                        } else {
                            if (!string3.equals("AfterClass")) continue;
                            n2 = 8;
                        }
                        if (classMap.positions[n2] != -1) continue;
                        classMap.positions[n2] = n;
                    }
                    break;
                }
                default: {
                    string = "x ";
                }
            }
            arrayList.add(string);
            ++n;
        }
        return classMap;
    }

    int getSetUpIndex() {
        return this.positions[0];
    }

    private void setSetUpIndex(int n) {
        this.positions[0] = n;
    }

    int getTearDownIndex() {
        return this.positions[1];
    }

    private void setTearDownIndex(int n) {
        this.positions[1] = n;
    }

    int getBeforeIndex() {
        return this.positions[5];
    }

    private void setBeforeIndex(int n) {
        this.positions[5] = n;
    }

    int getAfterIndex() {
        return this.positions[6];
    }

    private void setAfterIndex(int n) {
        this.positions[6] = n;
    }

    int getBeforeClassIndex() {
        return this.positions[7];
    }

    private void setBeforeClassIndex(int n) {
        this.positions[7] = n;
    }

    int getAfterClassIndex() {
        return this.positions[8];
    }

    private void setAfterClassIndex(int n) {
        this.positions[8] = n;
    }

    int getFirstMethodIndex() {
        return this.positions[2];
    }

    private void setFirstMethodIndex(int n) {
        this.positions[2] = n;
    }

    int getFirstNestedClassIndex() {
        return this.positions[4];
    }

    private void setFirstNestedClassIndex(int n) {
        this.positions[4] = n;
    }

    int getLastInitializerIndex() {
        return this.positions[3];
    }

    private void setLastInitializerIndex(int n) {
        this.positions[3] = n;
    }

    boolean containsSetUp() {
        return this.getSetUpIndex() != -1;
    }

    boolean containsTearDown() {
        return this.getTearDownIndex() != -1;
    }

    boolean containsBefore() {
        return this.getBeforeIndex() != -1;
    }

    boolean containsAfter() {
        return this.getAfterIndex() != -1;
    }

    boolean containsBeforeClass() {
        return this.getBeforeClassIndex() != -1;
    }

    boolean containsAfterClass() {
        return this.getAfterClassIndex() != -1;
    }

    boolean containsNoArgMethod(String string) {
        return this.findNoArgMethod(string) != -1;
    }

    boolean containsMethods() {
        return this.getFirstMethodIndex() != -1;
    }

    boolean containsInitializers() {
        return this.getLastInitializerIndex() != -1;
    }

    boolean containsNestedClasses() {
        return this.getFirstNestedClassIndex() != -1;
    }

    int findNoArgMethod(String string) {
        if (!this.containsMethods()) {
            return -1;
        }
        if (string.equals("setUp")) {
            return this.getSetUpIndex();
        }
        if (string.equals("tearDown")) {
            return this.getTearDownIndex();
        }
        return this.signatures.indexOf("! " + string);
    }

    void addNoArgMethod(String string) {
        this.addNoArgMethod(string, this.size());
    }

    void addNoArgMethod(String string, int n) {
        int n2 = this.size();
        if (n > n2) {
            throw new IndexOutOfBoundsException("index: " + n + ", size: " + n2);
        }
        String string2 = "! " + string;
        if (n != n2) {
            this.signatures.add(n, string2);
            this.shiftPositions(n, 1);
        } else {
            this.signatures.add(string2);
        }
        if (string.equals("setUp")) {
            this.setSetUpIndex(n);
        } else if (string.equals("tearDown")) {
            this.setTearDownIndex(n);
        }
        if (this.getFirstMethodIndex() == -1) {
            this.setFirstMethodIndex(n);
        }
    }

    void addNoArgMethod(String string, String string2) {
        this.addNoArgMethod(string, string2, this.size());
    }

    void addNoArgMethod(String string, String string2, int n) {
        this.addNoArgMethod(string, n);
        if (string2.equals("org.junit.Before")) {
            this.setBeforeIndex(n);
        } else if (string2.equals("org.junit.After")) {
            this.setAfterIndex(n);
        } else if (string2.equals("org.junit.BeforeClass")) {
            this.setBeforeClassIndex(n);
        } else if (string2.equals("org.junit.AfterClass")) {
            this.setAfterClassIndex(n);
        }
    }

    void removeNoArgMethod(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index (" + n + ')');
        }
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException("index: " + n + ", size: " + this.size());
        }
        String string = this.signatures.get(n);
        if (!string.startsWith("! ")) {
            throw new IllegalArgumentException("not a no-arg method at the given index (" + n + ')');
        }
        if (n == this.getSetUpIndex()) {
            this.setSetUpIndex(-1);
        } else if (n == this.getTearDownIndex()) {
            this.setTearDownIndex(-1);
        }
        if (n == this.getFirstMethodIndex()) {
            int n2 = this.size();
            if (n == n2 - 1) {
                this.setFirstMethodIndex(-1);
            } else {
                int n3 = -1;
                int n4 = n + 1;
                for (String string2 : this.signatures.subList(n + 1, n2)) {
                    if (string2.startsWith("! ")) {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                this.setFirstMethodIndex(n3);
            }
        }
        this.shiftPositions(n + 1, -1);
    }

    List<String> getNoArgMethods() {
        if (!this.containsMethods()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(this.signatures.size());
        for (String string : this.signatures) {
            if (!string.startsWith("! ")) continue;
            arrayList.add(string.substring(2));
        }
        return arrayList.isEmpty() ? Collections.emptyList() : arrayList;
    }

    int size() {
        return this.signatures.size();
    }

    private void shiftPositions(int n, int n2) {
        for (int i = 0; i < this.positions.length; ++i) {
            int n3 = this.positions[i];
            if (n3 == -1 || n3 < n) continue;
            this.positions[i] = n3 + n2;
        }
    }
}

