/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.AMConfigManager;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.AMConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.CertificateSettingsType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ObjectFactory;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ProviderConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ResponseType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.SecurityMechanismType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ServerConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.UserPassSettingsType;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;
import org.netbeans.modules.identity.profile.api.configurator.spi.TrustAuthorityConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderConfigImpl
implements ProviderConfig {
    private String pName = null;
    private String pType = null;
    private JAXBElement<AMConfigType> amconfig = null;
    private ObjectFactory objFactory = null;
    private ProviderConfigType providerConfig = null;
    private String path;

    public ProviderConfigImpl(String string, String string2, String string3) {
        this.pName = string;
        this.pType = string2;
        this.path = string3;
        this.objFactory = new ObjectFactory();
        this.amconfig = AMConfigManager.getDefault().getAMConfig(string3);
        for (ProviderConfigType providerConfigType : ((AMConfigType)this.amconfig.getValue()).getProviderConfig()) {
            if (!providerConfigType.getName().equals(string) || !providerConfigType.getType().equals(string2)) continue;
            this.providerConfig = providerConfigType;
            break;
        }
        if (this.providerConfig == null) {
            this.providerConfig = this.objFactory.createProviderConfigType();
            ((AMConfigType)this.amconfig.getValue()).getProviderConfig().add(this.providerConfig);
            this.providerConfig.setName(string);
            this.providerConfig.setType(string2);
        }
    }

    @Override
    public boolean isResponseSignEnabled() {
        ResponseType responseType = this.providerConfig.getResponse();
        if (responseType != null) {
            return responseType.isSigned();
        }
        return false;
    }

    @Override
    public void setResponseSignEnabled(boolean bl) {
        ResponseType responseType = this.providerConfig.getResponse();
        if (responseType == null) {
            responseType = this.objFactory.createResponseType();
            this.providerConfig.setResponse(responseType);
        }
        responseType.setSigned(bl);
    }

    @Override
    public String getKeyAlias() {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType != null) {
            return certificateSettingsType.getKeyAlias();
        }
        return null;
    }

    @Override
    public void setKeyAlias(String string) {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType == null) {
            certificateSettingsType = this.objFactory.createCertificateSettingsType();
            this.providerConfig.setCertificateSettings(certificateSettingsType);
        }
        certificateSettingsType.setKeyAlias(string);
    }

    @Override
    public String getKeyStoreFile() {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType != null) {
            return certificateSettingsType.getKeystoreLocation();
        }
        return null;
    }

    @Override
    public String getKeyStorePassword() {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType != null) {
            return certificateSettingsType.getKeystorePassword();
        }
        return null;
    }

    @Override
    public void setKeyStore(String string, String string2, String string3) {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType == null) {
            certificateSettingsType = this.objFactory.createCertificateSettingsType();
            this.providerConfig.setCertificateSettings(certificateSettingsType);
        }
        certificateSettingsType.setKeystoreLocation(string);
        certificateSettingsType.setKeystorePassword(string2);
        certificateSettingsType.setKeyPassword(string3);
    }

    @Override
    public Object getProperty(String string) {
        return null;
    }

    @Override
    public void setProperty(String string, Object object) {
    }

    @Override
    public Collection<String> getSecurityMechanisms() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SecurityMechanismType securityMechanismType = this.providerConfig.getSecurityMechanism();
        if (securityMechanismType != null) {
            arrayList.add(securityMechanismType.getUri());
        }
        return arrayList;
    }

    @Override
    public void setSecurityMechanisms(Collection<String> collection) {
        if (collection.size() == 0) {
            this.providerConfig.setSecurityMechanism(null);
        } else if (collection.size() == 1) {
            SecurityMechanismType securityMechanismType = this.providerConfig.getSecurityMechanism();
            if (securityMechanismType == null) {
                securityMechanismType = this.objFactory.createSecurityMechanismType();
                this.providerConfig.setSecurityMechanism(securityMechanismType);
            }
            String string = collection.iterator().next();
            securityMechanismType.setUri(string);
        }
    }

    @Override
    public void saveProvider() {
        AMConfigManager.getDefault().saveAMConfig(this.amconfig, this.path);
    }

    @Override
    public void deleteProvider() {
        ArrayList<ProviderConfigType> arrayList = new ArrayList<ProviderConfigType>();
        AMConfigType aMConfigType = (AMConfigType)this.amconfig.getValue();
        List<ProviderConfigType> list = aMConfigType.getProviderConfig();
        for (ProviderConfigType providerConfigType : list) {
            if (providerConfigType.getName().equals(this.pName) && providerConfigType.getType().equals(this.pType)) {
                this.providerConfig = providerConfigType;
                break;
            }
            arrayList.add(providerConfigType);
        }
        list.clear();
        for (ProviderConfigType providerConfigType : arrayList) {
            list.add(providerConfigType);
        }
        this.saveProvider();
    }

    @Override
    public String getWSPEndpoint() {
        return null;
    }

    @Override
    public void setWSPEndpoint(String string) {
    }

    @Override
    public boolean isProviderExists() {
        return true;
    }

    @Override
    public ServerProperties getServerProperties(String string) {
        ServerConfigType serverConfigType = ((AMConfigType)this.amconfig.getValue()).getServerConfig();
        ServerProperties serverProperties = ServerProperties.getInstance(string);
        if (serverConfigType != null) {
            serverProperties.setProperty("org.netbeans.modules.identity.profile.api.configurator.id", serverConfigType.getName());
            serverProperties.setProperty("com.iplanet.am.server.host", serverConfigType.getHost());
            serverProperties.setProperty("com.iplanet.am.server.port", serverConfigType.getPort());
            serverProperties.setProperty("com.sun.identity.agents.app.username", serverConfigType.getUsername());
            serverProperties.setProperty("com.iplanet.am.service.password", serverConfigType.getPassword());
        }
        return serverProperties;
    }

    @Override
    public void setServerProperties(ServerProperties serverProperties) {
        ServerConfigType serverConfigType = ((AMConfigType)this.amconfig.getValue()).getServerConfig();
        if (serverConfigType == null) {
            serverConfigType = this.objFactory.createServerConfigType();
            ((AMConfigType)this.amconfig.getValue()).setServerConfig(serverConfigType);
        }
        serverConfigType.setName(serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        serverConfigType.setHost(serverProperties.getProperty("com.iplanet.am.server.host"));
        serverConfigType.setPort(serverProperties.getProperty("com.iplanet.am.server.port"));
        serverConfigType.setUsername(serverProperties.getProperty("com.sun.identity.agents.app.username"));
        serverConfigType.setPassword(serverProperties.getProperty("com.iplanet.am.service.password"));
    }

    @Override
    public String getUserName() {
        UserPassSettingsType userPassSettingsType = this.getUserPassSettings();
        return userPassSettingsType.getUsername();
    }

    @Override
    public void setUserName(String string) {
        UserPassSettingsType userPassSettingsType = this.getUserPassSettings();
        userPassSettingsType.setUsername(string);
    }

    @Override
    public String getPassword() {
        UserPassSettingsType userPassSettingsType = this.getUserPassSettings();
        return userPassSettingsType.getPassword();
    }

    @Override
    public void setPassword(String string) {
        UserPassSettingsType userPassSettingsType = this.getUserPassSettings();
        userPassSettingsType.setPassword(string);
    }

    private UserPassSettingsType getUserPassSettings() {
        UserPassSettingsType userPassSettingsType = this.providerConfig.getUserPassSettings();
        if (userPassSettingsType == null) {
            userPassSettingsType = this.objFactory.createUserPassSettingsType();
            this.providerConfig.setUserPassSettings(userPassSettingsType);
        }
        return userPassSettingsType;
    }

    @Override
    public void setUserNamePasswordPairs(Collection<Vector<String>> collection) {
    }

    @Override
    public Collection<Vector<String>> getUserNamePasswordPairs() {
        String string = this.getUserName();
        String string2 = this.getPassword();
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        if (string != null || string2 != null) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(string);
            vector2.add(string2);
            vector.add(vector2);
        }
        return vector;
    }

    private boolean isServerPropExist(ServerProperties serverProperties) {
        AMConfigType aMConfigType = (AMConfigType)this.amconfig.getValue();
        if (aMConfigType != null) {
            return aMConfigType.getServerConfig().getName().equals(serverProperties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        }
        return false;
    }

    @Override
    public Collection<String> getAllProviderNames() {
        List<ProviderConfigType> list = ((AMConfigType)this.amconfig.getValue()).getProviderConfig();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ProviderConfigType providerConfigType : list) {
            if (!this.pType.equals(providerConfigType.getType())) continue;
            arrayList.add(providerConfigType.getName());
        }
        return arrayList;
    }

    @Override
    public void setServiceType(String string) {
        this.providerConfig.setServiceType(string);
    }

    @Override
    public void setDefaultKeyStore(boolean bl) {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType == null) {
            certificateSettingsType = this.objFactory.createCertificateSettingsType();
            this.providerConfig.setCertificateSettings(certificateSettingsType);
        }
        certificateSettingsType.setDefaultKeystore(bl);
    }

    @Override
    public boolean useDefaultKeyStore() {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType != null) {
            Boolean bl = certificateSettingsType.isDefaultKeystore();
            return bl != null ? bl : true;
        }
        return true;
    }

    @Override
    public String getServiceType() {
        return this.providerConfig.getServiceType();
    }

    @Override
    public String getKeyPassword() {
        CertificateSettingsType certificateSettingsType = this.providerConfig.getCertificateSettings();
        if (certificateSettingsType != null) {
            return certificateSettingsType.getKeyPassword();
        }
        return null;
    }

    @Override
    public void setTrustAuthorityConfigList(List<TrustAuthorityConfig> list) {
    }

    @Override
    public void close() {
        AMConfigManager.getDefault().removeAMConfig(this.path);
    }
}

