/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MessageAuthentication
extends JPanel {
    private boolean inSync = false;
    private WSDLComponent comp;
    private SecurityProfile secProfile = null;
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysSecConvChBox;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqSigConfChBox;
    private JCheckBox secConvChBox;
    private JComboBox supportTokenCombo;
    private JLabel supportTokenLabel;
    private JComboBox wssVersionCombo;
    private JLabel wssVersionLabel;

    public MessageAuthentication(WSDLComponent wSDLComponent, SecurityProfile securityProfile) {
        this.initComponents();
        this.comp = wSDLComponent;
        this.secProfile = securityProfile;
        this.inSync = true;
        this.supportTokenCombo.removeAllItems();
        this.supportTokenCombo.addItem(ComboConstants.X509);
        this.supportTokenCombo.addItem(ComboConstants.USERNAME);
        this.wssVersionCombo.removeAllItems();
        this.wssVersionCombo.addItem(ComboConstants.WSS10);
        this.wssVersionCombo.addItem(ComboConstants.WSS11);
        this.layoutCombo.removeAllItems();
        this.layoutCombo.addItem(ComboConstants.STRICT);
        this.layoutCombo.addItem(ComboConstants.LAX);
        this.layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        this.layoutCombo.addItem(ComboConstants.LAXTSLAST);
        this.algoSuiteCombo.removeAllItems();
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        ExtensibilityElement extensibilityElement = null;
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
        boolean bl = wSDLComponent != null;
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement(wSDLComponent, SecureConversationToken.class);
        if (bl) {
            WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenElement(wSDLComponent2, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent3);
            Policy policy = (Policy)extensibilityElement.getParent();
            this.setChBox(this.secConvChBox, true);
            this.setChBox(this.derivedKeysSecConvChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(wSDLComponent2));
            this.setCombo(this.wssVersionCombo, SecurityPolicyModelHelper.isWss11((WSDLComponent)policy));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation((WSDLComponent)policy));
            policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent3, Policy.class);
            WSDLComponent wSDLComponent4 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)policy, 1);
            String string = SecurityTokensModelHelper.getTokenType(wSDLComponent4);
            this.setCombo(this.supportTokenCombo, string);
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.secConvChBox, false);
            this.setChBox(this.derivedKeysSecConvChBox, false);
            this.setCombo(this.wssVersionCombo, SecurityPolicyModelHelper.isWss11(this.comp));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
            WSDLComponent wSDLComponent5 = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
            String string = SecurityTokensModelHelper.getTokenType(wSDLComponent5);
            this.setCombo(this.supportTokenCombo, string);
        }
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)extensibilityElement));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)extensibilityElement));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.comp, 2);
        boolean bl = wSDLComponent != null;
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement(wSDLComponent, SecureConversationToken.class);
        if (jComponent.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        if (bl) {
            WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenElement(wSDLComponent2, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent3);
            Policy policy = (Policy)extensibilityElement.getParent();
            if (jComponent.equals(this.derivedKeysSecConvChBox)) {
                SecurityPolicyModelHelper.enableRequireDerivedKeys(wSDLComponent2, this.derivedKeysSecConvChBox.isSelected());
            }
            if (jComponent.equals(this.wssVersionCombo)) {
                boolean bl2 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
                WssElement wssElement = SecurityPolicyModelHelper.enableWss((WSDLComponent)policy, bl2);
                if (bl2) {
                    SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11((WSDLComponent)policy), this.reqSigConfChBox.isSelected());
                }
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
            }
            policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent3, Policy.class);
            if (jComponent.equals(this.supportTokenCombo)) {
                SecurityTokensModelHelper.setSupportingTokens((WSDLComponent)policy, (String)this.supportTokenCombo.getSelectedItem(), 1);
            }
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            if (jComponent.equals(this.reqSigConfChBox)) {
                SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
            if (jComponent.equals(this.wssVersionCombo)) {
                boolean bl3 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
                WssElement wssElement = SecurityPolicyModelHelper.enableWss(this.comp, bl3);
                if (bl3) {
                    SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
                }
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(wssElement, true);
            }
            if (jComponent.equals(this.supportTokenCombo)) {
                SecurityTokensModelHelper.setSupportingTokens(this.comp, (String)this.supportTokenCombo.getSelectedItem(), 1);
            }
        }
        if (jComponent.equals(this.layoutCombo)) {
            SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement, (String)this.layoutCombo.getSelectedItem());
            if (bl) {
                SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement2, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.algoSuiteCombo)) {
            AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement, (String)this.algoSuiteCombo.getSelectedItem());
            if (bl) {
                AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement2, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        this.enableDisable();
    }

    private void enableDisable() {
        boolean bl = this.secConvChBox.isSelected();
        this.derivedKeysSecConvChBox.setEnabled(bl);
        this.reqSigConfChBox.setEnabled(!bl);
        boolean bl2 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
        this.reqSigConfChBox.setEnabled(bl2);
    }

    private void setCombo(JComboBox jComboBox, String string) {
        if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private void setCombo(JComboBox jComboBox, boolean bl) {
        jComboBox.setSelectedIndex(bl ? 1 : 0);
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void initComponents() {
        this.supportTokenLabel = new JLabel();
        this.supportTokenCombo = new JComboBox();
        this.secConvChBox = new JCheckBox();
        this.reqSigConfChBox = new JCheckBox();
        this.derivedKeysSecConvChBox = new JCheckBox();
        this.wssVersionLabel = new JLabel();
        this.wssVersionCombo = new JComboBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.supportTokenLabel.setLabelFor(this.supportTokenCombo);
        Mnemonics.setLocalizedText((JLabel)this.supportTokenLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_AuthToken"));
        this.supportTokenCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.supportTokenComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.secConvChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.reqSigConfChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysSecConvChBox, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysSecConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.derivedKeysSecConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysSecConvChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.derivedKeysSecConvChBoxActionPerformed(actionEvent);
            }
        });
        this.wssVersionLabel.setLabelFor(this.wssVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.wssVersionLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_WSSVersionLabel"));
        this.wssVersionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.wssVersionComboActionPerformed(actionEvent);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.algoSuiteComboActionPerformed(actionEvent);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(MessageAuthentication.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageAuthentication.this.layoutComboActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.reqSigConfChBox).add((Component)this.secConvChBox).add((Component)this.derivedKeysSecConvChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.layoutLabel).add((Component)this.supportTokenLabel).add((Component)this.wssVersionLabel).add((Component)this.algoSuiteLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.supportTokenCombo, -2, -1, -2).add(2, (Component)this.wssVersionCombo, -2, -1, -2).add(2, (Component)this.algoSuiteCombo, -2, -1, -2).add(2, (Component)this.layoutCombo, -2, -1, -2)))).add(33, 33, 33)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo, this.supportTokenCombo, this.wssVersionCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.supportTokenLabel).add((Component)this.supportTokenCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.wssVersionLabel).add((Component)this.wssVersionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysSecConvChBox).addPreferredGap(0).add((Component)this.reqSigConfChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.layoutCombo, this.supportTokenCombo, this.wssVersionCombo}, 2);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqSigConfChBox);
    }

    private void derivedKeysSecConvChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.derivedKeysSecConvChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.secConvChBox);
    }

    private void wssVersionComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.wssVersionCombo);
    }

    private void supportTokenComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.supportTokenCombo);
    }

    private void layoutComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.algoSuiteCombo);
    }
}

