/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.AdvancedRMPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.AdvancedSecurityPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KeystorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.STSConfigServicePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TruststorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.ValidatorsPanel;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMMSModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSunModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ServicePanel
extends SectionInnerPanel {
    private WSDLModel model;
    private Node node;
    private Binding binding;
    private UndoManager undoManager;
    private Project project;
    private Service service;
    private JaxWsModel jaxwsmodel;
    private String oldProfile;
    private boolean doNotSync = false;
    private boolean inSync = false;
    private boolean isFromJava = true;
    private final Color RED = new Color(255, 0, 0);
    private final Color REGULAR;
    private boolean updateServiceUrl = true;
    private JCheckBox devDefaultsChBox;
    private JCheckBox fiChBox;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton keyButton;
    private JCheckBox mtomChBox;
    private JCheckBox orderedChBox;
    private JButton profConfigButton;
    private JComboBox profileCombo;
    private JLabel profileComboLabel;
    private JTextArea profileInfoField;
    private JButton rmAdvanced;
    private JCheckBox rmChBox;
    private JButton secAdvancedButton;
    private JCheckBox securityChBox;
    private JCheckBox stsChBox;
    private JButton stsConfigButton;
    private JCheckBox tcpChBox;
    private JButton trustButton;
    private JButton validatorsButton;

    public ServicePanel(SectionView sectionView, Node node, Project project, Binding binding, UndoManager undoManager, JaxWsModel jaxWsModel) {
        super(sectionView);
        this.model = binding.getModel();
        this.project = project;
        this.node = node;
        this.undoManager = undoManager;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.initComponents();
        this.REGULAR = this.profileInfoField.getForeground();
        if (node != null) {
            String string;
            this.service = (Service)node.getLookup().lookup(Service.class);
            if (this.service != null && (string = this.service.getWsdlUrl()) != null) {
                this.isFromJava = false;
            }
        } else {
            this.isFromJava = false;
        }
        if (!this.isFromJava && PolicyModelHelper.getPolicyUriForElement((WSDLComponent)binding) == null && ProfilesModelHelper.isServiceUrlHttps(binding)) {
            this.updateServiceUrl = false;
        }
        this.mtomChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.rmChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.orderedChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.securityChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileComboLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileInfoField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.profileInfoField.setFont(this.mtomChBox.getFont());
        this.stsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.tcpChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.fiChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.devDefaultsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator1.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator2.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.jSeparator3.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.mtomChBox);
        this.addImmediateModifier(this.rmChBox);
        this.addImmediateModifier(this.orderedChBox);
        this.addImmediateModifier(this.securityChBox);
        this.addImmediateModifier(this.profileCombo);
        this.addImmediateModifier(this.stsChBox);
        this.addImmediateModifier(this.tcpChBox);
        this.addImmediateModifier(this.fiChBox);
        this.addImmediateModifier(this.devDefaultsChBox);
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent componentEvent) {
                if (!ServicePanel.this.doNotSync) {
                    ServicePanel.this.sync();
                }
            }

            public void childrenAdded(ComponentEvent componentEvent) {
                if (!ServicePanel.this.doNotSync) {
                    ServicePanel.this.sync();
                }
            }

            public void childrenDeleted(ComponentEvent componentEvent) {
                if (!ServicePanel.this.doNotSync) {
                    ServicePanel.this.sync();
                }
            }
        });
    }

    private void fillProfileCombo(boolean bl) {
        this.profileCombo.removeAllItems();
        Set<SecurityProfile> set = SecurityProfileRegistry.getDefault().getSecurityProfiles();
        for (SecurityProfile securityProfile : set) {
            if (!securityProfile.isProfileSupported(this.project, (WSDLComponent)this.binding, bl)) continue;
            this.profileCombo.addItem(securityProfile.getDisplayName());
        }
    }

    private void sync() {
        this.inSync = true;
        boolean bl = TransportModelHelper.isMtomEnabled(this.binding);
        this.setChBox(this.mtomChBox, bl);
        boolean bl2 = TransportModelHelper.isFIEnabled(this.binding);
        this.setChBox(this.fiChBox, !bl2);
        boolean bl3 = TransportModelHelper.isTCPEnabled(this.binding);
        this.setChBox(this.tcpChBox, bl3);
        boolean bl4 = RMModelHelper.isRMEnabled((WSDLComponent)this.binding);
        this.setChBox(this.rmChBox, bl4);
        this.setChBox(this.orderedChBox, RMSunModelHelper.isOrderedEnabled(this.binding));
        boolean bl5 = ProprietarySecurityPolicyModelHelper.isSTSEnabled(this.binding);
        this.setChBox(this.stsChBox, bl5);
        this.fillProfileCombo(bl5);
        boolean bl6 = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        this.setChBox(this.securityChBox, bl6);
        if (bl6) {
            String string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
            this.setSecurityProfile(string);
            boolean bl7 = ProfilesModelHelper.isServiceDefaultSetupUsed(string, this.binding, this.project);
            this.setChBox(this.devDefaultsChBox, bl7);
            this.oldProfile = string;
        } else {
            this.setSecurityProfile(ComboConstants.PROF_USERNAME);
            this.setChBox(this.devDefaultsChBox, true);
        }
        this.enableDisable();
        this.inSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        if (this.inSync) {
            return;
        }
        if (jComponent.equals(this.rmChBox)) {
            if (this.rmChBox.isSelected()) {
                if (!RMModelHelper.isRMEnabled((WSDLComponent)this.binding)) {
                    RMModelHelper.enableRM(this.binding);
                    if (this.securityChBox.isSelected() && !ProfilesModelHelper.isSCEnabled((WSDLComponent)this.binding)) {
                        ProfilesModelHelper.enableSecureConversation((WSDLComponent)this.binding, true);
                    }
                }
            } else if (RMModelHelper.isRMEnabled((WSDLComponent)this.binding)) {
                RMModelHelper.disableRM(this.binding);
                RMMSModelHelper.disableFlowControl(this.binding);
                RMSunModelHelper.disableOrdered(this.binding);
                RMModelHelper.setInactivityTimeout(this.binding, null);
                RMMSModelHelper.setMaxReceiveBufferSize(this.binding, null);
            }
        }
        if (jComponent.equals(this.orderedChBox)) {
            if (this.orderedChBox.isSelected()) {
                if (!RMSunModelHelper.isOrderedEnabled(this.binding)) {
                    RMSunModelHelper.enableOrdered(this.binding);
                }
            } else if (RMSunModelHelper.isOrderedEnabled(this.binding)) {
                RMSunModelHelper.disableOrdered(this.binding);
            }
        }
        if (jComponent.equals(this.mtomChBox)) {
            if (this.mtomChBox.isSelected()) {
                if (!TransportModelHelper.isMtomEnabled(this.binding)) {
                    TransportModelHelper.enableMtom(this.binding);
                }
            } else if (TransportModelHelper.isMtomEnabled(this.binding)) {
                TransportModelHelper.disableMtom(this.binding);
            }
        }
        if (jComponent.equals(this.fiChBox)) {
            if (!this.fiChBox.isSelected()) {
                if (!TransportModelHelper.isFIEnabled(this.binding)) {
                    TransportModelHelper.enableFI(this.binding, true);
                }
            } else if (TransportModelHelper.isFIEnabled(this.binding)) {
                TransportModelHelper.enableFI(this.binding, false);
            }
        }
        if (jComponent.equals(this.tcpChBox)) {
            boolean bl = this.isJsr109Supported();
            if (this.tcpChBox.isSelected()) {
                if (!TransportModelHelper.isTCPEnabled(this.binding)) {
                    TransportModelHelper.enableTCP(this.service, this.isFromJava, this.binding, this.project, true, bl);
                }
            } else if (TransportModelHelper.isTCPEnabled(this.binding)) {
                TransportModelHelper.enableTCP(this.service, this.isFromJava, this.binding, this.project, false, bl);
            }
        }
        if (jComponent.equals(this.securityChBox)) {
            String string = (String)this.profileCombo.getSelectedItem();
            if (this.securityChBox.isSelected()) {
                this.profileCombo.setSelectedItem(string);
                if (this.devDefaultsChBox.isSelected()) {
                    Util.fillDefaults(this.project, false, true);
                    ProfilesModelHelper.setServiceDefaults((String)this.profileCombo.getSelectedItem(), this.binding, this.project);
                    if (ProfilesModelHelper.isSSLProfile(string)) {
                        ProfilesModelHelper.setSSLAttributes((WSDLComponent)this.binding);
                    }
                }
            } else {
                if (this.devDefaultsChBox.isSelected() && ProfilesModelHelper.isSSLProfile(string)) {
                    ProfilesModelHelper.unsetSSLAttributes((WSDLComponent)this.binding);
                }
                Util.unfillDefaults(this.project);
                SecurityPolicyModelHelper.disableSecurity((WSDLComponent)this.binding, true);
            }
            this.oldProfile = string;
        }
        if (jComponent.equals(this.devDefaultsChBox)) {
            if (this.devDefaultsChBox.isSelected()) {
                Util.fillDefaults(this.project, false, true);
                ProfilesModelHelper.setServiceDefaults((String)this.profileCombo.getSelectedItem(), this.binding, this.project);
            } else {
                Util.unfillDefaults(this.project);
            }
        }
        if (jComponent.equals(this.stsChBox)) {
            if (this.stsChBox.isSelected()) {
                ProprietarySecurityPolicyModelHelper.enableSTS(this.binding);
                this.inSync = true;
                this.fillProfileCombo(true);
                this.inSync = false;
            } else {
                ProprietarySecurityPolicyModelHelper.disableSTS(this.binding);
                this.inSync = true;
                this.fillProfileCombo(false);
                this.inSync = false;
            }
        }
        if (jComponent.equals(this.profileCombo)) {
            this.doNotSync = true;
            try {
                String string = (String)this.profileCombo.getSelectedItem();
                ProfilesModelHelper.setSecurityProfile((WSDLComponent)this.binding, string, this.oldProfile, this.updateServiceUrl);
                if (this.devDefaultsChBox.isSelected()) {
                    ProfilesModelHelper.setServiceDefaults(string, this.binding, this.project);
                    if (ProfilesModelHelper.isSSLProfile(string) && !ProfilesModelHelper.isSSLProfile(this.oldProfile)) {
                        ProfilesModelHelper.setSSLAttributes((WSDLComponent)this.binding);
                    }
                    if (!ProfilesModelHelper.isSSLProfile(string) && ProfilesModelHelper.isSSLProfile(this.oldProfile)) {
                        ProfilesModelHelper.unsetSSLAttributes((WSDLComponent)this.binding);
                    }
                }
                boolean bl = ProfilesModelHelper.isServiceDefaultSetupUsed(string, this.binding, this.project);
                this.inSync = true;
                this.devDefaultsChBox.setSelected(bl);
                this.inSync = false;
                this.profileInfoField.setText(SecurityProfileRegistry.getDefault().getProfile(string).getDescription());
                this.oldProfile = string;
            }
            finally {
                this.doNotSync = false;
            }
        }
        this.enableDisable();
    }

    public Boolean getChBox(JCheckBox jCheckBox) {
        if (jCheckBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void setSecurityProfile(String string) {
        this.profileCombo.setSelectedItem(string);
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        this.profileInfoField.setText(securityProfile.getDescription());
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        SectionView sectionView = this.getSectionView();
        this.enableDisable();
        if (sectionView != null) {
            sectionView.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    private void enableDisable() {
        boolean bl = this.rmChBox.isSelected();
        this.orderedChBox.setEnabled(bl);
        this.rmAdvanced.setEnabled(bl);
        boolean bl2 = Util.isTomcat(this.project);
        this.tcpChBox.setEnabled(!bl2);
        boolean bl3 = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        if (!bl3) {
            boolean bl4 = Util.isGlassfish(this.project);
            this.securityChBox.setEnabled(true);
            this.profileInfoField.setForeground(this.REGULAR);
            boolean bl5 = this.securityChBox.isSelected();
            this.profileComboLabel.setEnabled(bl5);
            this.profileCombo.setEnabled(bl5);
            this.profileInfoField.setEnabled(bl5);
            this.profConfigButton.setEnabled(bl5);
            boolean bl6 = true;
            boolean bl7 = true;
            boolean bl8 = true;
            boolean bl9 = true;
            boolean bl10 = this.devDefaultsChBox.isSelected();
            if (bl5) {
                String string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
                boolean bl11 = ProfilesModelHelper.isServiceDefaultSetupSupported(string);
                if (!bl11) {
                    bl10 = false;
                }
                this.devDefaultsChBox.setEnabled(bl11);
                boolean bl12 = ProfilesModelHelper.isSSLProfile(string);
                if (bl12 || ComboConstants.PROF_KERBEROS.equals(string)) {
                    bl6 = false;
                    bl7 = false;
                }
                if (ComboConstants.PROF_SAMLHOLDER.equals(string) || ComboConstants.PROF_SAMLSENDER.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string)) {
                    bl9 = false;
                }
                if (bl4) {
                    if (ComboConstants.PROF_USERNAME.equals(string) || ComboConstants.PROF_MUTUALCERT.equals(string) || ComboConstants.PROF_ENDORSCERT.equals(string) || ComboConstants.PROF_SAMLSENDER.equals(string) || ComboConstants.PROF_SAMLHOLDER.equals(string) || ComboConstants.PROF_STSISSUED.equals(string) || ComboConstants.PROF_STSISSUEDCERT.equals(string) || ComboConstants.PROF_STSISSUEDENDORSE.equals(string)) {
                        bl7 = false;
                    }
                    if (!(ComboConstants.PROF_STSISSUED.equals(string) || ComboConstants.PROF_STSISSUEDCERT.equals(string) || ComboConstants.PROF_STSISSUEDENDORSE.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string) || ComboConstants.PROF_SAMLHOLDER.equals(string) || ComboConstants.PROF_SAMLSENDER.equals(string))) {
                        bl8 = false;
                    }
                }
            } else {
                this.devDefaultsChBox.setEnabled(false);
            }
            this.secAdvancedButton.setEnabled(bl5 && !bl10);
            this.stsChBox.setEnabled(bl5 && !this.isFromJava && bl9);
            boolean bl13 = this.stsChBox.isSelected();
            this.stsConfigButton.setEnabled(bl13);
            if (bl13) {
                bl7 = true;
                bl6 = true;
                bl8 = true;
            }
            this.validatorsButton.setEnabled(bl5 && !bl10 && bl8);
            this.keyButton.setEnabled(bl5 && bl6 && !bl10);
            this.trustButton.setEnabled(bl5 && bl7 && !bl10);
        } else {
            this.profileComboLabel.setEnabled(false);
            this.profileCombo.setEnabled(false);
            this.profileInfoField.setEnabled(false);
            this.profConfigButton.setEnabled(false);
            this.stsChBox.setEnabled(false);
            this.devDefaultsChBox.setEnabled(false);
            this.stsConfigButton.setEnabled(false);
            this.securityChBox.setEnabled(false);
            this.validatorsButton.setEnabled(false);
            this.keyButton.setEnabled(false);
            this.trustButton.setEnabled(false);
            this.profileInfoField.setEnabled(true);
            this.profileInfoField.setForeground(this.RED);
            this.profileInfoField.setText(NbBundle.getMessage(ServicePanel.class, (String)"TXT_AMSecSelected"));
        }
    }

    private boolean isJsr109Supported() {
        J2eePlatform j2eePlatform = Util.getJ2eePlatform(this.project);
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("jsr109");
        }
        return false;
    }

    private void initComponents() {
        this.mtomChBox = new JCheckBox();
        this.rmChBox = new JCheckBox();
        this.securityChBox = new JCheckBox();
        this.orderedChBox = new JCheckBox();
        this.profileComboLabel = new JLabel();
        this.profileCombo = new JComboBox();
        this.rmAdvanced = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.stsChBox = new JCheckBox();
        this.tcpChBox = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.keyButton = new JButton();
        this.trustButton = new JButton();
        this.stsConfigButton = new JButton();
        this.profConfigButton = new JButton();
        this.fiChBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.profileInfoField = new JTextArea();
        this.validatorsButton = new JButton();
        this.devDefaultsChBox = new JCheckBox();
        this.secAdvancedButton = new JButton();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ServicePanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                ServicePanel.this.formAncestorAdded(ancestorEvent);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.mtomChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_mtomChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.rmChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_rmChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.securityChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_securityChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.orderedChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_OrderedChBox"));
        this.profileComboLabel.setLabelFor(this.profileCombo);
        Mnemonics.setLocalizedText((JLabel)this.profileComboLabel, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_profileComboLabel"));
        this.profileCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"SAML Sender Vouches With Certificates", "Anonymous with Bilateral Certificates"}));
        Mnemonics.setLocalizedText((AbstractButton)this.rmAdvanced, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Advanced"));
        this.rmAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.rmAdvancedActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.stsChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_stsChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.tcpChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_tcpChBox"));
        Mnemonics.setLocalizedText((AbstractButton)this.keyButton, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_keystoreButton"));
        this.keyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.keyButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.trustButton, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_truststoreButton"));
        this.trustButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.trustButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.stsConfigButton, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_stsConfigButton"));
        this.stsConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.stsConfigButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.profConfigButton, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_keyConfigButton"));
        this.profConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.profConfigButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.fiChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_fiChBox"));
        this.profileInfoField.setEditable(false);
        this.profileInfoField.setLineWrap(true);
        this.profileInfoField.setText("This is a text This is a text This is a text This is a text This is a text This is a text This is");
        this.profileInfoField.setWrapStyleWord(true);
        this.profileInfoField.setAutoscrolls(false);
        this.profileInfoField.setOpaque(false);
        this.jScrollPane1.setViewportView(this.profileInfoField);
        this.profileInfoField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_ProfileDesc_ACSN"));
        this.profileInfoField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_ProfileDesc_ACSD"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/wsitconf/ui/service/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.validatorsButton, (String)resourceBundle.getString("LBL_validatorsButton"));
        this.validatorsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.validatorsButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.devDefaultsChBox, (String)NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Defaults"));
        Mnemonics.setLocalizedText((AbstractButton)this.secAdvancedButton, (String)resourceBundle.getString("LBL_Section_Service_Advanced"));
        this.secAdvancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServicePanel.this.secAdvancedButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 486, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 486, Short.MAX_VALUE).add((Component)this.mtomChBox).add((Component)this.rmChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rmAdvanced).add((Component)this.orderedChBox)).add(79, 79, 79)).add((Component)this.securityChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.jScrollPane1)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.profileComboLabel).addPreferredGap(0).add((Component)this.profileCombo, 0, 215, Short.MAX_VALUE).add(6, 6, 6).add((Component)this.profConfigButton)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.devDefaultsChBox)).add((Component)this.jSeparator3, -1, 486, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.stsChBox).addPreferredGap(0).add((Component)this.stsConfigButton)).add((Component)this.tcpChBox).add((Component)this.fiChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.keyButton).addPreferredGap(0).add((Component)this.trustButton).addPreferredGap(0).add((Component)this.validatorsButton).addPreferredGap(0).add((Component)this.secAdvancedButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.mtomChBox).addPreferredGap(0).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(0).add((Component)this.rmChBox).addPreferredGap(0).add((Component)this.orderedChBox).addPreferredGap(0).add((Component)this.rmAdvanced).add(8, 8, 8).add((Component)this.jSeparator2, -2, -1, -2).addPreferredGap(0).add((Component)this.securityChBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.profileComboLabel).add((Component)this.profileCombo, -2, -1, -2).add((Component)this.profConfigButton)).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 58, -2).addPreferredGap(0).add((Component)this.devDefaultsChBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.trustButton).add((Component)this.keyButton).add((Component)this.validatorsButton).add((Component)this.secAdvancedButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.stsChBox).add((Component)this.stsConfigButton)).add(11, 11, 11).add((Component)this.jSeparator3, -2, -1, -2).add(8, 8, 8).add((Component)this.tcpChBox).addPreferredGap(0).add((Component)this.fiChBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.mtomChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_mtomChBox_ACSN"));
        this.mtomChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_mtomChBox_ACSD"));
        this.rmChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_rmChBox_ACSN"));
        this.rmChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_rmChBox_ACSD"));
        this.securityChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_securityChBox_ACSN"));
        this.securityChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_securityChBox_ACSD"));
        this.orderedChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_OrderedChBox_ACSN"));
        this.orderedChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_OrderedChBox_ACSD"));
        this.profileComboLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_profileComboLabel_ACSN"));
        this.profileComboLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_profileComboLabel_ACSD"));
        this.profileCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_ProfileCombo_ACSN"));
        this.profileCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_ProfileCombo_ACSD"));
        this.rmAdvanced.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Advanced_ACSN"));
        this.rmAdvanced.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Advanced_ACSD"));
        this.stsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_stsChBox_ACSN"));
        this.stsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_stsChBox_ACSD"));
        this.tcpChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_tcpChBox_ACSN"));
        this.tcpChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_tcpChBox_ACSD"));
        this.keyButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_keystoreButton_ACSN"));
        this.keyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_keystoreButton_ACSD"));
        this.trustButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_truststoreButton_ACSN"));
        this.trustButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_truststoreButton_ACSD"));
        this.stsConfigButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_stsConfigButton_ACSN"));
        this.stsConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_stsConfigButton_ACSD"));
        this.profConfigButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_keyConfigButton_ACSN"));
        this.profConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_keyConfigButton_ACSD"));
        this.fiChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_fiChBox_ACSN"));
        this.fiChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_fiChBox_ACSD"));
        this.validatorsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_validatorsButton_ACSN"));
        this.validatorsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_validatorsButton_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Defaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Defaults_ACSD"));
        this.secAdvancedButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"LBL_Section_Service_Advanced_Security_ACSD"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServicePanel.class, (String)"Panel_ACSN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicePanel.class, (String)"Panel_ACSD"));
        this.getAccessibleContext().setAccessibleParent((Accessible)((Object)this));
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableDisable();
    }

    private void validatorsButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.profileCombo.getSelectedItem();
        ValidatorsPanel validatorsPanel = new ValidatorsPanel((WSDLComponent)this.binding, this.project, string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)validatorsPanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_Validators_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            validatorsPanel.storeState();
        }
    }

    private void profConfigButtonActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.profileCombo.getSelectedItem();
        SecurityProfile securityProfile = SecurityProfileRegistry.getDefault().getProfile(string);
        securityProfile.displayConfig((WSDLComponent)this.binding, this.undoManager);
    }

    private void stsConfigButtonActionPerformed(ActionEvent actionEvent) {
        UndoCounter undoCounter = new UndoCounter();
        this.model.addUndoableEditListener((UndoableEditListener)undoCounter);
        STSConfigServicePanel sTSConfigServicePanel = new STSConfigServicePanel(this.project, this.binding);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)sTSConfigServicePanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_STSConfig_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!this.undoManager.canUndo()) continue;
                this.undoManager.undo();
            }
        }
        this.model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    private void trustButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.isJsr109Supported();
        String string = (String)this.profileCombo.getSelectedItem();
        TruststorePanel truststorePanel = new TruststorePanel((WSDLComponent)this.binding, this.project, bl, string, false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)truststorePanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_Truststore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            truststorePanel.storeState();
        }
    }

    private void keyButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.isJsr109Supported();
        KeystorePanel keystorePanel = new KeystorePanel((WSDLComponent)this.binding, this.project, bl, false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)keystorePanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_Keystore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            keystorePanel.storeState();
        }
    }

    private void rmAdvancedActionPerformed(ActionEvent actionEvent) {
        AdvancedRMPanel advancedRMPanel = new AdvancedRMPanel(this.binding);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)advancedRMPanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_AdvancedRM_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            advancedRMPanel.storeState();
        }
    }

    private void secAdvancedButtonActionPerformed(ActionEvent actionEvent) {
        AdvancedSecurityPanel advancedSecurityPanel = new AdvancedSecurityPanel(this.binding);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)advancedSecurityPanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_AdvancedSec_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            advancedSecurityPanel.storeState();
        }
    }
}

