/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TransportPanelClient
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private JaxWsModel jaxwsmodel;
    private JCheckBox optimalEncChBox;
    private JCheckBox optimalTransportChBox;

    public TransportPanelClient(SectionView sectionView, Node node, Binding binding, JaxWsModel jaxWsModel) {
        super(sectionView);
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.initComponents();
        this.optimalEncChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.optimalTransportChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.optimalEncChBox);
        this.addImmediateModifier(this.optimalTransportChBox);
        this.sync();
    }

    public void sync() {
        this.inSync = true;
        this.setChBox(this.optimalEncChBox, TransportModelHelper.isAutoEncodingEnabled(this.binding));
        this.setChBox(this.optimalTransportChBox, TransportModelHelper.isAutoTransportEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent, Object object) {
        if (!this.inSync) {
            if (jComponent.equals(this.optimalEncChBox)) {
                TransportModelHelper.setAutoEncoding(this.binding, this.optimalEncChBox.isSelected());
            }
            if (jComponent.equals(this.optimalTransportChBox)) {
                TransportModelHelper.setAutoTransport(this.binding, this.optimalTransportChBox.isSelected());
            }
            this.enableDisable();
        }
    }

    private void enableDisable() {
        boolean bl = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        this.optimalEncChBox.setEnabled(!bl);
        this.optimalTransportChBox.setEnabled(!bl);
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    private void initComponents() {
        this.optimalEncChBox = new JCheckBox();
        this.optimalTransportChBox = new JCheckBox();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TransportPanelClient.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                TransportPanelClient.this.formAncestorAdded(ancestorEvent);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.optimalEncChBox, (String)NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalEncoding"));
        this.optimalEncChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optimalEncChBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.optimalTransportChBox, (String)NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalTransport"));
        this.optimalTransportChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optimalTransportChBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.optimalTransportChBox).add((Component)this.optimalEncChBox)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.optimalEncChBox).addPreferredGap(0).add((Component)this.optimalTransportChBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.optimalEncChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalEncoding_ACSN"));
        this.optimalEncChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalEncoding_ACSD"));
        this.optimalTransportChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalTransport_ACSN"));
        this.optimalTransportChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalTransport_ACSD"));
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableDisable();
    }
}

