/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientPanelFactory;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientView;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ClientTopComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712674L;
    private boolean initialized = false;
    private InnerPanelFactory panelFactory = null;
    private JaxWsModel jaxWsModel;
    private WSDLModel clientWsdlModel;
    private WSDLModel serviceModel;
    private Client client;
    private Node node;
    private Service service;

    public ClientTopComponent(Client client, JaxWsModel jaxWsModel, WSDLModel wSDLModel, WSDLModel wSDLModel2, Node node) {
        this.setLayout(new BorderLayout());
        this.jaxWsModel = jaxWsModel;
        this.clientWsdlModel = wSDLModel;
        this.serviceModel = wSDLModel2;
        this.initialized = false;
        this.client = client;
        this.node = node;
    }

    protected String preferredID() {
        return "WSITClientTopComponent";
    }

    public ClientTopComponent(Service service, WSDLModel wSDLModel, WSDLModel wSDLModel2, Node node) {
        this.setLayout(new BorderLayout());
        this.service = service;
        this.clientWsdlModel = wSDLModel;
        this.serviceModel = wSDLModel2;
        this.initialized = false;
        this.node = node;
    }

    private Service getService(String string, WSDLModel wSDLModel) {
        Collection collection;
        if (string != null && wSDLModel != null && (collection = wSDLModel.getDefinitions().getServices()) != null) {
            Iterator iterator = collection.iterator();
            Service service = null;
            while (iterator.hasNext()) {
                service = (Service)iterator.next();
                if (service == null || !string.equals(service.getName()) && collection.size() != 1) continue;
                return service;
            }
        }
        return null;
    }

    private void doInitialize() {
        this.initAccessibility();
        ToolBarDesignEditor toolBarDesignEditor = new ToolBarDesignEditor();
        this.panelFactory = new ClientPanelFactory(toolBarDesignEditor, this.clientWsdlModel, this.node, this.serviceModel, this.jaxWsModel);
        Service service = null;
        service = this.client != null ? this.getService(this.client.getName(), this.clientWsdlModel) : this.service;
        if (service != null) {
            ClientView clientView = new ClientView(this.panelFactory, this.clientWsdlModel, this.serviceModel, service);
            toolBarDesignEditor.setContentView((PanelView)clientView);
            this.add((Component)toolBarDesignEditor);
        }
        this.setFocusable(true);
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientTopComponent.class, (String)"ACS_Tab_DESC"));
    }

    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.addNotify();
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.componentShowing();
    }
}

