/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;

public class PdfPages {
    private ArrayList pages = new ArrayList();
    private ArrayList parents = new ArrayList();
    private int leafSize = 10;
    private PdfWriter writer;
    private PdfIndirectReference topParent;

    PdfPages(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    void addPage(PdfDictionary pdfDictionary) {
        try {
            if (this.pages.size() % this.leafSize == 0) {
                this.parents.add(this.writer.getPdfIndirectReference());
            }
            PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)this.parents.get(this.parents.size() - 1);
            pdfDictionary.put(PdfName.PARENT, pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = this.writer.getCurrentPage();
            this.writer.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
            this.pages.add(pdfIndirectReference2);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    PdfIndirectReference writePageTree() throws IOException {
        if (this.pages.size() == 0) {
            throw new IOException("The document has no pages.");
        }
        int n = 1;
        ArrayList<PdfIndirectReference> arrayList = this.parents;
        ArrayList arrayList2 = this.pages;
        ArrayList<PdfIndirectReference> arrayList3 = new ArrayList<PdfIndirectReference>();
        while (true) {
            n *= this.leafSize;
            int n2 = this.leafSize;
            int n3 = arrayList2.size() % this.leafSize;
            if (n3 == 0) {
                n3 = this.leafSize;
            }
            int n4 = 0;
            while (n4 < arrayList.size()) {
                int n5;
                int n6 = n;
                if (n4 == arrayList.size() - 1) {
                    n5 = n3;
                    n6 = this.pages.size() % n;
                    if (n6 == 0) {
                        n6 = n;
                    }
                } else {
                    n5 = n2;
                }
                PdfDictionary pdfDictionary = new PdfDictionary(PdfName.PAGES);
                pdfDictionary.put(PdfName.COUNT, new PdfNumber(n6));
                PdfArray pdfArray = new PdfArray();
                ArrayList arrayList4 = pdfArray.getArrayList();
                arrayList4.addAll(((AbstractList)arrayList2).subList(n4 * n2, n4 * n2 + n5));
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                if (arrayList.size() > 1) {
                    if (n4 % this.leafSize == 0) {
                        arrayList3.add(this.writer.getPdfIndirectReference());
                    }
                    pdfDictionary.put(PdfName.PARENT, (PdfIndirectReference)arrayList3.get(n4 / this.leafSize));
                }
                this.writer.addToBody((PdfObject)pdfDictionary, (PdfIndirectReference)arrayList.get(n4));
                ++n4;
            }
            if (arrayList.size() == 1) {
                this.topParent = (PdfIndirectReference)arrayList.get(0);
                return this.topParent;
            }
            arrayList2 = arrayList;
            arrayList = arrayList3;
            arrayList3 = new ArrayList();
        }
    }

    PdfIndirectReference getTopParent() {
        return this.topParent;
    }

    void setLinearMode(PdfIndirectReference pdfIndirectReference) {
        if (this.parents.size() > 1) {
            throw new RuntimeException("Linear page mode can only be called with a single parent.");
        }
        if (pdfIndirectReference != null) {
            this.topParent = pdfIndirectReference;
            this.parents.clear();
            this.parents.add(pdfIndirectReference);
        }
        this.leafSize = 10000000;
    }

    void addPage(PdfIndirectReference pdfIndirectReference) {
        this.pages.add(pdfIndirectReference);
    }

    int reorderPages(int[] nArray) throws DocumentException {
        if (nArray == null) {
            return this.pages.size();
        }
        if (this.parents.size() > 1) {
            throw new DocumentException("Page reordering requires a single parent in the page tree.");
        }
        if (nArray.length != this.pages.size()) {
            throw new DocumentException("Page reordering requires and array with the same size as the number of pages.");
        }
        int n = this.pages.size();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 < 1 || n3 > n) {
                throw new DocumentException("Page reordering requires pages between 1 and " + n + ". Found " + n3 + ".");
            }
            if (blArray[n3 - 1]) {
                throw new DocumentException("Page reordering requires no page repetition. Page " + n3 + " is repeated.");
            }
            blArray[n3 - 1] = true;
            ++n2;
        }
        Object[] objectArray = this.pages.toArray();
        int n4 = 0;
        while (n4 < n) {
            this.pages.set(n4, objectArray[nArray[n4] - 1]);
            ++n4;
        }
        return n;
    }
}

