/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectGenerator {
    private static final String[] rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
    private static final String[] viewElementsOrder = new String[]{"items", "context-menu"};
    private static final String[] folderElementsOrder = new String[]{"source-folder", "build-folder", "build-file"};
    private static final String[] viewItemElementsOrder = new String[]{"source-folder", "source-file"};

    public static List<SourceFolder> getSourceFolders(AntProjectHelper antProjectHelper, String string) {
        ArrayList<SourceFolder> arrayList = new ArrayList<SourceFolder>();
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Element element2 = Util.findElement((Element)element, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return arrayList;
        }
        for (Element element3 : Util.findSubElements((Element)element2)) {
            if (!element3.getLocalName().equals("source-folder")) continue;
            SourceFolder sourceFolder = new SourceFolder();
            Element element4 = Util.findElement((Element)element3, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (element4 != null) {
                sourceFolder.label = Util.findText((Element)element4);
            }
            if ((element4 = Util.findElement((Element)element3, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.type = Util.findText((Element)element4);
            }
            if ((element4 = Util.findElement((Element)element3, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.location = Util.findText((Element)element4);
            }
            if ((element4 = Util.findElement((Element)element3, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.includes = Util.findText((Element)element4);
            }
            if ((element4 = Util.findElement((Element)element3, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.excludes = Util.findText((Element)element4);
            }
            if ((element4 = Util.findElement((Element)element3, (String)"encoding", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.encoding = Util.findText((Element)element4);
            }
            if (string != null && !string.equals(sourceFolder.type)) continue;
            if (sourceFolder.label == null || sourceFolder.label.length() == 0) {
                throw new IllegalArgumentException("label element is empty or not specified. " + antProjectHelper.getProjectDirectory());
            }
            if (sourceFolder.location == null || sourceFolder.location.length() == 0) {
                throw new IllegalArgumentException("location element is empty or not specified. " + antProjectHelper.getProjectDirectory());
            }
            arrayList.add(sourceFolder);
        }
        return arrayList;
    }

    public static void putSourceFolders(AntProjectHelper antProjectHelper, List<SourceFolder> list, String string) {
        Object object;
        Element element;
        Element element2 = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Document document = element2.getOwnerDocument();
        Element element3 = Util.findElement((Element)element2, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folders");
            Util.appendChildElement((Element)element2, (Element)element3, (String[])rootElementsOrder);
        } else {
            for (Element object2 : Util.findSubElements((Element)element3)) {
                if (!object2.getLocalName().equals("source-folder")) continue;
                if (string == null) {
                    element3.removeChild(object2);
                    continue;
                }
                element = Util.findElement((Element)object2, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (element == null || !string.equals(object = Util.findText((Element)element))) continue;
                element3.removeChild(object2);
            }
        }
        for (SourceFolder sourceFolder : list) {
            element = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-folder");
            if (sourceFolder.label == null || sourceFolder.label.length() <= 0) {
                throw new IllegalArgumentException("label cannot be empty. " + antProjectHelper.getProjectDirectory());
            }
            object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
            object.appendChild(document.createTextNode(sourceFolder.label));
            element.appendChild((Node)object);
            if (sourceFolder.type != null) {
                object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "type");
                object.appendChild(document.createTextNode(sourceFolder.type));
                element.appendChild((Node)object);
            }
            if (sourceFolder.location == null || sourceFolder.location.length() <= 0) {
                throw new IllegalArgumentException("location cannot be empty. " + antProjectHelper.getProjectDirectory());
            }
            object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            object.appendChild(document.createTextNode(sourceFolder.location));
            element.appendChild((Node)object);
            if (sourceFolder.includes != null) {
                object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "includes");
                object.appendChild(document.createTextNode(sourceFolder.includes));
                element.appendChild((Node)object);
            }
            if (sourceFolder.excludes != null) {
                object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "excludes");
                object.appendChild(document.createTextNode(sourceFolder.excludes));
                element.appendChild((Node)object);
            }
            if (sourceFolder.encoding != null) {
                object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "encoding");
                object.appendChild(document.createTextNode(sourceFolder.encoding));
                element.appendChild((Node)object);
            }
            Util.appendChildElement((Element)element3, (Element)element, (String[])folderElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)antProjectHelper, (Element)element2);
    }

    public static List getSourceViews(AntProjectHelper antProjectHelper, String string) {
        ArrayList<SourceFolder> arrayList = new ArrayList<SourceFolder>();
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Element element2 = Util.findElement((Element)element, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return arrayList;
        }
        Element element3 = Util.findElement((Element)element2, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            return arrayList;
        }
        for (Element element4 : Util.findSubElements((Element)element3)) {
            if (!element4.getLocalName().equals("source-folder")) continue;
            SourceFolder sourceFolder = new SourceFolder();
            sourceFolder.style = element4.getAttribute("style");
            assert (sourceFolder.style != null && sourceFolder.style.length() > 0) : "Bad style attr on <source-folder> in " + antProjectHelper;
            Element element5 = Util.findElement((Element)element4, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (element5 != null) {
                sourceFolder.label = Util.findText((Element)element5);
            }
            if ((element5 = Util.findElement((Element)element4, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.location = Util.findText((Element)element5);
            }
            if ((element5 = Util.findElement((Element)element4, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.includes = Util.findText((Element)element5);
            }
            if ((element5 = Util.findElement((Element)element4, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sourceFolder.excludes = Util.findText((Element)element5);
            }
            if (string != null && !string.equals(sourceFolder.style)) continue;
            arrayList.add(sourceFolder);
        }
        return arrayList;
    }

    public static void putSourceViews(AntProjectHelper antProjectHelper, List<SourceFolder> list, String string) {
        Element element;
        ArrayList arrayList = new ArrayList();
        Element element2 = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Document document = element2.getOwnerDocument();
        Element element3 = Util.findElement((Element)element2, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            Util.appendChildElement((Element)element2, (Element)element3, (String[])rootElementsOrder);
        }
        if ((element = Util.findElement((Element)element3, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) {
            element = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "items");
            Util.appendChildElement((Element)element3, (Element)element, (String[])viewElementsOrder);
        }
        List list2 = Util.findSubElements((Element)element);
        for (Object object : list2) {
            if (!object.getLocalName().equals("source-folder")) continue;
            String object2 = object.getAttribute("style");
            if (string != null && !string.equals(object2)) continue;
            element.removeChild((Node)object);
        }
        for (SourceFolder sourceFolder : list) {
            Element element4;
            if (sourceFolder.style == null || sourceFolder.style.length() == 0) continue;
            Element element5 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-folder");
            element5.setAttribute("style", sourceFolder.style);
            if (sourceFolder.label != null) {
                element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
                element4.appendChild(document.createTextNode(sourceFolder.label));
                element5.appendChild(element4);
            }
            if (sourceFolder.location != null) {
                element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
                element4.appendChild(document.createTextNode(sourceFolder.location));
                element5.appendChild(element4);
            }
            if (sourceFolder.includes != null) {
                element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "includes");
                element4.appendChild(document.createTextNode(sourceFolder.includes));
                element5.appendChild(element4);
            }
            if (sourceFolder.excludes != null) {
                element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "excludes");
                element4.appendChild(document.createTextNode(sourceFolder.excludes));
                element5.appendChild(element4);
            }
            Util.appendChildElement((Element)element, (Element)element5, (String[])viewItemElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)antProjectHelper, (Element)element2);
    }

    public static List<JavaCompilationUnit> getJavaCompilationUnits(AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration) {
        ArrayList<JavaCompilationUnit> arrayList = new ArrayList<JavaCompilationUnit>();
        Element element = auxiliaryConfiguration.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/1", true);
        }
        if (element == null) {
            return arrayList;
        }
        for (Element element2 : Util.findSubElements((Element)element)) {
            JavaCompilationUnit javaCompilationUnit = new JavaCompilationUnit();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<JavaCompilationUnit.CP> arrayList4 = new ArrayList<JavaCompilationUnit.CP>();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            for (Element element3 : Util.findSubElements((Element)element2)) {
                if (element3.getLocalName().equals("package-root")) {
                    arrayList5.add(Util.findText((Element)element3));
                    continue;
                }
                if (element3.getLocalName().equals("classpath")) {
                    JavaCompilationUnit.CP cP = new JavaCompilationUnit.CP();
                    cP.classpath = Util.findText((Element)element3);
                    cP.mode = element3.getAttribute("mode");
                    if (cP.mode == null || cP.classpath == null) continue;
                    arrayList4.add(cP);
                    continue;
                }
                if (element3.getLocalName().equals("built-to")) {
                    arrayList2.add(Util.findText((Element)element3));
                    continue;
                }
                if (element3.getLocalName().equals("javadoc-built-to")) {
                    arrayList3.add(Util.findText((Element)element3));
                    continue;
                }
                if (element3.getLocalName().equals("source-level")) {
                    javaCompilationUnit.sourceLevel = Util.findText((Element)element3);
                }
                if (!element3.getLocalName().equals("unit-tests")) continue;
                javaCompilationUnit.isTests = true;
            }
            javaCompilationUnit.output = arrayList2.size() > 0 ? arrayList2 : null;
            javaCompilationUnit.javadoc = arrayList3.size() > 0 ? arrayList3 : null;
            javaCompilationUnit.classpath = arrayList4.size() > 0 ? arrayList4 : null;
            javaCompilationUnit.packageRoots = arrayList5.size() > 0 ? arrayList5 : null;
            arrayList.add(javaCompilationUnit);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static void putJavaCompilationUnits(AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration, List<JavaCompilationUnit> list) {
        void var5_10;
        Object object;
        Element element;
        boolean bl = false;
        for (JavaCompilationUnit object22 : list) {
            if (!object22.isTests && (object22.javadoc == null || object22.javadoc.isEmpty())) continue;
            bl = true;
            break;
        }
        if ((element = auxiliaryConfiguration.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true)) != null) {
            object = "http://www.netbeans.org/ns/freeform-project-java/2";
        } else {
            object = bl ? "http://www.netbeans.org/ns/freeform-project-java/2" : "http://www.netbeans.org/ns/freeform-project-java/1";
            Element element2 = auxiliaryConfiguration.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/1", true);
            if (element2 != null) {
                if (bl) {
                    auxiliaryConfiguration.removeConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/1", true);
                    Element element3 = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper).getOwnerDocument().createElementNS("http://www.netbeans.org/ns/freeform-project-java/2", "java-data");
                }
            } else {
                Element element4 = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper).getOwnerDocument().createElementNS((String)object, "java-data");
            }
        }
        Document document = var5_10.getOwnerDocument();
        for (Element element5 : Util.findSubElements((Element)var5_10)) {
            var5_10.removeChild(element5);
        }
        for (JavaCompilationUnit javaCompilationUnit : list) {
            Element element6;
            Element element7 = document.createElementNS((String)object, "compilation-unit");
            var5_10.appendChild(element7);
            if (javaCompilationUnit.packageRoots != null) {
                for (String string : javaCompilationUnit.packageRoots) {
                    element6 = document.createElementNS((String)object, "package-root");
                    element6.appendChild(document.createTextNode(string));
                    element7.appendChild(element6);
                }
            }
            if (javaCompilationUnit.isTests) {
                assert (((String)object).equals("http://www.netbeans.org/ns/freeform-project-java/2"));
                element7.appendChild(document.createElementNS((String)object, "unit-tests"));
            }
            if (javaCompilationUnit.classpath != null) {
                for (JavaCompilationUnit.CP cP : javaCompilationUnit.classpath) {
                    element6 = document.createElementNS((String)object, "classpath");
                    element6.appendChild(document.createTextNode(cP.classpath));
                    element6.setAttribute("mode", cP.mode);
                    element7.appendChild(element6);
                }
            }
            if (javaCompilationUnit.output != null) {
                for (String string : javaCompilationUnit.output) {
                    element6 = document.createElementNS((String)object, "built-to");
                    element6.appendChild(document.createTextNode(string));
                    element7.appendChild(element6);
                }
            }
            if (javaCompilationUnit.javadoc != null) {
                for (String string : javaCompilationUnit.javadoc) {
                    assert (((String)object).equals("http://www.netbeans.org/ns/freeform-project-java/2"));
                    element6 = document.createElementNS((String)object, "javadoc-built-to");
                    element6.appendChild(document.createTextNode(string));
                    element7.appendChild(element6);
                }
            }
            if (javaCompilationUnit.sourceLevel == null) continue;
            element6 = document.createElementNS((String)object, "source-level");
            element6.appendChild(document.createTextNode(javaCompilationUnit.sourceLevel));
            element7.appendChild(element6);
        }
        auxiliaryConfiguration.putConfigurationFragment((Element)var5_10, true);
    }

    public static List<Export> guessExports(PropertyEvaluator propertyEvaluator, File file, List<TargetMapping> list, List<JavaCompilationUnit> list2) {
        ArrayList<Export> arrayList = new ArrayList<Export>();
        String string = null;
        String string2 = null;
        for (TargetMapping object : list) {
            if (!object.name.equals("build")) continue;
            if (object.targets.size() == 1) {
                string = object.targets.get(0);
                string2 = object.script;
                continue;
            }
            return new ArrayList<Export>();
        }
        if (string == null) {
            return new ArrayList<Export>();
        }
        for (JavaCompilationUnit javaCompilationUnit : list2) {
            if (javaCompilationUnit.output == null) continue;
            for (String string3 : javaCompilationUnit.output) {
                Export export;
                String string4 = propertyEvaluator.evaluate(string3);
                if (string4.endsWith(".jar")) {
                    export = new Export();
                    export.type = "jar";
                    export.location = string3;
                    export.script = string2;
                    export.buildTarget = string;
                    arrayList.add(export);
                    continue;
                }
                if (!JavaProjectGenerator.isFolder(propertyEvaluator, file, string4)) continue;
                export = new Export();
                export.type = "folder";
                export.location = string3;
                export.script = string2;
                export.buildTarget = string;
                arrayList.add(export);
            }
        }
        return arrayList;
    }

    public static void putExports(AntProjectHelper antProjectHelper, List<Export> list) {
        ArrayList arrayList = new ArrayList();
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Document document = element.getOwnerDocument();
        for (Object object : Util.findSubElements((Element)element)) {
            if (!object.getLocalName().equals("export")) continue;
            element.removeChild((Node)object);
        }
        for (Export export : list) {
            Element element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "export");
            Element element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "type");
            element3.appendChild(document.createTextNode(export.type));
            element2.appendChild(element3);
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            element3.appendChild(document.createTextNode(export.location));
            element2.appendChild(element3);
            if (export.script != null) {
                element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
                element3.appendChild(document.createTextNode(export.script));
                element2.appendChild(element3);
            }
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "build-target");
            element3.appendChild(document.createTextNode(export.buildTarget));
            element2.appendChild(element3);
            if (export.cleanTarget != null) {
                element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "clean-target");
                element3.appendChild(document.createTextNode(export.cleanTarget));
                element2.appendChild(element3);
            }
            Util.appendChildElement((Element)element, (Element)element2, (String[])rootElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)antProjectHelper, (Element)element);
    }

    public static List<String> guessSubprojects(PropertyEvaluator propertyEvaluator, List<JavaCompilationUnit> list, File file, File file2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (JavaCompilationUnit javaCompilationUnit : list) {
            if (javaCompilationUnit.classpath == null) continue;
            for (JavaCompilationUnit.CP cP : javaCompilationUnit.classpath) {
                String string;
                if (!"compile".equals(cP.mode) || (string = propertyEvaluator.evaluate(cP.classpath)) == null) continue;
                for (String string2 : PropertyUtils.tokenizePath((String)string)) {
                    File file3 = FileUtil.normalizeFile((File)new File(string2));
                    AntArtifact antArtifact = AntArtifactQuery.findArtifactFromFile((File)file3);
                    if (antArtifact == null) continue;
                    File file4 = FileUtil.toFile((FileObject)antArtifact.getProject().getProjectDirectory());
                    String string3 = Util.relativizeLocation((File)file, (File)file2, (File)file4);
                    hashSet.add(string3);
                }
            }
        }
        return new ArrayList<String>(hashSet);
    }

    public static void putSubprojects(AntProjectHelper antProjectHelper, List<String> list) {
        ArrayList arrayList = new ArrayList();
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Document document = element.getOwnerDocument();
        Element element2 = Util.findElement((Element)element, (String)"subprojects", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            element.removeChild(element2);
        }
        element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "subprojects");
        Util.appendChildElement((Element)element, (Element)element2, (String[])rootElementsOrder);
        for (String string : list) {
            Element element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "project");
            element3.appendChild(document.createTextNode(string));
            element2.appendChild(element3);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)antProjectHelper, (Element)element);
    }

    public static List<String> guessBuildFolders(PropertyEvaluator propertyEvaluator, List<JavaCompilationUnit> list, File file, File file2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JavaCompilationUnit javaCompilationUnit : list) {
            if (javaCompilationUnit.output == null) continue;
            for (String string : javaCompilationUnit.output) {
                File file3 = Util.resolveFile((PropertyEvaluator)propertyEvaluator, (File)file2, (String)string);
                if (!file3.isDirectory()) continue;
                String string2 = file3.getAbsolutePath();
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separatorChar;
                }
                if (string2.startsWith(file.getAbsolutePath() + File.separatorChar) || string2.startsWith(file2.getAbsolutePath() + File.separatorChar)) continue;
                boolean bl = true;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (!string3.endsWith(File.separator)) {
                        string3 = string3 + File.separatorChar;
                    }
                    if (string3.equals(string2)) {
                        bl = false;
                        break;
                    }
                    if (string2.startsWith(string3)) {
                        bl = false;
                        break;
                    }
                    if (!string3.startsWith(string2)) continue;
                    iterator.remove();
                }
                if (!bl) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static void putBuildFolders(AntProjectHelper antProjectHelper, List<String> list) {
        JavaProjectGenerator.putBuildElement(antProjectHelper, list, "build-folder");
    }

    private static void putBuildElement(AntProjectHelper antProjectHelper, List<String> list, String string) {
        Element element;
        Element element2 = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Document document = element2.getOwnerDocument();
        Element element3 = Util.findElement((Element)element2, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folders");
            Util.appendChildElement((Element)element2, (Element)element3, (String[])rootElementsOrder);
        } else {
            List list2 = Util.findSubElements((Element)element3);
            Iterator object = list2.iterator();
            while (object.hasNext()) {
                element = (Element)object.next();
                if (!element.getLocalName().equals(string)) continue;
                element3.removeChild(element);
            }
        }
        for (String string2 : list) {
            element = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", string);
            Element element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            element4.appendChild(document.createTextNode(string2));
            element.appendChild(element4);
            Util.appendChildElement((Element)element3, (Element)element, (String[])folderElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)antProjectHelper, (Element)element2);
    }

    public static List<String> getBuildFiles(PropertyEvaluator propertyEvaluator, List<JavaCompilationUnit> list, File file, File file2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (JavaCompilationUnit javaCompilationUnit : list) {
            if (javaCompilationUnit.output == null) continue;
            for (String string : javaCompilationUnit.output) {
                String string2;
                File file3 = Util.resolveFile((PropertyEvaluator)propertyEvaluator, (File)file2, (String)string);
                try {
                    if (file3.exists() && !FileUtil.isArchiveFile((URL)file3.toURL())) {
                        continue;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
                if ((string2 = file3.getAbsolutePath()).startsWith(file.getAbsolutePath() + File.separatorChar) || string2.startsWith(file2.getAbsolutePath() + File.separatorChar)) continue;
                boolean bl = true;
                for (String string3 : arrayList) {
                    if (!string3.equals(string2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static void putBuildFiles(AntProjectHelper antProjectHelper, List<String> list) {
        JavaProjectGenerator.putBuildElement(antProjectHelper, list, "build-file");
    }

    public static List<TargetMapping> getTargetMappings(AntProjectHelper antProjectHelper) {
        ArrayList<TargetMapping> arrayList = new ArrayList<TargetMapping>();
        Element element = Util.getPrimaryConfigurationData((AntProjectHelper)antProjectHelper);
        Element element2 = Util.findElement((Element)element, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return arrayList;
        }
        for (Element element3 : Util.findSubElements((Element)element2)) {
            TargetMapping targetMapping = new TargetMapping();
            targetMapping.name = element3.getAttribute("name");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            EditableProperties editableProperties = new EditableProperties(false);
            for (Element element4 : Util.findSubElements((Element)element3)) {
                if (element4.getLocalName().equals("target")) {
                    arrayList2.add(Util.findText((Element)element4));
                    continue;
                }
                if (element4.getLocalName().equals("script")) {
                    targetMapping.script = Util.findText((Element)element4);
                    continue;
                }
                if (element4.getLocalName().equals("context")) {
                    TargetMapping.Context context = new TargetMapping.Context();
                    for (Element element5 : Util.findSubElements((Element)element4)) {
                        Element element6;
                        if (element5.getLocalName().equals("property")) {
                            context.property = Util.findText((Element)element5);
                            continue;
                        }
                        if (element5.getLocalName().equals("format")) {
                            context.format = Util.findText((Element)element5);
                            continue;
                        }
                        if (element5.getLocalName().equals("folder")) {
                            context.folder = Util.findText((Element)element5);
                            continue;
                        }
                        if (element5.getLocalName().equals("pattern")) {
                            context.pattern = Util.findText((Element)element5);
                            continue;
                        }
                        if (!element5.getLocalName().equals("arity") || (element6 = Util.findElement((Element)element5, (String)"separated-files", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                        context.separator = Util.findText((Element)element6);
                    }
                    targetMapping.context = context;
                }
                if (!element4.getLocalName().equals("property")) continue;
                JavaProjectGenerator.readProperty(element4, editableProperties);
            }
            targetMapping.targets = arrayList2;
            if (editableProperties.keySet().size() > 0) {
                targetMapping.properties = editableProperties;
            }
            arrayList.add(targetMapping);
        }
        return arrayList;
    }

    static boolean isFolder(PropertyEvaluator propertyEvaluator, File file, String string) {
        File file2 = Util.resolveFile((PropertyEvaluator)propertyEvaluator, (File)file, (String)string);
        if (file2 != null && file2.isDirectory()) {
            return true;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        return n == -1 || n < n2;
    }

    private static void readProperty(Element element, EditableProperties editableProperties) {
        String string = element.getAttribute("name");
        String string2 = Util.findText((Element)element);
        editableProperties.setProperty(string, string2);
    }

    public static final class TargetMapping {
        public String script;
        public List<String> targets;
        public String name;
        public EditableProperties properties;
        public Context context;

        public static final class Context {
            public String property;
            public String format;
            public String folder;
            public String pattern;
            public String separator;
        }
    }

    public static final class Export {
        public String type;
        public String location;
        public String script;
        public String buildTarget;
        public String cleanTarget;
    }

    public static final class JavaCompilationUnit {
        public List<String> packageRoots;
        public List<CP> classpath;
        public List<String> output;
        public List<String> javadoc;
        public String sourceLevel;
        public boolean isTests;

        public String toString() {
            return "FPG.JCU[packageRoots=" + this.packageRoots + ", classpath=" + this.classpath + ", output=" + this.output + ", javadoc=" + this.javadoc + ", sourceLevel=" + this.sourceLevel + ",isTests=" + this.isTests + "]";
        }

        public static final class CP {
            public String classpath;
            public String mode;

            public String toString() {
                return "FPG.JCU.CP:[classpath=" + this.classpath + ", mode=" + this.mode + ", this=" + super.toString() + "]";
            }
        }
    }

    public static final class SourceFolder {
        public String label;
        public String type;
        public String location;
        public String style;
        public String includes;
        public String excludes;
        public String encoding;

        public String toString() {
            return "FPG.SF[label=" + this.label + ",type=" + this.type + ",location=" + this.location + ",style=" + this.style + ",includes=" + this.includes + ",excludes=" + this.excludes + ",encoding=" + this.encoding + "]";
        }
    }
}

