/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.j2ee.common.DDEditorNavigator;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.common.ParseUtils;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.j2ee.ddloaders.catalog.EnterpriseCatalog;
import org.netbeans.modules.j2ee.ddloaders.ejb.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.ejb.DDChangeListener;
import org.netbeans.modules.j2ee.ddloaders.ejb.EjbJarDataLoader;
import org.netbeans.modules.j2ee.ddloaders.multiview.CmpRelationshipsMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataNode;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbMultiViewElement;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.SessionHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.xml.multiview.DesignMultiViewDesc;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EjbJarMultiViewDataObject
extends DDMultiViewDataObject
implements DDChangeListener,
DDEditorNavigator,
FileChangeListener,
ChangeListener {
    private EjbJarProxy ejbJar;
    private FileObject[] srcRoots;
    private PropertyChangeListener ejbJarChangeListener;
    private Map entityHelperMap = new HashMap();
    private Map sessionHelperMap = new HashMap();
    private static final long serialVersionUID = 8857563089355069362L;
    private static final Logger LOGGER = Logger.getLogger(EjbJarMultiViewDataObject.class.getName());
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    private static final int HOME = 10;
    private static final int REMOTE = 20;
    private static final int LOCAL_HOME = 30;
    private static final int LOCAL = 40;
    private static final String OVERVIEW = "Overview";
    private static final String CMP_RELATIONSHIPS = "CmpRelationships";
    private RequestProcessor.Task elementTask;
    private List deletedEjbNames;
    private List newFileNames;

    public EjbJarMultiViewDataObject(FileObject fileObject, EjbJarDataLoader ejbJarDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)ejbJarDataLoader);
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)validateXMLSupport);
        ViewCookieFactory viewCookieFactory = new ViewCookieFactory();
        cookieSet.add(ViewCookie.class, (CookieSet.Factory)viewCookieFactory);
        Project project = this.getProject();
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
        }
        this.refreshSourceFolders();
    }

    private void refreshSourceFolders() {
        SourceGroup[] sourceGroupArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Project project = this.getProject();
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sourceGroupArray = sources.getSourceGroups("java");
        } else {
            sourceGroupArray = null;
        }
        if (sourceGroupArray != null) {
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbJar = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)sourceGroupArray[i].getRootFolder());
                if (ejbJar == null || ejbJar.getDeploymentDescriptor() == null) continue;
                try {
                    FileObject fileObject = sourceGroupArray[i].getRootFolder();
                    arrayList.add(sourceGroupArray[i].getRootFolder());
                    FileSystem fileSystem = fileObject.getFileSystem();
                    fileSystem.removeFileChangeListener((FileChangeListener)this);
                    fileSystem.addFileChangeListener((FileChangeListener)this);
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
        }
        this.srcRoots = arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private Project getProject() {
        return FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
    }

    public FileObject getProjectDirectory() {
        Project project = this.getProject();
        return project == null ? null : project.getProjectDirectory();
    }

    public SourceGroup[] getSourceGroups() {
        Project project = this.getProject();
        if (project != null) {
            return ProjectUtils.getSources((Project)project).getSourceGroups("java");
        }
        return null;
    }

    private String getPackageName(FileObject fileObject) {
        for (int i = 0; i < this.srcRoots.length; ++i) {
            String string = FileUtil.getRelativePath((FileObject)this.srcRoots[i], (FileObject)fileObject);
            if (string == null) continue;
            if (fileObject.getExt().length() > 0) {
                string = string.substring(0, string.length() - fileObject.getExt().length() - 1);
            }
            return string.replace('/', '.');
        }
        return null;
    }

    public EjbJar getEjbJar() {
        if (this.ejbJar == null) {
            try {
                this.parseDocument();
            }
            catch (IOException iOException) {
                Utils.notifyError(iOException);
            }
        }
        return this.ejbJar;
    }

    protected Node createNodeDelegate() {
        return new EjbJarMultiViewDataNode(this);
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon";
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/j2ee/ddloaders/resources/DDInvalidIcon";
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        DataObject dataObject = super.handleCopy(dataFolder);
        try {
            dataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dataObject;
    }

    public void deploymentChange(DDChangeEvent dDChangeEvent) {
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void elementCreated(String string) {
        EjbJarMultiViewDataObject ejbJarMultiViewDataObject = this;
        synchronized (ejbJarMultiViewDataObject) {
            if (this.newFileNames == null) {
                this.newFileNames = new ArrayList();
            }
            this.newFileNames.add(string);
        }
        if (this.elementTask == null) {
            this.elementTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    EjbJarMultiViewDataObject ejbJarMultiViewDataObject;
                    if (EjbJarMultiViewDataObject.this.deletedEjbNames != null) {
                        for (int i = 0; i < EjbJarMultiViewDataObject.this.deletedEjbNames.size(); ++i) {
                            String string;
                            String string2 = string = (String)EjbJarMultiViewDataObject.this.deletedEjbNames.get(i);
                            int n = string.lastIndexOf(".");
                            if (n > 0) {
                                string2 = string.substring(n + 1);
                            }
                            boolean bl = false;
                            for (int j = 0; j < EjbJarMultiViewDataObject.this.newFileNames.size(); ++j) {
                                String string3;
                                String string4 = string3 = (String)EjbJarMultiViewDataObject.this.newFileNames.get(j);
                                int n2 = string3.lastIndexOf(".");
                                if (n2 > 0) {
                                    string4 = string3.substring(n2 + 1);
                                }
                                if (!string2.equals(string4)) continue;
                                bl = true;
                                DDChangeEvent dDChangeEvent = new DDChangeEvent(EjbJarMultiViewDataObject.this, (DataObject)EjbJarMultiViewDataObject.this, string, string3, 2);
                                EjbJarMultiViewDataObject.this.deploymentChange(dDChangeEvent);
                                EjbJarMultiViewDataObject ejbJarMultiViewDataObject2 = EjbJarMultiViewDataObject.this;
                                synchronized (ejbJarMultiViewDataObject2) {
                                    EjbJarMultiViewDataObject.this.newFileNames.remove(string3);
                                    break;
                                }
                            }
                            if (bl) continue;
                            DDChangeEvent dDChangeEvent = new DDChangeEvent(EjbJarMultiViewDataObject.this, (DataObject)EjbJarMultiViewDataObject.this, null, string, 3);
                            EjbJarMultiViewDataObject.this.deploymentChange(dDChangeEvent);
                        }
                        ejbJarMultiViewDataObject = EjbJarMultiViewDataObject.this;
                        synchronized (ejbJarMultiViewDataObject) {
                            EjbJarMultiViewDataObject.this.deletedEjbNames = null;
                        }
                    }
                    ejbJarMultiViewDataObject = EjbJarMultiViewDataObject.this;
                    synchronized (ejbJarMultiViewDataObject) {
                        EjbJarMultiViewDataObject.this.newFileNames = null;
                    }
                }
            }, 1500, 1);
        } else {
            this.elementTask.schedule(1500);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = fileRenameEvent.getFile();
        String string = this.getPackageName(fileObject);
        if (string != null) {
            int n = string.lastIndexOf(".");
            String string2 = fileRenameEvent.getName();
            String string3 = (n >= 0 ? string.substring(0, n + 1) : "") + string2;
            EjbJar ejbJar = this.getEjbJar();
            if (ejbJar.getStatus() == 0) {
                this.fireEvent(string3, string, 2);
            }
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        String string = this.getPackageName(fileObject);
        if (string != null) {
            if (this.newFileNames == null) {
                this.fireEvent(null, string, 3);
            } else {
                Ejb[] ejbArray = this.nullSafeGetEjbs();
                for (int i = 0; i < ejbArray.length; ++i) {
                    if (!string.equals(ejbArray[i].getEjbClass())) continue;
                    EjbJarMultiViewDataObject ejbJarMultiViewDataObject = this;
                    synchronized (ejbJarMultiViewDataObject) {
                        if (this.deletedEjbNames == null) {
                            this.deletedEjbNames = new ArrayList();
                        }
                        this.deletedEjbNames.add(string);
                        break;
                    }
                }
            }
        }
    }

    private Ejb[] nullSafeGetEjbs() {
        EjbJar ejbJar = this.getEjbJar();
        if (ejbJar == null) {
            return new Ejb[0];
        }
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return new Ejb[0];
        }
        Ejb[] ejbArray = enterpriseBeans.getEjbs();
        return ejbArray != null ? ejbArray : new Ejb[]{};
    }

    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = fileEvent.getFile();
        String string = this.getPackageName(fileObject);
        if (string != null) {
            this.elementCreated(string);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshSourceFolders();
    }

    protected void parseDocument() throws IOException {
        DDProvider dDProvider = DDProvider.getDefault();
        if (this.ejbJar == null || this.ejbJar.getOriginal() == null) {
            try {
                EjbJarProxy ejbJarProxy = (EjbJarProxy)dDProvider.getDDRoot(this.getPrimaryFile());
                if (ejbJarProxy == null) {
                    LOGGER.log(Level.INFO, "Could not resolve EjbJar for " + this.getPrimaryFile().getPath() + "");
                    ejbJarProxy = new EjbJarProxy(null, null);
                }
                this.setEjbJar(ejbJarProxy);
            }
            catch (IOException iOException) {
                if (this.ejbJar == null) {
                    this.setEjbJar(new EjbJarProxy(null, null));
                }
            }
        } else {
            DDUtils.merge((EjbJarProxy)this.ejbJar, (Reader)this.createReader());
        }
        this.validateDocument();
    }

    protected void validateDocument() throws IOException {
        block3: {
            try {
                ParseUtils.parseDD((InputSource)new InputSource(this.createInputStream()), (EntityResolver)new EnterpriseCatalog());
                this.setSaxError(null);
            }
            catch (SAXException sAXException) {
                this.setSaxError(sAXException);
                this.ejbJar.setStatus(2);
                if (sAXException instanceof SAXParseException) {
                    this.ejbJar.setError((SAXParseException)sAXException);
                }
                if (!(sAXException.getException() instanceof SAXParseException)) break block3;
                this.ejbJar.setError((SAXParseException)sAXException.getException());
            }
        }
    }

    private void setEjbJar(EjbJarProxy ejbJarProxy) {
        if (this.ejbJar != null) {
            this.ejbJar.removePropertyChangeListener(this.ejbJarChangeListener);
        }
        this.ejbJar = ejbJarProxy;
        if (this.ejbJarChangeListener == null) {
            this.ejbJarChangeListener = new EjbJarPropertyChangeListener();
        }
        this.ejbJar.addPropertyChangeListener(this.ejbJarChangeListener);
    }

    protected RootInterface getDDModel() {
        if (this.ejbJar == null) {
            try {
                this.parseDocument();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
        }
        return this.ejbJar;
    }

    public boolean isDocumentParseable() {
        return 2 != this.getEjbJar().getStatus();
    }

    protected String getPrefixMark() {
        return "<ejb-jar";
    }

    protected DesignMultiViewDesc[] getMultiViewDesc() {
        if (Util.isJavaEE5orHigher((Project)this.getProject())) {
            return new DesignMultiViewDesc[0];
        }
        return new DesignMultiViewDesc[]{new DDView(this, OVERVIEW), new DDView(this, CMP_RELATIONSHIPS)};
    }

    protected boolean isModelCreated() {
        return this.ejbJar != null && this.ejbJar.getOriginal() != null;
    }

    public void showElement(final Object object) {
        if (object instanceof Relationships || object instanceof EjbRelation) {
            this.openView(1);
        } else {
            this.openView(0);
        }
        Utils.runInAwtDispatchThread(new Runnable(){

            public void run() {
                SectionNodeView sectionNodeView = (SectionNodeView)EjbJarMultiViewDataObject.this.getActiveMVElement().getSectionView();
                Node node = sectionNodeView.getRoot();
                SectionNode sectionNode = ((SectionNode)node.getChildren().getNodes()[0]).getNodeForElement(object);
                if (sectionNode != null) {
                    sectionNodeView.openPanel((Object)sectionNode);
                    ((SectionNodeInnerPanel)sectionNode.getSectionNodePanel().getInnerPanel()).focusData(object);
                }
            }
        });
    }

    public ToolBarMultiViewElement getActiveMVElement() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    private Ejb getEjbFromEjbClass(String string) {
        EnterpriseBeans enterpriseBeans = this.getEjbJar().getEnterpriseBeans();
        if (enterpriseBeans != null) {
            Ejb[] ejbArray = enterpriseBeans.getEjbs();
            for (int i = 0; i < ejbArray.length; ++i) {
                if (ejbArray[i].getEjbClass() == null || !ejbArray[i].getEjbClass().equals(string)) continue;
                return ejbArray[i];
            }
        }
        return null;
    }

    private int getBeanInterfaceType(String string) {
        int n = -1;
        EjbJar ejbJar = this.getEjbJar();
        if (ejbJar == null) {
            return n;
        }
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return n;
        }
        Session[] sessionArray = enterpriseBeans.getSession();
        for (int i = 0; i < sessionArray.length; ++i) {
            if (sessionArray[i].getHome() != null && sessionArray[i].getHome().equals(string)) {
                n = 10;
                break;
            }
            if (sessionArray[i].getRemote() != null && sessionArray[i].getRemote().equals(string)) {
                n = 20;
                break;
            }
            if (sessionArray[i].getLocalHome() != null && sessionArray[i].getLocalHome().equals(string)) {
                n = 30;
                break;
            }
            if (sessionArray[i].getLocal() == null || !sessionArray[i].getLocal().equals(string)) continue;
            n = 40;
            break;
        }
        return n;
    }

    private int getSpecificEvent(int n, int n2) {
        if (n == 2) {
            switch (n2) {
                case 10: {
                    return 5;
                }
                case 20: {
                    return 6;
                }
                case 30: {
                    return 7;
                }
                case 40: {
                    return 8;
                }
            }
        }
        if (n == 3) {
            switch (n2) {
                case 10: {
                    return 9;
                }
                case 20: {
                    return 10;
                }
                case 30: {
                    return 11;
                }
                case 40: {
                    return 12;
                }
            }
        }
        return -1;
    }

    private boolean fireEvent(String string, String string2, int n) {
        int n2;
        boolean bl = false;
        int n3 = -1;
        String string3 = n == 2 ? string : string2;
        Ejb ejb = this.getEjbFromEjbClass(string3);
        if (ejb != null) {
            n3 = n == 2 ? 13 : 14;
            bl = true;
        }
        if (!bl && (n2 = this.getBeanInterfaceType(string3)) > 0) {
            n3 = this.getSpecificEvent(n, n2);
            bl = true;
        }
        if (bl) {
            assert (n3 > 0);
            DDChangeEvent dDChangeEvent = new DDChangeEvent(this, (DataObject)this, string, string2, n3);
            this.deploymentChange(dDChangeEvent);
        }
        return bl;
    }

    public EntityHelper getEntityHelper(Entity entity) {
        EntityHelper entityHelper = (EntityHelper)this.entityHelperMap.get(entity);
        if (entityHelper == null) {
            entityHelper = new EntityHelper(this, entity);
            this.entityHelperMap.put(entity, entityHelper);
        }
        return entityHelper;
    }

    public SessionHelper getSessionHelper(Session session) {
        SessionHelper sessionHelper = (SessionHelper)this.sessionHelperMap.get(session);
        if (sessionHelper == null) {
            sessionHelper = new SessionHelper(this, session);
            this.sessionHelperMap.put(session, sessionHelper);
        }
        return sessionHelper;
    }

    private class EjbJarPropertyChangeListener
    implements PropertyChangeListener {
        private EjbJarPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("dd_status".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            if (object instanceof EnterpriseBeans) {
                Object object2 = propertyChangeEvent.getOldValue();
                Object object3 = propertyChangeEvent.getNewValue();
                if (object2 instanceof Entity || object3 instanceof Entity) {
                    EjbJarMultiViewDataObject.this.entityHelperMap.keySet().retainAll(Arrays.asList(((EnterpriseBeans)object).getEntity()));
                } else if (object2 instanceof Session || object3 instanceof Session) {
                    EjbJarMultiViewDataObject.this.sessionHelperMap.keySet().retainAll(Arrays.asList(((EnterpriseBeans)object).getSession()));
                }
            }
        }
    }

    private static class DDView
    extends DesignMultiViewDesc
    implements Serializable {
        private String name;
        static final long serialVersionUID = -8759598009819101630L;

        DDView(EjbJarMultiViewDataObject ejbJarMultiViewDataObject, String string) {
            super((XmlMultiViewDataObject)ejbJarMultiViewDataObject, string);
            this.name = string;
        }

        public MultiViewElement createElement() {
            EjbJarMultiViewDataObject ejbJarMultiViewDataObject = (EjbJarMultiViewDataObject)this.getDataObject();
            if (this.name.equals(EjbJarMultiViewDataObject.OVERVIEW)) {
                return new EjbMultiViewElement(ejbJarMultiViewDataObject);
            }
            if (this.name.equals(EjbJarMultiViewDataObject.CMP_RELATIONSHIPS)) {
                return new CmpRelationshipsMultiViewElement(ejbJarMultiViewDataObject);
            }
            return null;
        }

        public HelpCtx getHelpCtx() {
            EjbJarMultiViewDataObject ejbJarMultiViewDataObject = (EjbJarMultiViewDataObject)this.getDataObject();
            return new HelpCtx(ejbJarMultiViewDataObject.getActiveMVElement().getSectionView().getClass());
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon.gif");
        }

        public String preferredID() {
            return "dd_multiview_" + this.name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(EjbJarMultiViewDataObject.class, (String)("LBL_" + this.name));
        }
    }

    private static final class ViewSupport
    implements ViewCookie {
        private MultiDataObject.Entry primary;

        public ViewSupport(MultiDataObject.Entry entry) {
            this.primary = entry;
        }

        public void view() {
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(this.primary.getFile().getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
    }

    private class ViewCookieFactory
    implements CookieSet.Factory {
        private ViewCookieFactory() {
        }

        public Node.Cookie createCookie(Class clazz) {
            if (clazz == ViewCookie.class) {
                return new ViewSupport(EjbJarMultiViewDataObject.this.getPrimaryEntry());
            }
            return null;
        }
    }
}

