/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.netbeans.modules.ruby.options.FmtOptions;
import org.netbeans.modules.ruby.options.FmtTabsIndents;
import org.netbeans.modules.ruby.options.FormatingOptionsPanelController;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormatingOptionsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private FormatingOptionsPanelController fopControler;
    private List<Category> categories = new ArrayList<Category>();
    private boolean loaded = false;
    private JComboBox categoryCombo;
    private JLabel categoryLabel;
    private JPanel categoryPanel;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JEditorPane previewPane;
    private JPanel previewPanel;

    public FormatingOptionsPanel(FormatingOptionsPanelController formatingOptionsPanelController) {
        this.fopControler = formatingOptionsPanelController;
        this.initComponents();
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        this.previewPane.setContentType("text/x-ruby");
        this.previewPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.previewPane.setText("1234567890123456789012345678901234567890");
        this.previewPane.setDoubleBuffered(true);
        this.createCategories();
        DefaultComboBoxModel<Category> defaultComboBoxModel = new DefaultComboBoxModel<Category>();
        for (Category category : this.categories) {
            defaultComboBoxModel.addElement(category);
        }
        this.categoryCombo.setModel(defaultComboBoxModel);
        this.categoryCombo.addActionListener(this);
        this.actionPerformed(new ActionEvent(defaultComboBoxModel, 0, null));
    }

    void load() {
        this.loaded = false;
        for (Category category : this.categories) {
            category.update();
        }
        this.loaded = true;
        this.repaintPreview();
    }

    void store() {
        for (Category category : this.categories) {
            category.applyChanges();
        }
        FmtOptions.flush();
        FmtOptions.lastValues = null;
    }

    void cancel() {
        FmtOptions.lastValues = null;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.optionsPanel = new JPanel();
        this.categoryLabel = new JLabel();
        this.categoryCombo = new JComboBox();
        this.categoryPanel = new JPanel();
        this.previewPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOpaque(false);
        this.optionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.categoryLabel.setLabelFor(this.categoryCombo);
        Mnemonics.setLocalizedText((JLabel)this.categoryLabel, (String)NbBundle.getMessage(FormatingOptionsPanel.class, (String)"LBL_Category"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.optionsPanel.add((Component)this.categoryLabel, gridBagConstraints);
        this.categoryCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.optionsPanel.add((Component)this.categoryCombo, gridBagConstraints);
        this.categoryPanel.setOpaque(false);
        this.categoryPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.optionsPanel.add((Component)this.categoryPanel, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.optionsPanel);
        this.previewPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.previewPanel.setOpaque(false);
        this.previewPanel.setPreferredSize(new Dimension(300, 20));
        this.previewPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setDoubleBuffered(true);
        this.previewPane.setEditable(false);
        this.jScrollPane1.setViewportView(this.previewPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.previewPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.previewPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void createCategories() {
        this.categories.add(FmtTabsIndents.getController());
        for (Category category : this.categories) {
            category.addPropertyChangeListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Category category = (Category)((Object)this.categoryCombo.getSelectedItem());
        this.categoryPanel.setVisible(false);
        this.categoryPanel.removeAll();
        this.categoryPanel.add((Component)category.getComponent(null), "Center");
        this.categoryPanel.setVisible(true);
        if (this.loaded) {
            this.repaintPreview();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.loaded) {
            return;
        }
        this.fopControler.changed();
        this.repaintPreview();
    }

    private void repaintPreview() {
        PreviewPreferences previewPreferences = new PreviewPreferences();
        for (Category category : this.categories) {
            category.storeTo(previewPreferences);
        }
        Category category = (Category)((Object)this.categoryCombo.getSelectedItem());
        this.jScrollPane1.setIgnoreRepaint(true);
        category.refreshPreview(this.previewPane, previewPreferences);
        this.previewPane.setIgnoreRepaint(false);
        this.previewPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        this.previewPane.repaint(100L);
        FmtOptions.lastValues = previewPreferences;
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        protected void putSpi(String string, String string2) {
            this.map.put(string, string2);
        }

        protected String getSpi(String string) {
            return (String)this.map.get(string);
        }

        protected void removeSpi(String string) {
            this.map.remove(string);
        }

        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] keysSpi() throws BackingStoreException {
            String[] stringArray = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(stringArray);
        }

        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected AbstractPreferences childSpi(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static abstract class Category
    extends OptionsPanelController {
        private String displayName;

        public Category(String string) {
            this.displayName = NbBundle.getMessage(FormatingOptionsPanel.class, (String)string);
        }

        public abstract void storeTo(Preferences var1);

        public abstract void refreshPreview(JEditorPane var1, Preferences var2);

        public String toString() {
            return this.displayName;
        }
    }
}

