/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Language;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.modules.ruby.Formatter;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.options.CodeStyle;
import org.netbeans.modules.ruby.options.FormatingOptionsPanel;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtOptions {
    public static final String expandTabToSpaces = "expandTabToSpaces";
    public static final String tabSize = "tabSize";
    public static final String indentSize = "indentSize";
    public static final String continuationIndentSize = "continuationIndentSize";
    public static final String reformatComments = "reformatComments";
    public static final String indentHtml = "indentHtml";
    public static final String rightMargin = "rightMargin";
    public static CodeStyleProducer codeStyleProducer;
    public static Preferences lastValues;
    private static Class<? extends EditorKit> kitClass;
    private static final String DEFAULT_PROFILE = "default";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String string) {
        return Integer.parseInt(defaults.get(string));
    }

    public static boolean getDefaultAsBoolean(String string) {
        return Boolean.parseBoolean(defaults.get(string));
    }

    public static String getDefaultAsString(String string) {
        return defaults.get(string);
    }

    public static Preferences getPreferences(String string) {
        return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").node(string);
    }

    public static boolean getGlobalExpandTabToSpaces() {
        org.netbeans.editor.Formatter formatter = (org.netbeans.editor.Formatter)Settings.getValue(FmtOptions.getKitClass(), (String)"formatter");
        if (formatter != null) {
            return formatter.expandTabs();
        }
        return FmtOptions.getDefaultAsBoolean(expandTabToSpaces);
    }

    public static int getGlobalTabSize() {
        Integer n = (Integer)Settings.getValue(FmtOptions.getKitClass(), (String)"tab-size");
        return n != null ? n : FmtOptions.getDefaultAsInt(tabSize);
    }

    public static int getGlobalRightMargin() {
        Integer n = (Integer)Settings.getValue(FmtOptions.getKitClass(), (String)"text-limit-width");
        return n != null ? n : FmtOptions.getDefaultAsInt(rightMargin);
    }

    public static Class<? extends EditorKit> getKitClass() {
        if (kitClass == null) {
            EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-ruby")).lookup(EditorKit.class);
            kitClass = editorKit != null ? editorKit.getClass() : EditorKit.class;
        }
        return kitClass;
    }

    public static void flush() {
        try {
            FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()).flush();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static CodeStyle createCodeStyle(Preferences preferences) {
        CodeStyle.getDefault(null);
        return codeStyleProducer.create(preferences);
    }

    public static boolean isInteger(String string) {
        String string2 = defaults.get(string);
        try {
            Integer.parseInt(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getLastValue(String string) {
        Preferences preferences = lastValues == null ? FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()) : lastValues;
        return preferences.get(string, FmtOptions.getDefaultAsString(string));
    }

    private static void createDefaults() {
        String[][] stringArrayArray = new String[][]{{expandTabToSpaces, TRUE}, {tabSize, "8"}, {indentSize, "2"}, {continuationIndentSize, "2"}, {reformatComments, FALSE}, {indentHtml, TRUE}, {rightMargin, "80"}};
        defaults = new HashMap<String, String>();
        for (String[] stringArray : stringArrayArray) {
            defaults.put(stringArray[0], stringArray[1]);
        }
    }

    static {
        FmtOptions.createDefaults();
    }

    public static interface CodeStyleProducer {
        public CodeStyle create(Preferences var1);
    }

    public static class CategorySupport
    extends FormatingOptionsPanel.Category
    implements ActionListener,
    DocumentListener {
        public static final String OPTION_ID = "org.netbeans.modules.ruby.options.FormatingOptions.ID";
        private static final int LOAD = 0;
        private static final int STORE = 1;
        private static final int ADD_LISTENERS = 2;
        private String previewText = NbBundle.getMessage(FmtOptions.class, (String)"SAMPLE_Default");
        private String[][] forcedOptions;
        private boolean changed = false;
        private JPanel panel;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public CategorySupport(String string, JPanel jPanel, String string2, String[] ... stringArray) {
            super(string);
            this.panel = jPanel;
            this.previewText = string2 == null ? this.previewText : string2;
            this.forcedOptions = stringArray;
            this.addListeners();
        }

        protected void addListeners() {
            this.scan(this.panel, 2, null);
        }

        public void update() {
            this.scan(this.panel, 0, null);
        }

        public void applyChanges() {
            this.scan(this.panel, 1, null);
        }

        public void storeTo(Preferences preferences) {
            this.scan(this.panel, 1, preferences);
        }

        public void refreshPreview(JEditorPane jEditorPane, Preferences preferences) {
            Object object;
            for (String[] object22 : this.forcedOptions) {
                preferences.put(object22[0], object22[1]);
            }
            int n = 30;
            try {
                int n2;
                Font font;
                FontMetrics fontMetrics;
                int n3;
                n = preferences.getInt(FmtOptions.rightMargin, FmtOptions.getDefaultAsInt(FmtOptions.rightMargin));
                object = jEditorPane;
                if (jEditorPane.getParent() instanceof JViewport) {
                    object = (JViewport)jEditorPane.getParent();
                }
                if ((n3 = (fontMetrics = ((JComponent)object).getFontMetrics(font = ((Component)object).getFont())).charWidth('x')) > 0 && (n2 = ((JComponent)object).getWidth() / n3) > 3) {
                    n = n2 - 2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object = FmtOptions.createCodeStyle(preferences);
            try {
                BaseDocument baseDocument = new BaseDocument(null, false);
                baseDocument.putProperty(Language.class, RubyTokenId.language());
                baseDocument.insertString(0, this.previewText, null);
                Formatter formatter = new Formatter((CodeStyle)object, n);
                formatter.reformat((Document)baseDocument, 0, baseDocument.getLength(), null);
                String string = baseDocument.getText(0, baseDocument.getLength());
                jEditorPane.setText(string);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        public void cancel() {
        }

        public boolean isValid() {
            return true;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public JComponent getComponent(Lookup lookup) {
            return this.panel;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        void changed() {
            if (!this.changed) {
                this.changed = true;
                this.pcs.firePropertyChange("changed", false, true);
            }
            this.pcs.firePropertyChange("valid", null, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.changed();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.changed();
        }

        private void scan(Container container, int n, Preferences preferences) {
            for (Component component : container.getComponents()) {
                JComponent jComponent;
                Object object;
                if (component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty(OPTION_ID)) != null && object instanceof String) {
                    switch (n) {
                        case 0: {
                            this.loadData(jComponent, (String)object);
                            break;
                        }
                        case 1: {
                            this.storeData(jComponent, (String)object, preferences);
                            break;
                        }
                        case 2: {
                            this.addListener(jComponent);
                        }
                    }
                }
                if (!(component instanceof Container)) continue;
                this.scan((Container)component, n, preferences);
            }
        }

        private void loadData(JComponent jComponent, String string) {
            Preferences preferences = FmtOptions.getPreferences(FmtOptions.getCurrentProfileId());
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.setText(preferences.get(string, FmtOptions.getDefaultAsString(string)));
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                boolean bl = FmtOptions.getDefaultAsBoolean(string);
                jCheckBox.setSelected(preferences.getBoolean(string, bl));
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                String string2 = preferences.get(string, FmtOptions.getDefaultAsString(string));
                ComboBoxModel comboBoxModel = this.createModel(string2);
                jComboBox.setModel(comboBoxModel);
                ComboItem comboItem = CategorySupport.whichItem(string2, comboBoxModel);
                jComboBox.setSelectedItem(comboItem);
            }
        }

        private void storeData(JComponent jComponent, String string, Preferences preferences) {
            Preferences preferences2;
            Preferences preferences3 = preferences2 = preferences == null ? FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()) : preferences;
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                String string2 = jTextField.getText();
                if (FmtOptions.isInteger(string)) {
                    try {
                        int n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string2 = FmtOptions.getLastValue(string);
                    }
                }
                preferences2.put(string, string2);
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                preferences2.putBoolean(string, jCheckBox.isSelected());
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                preferences2.put(string, ((ComboItem)jComboBox.getSelectedItem()).value);
            }
        }

        private void addListener(JComponent jComponent) {
            if (jComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jComponent;
                jTextField.addActionListener(this);
                jTextField.getDocument().addDocumentListener(this);
            } else if (jComponent instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)jComponent;
                jCheckBox.addActionListener(this);
            } else if (jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                jComboBox.addActionListener(this);
            }
        }

        private ComboBoxModel createModel(String string) {
            return null;
        }

        private static ComboItem whichItem(String string, ComboBoxModel comboBoxModel) {
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                ComboItem comboItem = (ComboItem)comboBoxModel.getElementAt(i);
                if (!string.equals(comboItem.value)) continue;
                return comboItem;
            }
            return null;
        }

        private static class ComboItem {
            String value;
            String displayName;

            public ComboItem(String string, String string2) {
                this.value = string;
                this.displayName = NbBundle.getMessage(FmtOptions.class, (String)string2);
            }

            public String toString() {
                return this.displayName;
            }
        }
    }
}

