/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.options;

import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.options.FmtOptions;

public final class CodeStyle {
    private static CodeStyle INSTANCE;
    private Preferences preferences;

    private CodeStyle(Preferences preferences) {
        this.preferences = preferences;
    }

    public static CodeStyle getTestStyle(Preferences preferences) {
        return new CodeStyle(preferences);
    }

    public static synchronized CodeStyle getDefault(Project project) {
        if (FmtOptions.codeStyleProducer == null) {
            FmtOptions.codeStyleProducer = new Producer();
        }
        if (INSTANCE == null) {
            INSTANCE = CodeStyle.create();
        }
        return INSTANCE;
    }

    static CodeStyle create() {
        return new CodeStyle(FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()));
    }

    public int getIndentSize() {
        return this.preferences.getInt("indentSize", FmtOptions.getDefaultAsInt("indentSize"));
    }

    public int getContinuationIndentSize() {
        return this.preferences.getInt("continuationIndentSize", FmtOptions.getDefaultAsInt("continuationIndentSize"));
    }

    public boolean reformatComments() {
        return this.preferences.getBoolean("reformatComments", FmtOptions.getDefaultAsBoolean("reformatComments"));
    }

    public boolean indentHtml() {
        return this.preferences.getBoolean("indentHtml", FmtOptions.getDefaultAsBoolean("indentHtml"));
    }

    public int getRightMargin() {
        return this.preferences.getInt("rightMargin", FmtOptions.getGlobalRightMargin());
    }

    static {
        FmtOptions.codeStyleProducer = new Producer();
    }

    private static class Producer
    implements FmtOptions.CodeStyleProducer {
        private Producer() {
        }

        public CodeStyle create(Preferences preferences) {
            return new CodeStyle(preferences);
        }
    }
}

