/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.CommentNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.SClassNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.ByteList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstConstantElement;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureAnalyzer
implements StructureScanner {
    private Set<AstClassElement> haveAccessModifiers;
    private List<AstElement> structure;
    private Map<AstClassElement, Set<InstAsgnNode>> fields;
    private Set<String> requires;
    private List<AstMethodElement> methods;
    private Map<AstClassElement, Set<AstAttributeElement>> attributes;
    private HtmlFormatter formatter;
    private CompilationInfo info;
    private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
    private static ImageIcon keywordIcon;
    private static final int MAX_RUBY_LABEL_LENGTH = 30;
    private static final String DEFAULT_LABEL = "<% %>";

    public List<? extends StructureItem> scan(CompilationInfo compilationInfo, HtmlFormatter htmlFormatter) {
        if (RubyUtils.isRhtmlFile(compilationInfo.getFileObject())) {
            return this.scanRhtml(compilationInfo, htmlFormatter);
        }
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(compilationInfo);
        this.info = compilationInfo;
        this.formatter = htmlFormatter;
        AnalysisResult analysisResult = rubyParseResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        ArrayList<RubyStructureItem> arrayList = new ArrayList<RubyStructureItem>(list.size());
        for (AstElement astElement : list) {
            arrayList.add(new RubyStructureItem(astElement, compilationInfo));
        }
        return arrayList;
    }

    private AnalysisResult scan(RubyParseResult rubyParseResult) {
        Object object;
        Set<InstAsgnNode> set;
        AnalysisResult analysisResult = new AnalysisResult();
        Node node = AstUtilities.getRoot(rubyParseResult);
        if (node == null) {
            return analysisResult;
        }
        this.structure = new ArrayList<AstElement>();
        this.fields = new HashMap<AstClassElement, Set<InstAsgnNode>>();
        this.attributes = new HashMap<AstClassElement, Set<AstAttributeElement>>();
        this.requires = new HashSet<String>();
        this.methods = new ArrayList<AstMethodElement>();
        this.haveAccessModifiers = new HashSet<AstClassElement>();
        AstPath astPath = new AstPath();
        astPath.descend(node);
        this.scan(node, astPath, null, null, null);
        astPath.ascend();
        HashMap<String, InstAsgnNode> hashMap = new HashMap<String, InstAsgnNode>();
        for (AstClassElement astClassElement : this.fields.keySet()) {
            set = this.fields.get(astClassElement);
            if (set == null) continue;
            for (InstAsgnNode instAsgnNode : set) {
                hashMap.put(instAsgnNode.getName(), instAsgnNode);
            }
            for (InstAsgnNode instAsgnNode : hashMap.values()) {
                AstFieldElement astFieldElement = new AstFieldElement(this.info, (Node)instAsgnNode);
                astFieldElement.setIn(astClassElement.getFqn());
                object = instAsgnNode.getName();
                if (((String)object).startsWith("@@")) {
                    object = ((String)object).substring(2);
                } else if (((String)object).startsWith("@")) {
                    object = ((String)object).substring(1);
                }
                boolean bl = false;
                for (AstElement astElement : astClassElement.getChildren()) {
                    if (astElement.getKind() != ElementKind.ATTRIBUTE || !astElement.getName().equals(object)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                astClassElement.addChild(astFieldElement);
            }
            hashMap.clear();
        }
        for (AstClassElement astClassElement : this.haveAccessModifiers) {
            set = new HashSet<InstAsgnNode>();
            Iterator iterator = new HashSet();
            AstUtilities.findPrivateMethods(astClassElement.getNode(), set, iterator);
            if (iterator.size() > 0) {
                for (AstMethodElement astMethodElement : this.methods) {
                    if (!(astMethodElement instanceof AstMethodElement) || !iterator.contains(((AstElement)(object = astMethodElement)).getNode())) continue;
                    ((AstMethodElement)object).setAccess(Modifier.PRIVATE);
                }
            }
            if (set.size() <= 0) continue;
            for (AstMethodElement astMethodElement : this.methods) {
                if (!(astMethodElement instanceof AstMethodElement) || !set.contains(((AstElement)(object = astMethodElement)).getNode())) continue;
                ((AstMethodElement)object).setAccess(Modifier.PROTECTED);
            }
        }
        analysisResult.setElements(this.structure);
        analysisResult.setAttributes(this.attributes);
        analysisResult.setRequires(this.requires);
        return analysisResult;
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        if (RubyUtils.isRhtmlFile(compilationInfo.getFileObject())) {
            return Collections.emptyMap();
        }
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return Collections.emptyMap();
        }
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(compilationInfo);
        AnalysisResult analysisResult = rubyParseResult.getStructure();
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        try {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            this.addFolds(baseDocument, analysisResult.getElements(), hashMap, arrayList);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return hashMap;
    }

    private void addFolds(BaseDocument baseDocument, List<? extends AstElement> list, Map<String, List<OffsetRange>> map, List<OffsetRange> list2) throws BadLocationException {
        for (AstElement astElement : list) {
            Object object;
            ElementKind elementKind = astElement.getKind();
            switch (elementKind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case CLASS: 
                case MODULE: {
                    object = astElement.getNode();
                    OffsetRange offsetRange = AstUtilities.getRange((Node)object);
                    if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR && offsetRange.getStart() <= Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange.getStart())) break;
                    int n = offsetRange.getStart();
                    n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    int n2 = offsetRange.getEnd();
                    if (n == -1 || n2 == -1 || n >= n2 || n2 > baseDocument.getLength()) break;
                    offsetRange = new OffsetRange(n, n2);
                    list2.add(offsetRange);
                }
            }
            if ((object = astElement.getChildren()) == null || object.size() <= 0) continue;
            this.addFolds(baseDocument, (List<? extends AstElement>)object, map, list2);
        }
    }

    private void scan(Node node, AstPath astPath, String string, Set<String> set, AstElement set2) {
        Set<InstAsgnNode> set3;
        switch (node.nodeId) {
            case CLASSNODE: {
                set3 = new AstClassElement(this.info, node);
                ((AstElement)((Object)set3)).setIn(string);
                Object object2 = AstUtilities.getFqnName(astPath);
                ((AstClassElement)((Object)set3)).setFqn((String)object2);
                string = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node));
                set = new HashSet<String>();
                ((AstClassElement)((Object)set3)).setIncludes(set);
                if (set2 != null) {
                    ((AstElement)((Object)set2)).addChild((AstElement)((Object)set3));
                } else {
                    this.structure.add((AstElement)((Object)set3));
                }
                set2 = set3;
                break;
            }
            case MODULENODE: {
                set3 = new AstModuleElement(this.info, node);
                ((AstElement)((Object)set3)).setIn(string);
                ((AstModuleElement)((Object)set3)).setFqn(AstUtilities.getFqnName(astPath));
                string = AstUtilities.getClassOrModuleName((IScopingNode)((ModuleNode)node));
                if (set2 != null) {
                    ((AstElement)((Object)set2)).addChild((AstElement)((Object)set3));
                } else {
                    this.structure.add((AstElement)((Object)set3));
                }
                set2 = set3;
                break;
            }
            case SCLASSNODE: {
                set3 = new AstClassElement(this.info, node);
                ((AstElement)((Object)set3)).setIn(string);
                ((AstClassElement)((Object)set3)).setFqn(AstUtilities.getFqnName(astPath));
                Object object2 = ((SClassNode)node).getReceiverNode();
                string = object2 instanceof INameNode ? ((INameNode)object2).getName() : null;
                set = new HashSet<String>();
                ((AstClassElement)((Object)set3)).setIncludes(set);
                if (set2 != null) {
                    ((AstElement)((Object)set2)).addChild((AstElement)((Object)set3));
                } else {
                    this.structure.add((AstElement)((Object)set3));
                }
                set2 = set3;
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                Object object2;
                set3 = new AstMethodElement(this.info, node);
                this.methods.add((AstMethodElement)((Object)set3));
                ((AstElement)((Object)set3)).setIn(string);
                if (node instanceof DefnNode && "initialize".equals(((DefnNode)node).getName())) {
                    ((AstMethodElement)((Object)set3)).setAccess(Modifier.PRIVATE);
                } else if (set2 != null && ((AstElement)((Object)set2)).getNode() instanceof SClassNode) {
                    ((AstMethodElement)((Object)set3)).setModifiers(EnumSet.of(Modifier.STATIC));
                }
                if (node instanceof DefsNode && set2 instanceof AstModuleElement && "included".equals(((DefsNode)node).getName()) && (object2 = this.getExtendWith((MethodDefNode)((DefsNode)node))) != null) {
                    if (((String)object2).indexOf(58) == -1) {
                        String object4 = AstUtilities.getFqnName(astPath);
                        object2 = object4 + "::" + (String)object2;
                    }
                    ((AstModuleElement)((Object)set2)).setExtendWith((String)object2);
                }
                if (set2 != null) {
                    ((AstElement)((Object)set2)).addChild((AstElement)((Object)set3));
                    break;
                }
                this.structure.add((AstElement)((Object)set3));
                break;
            }
            case CONSTDECLNODE: {
                set3 = new AstConstantElement(this.info, (ConstDeclNode)node);
                ((AstElement)((Object)set3)).setIn(string);
                if (set2 != null) {
                    ((AstElement)((Object)set2)).addChild((AstElement)((Object)set3));
                    break;
                }
                this.structure.add((AstElement)((Object)set3));
                break;
            }
            case CLASSVARDECLNODE: {
                set3 = new AstFieldElement(this.info, node);
                ((AstElement)((Object)set3)).setIn(string);
                if (set2 != null) {
                    ((AstElement)((Object)set2)).addChild((AstElement)((Object)set3));
                    break;
                }
                this.structure.add((AstElement)((Object)set3));
                break;
            }
            case INSTASGNNODE: {
                if (!(set2 instanceof AstClassElement)) break;
                set3 = this.fields.get(set2);
                if (set3 == null) {
                    set3 = new HashSet<InstAsgnNode>();
                    this.fields.put((AstClassElement)((Object)set2), set3);
                }
                set3.add((InstAsgnNode)node);
                break;
            }
            case VCALLNODE: {
                set3 = ((INameNode)node).getName();
                if (!"private".equals(set3) && !"protected".equals(set3) || !(set2 instanceof AstClassElement)) break;
                this.haveAccessModifiers.add((AstClassElement)((Object)set2));
                break;
            }
            case FCALLNODE: {
                Set<AstAttributeElement> set4;
                Object object;
                Object object2;
                set3 = ((INameNode)node).getName();
                if (((String)((Object)set3)).equals("require")) {
                    ByteList byteList;
                    Node node2;
                    ListNode listNode;
                    object2 = ((FCallNode)node).getArgsNode();
                    if (!(object2 instanceof ListNode) || (listNode = (ListNode)object2).size() <= 0 || !((node2 = listNode.get(0)) instanceof StrNode) || (byteList = ((StrNode)node2).getValue()) == null || byteList.length() <= 0) break;
                    this.requires.add(byteList.toString());
                    break;
                }
                if (set != null && ((String)((Object)set3)).equals("include")) {
                    ListNode listNode;
                    object2 = ((FCallNode)node).getArgsNode();
                    if (!(object2 instanceof ListNode) || (listNode = (ListNode)object2).size() <= 0) break;
                    Node node3 = listNode.get(0);
                    if (node3 instanceof Colon2Node) {
                        set.add(AstUtilities.getFqn((Colon2Node)node3));
                        break;
                    }
                    if (!(node3 instanceof INameNode)) break;
                    set.add(((INameNode)node3).getName());
                    break;
                }
                if (("private".equals(set3) || "protected".equals(set3)) && set2 instanceof AstClassElement) {
                    this.haveAccessModifiers.add((AstClassElement)((Object)set2));
                    break;
                }
                if (AstUtilities.isAttr(node)) {
                    object2 = AstUtilities.getAttrSymbols(node);
                    if (object2 == null || ((SymbolNode[])object2).length <= 0) break;
                    for (Node node4 : object2) {
                        object = new AstAttributeElement(this.info, (SymbolNode)node4, node);
                        if (set2 instanceof AstClassElement) {
                            set4 = this.attributes.get(set2);
                            if (set4 == null) {
                                set4 = new HashSet<AstAttributeElement>();
                                this.attributes.put((AstClassElement)((Object)set2), set4);
                            }
                            set4.add((AstAttributeElement)object);
                        }
                        if (set2 != null) {
                            ((AstElement)((Object)set2)).addChild((AstElement)object);
                            continue;
                        }
                        this.structure.add((AstElement)object);
                    }
                } else {
                    if (!((String)((Object)set3)).equals("module_function") || !((object2 = ((FCallNode)node).getArgsNode()) instanceof ListNode)) break;
                    ListNode listNode = (ListNode)object2;
                    int n = listNode.size();
                    for (int i = 0; i < n; ++i) {
                        AstMethodElement astMethodElement2;
                        Node node4;
                        node4 = listNode.get(i);
                        if (!(node4 instanceof SymbolNode) || (object = ((SymbolNode)node4).getName()) == null || ((String)object).length() <= 0) continue;
                        set4 = null;
                        for (AstMethodElement astMethodElement2 : this.methods) {
                            AstMethodElement astMethodElement3;
                            if (!(astMethodElement2 instanceof AstMethodElement) || !((String)object).equals((astMethodElement3 = astMethodElement2).getName())) continue;
                            set4 = astMethodElement3;
                            break;
                        }
                        if (set4 == null) continue;
                        Node node5 = ((AstElement)((Object)set4)).getNode();
                        astMethodElement2 = new AstMethodElement(this.info, node5);
                        astMethodElement2.setIn(string);
                        if (node5 instanceof DefnNode && "initialize".equals(((DefnNode)node5).getName())) {
                            astMethodElement2.setAccess(Modifier.PRIVATE);
                        }
                        astMethodElement2.setModifiers(EnumSet.of(Modifier.STATIC));
                        if (set2 != null) {
                            ((AstElement)((Object)set2)).addChild(astMethodElement2);
                            continue;
                        }
                        this.structure.add(astMethodElement2);
                    }
                }
                break;
            }
        }
        set3 = node.childNodes();
        if (set3 == null) {
            return;
        }
        for (Node node6 : set3) {
            astPath.descend(node6);
            this.scan(node6, astPath, string, set, (AstElement)((Object)set2));
            astPath.ascend();
        }
    }

    private String getExtendWith(MethodDefNode methodDefNode) {
        ListNode listNode;
        List<String> list = AstUtilities.getDefArgs(methodDefNode, true);
        if (list == null || list.size() != 1) {
            return null;
        }
        String string = list.get(0);
        CallNode callNode = this.findExtendCall((Node)methodDefNode);
        if (callNode == null) {
            return null;
        }
        Node node = callNode.getReceiverNode();
        if (node == null || !(node instanceof INameNode)) {
            return null;
        }
        String string2 = ((INameNode)node).getName();
        if (!string.equals(string2)) {
            return null;
        }
        Node node2 = callNode.getArgsNode();
        if (node2 instanceof ListNode && (listNode = (ListNode)node2).size() == 1) {
            Node node3 = listNode.get(0);
            String string3 = null;
            if (node3 instanceof Colon2Node) {
                string3 = ((Colon2Node)node3).getName();
            } else if (node3 instanceof ConstNode) {
                string3 = ((ConstNode)node3).getName();
            }
            return string3;
        }
        return null;
    }

    private CallNode findExtendCall(Node node) {
        Object object;
        if (node instanceof CallNode && "extend".equals((object = (CallNode)node).getName())) {
            return object;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            CallNode callNode = this.findExtendCall(node2);
            if (callNode == null) continue;
            return callNode;
        }
        return null;
    }

    AnalysisResult analyze(RubyParseResult rubyParseResult, CompilationInfo compilationInfo) {
        this.info = compilationInfo;
        return this.scan(rubyParseResult);
    }

    public void addComments(RubyParseResult rubyParseResult) {
        Node node = rubyParseResult.getRootNode();
        if (node == null) {
            return;
        }
        RubyParserResult rubyParserResult = rubyParseResult.getJRubyResult();
        List list = rubyParserResult.getCommentNodes();
        for (CommentNode commentNode : list) {
            ISourcePosition iSourcePosition = commentNode.getPosition();
            int n = iSourcePosition.getStartOffset();
            int n2 = iSourcePosition.getEndOffset();
            Node node2 = this.findClosest(node, n, n2);
            assert (node2 != null);
            node2.addComment(commentNode);
        }
    }

    private Node findClosest(Node node, int n, int n2) {
        List list = node.childNodes();
        ISourcePosition iSourcePosition = node.getPosition();
        if (n2 < iSourcePosition.getStartOffset()) {
            return node;
        }
        if (n > iSourcePosition.getEndOffset()) {
            return null;
        }
        for (Node node2 : list) {
            Node node3 = this.findClosest(node2, n, n2);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends StructureItem> scanRhtml(CompilationInfo compilationInfo, HtmlFormatter htmlFormatter) {
        AbstractDocument abstractDocument;
        ArrayList<RhtmlStructureItem> arrayList = new ArrayList<RhtmlStructureItem>();
        try {
            abstractDocument = (AbstractDocument)compilationInfo.getDocument();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return Collections.emptyList();
        }
        abstractDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)compilationInfo.getDocument());
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            if (tokenSequence == null) {
                ArrayList<RhtmlStructureItem> arrayList2 = arrayList;
                return arrayList2;
            }
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                TokenId tokenId = tokenSequence.token().id();
                if (!tokenId.name().equals("DELIMITER")) continue;
                int n = tokenSequence.offset();
                if (!tokenSequence.moveNext()) continue;
                Token token = tokenSequence.token();
                int n2 = tokenSequence.offset() + token.length();
                if (!token.id().name().equals("DELIMITER")) {
                    while (tokenSequence.moveNext()) {
                        if (!tokenSequence.token().id().name().equals("DELIMITER")) continue;
                        n2 = tokenSequence.offset() + token.length();
                        break;
                    }
                }
                String string = StructureAnalyzer.navigatorName(abstractDocument, tokenHierarchy, n);
                arrayList.add(new RhtmlStructureItem(string, htmlFormatter, n, n2));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            abstractDocument.readUnlock();
        }
        return arrayList;
    }

    public static String navigatorName(Document document, TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence;
        TokenId tokenId;
        TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
        tokenSequence2.move(n);
        if (tokenSequence2.moveNext() && (tokenId = tokenSequence2.token().id()).name().equals("DELIMITER") && tokenSequence2.moveNext() && (tokenId = tokenSequence2.token().id()).name().startsWith("RUBY") && (tokenSequence = tokenSequence2.embedded()) != null) {
            tokenSequence.moveStart();
            tokenSequence.moveNext();
            while (tokenSequence.token().id() == RubyTokenId.WHITESPACE && tokenSequence.moveNext()) {
            }
            int n2 = tokenSequence.offset();
            tokenId = tokenSequence.token().id();
            if (tokenId == RubyTokenId.WHITESPACE) {
                return DEFAULT_LABEL;
            }
            if (tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.REGEXP_BEGIN) {
                while (tokenSequence.moveNext()) {
                    tokenId = tokenSequence.token().id();
                    if (tokenId != RubyTokenId.STRING_END && tokenId != RubyTokenId.QUOTED_STRING_END && tokenId != RubyTokenId.REGEXP_END) continue;
                    int n3 = tokenSequence.offset() + tokenSequence.token().length();
                    return StructureAnalyzer.createName(document, n2, n3);
                }
            }
            int n4 = tokenSequence.offset() + tokenSequence.token().length();
            if (tokenSequence.moveNext() && (tokenId = tokenSequence.token().id()) == RubyTokenId.DOT && tokenSequence.moveNext()) {
                n4 = tokenSequence.offset() + tokenSequence.token().length();
            }
            return StructureAnalyzer.createName(document, n2, n4);
        }
        return DEFAULT_LABEL;
    }

    private static String createName(Document document, int n, int n2) {
        try {
            String string;
            int n3;
            boolean bl = false;
            int n4 = n2 - n;
            if (n + n4 > document.getLength()) {
                n4 = document.getLength() - n;
                bl = true;
            }
            if (n4 > 30) {
                n4 = 30;
                bl = true;
            }
            if ((n3 = (string = document.getText(n, n4)).indexOf(10)) != -1) {
                if (string.startsWith("<%\n") || string.startsWith("<%#\n")) {
                    if ((n3 = (string = string.substring(n3 + 1)).indexOf(10)) != -1) {
                        string = string.substring(0, n3);
                    }
                } else {
                    boolean bl2 = true;
                    for (int i = 0; i < n3; ++i) {
                        if (Character.isWhitespace(string.charAt(i))) continue;
                        bl2 = false;
                        break;
                    }
                    string = bl2 ? string.substring(n3 + 1) : string.substring(0, n3);
                }
            }
            if (bl) {
                return string + "...";
            }
            return string;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return DEFAULT_LABEL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RhtmlStructureItem
    implements StructureItem {
        private final String name;
        private final HtmlFormatter formatter;
        private final int start;
        private final int end;

        public RhtmlStructureItem(String string, HtmlFormatter htmlFormatter, int n, int n2) {
            this.name = string;
            this.formatter = htmlFormatter;
            this.start = n;
            this.end = n2;
        }

        public String getName() {
            return this.name;
        }

        public String getHtml() {
            this.formatter.reset();
            this.formatter.appendText(this.name);
            return this.formatter.getText();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.start;
        }

        public long getEndPosition() {
            return this.end;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem rubyStructureItem = (RubyStructureItem)object;
            return this.getName().equals(rubyStructureItem.getName());
        }

        public ImageIcon getCustomIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)StructureAnalyzer.RUBY_KEYWORD));
            }
            return keywordIcon;
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RubyStructureItem
    implements StructureItem {
        AstElement node;
        ElementKind kind;
        CompilationInfo info;

        private RubyStructureItem(AstElement astElement, CompilationInfo compilationInfo) {
            this.node = astElement;
            this.info = compilationInfo;
            this.kind = astElement.getKind();
        }

        public String getName() {
            return this.node.getName();
        }

        public String getHtml() {
            AstMethodElement astMethodElement;
            List<String> list;
            StructureAnalyzer.this.formatter.reset();
            StructureAnalyzer.this.formatter.appendText(this.node.getName());
            if ((this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) && (list = (astMethodElement = (AstMethodElement)this.node).getParameters()) != null && list.size() > 0) {
                StructureAnalyzer.this.formatter.appendHtml("(");
                StructureAnalyzer.this.formatter.parameters(true);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    StructureAnalyzer.this.formatter.appendText(string);
                    if (!iterator.hasNext()) continue;
                    StructureAnalyzer.this.formatter.appendHtml(", ");
                }
                StructureAnalyzer.this.formatter.parameters(false);
                StructureAnalyzer.this.formatter.appendHtml(")");
            }
            return StructureAnalyzer.this.formatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.node;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.node.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case CONSTANT: 
                case FIELD: 
                case KEYWORD: 
                case VARIABLE: 
                case OTHER: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> list = this.node.getChildren();
            if (list != null && list.size() > 0) {
                ArrayList<RubyStructureItem> arrayList = new ArrayList<RubyStructureItem>(list.size());
                for (AstElement astElement : list) {
                    arrayList.add(new RubyStructureItem(astElement, this.info));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.node.getNode().getPosition().getStartOffset();
        }

        public long getEndPosition() {
            return this.node.getNode().getPosition().getEndOffset();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem rubyStructureItem = (RubyStructureItem)object;
            if (this.kind != rubyStructureItem.kind) {
                return false;
            }
            if (!this.getName().equals(rubyStructureItem.getName())) {
                return false;
            }
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity;
                Arity arity2 = Arity.getDefArity(this.node.getNode());
                if (!arity2.equals(arity = Arity.getDefArity(rubyStructureItem.node.getNode()))) {
                    return false;
                }
                if (!((Object)this.getModifiers()).equals(rubyStructureItem.getModifiers())) {
                    return false;
                }
                List<String> list = ((AstMethodElement)this.node).getParameters();
                List<String> list2 = ((AstMethodElement)rubyStructureItem.node).getParameters();
                if (list == null) {
                    return list2 == null;
                }
                return ((Object)list).equals(list2);
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity = Arity.getDefArity(this.node.getNode());
                n = 37 * n + arity.hashCode();
            }
            return n;
        }

        public String toString() {
            return this.getName() + " (kind: " + this.kind + ')';
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        public String getSortText() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnalysisResult {
        private List<? extends AstElement> elements;
        private Map<AstClassElement, Set<AstAttributeElement>> attributes;
        private Set<String> requires;

        private AnalysisResult() {
        }

        public Set<String> getRequires() {
            return this.requires;
        }

        public void setRequires(Set<String> set) {
            this.requires = set;
        }

        private void setElements(List<? extends AstElement> list) {
            this.elements = list;
        }

        private void setAttributes(Map<AstClassElement, Set<AstAttributeElement>> map) {
            this.attributes = map;
        }

        public Map<AstClassElement, Set<AstAttributeElement>> getAttributes() {
            return this.attributes;
        }

        public List<? extends AstElement> getElements() {
            if (this.elements == null) {
                return Collections.emptyList();
            }
            return this.elements;
        }
    }
}

