/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.ReflowParagraphAction;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.options.CodeStyle;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter
implements org.netbeans.modules.gsf.api.Formatter {
    private boolean isRhtmlDocument;
    private final CodeStyle codeStyle;
    private int rightMarginOverride = -1;

    public Formatter() {
        this.codeStyle = CodeStyle.getDefault(null);
    }

    public Formatter(CodeStyle codeStyle, int n) {
        assert (codeStyle != null);
        this.codeStyle = codeStyle;
        this.rightMarginOverride = n;
    }

    public boolean needsParserResult() {
        return false;
    }

    public void reindent(Document document, int n, int n2) {
        this.reindent(document, n, n2, null, true);
    }

    public void reformat(Document document, int n, int n2, CompilationInfo compilationInfo) {
        this.reindent(document, n, n2, compilationInfo, false);
    }

    public int indentSize() {
        return this.codeStyle.getIndentSize();
    }

    public int hangingIndentSize() {
        return this.codeStyle.getContinuationIndentSize();
    }

    private int getFormatStableStart(BaseDocument baseDocument, int n) {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId tokenId;
            if ((tokenId = (token = tokenSequence.token()).id()) != RubyTokenId.CLASS && tokenId != RubyTokenId.MODULE && tokenId != RubyTokenId.DEF) continue;
            return tokenSequence.offset();
        } while (tokenSequence.movePrevious());
        return tokenSequence.offset();
    }

    public static int getTokenBalanceDelta(TokenId tokenId, Token<? extends RubyTokenId> token, BaseDocument baseDocument, TokenSequence<? extends RubyTokenId> tokenSequence, boolean bl) {
        if (tokenId == RubyTokenId.IDENTIFIER) {
            if (token.length() == 1) {
                char c = token.text().charAt(0);
                if (c == '[') {
                    return 1;
                }
                if (c == ']') {
                    return -1;
                }
            }
        } else {
            if (tokenId == RubyTokenId.LPAREN || tokenId == RubyTokenId.LBRACKET || tokenId == RubyTokenId.LBRACE) {
                return 1;
            }
            if (tokenId == RubyTokenId.RPAREN || tokenId == RubyTokenId.RBRACKET || tokenId == RubyTokenId.RBRACE) {
                return -1;
            }
            if (bl) {
                if (LexUtilities.isBeginToken(tokenId, baseDocument, tokenSequence)) {
                    return 1;
                }
                if (tokenId == RubyTokenId.END) {
                    return -1;
                }
            }
        }
        return 0;
    }

    public static int getTokenBalance(BaseDocument baseDocument, int n, int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        if (bl2) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            do {
                Token token;
                Token token2;
                TokenId tokenId;
                if (!(tokenId = (token2 = tokenSequence.token()).id()).primaryCategory().equals("ruby")) continue;
                TokenSequence tokenSequence2 = tokenSequence.embedded(RubyTokenId.language());
                tokenSequence2.move(n);
                tokenSequence2.moveNext();
                while ((token = tokenSequence2.token()) != null) {
                    TokenId tokenId2 = token.id();
                    n3 += Formatter.getTokenBalanceDelta(tokenId2, (Token<? extends RubyTokenId>)token, baseDocument, (TokenSequence<? extends RubyTokenId>)tokenSequence2, bl);
                    if (tokenSequence2.moveNext() && tokenSequence2.offset() < n2) continue;
                }
            } while (tokenSequence.moveNext() && tokenSequence.offset() < n2);
        } else {
            TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            do {
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                n3 += Formatter.getTokenBalanceDelta(tokenId, (Token<? extends RubyTokenId>)token, baseDocument, tokenSequence, bl);
            } while (tokenSequence.moveNext() && tokenSequence.offset() < n2);
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInLiteral(BaseDocument baseDocument, int n) throws BadLocationException {
        TokenId tokenId;
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends RubyTokenId> token = LexUtilities.getToken(baseDocument, n2);
            if (token == null) return true;
            TokenId tokenId2 = token.id();
            if (tokenId2 == RubyTokenId.STRING_LITERAL || tokenId2 == RubyTokenId.DOCUMENTATION || tokenId2 == RubyTokenId.QUOTED_STRING_LITERAL || tokenId2 == RubyTokenId.REGEXP_LITERAL) {
                return true;
            }
            if (tokenId2 != RubyTokenId.STRING_END && tokenId2 != RubyTokenId.QUOTED_STRING_END) return false;
            TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n2);
            tokenSequence.move(n2);
            OffsetRange offsetRange = LexUtilities.findHeredocBegin(tokenSequence, token);
            if (offsetRange == OffsetRange.NONE) return false;
            String string = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
            return !string.startsWith("<<-");
        }
        Token<? extends RubyTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token == null || (tokenId = token.id()) != RubyTokenId.STRING_LITERAL && tokenId != RubyTokenId.DOCUMENTATION && tokenId != RubyTokenId.QUOTED_STRING_LITERAL && tokenId != RubyTokenId.REGEXP_LITERAL) return false;
        return true;
    }

    private Token<? extends RubyTokenId> getFirstToken(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            if (this.isRhtmlDocument) {
                TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n2);
                if (tokenSequence != null) {
                    tokenSequence.moveNext();
                    Token token = tokenSequence.token();
                    while (token != null && token.id() == RubyTokenId.WHITESPACE) {
                        if (!tokenSequence.moveNext()) {
                            return null;
                        }
                        token = tokenSequence.token();
                    }
                    return token;
                }
            } else {
                return LexUtilities.getToken(baseDocument, n2);
            }
        }
        return null;
    }

    private boolean isEndIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends RubyTokenId> token = this.getFirstToken(baseDocument, n);
            if (token == null) {
                String string;
                return this.isRhtmlDocument && n2 < baseDocument.getLength() - 2 && ((string = baseDocument.getText(n2, 2)).equals("-%") && n2 < baseDocument.getLength() - 3 ? (string = baseDocument.getText(n2, 3)).equals("-%>") : string.equals("%>"));
            }
            TokenId tokenId = token.id();
            return LexUtilities.isIndentToken(tokenId) && !LexUtilities.isBeginToken(tokenId, baseDocument, n) || tokenId == RubyTokenId.END || tokenId == RubyTokenId.RBRACE || tokenId == RubyTokenId.RBRACKET || tokenId == RubyTokenId.RPAREN;
        }
        return false;
    }

    private boolean isLineContinued(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        if ((n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) == -1) {
            return false;
        }
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token<? extends RubyTokenId> token = tokenSequence.token();
        if (token != null) {
            String string;
            boolean bl;
            TokenId tokenId = token.id();
            boolean bl2 = bl = tokenId == RubyTokenId.NONUNARY_OP || tokenId == RubyTokenId.DOT;
            if (tokenSequence.offset() == n && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                bl = true;
            }
            if (token.length() == 1 && tokenId == RubyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",") && n2 == 0) {
                bl = true;
            }
            if (bl) {
                token = LexUtilities.getToken(baseDocument, Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n));
                return token == null || (tokenId = token.id()) != RubyTokenId.DEF && (tokenId != RubyTokenId.ANY_KEYWORD || !((Object)token.text()).toString().equals("alias"));
            }
            if (tokenId == RubyTokenId.ANY_KEYWORD && ("or".equals(string = ((Object)token.text()).toString()) || "and".equals(string))) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindent(Document document, int n, int n2, CompilationInfo compilationInfo, boolean bl) {
        this.isRhtmlDocument = RubyUtils.isRhtmlDocument(document);
        try {
            Token<? extends RubyTokenId> token;
            BaseDocument baseDocument = (BaseDocument)document;
            if (bl && this.isRhtmlDocument && (token = LexUtilities.getToken(baseDocument, n)) == null) {
                return;
            }
            Formatter.syncOptions(baseDocument, this.codeStyle);
            if (n2 > baseDocument.getLength()) {
                n2 = baseDocument.getLength();
            }
            int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n4 = 0;
            int n5 = 0;
            if (n > 0) {
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n - 1));
                n4 = this.getFormatStableStart(baseDocument, n6);
                n5 = LexUtilities.getLineIndent(baseDocument, n4);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl2 = n != 0 || n2 != baseDocument.getLength();
            boolean bl3 = n2 == baseDocument.getLength() || bl;
            this.computeIndents(baseDocument, n5, n4, n2, compilationInfo, arrayList, arrayList2, bl2, bl3, bl);
            try {
                baseDocument.atomicLock();
                assert (arrayList2.size() == arrayList.size());
                org.netbeans.editor.Formatter formatter = baseDocument.getFormatter();
                for (int i = arrayList2.size() - 1; i >= 0; --i) {
                    int n7;
                    int n8 = (Integer)arrayList2.get(i);
                    int n9 = (Integer)arrayList.get(i);
                    if (n9 < n3) break;
                    if (n9 == n3 && i > 0) {
                        n7 = (Integer)arrayList.get(i - 1);
                        int n10 = (Integer)arrayList2.get(i - 1);
                        int n11 = LexUtilities.getLineIndent(baseDocument, n7);
                        if (n11 != n10 && !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n7) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n7)) {
                            n8 = n11 + (n8 - n10);
                        }
                    }
                    if ((n7 = LexUtilities.getLineIndent(baseDocument, n9)) == n8) continue;
                    formatter.changeRowIndent(baseDocument, n9, n8);
                }
                if (!bl && this.codeStyle.reformatComments()) {
                    this.reformatComments(baseDocument, n, n2);
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public void computeIndents(BaseDocument baseDocument, int n, int n2, int n3, CompilationInfo compilationInfo, List<Integer> list, List<Integer> list2, boolean bl, boolean bl2, boolean bl3) {
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            int n5 = n3;
            int n6 = this.codeStyle.getIndentSize();
            int n7 = this.codeStyle.getContinuationIndentSize();
            int n8 = 0;
            int n9 = 0;
            boolean bl4 = false;
            boolean bl5 = false;
            if (this.isRhtmlDocument) {
                bl5 = this.codeStyle.indentHtml();
            }
            while (!bl2 && n4 < n5 || bl2 && n4 <= n5) {
                int n10;
                int n11;
                int n12;
                int n13 = n12 = bl4 ? n7 : 0;
                if (this.isRhtmlDocument && !bl3) {
                    n = LexUtilities.getLineIndent(baseDocument, n4);
                }
                if (this.isInLiteral(baseDocument, n4)) {
                    n11 = LexUtilities.getLineIndent(baseDocument, n4);
                    if (this.isRhtmlDocument && bl5 && n8 > 0) {
                        n11 += n8 * n6;
                    }
                } else {
                    n11 = this.isEndIndent(baseDocument, n4) ? (n8 - 1) * n6 + n12 + n : n8 * n6 + n12 + n;
                }
                if (n11 < 0) {
                    n11 = 0;
                }
                if ((n10 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4)) != -1 || bl) {
                    list2.add(n11);
                    list.add(n4);
                }
                int n14 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4) + 1;
                if (n10 != -1) {
                    n8 += Formatter.getTokenBalance(baseDocument, n10, n14, true, this.isRhtmlDocument);
                    bl4 = this.isLineContinued(baseDocument, n4, n9 += Formatter.getTokenBalance(baseDocument, n10, n14, false, this.isRhtmlDocument));
                }
                n4 = n14;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    void reformatComments(BaseDocument baseDocument, int n, int n2) {
        Object object;
        int n3 = this.rightMarginOverride;
        if (n3 == -1) {
            object = this.codeStyle;
            if (object == null) {
                object = CodeStyle.getDefault(null);
            }
            n3 = ((CodeStyle)object).getRightMargin();
        }
        object = new ReflowParagraphAction();
        ((ReflowParagraphAction)object).reflowComments(baseDocument, n, n2, n3);
    }

    private static void syncOptions(BaseDocument baseDocument, CodeStyle codeStyle) {
        org.netbeans.editor.Formatter formatter = baseDocument.getFormatter();
        if (formatter.getSpacesPerTab() != codeStyle.getIndentSize()) {
            formatter.setSpacesPerTab(codeStyle.getIndentSize());
        }
    }
}

