/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Query;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationVisitor;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath.BPELExtensionXpathValidator;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath.PathValidationContext;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath.PathValidatorVisitor;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.xpath.WsdlNamespaceContext;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathModelHelper;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.ExternalModelResolver;
import org.netbeans.modules.xml.xpath.ext.spi.SimpleSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.validation.XPathValidationContext;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;
import org.openide.util.NbBundle;

public class BPELExtensionXpathVisitor
extends ValidationVisitor {
    public static final String XPATH_EXPRESSION_TYPE = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
    private Validator mValidator;

    public BPELExtensionXpathVisitor(Validator validator) {
        this.mValidator = validator;
        this.init();
    }

    public void visit(final PropertyAlias propertyAlias) {
        boolean bl;
        Query query = propertyAlias.getQuery();
        if (query == null) {
            return;
        }
        String string = query.getContent();
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = query.getQueryLanguage();
        boolean bl2 = bl = string2 == null || XPATH_EXPRESSION_TYPE.equals(string2);
        if (!bl) {
            return;
        }
        final SchemaComponent schemaComponent = this.resolveContextSchemaComp(propertyAlias, query);
        if (schemaComponent == null) {
            return;
        }
        XPathModelHelper xPathModelHelper = XPathModelHelper.getInstance();
        XPathModel xPathModel = xPathModelHelper.newXPathModel();
        WsdlNamespaceContext wsdlNamespaceContext = new WsdlNamespaceContext((WSDLComponent)propertyAlias);
        xPathModel.setNamespaceContext((NamespaceContext)wsdlNamespaceContext);
        PathValidationContext pathValidationContext = new PathValidationContext(xPathModel, this.mValidator, this, (WSDLComponent)propertyAlias, (WSDLComponent)query, wsdlNamespaceContext);
        pathValidationContext.setSchemaContextComponent(schemaComponent);
        xPathModel.setValidationContext((XPathValidationContext)pathValidationContext);
        xPathModel.setExternalModelResolver(new ExternalModelResolver(){

            public Collection<SchemaModel> getModels(String string) {
                WSDLModel wSDLModel = propertyAlias.getModel();
                List list = wSDLModel.findSchemas(string);
                ArrayList<SchemaModel> arrayList = new ArrayList<SchemaModel>(list.size());
                for (Schema schema : list) {
                    SchemaModel schemaModel = schema.getModel();
                    arrayList.add(schemaModel);
                }
                return arrayList;
            }

            public Collection<SchemaModel> getVisibleModels() {
                SchemaModel schemaModel = schemaComponent.getModel();
                return Collections.singleton(schemaModel);
            }

            public boolean isSchemaVisible(String string) {
                WSDLModel wSDLModel = propertyAlias.getModel();
                List list = wSDLModel.findSchemas(string);
                return list != null && list.size() > 0;
            }
        });
        XPathExpression xPathExpression = null;
        try {
            xPathExpression = xPathModel.parseExpression(string);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        assert (xPathExpression != null);
        if (!(xPathExpression instanceof XPathLocationPath)) {
            String string3 = NbBundle.getMessage(BPELExtensionXpathValidator.class, (String)"LOCATION_PATH_REQUIRED");
            this.addNewResultItem(Validator.ResultType.ERROR, (Component)query, string3, "");
            return;
        }
        SimpleSchemaContext simpleSchemaContext = new SimpleSchemaContext(schemaComponent);
        xPathModel.setSchemaContext((XPathSchemaContext)simpleSchemaContext);
        xPathModel.resolveExtReferences(true);
        PathValidatorVisitor pathValidatorVisitor = new PathValidatorVisitor(pathValidationContext);
        xPathExpression.accept((XPathVisitor)pathValidatorVisitor);
    }

    private SchemaComponent resolveContextSchemaComp(PropertyAlias propertyAlias, Query query) {
        String string;
        Object object;
        assert (propertyAlias != null && query != null);
        NamedComponentReference namedComponentReference = null;
        NamedComponentReference namedComponentReference2 = null;
        String string2 = query.getContent();
        NamedComponentReference<Message> namedComponentReference3 = propertyAlias.getMessageType();
        if (namedComponentReference3 != null) {
            object = (Message)namedComponentReference3.get();
            if (object == null) {
                String string3 = BPELExtensionXpathVisitor.constructMessage("UNRESOLVED_MESSAGE_TYPE", namedComponentReference3.getRefString());
                this.addNewResultItem(Validator.ResultType.ERROR, (Component)query, string3, "");
                return null;
            }
            string = propertyAlias.getPart();
            Collection collection = object.getParts();
            Part part = null;
            for (Part part2 : collection) {
                if (!part2.getName().equals(string)) continue;
                part = part2;
            }
            if (part == null) {
                String string4 = BPELExtensionXpathVisitor.constructMessage("UNKNOWN_MESSAGE_PART", string, object.getName());
                this.addNewResultItem(Validator.ResultType.ERROR, (Component)query, string4, "");
                return null;
            }
            namedComponentReference = part.getElement();
            namedComponentReference2 = part.getType();
        } else {
            namedComponentReference = propertyAlias.getElement();
            namedComponentReference2 = propertyAlias.getType();
        }
        if (namedComponentReference == null && namedComponentReference2 == null) {
            object = BPELExtensionXpathVisitor.constructMessage("UNRESOLVED_QUERY_ROOT_TYPE", string2);
            this.addNewResultItem(Validator.ResultType.ERROR, (Component)query, (String)object, "");
            return null;
        }
        object = null;
        if (namedComponentReference != null) {
            string = (GlobalElement)namedComponentReference.get();
            if (string != null) {
                object = string;
            }
        } else if (namedComponentReference2 != null && (string = (GlobalType)namedComponentReference2.get()) != null) {
            object = string;
        }
        if (object == null) {
            string = BPELExtensionXpathVisitor.constructMessage("UNRESOLVED_QUERY_ROOT_TYPE", string2);
            this.addNewResultItem(Validator.ResultType.ERROR, (Component)query, string, "");
        }
        return object;
    }

    void addNewResultItem(Validator.ResultType resultType, Component component, String string, String string2) {
        Validator.ResultItem resultItem = new Validator.ResultItem(this.mValidator, resultType, component, string + string2);
        this.getResultItems().add(resultItem);
    }

    public static String constructMessage(String string, Object ... objectArray) {
        String string2 = NbBundle.getMessage(BPELExtensionXpathValidator.class, (String)string);
        if (objectArray != null && objectArray.length > 0) {
            string2 = MessageFormat.format(string2, objectArray);
        }
        return string2;
    }

    private Throwable getInitialCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return throwable;
        }
        return this.getInitialCause(throwable2);
    }
}

