/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.deprecation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.spi.GenericExtensibilityElement;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class BPELExtensionDeprecationValidator
implements Validator {
    public static final String VAL_DEPRECATED_PLINK_NAMESPACE_IN_DEFINITION = "VAL_DEPRECATED_PLINK_NAMESPACE_IN_DEFINITION";
    public static final String FIX_DEPRECATED_PLINK_NAMESPACE_IN_DEFINITION = "FIX_DEPRECATED_PLINK_NAMESPACE_IN_DEFINITION";
    public static final String VAL_DEPRECATED_PROPERTY_NAMESPACE_IN_DEFINITION = "VAL_DEPRECATED_PROPERTY_NAMESPACE_IN_DEFINITION";
    public static final String FIX_DEPRECATED_PROPERTY_NAMESPACE_IN_DEFINITION = "FIX_DEPRECATED_PROPERTY_NAMESPACE_IN_DEFINITION";
    public static final String DEPRECATED_PLINK_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/03/partner-link/";
    public static final String DEPRECATED_PROPERTY_NAMESPACE = "http://schemas.xmlsoap.org/ws/2004/03/business-process/";
    public static final ValidationResult EMPTY_RESULT = new ValidationResult((Collection)Collections.EMPTY_SET, (Collection)Collections.EMPTY_SET);

    public String getName() {
        return this.getClass().getName();
    }

    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        if (!(model instanceof WSDLModel)) {
            return EMPTY_RESULT;
        }
        WSDLModel wSDLModel = (WSDLModel)model;
        if (wSDLModel.getState() == Model.State.NOT_WELL_FORMED) {
            return EMPTY_RESULT;
        }
        HashSet<Validator.ResultItem> hashSet = null;
        Set<Model> set = Collections.singleton(model);
        Definitions definitions = wSDLModel.getDefinitions();
        boolean bl = false;
        for (GenericExtensibilityElement genericExtensibilityElement : definitions.getExtensibilityElements(GenericExtensibilityElement.class)) {
            String string;
            if (genericExtensibilityElement.getQName() == null || ((string = genericExtensibilityElement.getQName().getNamespaceURI()) == null || !string.equals(DEPRECATED_PLINK_NAMESPACE)) && !string.equals(DEPRECATED_PROPERTY_NAMESPACE)) continue;
            bl = true;
            break;
        }
        if (bl) {
            Map map = ((AbstractDocumentComponent)definitions).getPrefixes();
            hashSet = new HashSet<Validator.ResultItem>();
            if (map.containsValue(DEPRECATED_PLINK_NAMESPACE)) {
                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)definitions, NbBundle.getMessage(this.getClass(), (String)VAL_DEPRECATED_PLINK_NAMESPACE_IN_DEFINITION, (Object)DEPRECATED_PLINK_NAMESPACE) + " : " + NbBundle.getMessage(this.getClass(), (String)FIX_DEPRECATED_PLINK_NAMESPACE_IN_DEFINITION, (Object)DEPRECATED_PLINK_NAMESPACE, (Object)"http://docs.oasis-open.org/wsbpel/2.0/plnktype")));
            }
            if (map.containsValue(DEPRECATED_PROPERTY_NAMESPACE)) {
                hashSet.add(new Validator.ResultItem((Validator)this, Validator.ResultType.WARNING, (Component)definitions, NbBundle.getMessage(this.getClass(), (String)VAL_DEPRECATED_PROPERTY_NAMESPACE_IN_DEFINITION, (Object)DEPRECATED_PROPERTY_NAMESPACE) + " : " + NbBundle.getMessage(this.getClass(), (String)FIX_DEPRECATED_PROPERTY_NAMESPACE_IN_DEFINITION, (Object)DEPRECATED_PROPERTY_NAMESPACE, (Object)"http://docs.oasis-open.org/wsbpel/2.0/varprop")));
            }
        }
        if (hashSet == null) {
            return EMPTY_RESULT;
        }
        return new ValidationResult(hashSet, set);
    }
}

