/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.wizard.HardStringWizardPanel;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestStringWizardPanel
extends JPanel {
    private static final int COLUMN_INDEX_CHECK = 0;
    private static final int COLUMN_INDEX_HARDSTRING = 1;
    private static final int COLUMN_INDEX_KEY = 2;
    private static final int COLUMN_INDEX_VALUE = 3;
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final AbstractTableModel tableModel = new TestStringTableModel();
    private JScrollPane scrollPane;
    private JComboBox sourceCombo;
    private JLabel sourceLabel;
    private JLabel testStringLabel;
    private JTable testStringTable;

    private TestStringWizardPanel() {
        this.initComponents();
        this.postInitComponents();
        this.initTable();
        this.setComboModel(this.sourceMap);
    }

    private void setComboModel(Map<DataObject, SourceData> map) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        for (Map.Entry<DataObject, SourceData> entry : map.entrySet()) {
            if (entry.getValue().getStringMap().isEmpty()) continue;
            arrayList.add(entry.getKey());
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void postInitComponents() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.testStringLabel.setLabelFor(this.testStringTable);
    }

    public Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map<DataObject, SourceData> map) {
        this.sourceMap.clear();
        this.sourceMap.putAll(map);
        this.setComboModel(map);
    }

    private Map<HardCodedString, I18nString> getStringMap() {
        SourceData sourceData = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        return sourceData == null ? null : sourceData.getStringMap();
    }

    private Set<HardCodedString> getRemovedStrings() {
        SourceData sourceData = this.sourceMap.get(this.sourceCombo.getSelectedItem());
        if (sourceData == null) {
            return null;
        }
        if (sourceData.getRemovedStrings() == null) {
            sourceData.setRemovedStrings(new HashSet<HardCodedString>());
        }
        return sourceData.getRemovedStrings();
    }

    private void initTable() {
        this.testStringTable.setDefaultRenderer(HardCodedString.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                HardCodedString hardCodedString = (HardCodedString)object;
                jLabel.setText(hardCodedString != null ? hardCodedString.getText() : "");
                return jLabel;
            }
        });
        this.testStringTable.setDefaultRenderer(I18nString.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                I18nString i18nString = (I18nString)object;
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                int n3 = TestStringWizardPanel.this.testStringTable.convertColumnIndexToModel(n2);
                if (i18nString != null) {
                    jLabel.setText(n3 == 2 ? i18nString.getKey() : i18nString.getValue());
                } else {
                    jLabel.setText("");
                }
                return jLabel;
            }
        });
        this.testStringTable.setDefaultEditor(I18nString.class, new DefaultCellEditor(new JTextField()){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                I18nString i18nString = (I18nString)object;
                int n3 = TestStringWizardPanel.this.testStringTable.convertColumnIndexToModel(n2);
                object = n3 == 2 ? (i18nString == null ? "" : i18nString.getKey()) : (n3 == 3 ? (i18nString == null ? "" : i18nString.getValue()) : "");
                return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
        });
        this.testStringTable.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.testStringLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.testStringTable = new JTable();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getBundle(HardStringWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestStringWizardPanel.this.sourceComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
        this.sourceCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_Source_Accessible_Name"));
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_Source_Accessible_Description"));
        Mnemonics.setLocalizedText((JLabel)this.testStringLabel, (String)NbBundle.getBundle(HardStringWizardPanel.class).getString("LBL_missing_keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.testStringLabel, gridBagConstraints);
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.testStringTable.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.testStringTable);
        this.testStringTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_FoundStrings_Accessible_Name"));
        this.testStringTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestStringWizardPanel.class, (String)"LBL_FoundStrings_Accessible_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.scrollPane.getAccessibleContext().setAccessibleName("Found Strings with Missing Keys");
        this.scrollPane.getAccessibleContext().setAccessibleDescription("Found Strings with Missing Keys");
    }

    private void sourceComboActionPerformed(ActionEvent actionEvent) {
        if (this.sourceMap.get(this.sourceCombo.getSelectedItem()).getStringMap().isEmpty()) {
            JLabel jLabel = new JLabel(NbBundle.getMessage(TestStringWizardPanel.class, (String)"TXT_AllI18nStringsSource"));
            jLabel.setHorizontalAlignment(0);
            this.scrollPane.setViewportView(jLabel);
        } else {
            this.scrollPane.setViewportView(this.testStringTable);
            this.tableModel.fireTableDataChanged();
        }
        this.tableModel.fireTableDataChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements WizardDescriptor.FinishablePanel<I18nWizardDescriptor.Settings>,
    I18nWizardDescriptor.ProgressMonitor {
        private final JLabel emptyLabel = new JLabel(NbBundle.getMessage(TestStringWizardPanel.class, (String)"TXT_AllI18nStrings"));
        private transient TestStringWizardPanel testStringPanel;

        public Panel() {
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setVerticalAlignment(0);
        }

        @Override
        protected Component createComponent() {
            JPanel jPanel = new JPanel();
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TestStringWizardPanel.class, (String)"ACS_TestStringWizardPanel"));
            jPanel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
            jPanel.setName(NbBundle.getMessage(TestStringWizardPanel.class, (String)"TXT_FoundMissingResource"));
            jPanel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)this.getUI(), gridBagConstraints);
            return jPanel;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        public boolean isFinishPanel() {
            return true;
        }

        @Override
        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            JPanel jPanel = (JPanel)this.getComponent();
            if (Panel.foundStrings(this.getMap())) {
                if (jPanel.isAncestorOf(this.emptyLabel)) {
                    jPanel.remove(this.emptyLabel);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 1;
                    jPanel.add((Component)this.getUI(), gridBagConstraints);
                }
            } else if (jPanel.isAncestorOf(this.getUI())) {
                jPanel.remove(this.getUI());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                jPanel.add((Component)this.emptyLabel, gridBagConstraints);
            }
        }

        @Override
        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        @Override
        public void doLongTimeChanges() {
            if (Panel.foundStrings(this.getMap())) {
                ProgressWizardPanel progressWizardPanel = new ProgressWizardPanel(true);
                progressWizardPanel.setMainText(NbBundle.getMessage(this.getClass(), (String)"LBL_Internationalizing"));
                progressWizardPanel.setMainProgress(0);
                ((Container)this.getComponent()).remove(this.getUI());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                ((Container)this.getComponent()).add((Component)progressWizardPanel, gridBagConstraints);
                ((JComponent)this.getComponent()).revalidate();
                this.getComponent().repaint();
                Map<DataObject, SourceData> map = this.getUI().getSourceMap();
                int n = 0;
                for (Map.Entry<DataObject, SourceData> entry : map.entrySet()) {
                    ++n;
                    DataObject dataObject = entry.getKey();
                    SourceData sourceData = entry.getValue();
                    I18nSupport i18nSupport = sourceData.getSupport();
                    Map<HardCodedString, I18nString> map2 = sourceData.getStringMap();
                    Set<HardCodedString> set = sourceData.getRemovedStrings();
                    ClassPath classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                    progressWizardPanel.setSubText(Util.getString("LBL_Source") + " " + classPath.getResourceName(dataObject.getPrimaryFile(), '.', false));
                    int n2 = 0;
                    for (Map.Entry<HardCodedString, I18nString> entry2 : map2.entrySet()) {
                        Object object;
                        ++n2;
                        HardCodedString hardCodedString = entry2.getKey();
                        I18nString i18nString = entry2.getValue();
                        if (set != null && set.contains(hardCodedString)) continue;
                        String string = i18nString.getComment();
                        if (string == null || "".equals(string)) {
                            object = dataObject;
                            classPath = ClassPath.getClassPath((FileObject)object.getPrimaryFile(), (String)"classpath/source");
                            string = classPath.getResourceName(object.getPrimaryFile(), '.', false);
                        }
                        object = i18nString.getKey();
                        String string2 = i18nSupport.getResourceHolder().getCommentForKey((String)object);
                        string = string + (string2 == null ? "" : " " + string2);
                        i18nSupport.getResourceHolder().addProperty(i18nString.getKey(), i18nString.getValue(), string, false);
                        progressWizardPanel.setSubProgress((int)((float)n2 / (float)map2.size() * 100.0f));
                    }
                    if (i18nSupport.hasAdditionalCustomizer()) {
                        i18nSupport.performAdditionalChanges();
                    }
                    progressWizardPanel.setMainProgress((int)((float)n / (float)map.size() * 100.0f));
                }
            }
        }

        @Override
        public void reset() {
        }

        private static boolean foundStrings(Map<DataObject, SourceData> map) {
            for (Map.Entry<DataObject, SourceData> entry : map.entrySet()) {
                if (entry.getValue().getStringMap().isEmpty()) continue;
                return true;
            }
            return false;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.testing");
        }

        private synchronized TestStringWizardPanel getUI() {
            if (this.testStringPanel == null) {
                this.testStringPanel = new TestStringWizardPanel();
            }
            return this.testStringPanel;
        }
    }

    public static class CustomizeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private I18nString i18nString;
        private JButton editorComponent = new JButton("...");

        public CustomizeCellEditor() {
            this.editorComponent.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PropertyPanel propertyPanel = CustomizeCellEditor.this.i18nString.getSupport().getPropertyPanel();
                    propertyPanel.setI18nString(CustomizeCellEditor.this.i18nString);
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyPanel, "Customize Property");
                    dialogDescriptor.setModal(true);
                    dialogDescriptor.setOptionType(-1);
                    dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
                    dialogDescriptor.setAdditionalOptions(new Object[0]);
                    dialogDescriptor.setButtonListener((ActionListener)CustomizeCellEditor.this);
                    Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                    dialog.setVisible(true);
                }
            });
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.i18nString = (I18nString)object;
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.i18nString;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 1;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }
    }

    private class TestStringTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            Map map = TestStringWizardPanel.this.getStringMap();
            return map == null ? 0 : map.size();
        }

        public Object getValueAt(int n, int n2) {
            Map map = TestStringWizardPanel.this.getStringMap();
            if (map == null) {
                return null;
            }
            if (n2 == 0) {
                return !TestStringWizardPanel.this.getRemovedStrings().contains(map.keySet().toArray()[n]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (n2 == 1) {
                return map.keySet().toArray()[n];
            }
            return map.values().toArray()[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 || n2 == 3;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            HardCodedString[] hardCodedStringArray;
            Map map = TestStringWizardPanel.this.getStringMap();
            if (map == null) {
                return;
            }
            if (n2 == 0 && object instanceof Boolean) {
                hardCodedStringArray = map.keySet().toArray(new HardCodedString[map.size()]);
                object2 = hardCodedStringArray[n];
                Set set = TestStringWizardPanel.this.getRemovedStrings();
                if (((Boolean)object).booleanValue()) {
                    set.remove(object2);
                } else {
                    set.add(object2);
                }
            }
            if (n2 == 3) {
                hardCodedStringArray = TestStringWizardPanel.this.getStringMap().values();
                object2 = hardCodedStringArray.toArray(new I18nString[hardCodedStringArray.size()])[n];
                ((I18nString)object2).setValue(object.toString());
            }
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            if (n == 1) {
                return HardCodedString.class;
            }
            return I18nString.class;
        }

        public String getColumnName(int n) {
            if (n == 1) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_HardString");
            }
            if (n == 2) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Key");
            }
            if (n == 3) {
                return NbBundle.getMessage(HardStringWizardPanel.class, (String)"LBL_Value");
            }
            return " ";
        }
    }
}

