/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdditionalWizardPanel
extends JPanel {
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final Set<DataObject> viewedSources = new HashSet<DataObject>(0);
    private JComponent additionalComponent = EMPTY_COMPONENT;
    private static final JLabel EMPTY_COMPONENT = new JLabel(Util.getString("TXT_HasNoAdditonal"));
    private JComboBox sourceCombo;
    private JLabel sourceLabel;

    private AdditionalWizardPanel() {
        this.initComponents();
        this.initA11Y();
        this.setComboModel(this.sourceMap);
    }

    private void initA11Y() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(Util.getString("ACS_sourceCombo"));
    }

    private void setComboModel(Map<DataObject, SourceData> map) {
        DataObject[] dataObjectArray = map.keySet().toArray(new DataObject[0]);
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        for (DataObject dataObject : dataObjectArray) {
            if (!map.get(dataObject).getSupport().hasAdditionalCustomizer()) continue;
            arrayList.add(dataObject);
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        Object object = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent((DataObject)object);
    }

    Set<DataObject> getViewedSources() {
        return this.viewedSources;
    }

    Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    void setSourceMap(Map<DataObject, SourceData> map) {
        this.sourceMap.clear();
        this.sourceMap.putAll(map);
        this.setComboModel(map);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getBundle(AdditionalWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalWizardPanel.this.sourceComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
    }

    private void sourceComboActionPerformed(ActionEvent actionEvent) {
        Object object = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent((DataObject)object);
    }

    private void updateAdditionalComponent(DataObject dataObject) {
        I18nSupport i18nSupport = null;
        if (dataObject != null) {
            i18nSupport = this.sourceMap.get(dataObject).getSupport();
        }
        this.remove(this.additionalComponent);
        if (i18nSupport != null && i18nSupport.hasAdditionalCustomizer()) {
            this.additionalComponent = i18nSupport.getAdditionalCustomizer();
            this.viewedSources.add(dataObject);
        } else {
            this.additionalComponent = EMPTY_COMPONENT;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.additionalComponent, gridBagConstraints);
        this.revalidate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final JLabel emptyLabel = new JLabel(Util.getString("TXT_HasNoAdditonal"));
        private transient AdditionalWizardPanel additionalPanel;

        Panel() {
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setVerticalAlignment(0);
        }

        @Override
        protected Component createComponent() {
            JPanel jPanel = new JPanel();
            jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AdditionalWizardPanel.class).getString("ACS_AdditionalWizardPanel"));
            jPanel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
            jPanel.setName(NbBundle.getBundle(this.getClass()).getString("TXT_ModifyAdditional"));
            jPanel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)this.getUI(), gridBagConstraints);
            return jPanel;
        }

        @Override
        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            JPanel jPanel = (JPanel)this.getComponent();
            if (Panel.hasAdditional(this.getMap())) {
                if (jPanel.isAncestorOf(this.emptyLabel)) {
                    jPanel.remove(this.emptyLabel);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 1;
                    jPanel.add((Component)this.getUI(), gridBagConstraints);
                }
            } else if (jPanel.isAncestorOf(this.getUI())) {
                jPanel.remove(this.getUI());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                jPanel.add((Component)this.emptyLabel, gridBagConstraints);
            }
        }

        @Override
        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            Map<DataObject, SourceData> map = this.getUI().getSourceMap();
            for (DataObject dataObject : this.getUI().getViewedSources()) {
                SourceData sourceData = map.get(dataObject);
                for (Map.Entry<HardCodedString, I18nString> entry : sourceData.getStringMap().entrySet()) {
                    entry.setValue(sourceData.getSupport().getDefaultI18nString(entry.getKey()));
                }
            }
            this.getMap().clear();
            this.getMap().putAll(map);
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressWizardPanel = new ProgressWizardPanel(true);
            this.showProgressPanel(progressWizardPanel);
            progressWizardPanel.setMainText(NbBundle.getMessage(this.getClass(), (String)"LBL_AdditionalIn"));
            progressWizardPanel.setMainProgress(0);
            Map<DataObject, SourceData> map = ((AdditionalWizardPanel)this.getComponent()).getSourceMap();
            Iterator<DataObject> iterator = ((AdditionalWizardPanel)this.getComponent()).getViewedSources().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                DataObject dataObject = iterator.next();
                SourceData sourceData = map.get(dataObject);
                ClassPath classPath = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                progressWizardPanel.setMainText(NbBundle.getMessage(this.getClass(), (String)"LBL_AdditionalIn") + " " + classPath.getResourceName(dataObject.getPrimaryFile(), '.', false));
                HardCodedString[] hardCodedStringArray = sourceData.getStringMap().keySet().toArray(new HardCodedString[0]);
                int n2 = 0;
                while (n < hardCodedStringArray.length) {
                    sourceData.getStringMap().put(hardCodedStringArray[n2], sourceData.getSupport().getDefaultI18nString(hardCodedStringArray[n2]));
                    ++n2;
                }
                progressWizardPanel.setMainProgress((int)((float)(n + 1) / (float)map.size() * 100.0f));
                ++n;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressWizardPanel) {
            ((Container)this.getComponent()).remove(this.getUI());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressWizardPanel, gridBagConstraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.getUI())) {
                container.removeAll();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                container.add((Component)this.getUI(), gridBagConstraints);
            }
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.wizard");
        }

        private static boolean hasAdditional(Map<DataObject, SourceData> map) {
            for (Map.Entry<DataObject, SourceData> entry : map.entrySet()) {
                if (!entry.getValue().getSupport().hasAdditionalCustomizer()) continue;
                return true;
            }
            return false;
        }

        private synchronized AdditionalWizardPanel getUI() {
            if (this.additionalPanel == null) {
                this.additionalPanel = new AdditionalWizardPanel();
            }
            return this.additionalPanel;
        }
    }
}

