/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class HelpStringCustomEditor
extends JPanel {
    private JComboBox combo;
    private JLabel comboLabel;
    private JList list;
    private JLabel listLabel;
    private JScrollPane scrollPane;

    public HelpStringCustomEditor(String string, List list, List list2, String string2, String string3) {
        this.initComponents();
        this.combo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.combo.setSelectedItem(string);
        this.list.setListData(list2.toArray());
        this.list.setBackground(UIManager.getDefaults().getColor("TextField..disabledBackground"));
        Mnemonics.setLocalizedText((JLabel)this.comboLabel, (String)string2);
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)I18nUtil.getBundle().getString("LBL_Arguments"));
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)string3);
    }

    public Object getPropertyValue() {
        return (String)this.combo.getSelectedItem();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCustomEditor"));
        this.combo.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCombo"));
        this.list.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringList"));
    }

    private void initComponents() {
        this.combo = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.comboLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.combo.setEditable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.combo, gridBagConstraints);
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                HelpStringCustomEditor.this.listKeyPressed(keyEvent);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HelpStringCustomEditor.this.listMouseClicked(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 11, 11);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.comboLabel.setLabelFor(this.combo);
        this.comboLabel.setText("comboLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.comboLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.list);
        this.listLabel.setText("listLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void listKeyPressed(KeyEvent keyEvent) {
        String string = (String)this.list.getSelectedValue();
        if (keyEvent.getKeyCode() == 10 && string != null) {
            keyEvent.consume();
            this.insertInFormat(string);
        }
    }

    private void listMouseClicked(MouseEvent mouseEvent) {
        String string = (String)this.list.getSelectedValue();
        if (mouseEvent.getClickCount() == 2 && string != null) {
            this.insertInFormat(string);
        }
    }

    private void insertInFormat(String string) {
        int n = string.indexOf(32);
        if (n < 0 || n > string.length()) {
            return;
        }
        String string2 = string.substring(0, n);
        JTextField jTextField = (JTextField)this.combo.getEditor().getEditorComponent();
        try {
            jTextField.getDocument().insertString(jTextField.getCaretPosition(), string2, null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
    }

    private static abstract class StringEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private static boolean useRaw = Boolean.getBoolean("netbeans.stringEditor.useRawCharacters");
        private boolean editable = true;
        private String instructions = null;
        private boolean oneline = false;
        private boolean customEd = true;
        private PropertyEnv env;

        private StringEditor() {
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setAsText(String string) {
            if ("null".equals(string) && this.getValue() == null) {
                return;
            }
            this.setValue(string);
        }

        public String getJavaInitializationString() {
            String string = (String)this.getValue();
            return "\"" + StringEditor.toAscii(string) + "\"";
        }

        public boolean supportsCustomEditor() {
            return this.customEd;
        }

        public abstract Component getCustomEditor();

        private static String toAscii(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
            char[] cArray = string.toCharArray();
            block9: for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                switch (c) {
                    case '\b': {
                        stringBuffer.append("\\b");
                        continue block9;
                    }
                    case '\t': {
                        stringBuffer.append("\\t");
                        continue block9;
                    }
                    case '\n': {
                        stringBuffer.append("\\n");
                        continue block9;
                    }
                    case '\f': {
                        stringBuffer.append("\\f");
                        continue block9;
                    }
                    case '\r': {
                        stringBuffer.append("\\r");
                        continue block9;
                    }
                    case '\"': {
                        stringBuffer.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        stringBuffer.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c >= ' ' && (useRaw || c <= '\u007f')) {
                            stringBuffer.append(c);
                            continue block9;
                        }
                        stringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c);
                        for (int j = 0; j < 4 - string2.length(); ++j) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                    }
                }
            }
            return stringBuffer.toString();
        }

        public void attachEnv(PropertyEnv propertyEnv) {
            this.env = propertyEnv;
            FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
            if (featureDescriptor instanceof Node.Property) {
                Node.Property property = (Node.Property)featureDescriptor;
                this.editable = property.canWrite();
                this.instructions = (String)property.getValue("instructions");
                this.oneline = Boolean.TRUE.equals(property.getValue("oneline"));
                this.customEd = !Boolean.TRUE.equals(property.getValue("suppressCustomEditor"));
            }
        }
    }

    public static class I18nRegExpEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getI18nRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_I18nRegExpFormat"), "i18n.pe.testregexp");
        }
    }

    public static class RegExpEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_NonI18nRegExpFormat"), "i18n.pe.i18nregexp");
        }
    }

    public static class ReplaceCodeEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), "i18n.pe.replacestring");
        }
    }

    public static class InitCodeEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getInitFormatItems(), I18nUtil.getInitHelpItems(), I18nUtil.getBundle().getString("LBL_InitCodeFormat"), "i18n.pe.bundlestring");
        }
    }
}

