/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.xml.wizard.AbstractPanel;
import org.netbeans.modules.xml.wizard.DTDParser;
import org.netbeans.modules.xml.wizard.Util;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.xml.sax.InputSource;

public class DTDPanel
extends AbstractPanel {
    private static final long serialVersionUID = 5310047495162425192L;
    private DefaultComboBoxModel rootModel;
    private DefaultComboBoxModel pidModel;
    private DefaultComboBoxModel sidModel;
    private static Vector recentSIDs = new Vector();
    private JLabel rootLabel;
    private JButton catalogButton;
    private JLabel pidLabel;
    private JComboBox rootComboBox;
    private JComboBox sidComboBox;
    private JTextArea descTextArea;
    private JComboBox pidComboBox;
    private JLabel sidLabel;
    private JPanel fillPanel;

    public DTDPanel() {
        this.initComponents();
        this.initAccessibility();
        Component component = this.pidComboBox.getEditor().getEditorComponent();
        component.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (DTDPanel.this.existsPID()) {
                    DTDPanel.this.updatePossibilities();
                }
            }
        });
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.pidLabel = new JLabel();
        this.pidComboBox = new JComboBox();
        this.catalogButton = new JButton();
        this.sidLabel = new JLabel();
        this.sidComboBox = new JComboBox();
        this.rootLabel = new JLabel();
        this.rootComboBox = new JComboBox();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setName(Util.THIS.getString("PROP_dtd_panel_name"));
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(Util.THIS.getString("MSG_dtd_panel_desc"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(this.descTextArea.getForeground());
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.pidLabel.setLabelFor(this.pidComboBox);
        this.pidLabel.setText(Util.THIS.getString("PROP_dtd_pid_name"));
        this.pidLabel.setToolTipText(Util.THIS.getString("PROP_dtd_pidLable_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.pidLabel, gridBagConstraints);
        this.pidComboBox.setEditable(true);
        this.pidComboBox.setToolTipText(Util.THIS.getString("PROP_dtd_pidComboBox_desc"));
        this.pidComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTDPanel.this.pidComboBoxActionPerformed(actionEvent);
            }
        });
        this.pidComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DTDPanel.this.pidComboBoxFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.pidComboBox, gridBagConstraints);
        this.catalogButton.setText(Util.THIS.getString("PROP_dtd_catalog_name"));
        this.catalogButton.setToolTipText(Util.THIS.getString("PROP_dtd_catalog_desc"));
        this.catalogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTDPanel.this.catalogButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.catalogButton, gridBagConstraints);
        this.sidLabel.setLabelFor(this.sidComboBox);
        this.sidLabel.setText(Util.THIS.getString("PROP_dtd_sid_name"));
        this.sidLabel.setToolTipText(Util.THIS.getString("PROP_dtd_sidLabel_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.sidLabel, gridBagConstraints);
        this.sidComboBox.setEditable(true);
        this.sidComboBox.setToolTipText(Util.THIS.getString("PROP_dtd_sidComboBox_desc"));
        this.sidComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DTDPanel.this.sidComboBoxActionPerformed(actionEvent);
            }
        });
        this.sidComboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DTDPanel.this.sidComboBoxFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.sidComboBox, gridBagConstraints);
        this.rootLabel.setLabelFor(this.rootComboBox);
        this.rootLabel.setText(Util.THIS.getString("PROP_dtd_root_name"));
        this.rootLabel.setToolTipText(Util.THIS.getString("PROP_dtd_rootLabel_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.rootLabel, gridBagConstraints);
        this.rootComboBox.setEditable(true);
        this.rootComboBox.setToolTipText(Util.THIS.getString("PROP_dtd_rootComboBox_desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.fillPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }

    private void catalogButtonActionPerformed(ActionEvent actionEvent) {
        Node node = this.getCatalogNode();
        if (node == null) {
            return;
        }
        NodeOperation.getDefault().explore(node);
    }

    private void initAccessibility() {
        Util util = Util.THIS;
        this.rootLabel.setDisplayedMnemonic(util.getChar("PROP_dtd_rootLabel_mne"));
        this.pidLabel.setDisplayedMnemonic(util.getChar("PROP_dtd_pidLabel_mne"));
        this.sidLabel.setDisplayedMnemonic(util.getChar("PROP_dtd_sidLabel_mne"));
        this.catalogButton.setMnemonic(util.getChar("PROP_dtd_catalog_mne"));
        this.getAccessibleContext().setAccessibleDescription(this.descTextArea.getText());
    }

    private void sidComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.sidComboBox.isPopupVisible()) {
            return;
        }
        if (!this.existsPID()) {
            this.updatePossibilities();
        }
    }

    private void pidComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.pidComboBox.isPopupVisible()) {
            return;
        }
        if (this.existsPID()) {
            this.updatePossibilities();
        }
    }

    private void pidComboBoxFocusLost(FocusEvent focusEvent) {
        if (this.existsPID()) {
            this.updatePossibilities();
        }
    }

    private void sidComboBoxFocusLost(FocusEvent focusEvent) {
        if (!this.existsPID()) {
            this.updatePossibilities();
        }
    }

    private Node getCatalogNode() {
        return null;
    }

    private boolean existsPID() {
        Object object = this.pidModel.getSelectedItem();
        return object != null && object instanceof String && !((String)object).trim().equals("");
    }

    private void updatePossibilities() {
        Object object;
        Object object2;
        Util.THIS.debug("Updating possible roots (DTD)...");
        InputSource inputSource = new InputSource();
        Object object3 = this.sidModel.getSelectedItem();
        String string = null;
        try {
            if (object3 != null) {
                string = object3.toString();
                object2 = this.model.getTargetFolderURL();
                if (object2 != null) {
                    string = new URL((URL)object2, string).toExternalForm();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        inputSource.setSystemId(string);
        object2 = this.pidModel.getSelectedItem();
        inputSource.setPublicId(object2 == null ? null : object2.toString());
        Util.THIS.debug("PID: " + object2 + ", SID:" + object3);
        Set set = new DTDParser().parse(inputSource);
        if (set.size() > 0) {
            this.rootModel.removeAllElements();
            object = set.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                this.rootModel.addElement(string2);
            }
        }
        if ((object = this.rootComboBox.getEditor().getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)object).selectAll();
        }
    }

    protected void initView() {
        String[] stringArray = Util.getKnownDTDPublicIDs();
        this.pidModel = new DefaultComboBoxModel<String>(stringArray);
        this.sidModel = new DefaultComboBoxModel(recentSIDs);
        this.rootModel = new DefaultComboBoxModel();
        this.pidComboBox.setModel(this.pidModel);
        this.pidComboBox.getEditor().selectAll();
        this.catalogButton.setVisible(false);
        this.rootComboBox.setModel(this.rootModel);
        this.sidComboBox.setModel(this.sidModel);
    }

    protected void updateModel() {
        Object object = this.pidModel.getSelectedItem();
        this.model.setPublicID(object == null ? null : object.toString());
        Object object2 = this.sidModel.getSelectedItem();
        this.model.setSystemID(object2 == null ? null : object2.toString());
        Object object3 = this.rootModel.getSelectedItem();
        this.model.setRoot(object3 == null ? null : object3.toString());
        Util.THIS.debug("Model updated PID: " + object + " SID: " + object2 + " root: " + object3);
        if (!recentSIDs.contains(object2)) {
            recentSIDs.add(object2);
        }
    }

    protected void updateView() {
    }
}

