/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.api.project.rake.RakeArtifact;
import org.netbeans.modules.ruby.modules.project.rake.FileChangeSupport;
import org.netbeans.modules.ruby.modules.project.rake.FileChangeSupportEvent;
import org.netbeans.modules.ruby.modules.project.rake.FileChangeSupportListener;
import org.netbeans.modules.ruby.modules.project.rake.RakeBasedProjectFactorySingleton;
import org.netbeans.modules.ruby.modules.project.rake.UserQuestionHandler;
import org.netbeans.modules.ruby.modules.project.rake.Util;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ExtensibleMetadataProviderImpl;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.ProjectXmlSavedHook;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeBasedProjectType;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.SharabilityQueryImpl;
import org.netbeans.modules.ruby.spi.project.support.rake.SimpleRakeArtifact;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RakeProjectHelper {
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PRIVATE_XML_PATH = "nbproject/private/private.xml";
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String PRIVATE_NS = "http://www.netbeans.org/ns/project-private/1";
    private static final RequestProcessor RP;
    private final FileObject dir;
    private final ProjectState state;
    private final RakeBasedProjectType type;
    private Document projectXml;
    private Document privateXml;
    private final Set<String> modifiedMetadataPaths = new HashSet<String>();
    private final List<RakeProjectListener> listeners = new ArrayList<RakeProjectListener>();
    private final ProjectProperties properties;
    private final FileChangeSupportListener fileListener;
    private boolean writingXML = false;
    private ProjectXmlSavedHook pendingHook;
    private int pendingHookCount;
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS;
    private static final DocumentBuilder db;

    private RakeProjectHelper(FileObject fileObject, Document document, ProjectState projectState, RakeBasedProjectType rakeBasedProjectType) {
        this.dir = fileObject;
        assert (fileObject != null && FileUtil.toFile((FileObject)fileObject) != null);
        this.state = projectState;
        assert (projectState != null);
        this.type = rakeBasedProjectType;
        assert (rakeBasedProjectType != null);
        this.projectXml = document;
        assert (document != null);
        this.properties = new ProjectProperties(this);
        this.fileListener = new FileListener();
        FileChangeSupport.DEFAULT.addListener(this.fileListener, this.resolveFile(PROJECT_XML_PATH));
        FileChangeSupport.DEFAULT.addListener(this.fileListener, this.resolveFile(PRIVATE_XML_PATH));
    }

    RakeBasedProjectType getType() {
        return this.type;
    }

    private Document getConfigurationXml(boolean bl) {
        Document document;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document document2 = document = bl ? this.projectXml : this.privateXml;
        if (document == null) {
            String string = bl ? PROJECT_XML_PATH : PRIVATE_XML_PATH;
            document = this.loadXml(string);
            if (document == null) {
                String string2 = bl ? "project" : "project-private";
                String string3 = bl ? PROJECT_NS : PRIVATE_NS;
                document = XMLUtil.createDocument((String)string2, (String)string3, null, null);
                if (bl) {
                    Element element = document.createElementNS(PROJECT_NS, "type");
                    element.appendChild(document.createTextNode(this.getType().getType()));
                    document.getDocumentElement().appendChild(element);
                    document.getDocumentElement().appendChild(document.createElementNS(PROJECT_NS, "configuration"));
                }
            }
            if (bl) {
                this.projectXml = document;
            } else {
                this.privateXml = document;
            }
        }
        assert (document != null);
        return document;
    }

    private Document loadXml(String string) {
        block8: {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            assert (Thread.holdsLock(this.modifiedMetadataPaths));
            FileObject fileObject = this.dir.getFileObject(string);
            if (fileObject == null || !fileObject.isData()) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            assert (file != null);
            try {
                return XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
            }
            catch (IOException iOException) {
                if (!QUIETLY_SWALLOW_XML_LOAD_ERRORS) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            catch (SAXException sAXException) {
                if (QUIETLY_SWALLOW_XML_LOAD_ERRORS) break block8;
                ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock saveXml(final Document document, final String string) throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        assert (!this.writingXML);
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        final FileLock[] fileLockArray = new FileLock[1];
        this.writingXML = true;
        try {
            this.dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XMLUtil.write((Document)document, (OutputStream)byteArrayOutputStream, (String)"UTF-8");
                    final byte[] byArray = byteArrayOutputStream.toByteArray();
                    final FileObject fileObject = FileUtil.createData((FileObject)RakeProjectHelper.this.dir, (String)string);
                    try {
                        fileLockArray[0] = fileObject.lock();
                        OutputStream outputStream = fileObject.getOutputStream(fileLockArray[0]);
                        try {
                            outputStream.write(byArray);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    catch (UserQuestionException userQuestionException) {
                        RakeProjectHelper.this.needPendingHook();
                        UserQuestionHandler.handle(userQuestionException, new UserQuestionHandler.Callback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void accepted() {
                                assert (!RakeProjectHelper.this.writingXML);
                                RakeProjectHelper.this.writingXML = true;
                                try {
                                    FileLock fileLock = fileObject.lock();
                                    try {
                                        OutputStream outputStream = fileObject.getOutputStream(fileLock);
                                        try {
                                            outputStream.write(byArray);
                                        }
                                        finally {
                                            outputStream.close();
                                        }
                                    }
                                    finally {
                                        fileLock.releaseLock();
                                    }
                                    RakeProjectHelper.this.maybeCallPendingHook();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify((Throwable)iOException);
                                    this.reload();
                                }
                                finally {
                                    RakeProjectHelper.this.writingXML = false;
                                }
                            }

                            public void denied() {
                                this.reload();
                            }

                            public void error(IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                                this.reload();
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            private void reload() {
                                if (string.equals(RakeProjectHelper.PROJECT_XML_PATH)) {
                                    Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                                    synchronized (set) {
                                        RakeProjectHelper.this.projectXml = null;
                                    }
                                }
                                assert (string.equals(RakeProjectHelper.PRIVATE_XML_PATH)) : string;
                                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                                synchronized (set) {
                                    RakeProjectHelper.this.privateXml = null;
                                }
                                RakeProjectHelper.this.fireExternalChange(string);
                                RakeProjectHelper.this.cancelPendingHook();
                            }
                        });
                    }
                }
            });
        }
        finally {
            this.writingXML = false;
        }
        return fileLockArray[0];
    }

    private Element getConfigurationDataRoot(boolean bl) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document document = this.getConfigurationXml(bl);
        if (bl) {
            Element element = document.getDocumentElement();
            Element element2 = Util.findElement(element, "configuration", PROJECT_NS);
            assert (element2 != null);
            return element2;
        }
        return document.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRakeProjectListener(RakeProjectListener rakeProjectListener) {
        List<RakeProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(rakeProjectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRakeProjectListener(RakeProjectListener rakeProjectListener) {
        List<RakeProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(rakeProjectListener);
        }
    }

    void fireExternalChange(final String string) {
        Mutex.Action<Void> action = new Mutex.Action<Void>(){

            public Void run() {
                RakeProjectHelper.this.fireChange(string, false);
                return null;
            }
        };
        if (ProjectManager.mutex().isWriteAccess()) {
            ProjectManager.mutex().readAccess((Mutex.Action)action);
        } else if (ProjectManager.mutex().isReadAccess()) {
            action.run();
        } else {
            RP.post(new Runnable((Mutex.Action)action){
                final /* synthetic */ Mutex.Action val$action;
                {
                    this.val$action = action;
                }

                public void run() {
                    ProjectManager.mutex().readAccess(this.val$action);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String string, boolean bl) {
        RakeProjectListener[] rakeProjectListenerArray;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            rakeProjectListenerArray = this.listeners.toArray(new RakeProjectListener[this.listeners.size()]);
        }
        object = new RakeProjectEvent(this, string, bl);
        final boolean bl2 = string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH);
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>((RakeProjectEvent)object){
            final /* synthetic */ RakeProjectEvent val$ev;
            {
                this.val$ev = rakeProjectEvent;
            }

            public Void run() {
                for (int i = 0; i < rakeProjectListenerArray.length; ++i) {
                    try {
                        if (bl2) {
                            rakeProjectListenerArray[i].configurationXmlChanged(this.val$ev);
                            continue;
                        }
                        rakeProjectListenerArray[i].propertiesChanged(this.val$ev);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        ErrorManager.getDefault().notify((Throwable)runtimeException);
                    }
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifying(String string) {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            this.modifiedMetadataPaths.add(string);
        }
        this.fireChange(string, true);
    }

    public FileObject getProjectDirectory() {
        return this.dir;
    }

    public void notifyDeleted() {
        this.state.notifyDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markModified() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            this.modifiedMetadataPaths.add(PROJECT_XML_PATH);
        }
    }

    boolean isProjectXmlModified() {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        return this.modifiedMetadataPaths.contains(PROJECT_XML_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        HashSet<FileLock> hashSet = new HashSet<FileLock>();
        try {
            Set<String> set = this.modifiedMetadataPaths;
            synchronized (set) {
                assert (!this.modifiedMetadataPaths.isEmpty());
                assert (this.pendingHook == null);
                if (this.modifiedMetadataPaths.contains(PROJECT_XML_PATH)) {
                    Project object = RakeBasedProjectFactorySingleton.getProjectFor(this);
                    this.pendingHook = (ProjectXmlSavedHook)object.getLookup().lookup(ProjectXmlSavedHook.class);
                }
                Iterator<String> iterator = this.modifiedMetadataPaths.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    if (string.equals(PROJECT_XML_PATH)) {
                        assert (this.projectXml != null);
                        hashSet.add(this.saveXml(this.projectXml, string));
                    } else if (string.equals(PRIVATE_XML_PATH)) {
                        assert (this.privateXml != null);
                        hashSet.add(this.saveXml(this.privateXml, string));
                    } else {
                        hashSet.add(this.properties.write(string));
                    }
                    iterator.remove();
                }
                if (this.pendingHook != null && this.pendingHookCount == 0) {
                    try {
                        this.pendingHook.projectXmlSaved();
                    }
                    catch (IOException iOException) {
                        this.modifiedMetadataPaths.add(PROJECT_XML_PATH);
                        throw iOException;
                    }
                }
            }
        }
        finally {
            hashSet.remove(null);
            for (FileLock fileLock : hashSet) {
                fileLock.releaseLock();
            }
            if (this.pendingHookCount == 0) {
                this.pendingHook = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeCallPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0 && this.pendingHook != null) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws IOException {
                        RakeProjectHelper.this.pendingHook.projectXmlSaved();
                        return null;
                    }
                });
            }
            catch (MutexException mutexException) {
                ErrorManager.getDefault().notify((Throwable)mutexException);
            }
            finally {
                this.pendingHook = null;
            }
        }
    }

    void cancelPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0) {
            this.pendingHook = null;
        }
    }

    void needPendingHook() {
        ++this.pendingHookCount;
    }

    public EditableProperties getProperties(final String string) {
        if (string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to load properties from a project XML file");
        }
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                return RakeProjectHelper.this.properties.getProperties(string);
            }
        });
    }

    public void putProperties(final String string, final EditableProperties editableProperties) {
        if (string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                if (RakeProjectHelper.this.properties.putProperties(string, editableProperties)) {
                    RakeProjectHelper.this.modifying(string);
                }
                return null;
            }
        });
    }

    public PropertyProvider getPropertyProvider(final String string) {
        if (string.equals(PROJECT_XML_PATH) || string.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        return (PropertyProvider)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<PropertyProvider>(){

            public PropertyProvider run() {
                return RakeProjectHelper.this.properties.getPropertyProvider(string);
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean bl) {
        final String string = this.type.getPrimaryConfigurationDataElementName(bl);
        assert (string.indexOf(58) == -1);
        final String string2 = this.type.getPrimaryConfigurationDataElementNamespace(bl);
        assert (string2 != null && string2.length() > 0);
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element = RakeProjectHelper.this.getConfigurationFragment(string, string2, bl);
                    if (element != null) {
                        return element;
                    }
                    return RakeProjectHelper.cloneSafely(RakeProjectHelper.this.getConfigurationXml(bl).createElementNS(string2, string));
                }
            }
        });
    }

    public void putPrimaryConfigurationData(Element element, boolean bl) throws IllegalArgumentException {
        String string = this.type.getPrimaryConfigurationDataElementName(bl);
        assert (string.indexOf(58) == -1);
        String string2 = this.type.getPrimaryConfigurationDataElementNamespace(bl);
        assert (string2 != null && string2.length() > 0);
        if (!string.equals(element.getLocalName()) || !string2.equals(element.getNamespaceURI())) {
            throw new IllegalArgumentException("Wrong name/namespace: expected {" + string2 + "}" + string + " but was {" + element.getNamespaceURI() + "}" + element.getLocalName());
        }
        this.putConfigurationFragment(element, bl);
    }

    Element getConfigurationFragment(final String string, final String string2, final boolean bl) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Element run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element = RakeProjectHelper.this.getConfigurationDataRoot(bl);
                    Element element2 = Util.findElement(element, string, string2);
                    if (element2 != null) {
                        return RakeProjectHelper.cloneSafely(element2);
                    }
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element element) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document document = db.newDocument();
            return (Element)document.importNode(element, true);
        }
    }

    void putConfigurationFragment(final Element element, final boolean bl) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element3 = RakeProjectHelper.this.getConfigurationDataRoot(bl);
                    Element element2 = Util.findElement(element3, element.getLocalName(), element.getNamespaceURI());
                    if (element2 != null) {
                        element3.removeChild(element2);
                    }
                    Node node = null;
                    NodeList nodeList = element3.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node2 = nodeList.item(i);
                        if (node2.getNodeType() != 1) continue;
                        int n = node2.getNodeName().compareTo(element.getNodeName());
                        if (n == 0) {
                            n = node2.getNamespaceURI().compareTo(element.getNamespaceURI());
                        }
                        if (n <= 0) continue;
                        node = node2;
                        break;
                    }
                    element3.insertBefore(element3.getOwnerDocument().importNode(element, true), node);
                    RakeProjectHelper.this.modifying(bl ? RakeProjectHelper.PROJECT_XML_PATH : RakeProjectHelper.PRIVATE_XML_PATH);
                }
                return null;
            }
        });
    }

    boolean removeConfigurationFragment(final String string, final String string2, final boolean bl) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Set set = RakeProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element element = RakeProjectHelper.this.getConfigurationDataRoot(bl);
                    Element element2 = Util.findElement(element, string, string2);
                    if (element2 != null) {
                        element.removeChild(element2);
                        RakeProjectHelper.this.modifying(bl ? RakeProjectHelper.PROJECT_XML_PATH : RakeProjectHelper.PRIVATE_XML_PATH);
                        return true;
                    }
                    return false;
                }
            }
        });
    }

    public AuxiliaryConfiguration createAuxiliaryConfiguration() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public RakeArtifact createSimpleRakeArtifact(String string, String string2, PropertyEvaluator propertyEvaluator, String string3, String string4) {
        return new SimpleRakeArtifact(this, string, string2, propertyEvaluator, string3, string4);
    }

    public SharabilityQueryImplementation createSharabilityQuery(PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        stringArray3[stringArray.length] = "";
        String[] stringArray4 = new String[stringArray2.length + 1];
        System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
        stringArray4[stringArray2.length] = "nbproject/private";
        return new SharabilityQueryImpl(this, propertyEvaluator, stringArray3, stringArray4);
    }

    public PropertyProvider getStockPropertyPreprovider() {
        return this.properties.getStockPropertyPreprovider();
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        return this.properties.getStandardPropertyEvaluator();
    }

    public File resolveFile(String string) {
        if (string == null) {
            throw new NullPointerException("Attempted to pass a null filename to resolveFile");
        }
        return PropertyUtils.resolveFile(FileUtil.toFile((FileObject)this.dir), string);
    }

    public FileObject resolveFileObject(String string) {
        if (string == null) {
            throw new NullPointerException("Must pass a non-null filename");
        }
        return PropertyUtils.resolveFileObject(this.dir, string);
    }

    public String resolvePath(String string) {
        if (string == null) {
            throw new NullPointerException("Must pass a non-null path");
        }
        return PropertyUtils.resolvePath(FileUtil.toFile((FileObject)this.dir), string);
    }

    public String toString() {
        return "RakeProjectHelper[" + this.getProjectDirectory() + "]";
    }

    static {
        RakeBasedProjectFactorySingleton.HELPER_CALLBACK = new RakeBasedProjectFactorySingleton.RakeProjectHelperCallback(){

            public RakeProjectHelper createHelper(FileObject fileObject, Document document, ProjectState projectState, RakeBasedProjectType rakeBasedProjectType) {
                return new RakeProjectHelper(fileObject, document, projectState, rakeBasedProjectType);
            }

            public void save(RakeProjectHelper rakeProjectHelper) throws IOException {
                rakeProjectHelper.save();
            }
        };
        RP = new RequestProcessor("RakeProjectHelper.RP");
        QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    private final class FileListener
    implements FileChangeSupportListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void change(File file) {
            String string;
            if (RakeProjectHelper.this.writingXML) {
                return;
            }
            Set set = RakeProjectHelper.this.modifiedMetadataPaths;
            synchronized (set) {
                if (file.equals(RakeProjectHelper.this.resolveFile(RakeProjectHelper.PROJECT_XML_PATH))) {
                    if (RakeProjectHelper.this.modifiedMetadataPaths.contains(RakeProjectHelper.PROJECT_XML_PATH)) {
                        return;
                    }
                    string = RakeProjectHelper.PROJECT_XML_PATH;
                    RakeProjectHelper.this.projectXml = null;
                } else if (file.equals(RakeProjectHelper.this.resolveFile(RakeProjectHelper.PRIVATE_XML_PATH))) {
                    if (RakeProjectHelper.this.modifiedMetadataPaths.contains(RakeProjectHelper.PRIVATE_XML_PATH)) {
                        return;
                    }
                    string = RakeProjectHelper.PRIVATE_XML_PATH;
                    RakeProjectHelper.this.privateXml = null;
                } else {
                    throw new AssertionError((Object)("Unexpected file change in " + file));
                }
            }
            RakeProjectHelper.this.fireExternalChange(string);
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            this.change(fileChangeSupportEvent.getPath());
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            this.change(fileChangeSupportEvent.getPath());
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            this.change(fileChangeSupportEvent.getPath());
        }
    }
}

