/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.ui.FmtOptions;
import org.netbeans.modules.java.ui.FormatingOptionsPanel;
import org.openide.util.NbBundle;

public class FmtSpaces
extends JPanel
implements TreeCellRenderer,
MouseListener,
KeyListener {
    private static Controller controller;
    private DefaultTreeModel model;
    private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private JCheckBox renderer = new JCheckBox();
    private JTree cfgTree;
    private JScrollPane jScrollPane1;

    public FmtSpaces() {
        this.initComponents();
        this.model = this.createModel();
        this.cfgTree.setModel(this.model);
        this.cfgTree.setRootVisible(false);
        this.cfgTree.setShowsRootHandles(true);
        this.cfgTree.setCellRenderer(this);
        this.cfgTree.setEditable(false);
        this.cfgTree.addMouseListener(this);
        this.cfgTree.addKeyListener(this);
        this.dr.setIcon(null);
        this.dr.setOpenIcon(null);
        this.dr.setClosedIcon(null);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.model.getRoot();
        for (int i = defaultMutableTreeNode.getChildCount(); i >= 0; --i) {
            this.cfgTree.expandRow(i);
        }
    }

    public static FormatingOptionsPanel.Category getController() {
        if (controller == null) {
            controller = new Controller();
        }
        return controller;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.cfgTree = new JTree();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.cfgTree.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.cfgTree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Item item;
        this.renderer.setBackground(bl ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(bl ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 instanceof Item) {
            item = (Item)object2;
            if (((DefaultMutableTreeNode)object).getAllowsChildren()) {
                Component component = this.dr.getTreeCellRendererComponent(jTree, object, bl3, bl2, bl3, n, bl4);
                return component;
            }
        } else {
            Component component = this.dr.getTreeCellRendererComponent(jTree, object, bl3, bl2, bl3, n, bl4);
            return component;
        }
        this.renderer.setText(item.displayName);
        this.renderer.setSelected(item.value);
        return this.renderer;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle;
        Point point = mouseEvent.getPoint();
        TreePath treePath = this.cfgTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treePath != null && (rectangle = this.cfgTree.getPathBounds(treePath)) != null) {
            rectangle.width = rectangle.height;
            if (rectangle.contains(point)) {
                this.toggle(treePath);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        JTree jTree;
        TreePath treePath;
        if ((keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) && keyEvent.getSource() instanceof JTree && this.toggle(treePath = (jTree = (JTree)keyEvent.getSource()).getSelectionPath())) {
            keyEvent.consume();
        }
    }

    private DefaultTreeModel createModel() {
        Item[] itemArray = new Item[]{new Item("BeforeKeywords", new Item("spaceBeforeWhile", new Item[0]), new Item("spaceBeforeElse", new Item[0]), new Item("spaceBeforeCatch", new Item[0]), new Item("spaceBeforeFinally", new Item[0])), new Item("BeforeParentheses", new Item("spaceBeforeMethodDeclParen", new Item[0]), new Item("spaceBeforeMethodCallParen", new Item[0]), new Item("spaceBeforeIfParen", new Item[0]), new Item("spaceBeforeForParen", new Item[0]), new Item("spaceBeforeWhileParen", new Item[0]), new Item("spaceBeforeCatchParen", new Item[0]), new Item("spaceBeforeSwitchParen", new Item[0]), new Item("spaceBeforeSynchronizedParen", new Item[0]), new Item("spaceBeforeAnnotationParen", new Item[0])), new Item("AroundOperators", new Item("spaceAroundUnaryOps", new Item[0]), new Item("spaceAroundBinaryOps", new Item[0]), new Item("spaceAroundTernaryOps", new Item[0]), new Item("spaceAroundAssignOps", new Item[0])), new Item("BeforeLeftBraces", new Item("spaceBeforeClassDeclLeftBrace", new Item[0]), new Item("spaceBeforeMethodDeclLeftBrace", new Item[0]), new Item("spaceBeforeIfLeftBrace", new Item[0]), new Item("spaceBeforeElseLeftBrace", new Item[0]), new Item("spaceBeforeWhileLeftBrace", new Item[0]), new Item("spaceBeforeForLeftBrace", new Item[0]), new Item("spaceBeforeDoLeftBrace", new Item[0]), new Item("spaceBeforeSwitchLeftBrace", new Item[0]), new Item("spaceBeforeTryLeftBrace", new Item[0]), new Item("spaceBeforeCatchLeftBrace", new Item[0]), new Item("spaceBeforeFinallyLeftBrace", new Item[0]), new Item("spaceBeforeSynchronizedLeftBrace", new Item[0]), new Item("spaceBeforeStaticInitLeftBrace", new Item[0]), new Item("spaceBeforeArrayInitLeftBrace", new Item[0])), new Item("WithinParentheses", new Item("spaceWithinParens", new Item[0]), new Item("spaceWithinMethodDeclParens", new Item[0]), new Item("spaceWithinMethodCallParens", new Item[0]), new Item("spaceWithinIfParens", new Item[0]), new Item("spaceWithinForParens", new Item[0]), new Item("spaceWithinWhileParens", new Item[0]), new Item("spaceWithinSwitchParens", new Item[0]), new Item("spaceWithinCatchParens", new Item[0]), new Item("spaceWithinSynchronizedParens", new Item[0]), new Item("spaceWithinTypeCastParens", new Item[0]), new Item("spaceWithinAnnotationParens", new Item[0]), new Item("spaceWithinBraces", new Item[0]), new Item("spaceWithinArrayInitBrackets", new Item[0])), new Item("Other", new Item("spaceBeforeComma", new Item[0]), new Item("spaceAfterComma", new Item[0]), new Item("spaceBeforeSemi", new Item[0]), new Item("spaceAfterSemi", new Item[0]), new Item("spaceBeforeColon", new Item[0]), new Item("spaceAfterColon", new Item[0]), new Item("spaceAfterTypeCast", new Item[0]))};
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("root", true);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        for (Item item : itemArray) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(item, true);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (Item item2 : item.items) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(item2, false);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
        return defaultTreeModel;
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.cfgTree.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (object instanceof Item) {
            Item item = (Item)object;
            if (defaultMutableTreeNode.getAllowsChildren()) {
                return false;
            }
            item.value = !item.value;
            defaultTreeModel.nodeChanged(defaultMutableTreeNode);
            defaultTreeModel.nodeChanged(defaultMutableTreeNode.getParent());
            controller.changed();
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Controller
    extends FmtOptions.CategorySupport {
        FmtSpaces panel = (FmtSpaces)this.getComponent(null);

        public Controller() {
            super("LBL_Spaces", new FmtSpaces(), NbBundle.getMessage(FmtSpaces.class, (String)"SAMPLE_Spaces"), {"placeCatchOnNewLine", Boolean.FALSE.toString()}, {"placeElseOnNewLine", Boolean.FALSE.toString()}, {"placeWhileOnNewLine", Boolean.FALSE.toString()}, {"placeFinallyOnNewLine", Boolean.FALSE.toString()});
            this.update();
        }

        @Override
        protected void addListeners() {
        }

        @Override
        public void update() {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.panel.model.getRoot();
            List<Item> list = this.getAllItems();
            Preferences preferences = FmtOptions.getPreferences(FmtOptions.getCurrentProfileId());
            for (Item item : list) {
                boolean bl = FmtOptions.getDefaultAsBoolean(item.id);
                item.value = preferences.getBoolean(item.id, bl);
            }
        }

        @Override
        public void applyChanges() {
            this.storeTo(FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()));
        }

        @Override
        public void storeTo(Preferences preferences) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.panel.model.getRoot();
            List<Item> list = this.getAllItems();
            for (Item item : list) {
                preferences.putBoolean(item.id, item.value);
            }
        }

        private List<Item> getAllItems() {
            LinkedList<Item> linkedList = new LinkedList<Item>();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.panel.model.getRoot();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof Item)) continue;
                Item item = (Item)object;
                if (item.items != null && item.items.length != 0) continue;
                linkedList.add(item);
            }
            return linkedList;
        }
    }

    private static class Item {
        String id;
        String displayName;
        boolean value;
        Item[] items;

        public Item(String string, Item ... itemArray) {
            this.id = string;
            this.items = itemArray;
            this.displayName = NbBundle.getMessage(FmtSpaces.class, (String)("LBL_" + string));
        }

        public String toString() {
            return this.displayName;
        }
    }
}

