/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javadoc.JavadocClassReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolClassReader
extends JavadocClassReader {
    private Symtab syms;
    private Name.Table table;
    private Types types;
    private JavacTypes jTypes;
    private Log logger;
    private Source source;
    private boolean sigEnterPhase;
    private char[] buffer;
    private int currentBufferIndex;
    private boolean readingClassSignature = false;
    private boolean readingEnclMethod = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();

    public static void preRegister(final Context context, final boolean bl) {
        context.put(classReaderKey, new Context.Factory<ClassReader>(){

            public ClassReader make() {
                return new SymbolClassReader(context, bl);
            }
        });
    }

    protected SymbolClassReader(Context context, boolean bl) {
        super(context, bl);
        this.syms = Symtab.instance(context);
        this.table = Name.Table.instance((Context)context);
        this.types = Types.instance(context);
        this.jTypes = JavacTypes.instance(context);
        this.logger = Log.instance(context);
        this.source = Source.instance(context);
        this.allowGenerics = true;
        this.allowVarargs = true;
        this.allowAnnotations = true;
        this.buffer = new char[127];
    }

    private void addCharToBuffer(char c) {
        if (this.currentBufferIndex >= this.buffer.length) {
            char[] cArray = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
            this.buffer = cArray;
        }
        this.buffer[this.currentBufferIndex++] = c;
    }

    private void clearBuffer() {
        this.currentBufferIndex = 0;
    }

    private int bufferLength() {
        return this.currentBufferIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Symbol.ClassSymbol classSymbol) {
        Symbol symbol = this.currentOwner;
        try {
            this.fillInImpl(classSymbol);
            Object var4_3 = null;
            this.currentOwner = symbol;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentOwner = symbol;
            throw throwable;
        }
    }

    private boolean isSignatureFile(JavaFileObject javaFileObject) {
        if (javaFileObject instanceof FileObjects.Base) {
            return ((FileObjects.Base)javaFileObject).getExt().equals("sig");
        }
        return javaFileObject.toUri().toString().endsWith(".sig");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInImpl(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.classfile == null || classSymbol.classfile.getKind() != JavaFileObject.Kind.CLASS || !this.isSignatureFile(classSymbol.classfile)) {
            super.fillIn(classSymbol);
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classSymbol.classfile.openInputStream(), "UTF-8"));
            try {
                int n = bufferedReader.read();
                if (n != 71) {
                    throw new IOException("Wrong signature file: " + classSymbol.classfile.toUri());
                }
                this.fillInFromSig(classSymbol, bufferedReader);
                if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                    List<Type> list = this.missingTypeVariables;
                    List<Type> list2 = this.foundTypeVariables;
                    this.missingTypeVariables = List.nil();
                    this.foundTypeVariables = List.nil();
                    Type.ClassType classType = (Type.ClassType)this.currentOwner.type;
                    classType.supertype_field = this.types.subst(classType.supertype_field, list, list2);
                    classType.interfaces_field = this.types.subst(classType.interfaces_field, list, list2);
                } else if (this.missingTypeVariables.isEmpty() != this.foundTypeVariables.isEmpty()) {
                    Name name = ((Type)this.missingTypeVariables.head).tsym.name;
                    throw this.badClassFile("undecl.type.var", new Object[]{name});
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                this.missingTypeVariables = List.nil();
                this.foundTypeVariables = List.nil();
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            this.missingTypeVariables = List.nil();
            this.foundTypeVariables = List.nil();
            {
            }
        }
        catch (IOException iOException) {
            throw new Symbol.CompletionFailure((Symbol)classSymbol, iOException.getMessage()).initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillInFromSig(Symbol.ClassSymbol classSymbol, Reader reader) throws IOException {
        PoolConstant poolConstant;
        Object object;
        long l;
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classSymbol.members_field = new Scope(classSymbol);
        this.currentOwner = classSymbol;
        this.typevars = this.typevars.dup(this.currentOwner);
        if (classType.getEnclosingType().tag == 10) {
            this.enterTypevars(classType.getEnclosingType());
        }
        classSymbol.flags_field = l = this.readFlags(reader) & 0xFFFFFFFFAFFFFFFFL | 0x8000000000L;
        int n = reader.read();
        this.readingClassSignature = true;
        try {
            if (n == 60) {
                object = this.readTypeParamsWithName(reader, classSymbol);
                n = reader.read();
            } else {
                object = List.nil();
            }
            classType.typarams_field = object;
            assert (n == 78) : n;
            poolConstant = this.readPlainNameIntoTable(reader);
            if (poolConstant != classSymbol.flatname) {
                throw this.badClassFile("class.file.wrong.class", new Object[]{poolConstant});
            }
            n = reader.read();
            if (n != 59) {
                this.readEnclosingMethodAttr(reader, classSymbol, n);
            }
            classType.supertype_field = (n = reader.read()) != 59 ? this.readType(reader, n) : Type.noType;
            if (classType.supertype_field.getClass() == Type.class && !classType.supertype_field.isPrimitive()) {
                System.err.println("PROBLEM");
                System.err.println("c=" + classSymbol.flatname.toString());
            }
            List<Type> list = List.nil();
            while ((n = reader.read()) != 59) {
                list = list.prepend(this.readType(reader, n));
            }
            classType.interfaces_field = list.reverse();
            Object var11_9 = null;
            this.readingClassSignature = false;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.readingClassSignature = false;
            throw throwable;
        }
        while ((n = reader.read()) != 59) {
            assert (n == 78);
            object = this.readPlainName(reader);
            poolConstant = this.enterClass(this.findName((CharSequence)object), classSymbol);
            this.markInnerClassOwner(classSymbol, (Symbol.ClassSymbol)poolConstant, this.readFlags(reader));
        }
        n = reader.read();
        assert (n == 10 || n == -1) : classSymbol.classfile + ", char: " + (char)n + n;
        while ((object = this.readMember(reader)) != null) {
            this.enterMember(classSymbol, (Symbol)object);
        }
        this.attachAnnotations(classSymbol, reader);
        this.typevars = this.typevars.leave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void readEnclosingMethodAttr(Reader reader, Symbol.ClassSymbol classSymbol, int n) throws IOException {
        this.readingEnclMethod = true;
        try {
            Object object;
            assert (n == 78) : n;
            if (classSymbol.owner.kind == true) {
                classSymbol.owner.members().remove(classSymbol);
            }
            Symbol.ClassSymbol classSymbol2 = this.enterClass(this.readPlainNameIntoTable(reader));
            Symbol symbol = null;
            n = reader.read();
            if (n == 78) {
                void var8_9;
                object = this.readPlainNameIntoTable(reader);
                n = reader.read();
                assert (n == 40) : n;
                Object object2 = List.nil();
                while ((n = reader.read()) != 41) {
                    object2 = ((List)object2).prepend(this.readType(reader, n));
                }
                object2 = ((List)object2).reverse();
                n = reader.read();
                assert (n == 40) : n;
                List object3 = List.nil();
                while ((n = reader.read()) != 41) {
                    List<Type> list = var8_9.prepend(this.readType(reader, n));
                }
                List<Type> list = var8_9.reverse();
                Type type = this.readType(reader, reader.read());
                assert ((n = reader.read()) == 59) : n;
                Type.MethodType methodType = new Type.MethodType((List<Type>)object2, type, list, this.syms.methodClass);
                symbol = this.findMethod((Name)object, methodType, classSymbol2.members_field, classSymbol.flags());
                if (object != null && methodType != null && symbol == null) {
                    throw this.badClassFile("bad.enclosing.method", new Object[]{classSymbol});
                }
            }
            classSymbol.name = this.simpleBinaryName(classSymbol.flatname, classSymbol2.flatname);
            classSymbol.owner = symbol != null ? symbol : classSymbol2;
            classSymbol.fullname = classSymbol.name.len == 0 ? null : Symbol.ClassSymbol.formFullName(classSymbol.name, classSymbol.owner);
            if (symbol != null) {
                ((Type.ClassType)classSymbol.type).setEnclosingType(((Symbol.MethodSymbol)symbol).type);
            } else if ((classSymbol.flags_field & 8L) == 0L) {
                ((Type.ClassType)classSymbol.type).setEnclosingType(classSymbol2.type);
            } else {
                ((Type.ClassType)classSymbol.type).setEnclosingType(Type.noType);
            }
            this.enterTypevars(classSymbol);
            if (!this.missingTypeVariables.isEmpty()) {
                object = new ListBuffer();
                for (Type type : this.missingTypeVariables) {
                    ((ListBuffer)object).append(this.findTypeVar(type.tsym.name));
                }
                this.foundTypeVariables = ((ListBuffer)object).toList();
            } else {
                this.foundTypeVariables = List.nil();
            }
            Object var12_16 = null;
            this.readingEnclMethod = false;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.readingEnclMethod = false;
            throw throwable;
        }
    }

    private Symbol.MethodSymbol findMethod(Name name, Type.MethodType methodType, Scope scope, long l) {
        if (name == null || methodType == null) {
            return null;
        }
        Scope.Entry entry = scope.lookup(name);
        while (entry.scope != null) {
            if (entry.sym.kind == 16 && this.isSameBinaryType(entry.sym.type.asMethodType(), methodType)) {
                return (Symbol.MethodSymbol)entry.sym;
            }
            entry = entry.next();
        }
        if (name != this.table.init) {
            return null;
        }
        if ((l & 0x200L) != 0L) {
            return null;
        }
        if (((List)methodType.getParameterTypes()).isEmpty()) {
            return null;
        }
        methodType = new Type.MethodType(((List)methodType.getParameterTypes()).tail, methodType.getReturnType(), (List<Type>)methodType.getThrownTypes(), this.syms.methodClass);
        return this.findMethod(name, methodType, scope, l);
    }

    private void markInnerClassOwner(Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2, long l) {
        classSymbol2.complete();
        classSymbol2.flags_field = l & 0xFFFFFFFFAFFFFFFFL | 0x8000000000L;
        if ((classSymbol2.flags_field & 8L) == 0L) {
            ((Type.ClassType)classSymbol2.type).setEnclosingType(classSymbol.type);
            if (classSymbol2.erasure_field != null) {
                ((Type.ClassType)classSymbol2.erasure_field).setEnclosingType(this.types.erasure(classSymbol.type));
            }
        }
        this.enterMember(classSymbol, classSymbol2);
    }

    private List<Type.TypeVar> readTypeParams(Symbol symbol, Reader reader) throws IOException {
        int n;
        List<Type.TypeVar> list = List.nil();
        while ((n = reader.read()) != 62) {
            List<Type> list2;
            this.clearBuffer();
            this.addCharToBuffer((char)n);
            while ((n = reader.read()) != 58) {
                this.addCharToBuffer((char)n);
            }
            Name name = this.findName(this.buffer, this.bufferLength());
            Type.TypeVar typeVar = null;
            if (this.sigEnterPhase) {
                list2 = null;
                List<Type> list3 = this.missingTypeVariables;
                while (list3.nonEmpty()) {
                    if (name == ((Type)list3.head).tsym.name) {
                        typeVar = (Type.TypeVar)list3.head;
                        if (list2 != null) {
                            list2.tail = list3.tail;
                            break;
                        }
                        this.missingTypeVariables = list3.tail;
                        break;
                    }
                    list2 = list3;
                    list3 = list3.tail;
                }
                if (typeVar == null) {
                    typeVar = new Type.TypeVar(name, symbol, this.syms.botType);
                }
                this.typevars.enter(typeVar.tsym);
            } else {
                typeVar = (Type.TypeVar)this.findTypeVar(name);
            }
            list2 = List.nil();
            while ((n = reader.read()) != 59) {
                list2 = list2.prepend(this.readType(reader, n));
            }
            list2 = list2.reverse();
            if (!this.sigEnterPhase) {
                this.types.setBounds(typeVar, list2, null);
            }
            list = list.prepend(typeVar);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Type.TypeVar> readTypeParamsWithName(Reader reader, Symbol symbol) throws IOException {
        List<Type.TypeVar> list;
        LoggingReader loggingReader = new LoggingReader(reader);
        boolean bl = this.sigEnterPhase;
        this.sigEnterPhase = true;
        try {
            this.readTypeParams(symbol, loggingReader);
            list = null;
            this.sigEnterPhase = bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.sigEnterPhase = bl;
            throw throwable;
        }
        StringReader stringReader = new StringReader(loggingReader.logged.toString());
        list = this.readTypeParams(symbol, stringReader);
        stringReader.close();
        return list.reverse();
    }

    private java.util.List<? extends TypeMirror> readTypeParams(Reader reader) throws IOException {
        int n;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        while ((n = reader.read()) != 62) {
            arrayList.add(this.readType(reader, n));
        }
        return arrayList;
    }

    private String readPlainName(Reader reader) throws IOException {
        int n;
        this.clearBuffer();
        while ((n = reader.read()) != 59) {
            this.addCharToBuffer((char)n);
        }
        return new String(this.buffer, 0, this.bufferLength());
    }

    private String readName(Reader reader) throws IOException {
        int n = reader.read();
        assert (n == 78) : (char)n;
        return this.readPlainName(reader);
    }

    private Name readPlainNameIntoTable(Reader reader) throws IOException {
        int n;
        this.clearBuffer();
        while ((n = reader.read()) != 59) {
            this.addCharToBuffer((char)n);
        }
        return this.findName(this.buffer, this.bufferLength());
    }

    private Name readNameIntoTable(Reader reader) throws IOException {
        int n = reader.read();
        assert (n == 78) : (char)n;
        return this.readPlainNameIntoTable(reader);
    }

    private long readPlainFlags(Reader reader) throws IOException {
        return Long.parseLong(this.readPlainName(reader), 16);
    }

    private long readFlags(Reader reader) throws IOException {
        int n = reader.read();
        assert (n == 77);
        return this.readPlainFlags(reader);
    }

    private Type readType(Reader reader, int n) throws IOException {
        switch (n) {
            case 90: {
                return this.syms.booleanType;
            }
            case 66: {
                return this.syms.byteType;
            }
            case 83: {
                return this.syms.shortType;
            }
            case 73: {
                return this.syms.intType;
            }
            case 74: {
                return this.syms.longType;
            }
            case 67: {
                return this.syms.charType;
            }
            case 70: {
                return this.syms.floatType;
            }
            case 68: {
                return this.syms.doubleType;
            }
            case 86: {
                return this.syms.voidType;
            }
            case 76: {
                return this.readReferenceType(reader, null);
            }
            case 91: {
                return (Type)((Object)this.jTypes.getArrayType(this.readType(reader, reader.read())));
            }
            case 82: {
                return new Type.ErrorType(this.readPlainNameIntoTable(reader), this.syms.noSymbol);
            }
            case 81: {
                Name name = this.readPlainNameIntoTable(reader);
                if (this.sigEnterPhase) {
                    return Type.noType;
                }
                return this.findTypeVar(name);
            }
            case 43: {
                return new Type.WildcardType(this.readType(reader, reader.read()), BoundKind.EXTENDS, this.syms.boundClass);
            }
            case 45: {
                return new Type.WildcardType(this.readType(reader, reader.read()), BoundKind.SUPER, this.syms.boundClass);
            }
            case 63: {
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
        }
        throw new IllegalArgumentException("Completing: " + ((Symbol.ClassSymbol)this.currentOwner).flatname.toString() + ", read=" + (char)n + ":" + n);
    }

    Type findTypeVar(Name name) {
        Scope.Entry entry = this.typevars.lookup(name);
        if (entry.scope != null) {
            return entry.sym.type;
        }
        if (this.readingClassSignature || this.readingEnclMethod) {
            Type.TypeVar typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(typeVar);
            return typeVar;
        }
        throw this.badClassFile("undecl.type.var", new Object[]{name});
    }

    private Name findName(CharSequence charSequence) {
        char[] cArray = ((Object)charSequence).toString().toCharArray();
        return this.findName(cArray, cArray.length);
    }

    private Name findName(char[] cArray, int n) {
        return Name.fromChars((Name.Table)this.table, (char[])cArray, (int)0, (int)n);
    }

    private Type readReferenceType(Reader reader, Type type) throws IOException {
        java.util.List<? extends TypeMirror> list;
        int n;
        this.clearBuffer();
        while (";<".indexOf(n = reader.read()) == -1) {
            this.addCharToBuffer((char)n);
        }
        Name name = this.findName(this.buffer, this.bufferLength());
        Symbol.ClassSymbol classSymbol = type != null ? this.enterClass(name, type.tsym) : this.enterClass(name);
        Symbol symbol = this.currentOwner;
        java.util.List<? extends TypeMirror> list2 = list = n == 60 ? this.readTypeParams(reader) : null;
        Type type2 = list != null ? new Type.ClassType(type != null ? type : Type.noType, List.from(list.toArray(new Type[0])), classSymbol){
            boolean completed;
            {
                this.completed = false;
            }

            public Type getEnclosingType() {
                if (!this.completed) {
                    this.completed = true;
                    this.tsym.complete();
                    Type type = this.tsym.type.getEnclosingType();
                    if (type != Type.noType) {
                        List<Type> list = super.getEnclosingType().allparams();
                        List<Type> list2 = type.allparams();
                        if (list2.length() != list.length()) {
                            super.setEnclosingType(SymbolClassReader.this.types.erasure(type));
                        } else {
                            super.setEnclosingType(SymbolClassReader.this.types.subst(type, list2, list));
                        }
                    } else {
                        super.setEnclosingType(Type.noType);
                    }
                }
                return super.getEnclosingType();
            }

            public void setEnclosingType(Type type) {
                throw new UnsupportedOperationException();
            }
        } : (type != null ? new Type.ClassType(type, List.<Type>nil(), classSymbol) : classSymbol.erasure(this.types));
        this.currentOwner = symbol;
        if (n == 60) {
            n = reader.read();
            if (n == 36) {
                return this.readReferenceType(reader, type2);
            }
            assert (n == 59) : (char)n;
        }
        return type2;
    }

    private Symbol readMember(Reader reader) throws IOException {
        int n = reader.read();
        if (69 == n) {
            return this.readExecutableMember(reader);
        }
        if (65 == n) {
            return this.readField(reader);
        }
        if (87 == n) {
            return null;
        }
        if (n == -1) {
            return null;
        }
        throw new IllegalArgumentException("Unknown type: " + n);
    }

    private Symbol readExecutableMember(Reader reader) throws IOException {
        Type type;
        long l = this.readFlags(reader);
        if ((l & 0x80000000L) != 0L && !this.allowCovRetTypes) {
            l &= 0xFFFFFFFFFFFFEFFFL;
        }
        this.typevars = this.typevars.dup(this.currentOwner);
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(l, null, null, this.currentOwner);
        List<Type> list = null;
        int n = reader.read();
        if (n == 60) {
            list = this.readTypeParamsWithName(reader, methodSymbol);
            n = reader.read();
        }
        assert (n == 78) : n;
        methodSymbol.name = this.readPlainNameIntoTable(reader);
        n = reader.read();
        assert (n == 40) : n;
        List<Object> list2 = List.nil();
        List<Type> list3 = List.nil();
        while ((n = reader.read()) != 41) {
            assert (n == 77);
            long l2 = this.readPlainFlags(reader);
            type = this.readType(reader, reader.read());
            Name name = this.readNameIntoTable(reader);
            list3 = list3.prepend(type);
            list2 = list2.prepend(new Symbol.VarSymbol(l2, name, type, null));
        }
        list3 = list3.reverse();
        list2 = list2.reverse();
        n = reader.read();
        assert (n == 40) : n;
        List<Object> list4 = List.nil();
        while ((n = reader.read()) != 41) {
            list4 = list4.prepend(this.readType(reader, n));
        }
        Type type2 = this.readType(reader, reader.read());
        type = new Type.MethodType(list3, type2, list4.reverse(), this.syms.methodClass);
        if (list != null) {
            type = new Type.ForAll(list, type);
        }
        methodSymbol.type = type;
        methodSymbol.params = list2;
        for (Symbol.VarSymbol varSymbol : list2) {
            varSymbol.owner = methodSymbol;
        }
        this.attachAnnotations(methodSymbol, reader);
        n = reader.read();
        if (n != 59) {
            this.annotate.later((Annotate.Annotator)new ClassReader.AnnotationDefaultCompleter((ClassReader)((Object)this), methodSymbol, this.readAnnotationValue(reader, n)));
        }
        this.typevars = this.typevars.leave();
        n = reader.read();
        while (n == 32) {
            n = reader.read();
        }
        assert (n == 10 || n == -1) : n;
        return methodSymbol;
    }

    private Symbol readField(Reader reader) throws IOException {
        long l = this.readFlags(reader);
        Type type = this.readType(reader, reader.read());
        Name name = this.readNameIntoTable(reader);
        Object object = this.readConstantField(reader);
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(l, name, type, this.currentOwner);
        varSymbol.setData(object);
        this.attachAnnotations(varSymbol, reader);
        int n = reader.read();
        while (n == 32) {
            n = reader.read();
        }
        assert (n == 10 || n == -1) : n;
        return varSymbol;
    }

    private String readEscapedString(Reader reader) throws IOException {
        String string = this.readPlainName(reader);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char c2 = string.charAt(i + 1);
                switch (c2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 5), 16));
                        i += 4;
                        break;
                    }
                    case 'a': {
                        stringBuffer.append('@');
                        ++i;
                        break;
                    }
                    case 'b': {
                        stringBuffer.append(';');
                        ++i;
                        break;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        ++i;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported escape: " + c2);
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private Object readConstantField(Reader reader) throws IOException {
        Object object = null;
        int n = reader.read();
        switch (n) {
            case 90: {
                object = Boolean.parseBoolean(this.readPlainName(reader)) ? Integer.valueOf(1) : Integer.valueOf(0);
                break;
            }
            case 66: {
                object = Integer.valueOf(this.readPlainName(reader));
                break;
            }
            case 83: {
                object = Integer.valueOf(this.readPlainName(reader));
                break;
            }
            case 73: {
                object = Integer.valueOf(this.readPlainName(reader));
                break;
            }
            case 74: {
                object = Long.valueOf(this.readPlainName(reader));
                break;
            }
            case 67: {
                object = new Integer(Character.valueOf(this.readEscapedString(reader).charAt(0)).charValue());
                break;
            }
            case 70: {
                object = Float.valueOf(this.readPlainName(reader));
                break;
            }
            case 68: {
                object = Double.valueOf(this.readPlainName(reader));
                break;
            }
            case 76: {
                object = this.readEscapedString(reader);
                break;
            }
            case 88: {
                n = reader.read();
                assert (n == 59);
                break;
            }
            default: {
                throw this.badClassFile("Unknown constant type: " + (char)n, new Object[0]);
            }
        }
        return object;
    }

    private void attachAnnotations(Symbol symbol, Reader reader) throws IOException {
        List<ClassReader.CompoundAnnotationProxy> list = this.readAnnotations(reader);
        if (!list.isEmpty()) {
            this.annotate.later((Annotate.Annotator)new ClassReader.AnnotationCompleter((ClassReader)((Object)this), symbol, list));
        }
    }

    private List<ClassReader.CompoundAnnotationProxy> readAnnotations(Reader reader) throws IOException {
        int n;
        List<ClassReader.CompoundAnnotationProxy> list = List.nil();
        while ((n = reader.read()) != 59) {
            list = list.prepend(this.readAnnotation(reader, n));
        }
        return list.reverse();
    }

    private ClassReader.CompoundAnnotationProxy readAnnotation(Reader reader, int n) throws IOException {
        Type type = this.readType(reader, n);
        ListBuffer<Pair<Name, Attribute>> listBuffer = new ListBuffer<Pair<Name, Attribute>>();
        while ((n = reader.read()) != 59) {
            assert (n == 78);
            Name name = this.readPlainNameIntoTable(reader);
            Attribute attribute = this.readAnnotationValue(reader, reader.read());
            listBuffer = listBuffer.append(new Pair<Name, Attribute>(name, attribute));
        }
        return new ClassReader.CompoundAnnotationProxy(type, listBuffer.toList());
    }

    private Attribute readEnum(Reader reader) throws IOException {
        Type type = this.readType(reader, reader.read());
        Name name = this.readNameIntoTable(reader);
        Symbol.VarSymbol varSymbol = null;
        Scope.Entry entry = ((Type.ClassType)type).tsym.members().lookup(name);
        while (entry.scope != null) {
            if (entry.sym.kind == 4) {
                varSymbol = (Symbol.VarSymbol)entry.sym;
                break;
            }
            entry = entry.next();
        }
        if (varSymbol == null) {
            this.logger.error("unknown.enum.constant", this.currentClassFile, type, varSymbol);
            return new Attribute.Error(type);
        }
        return new Attribute.Enum(type, varSymbol);
    }

    private Attribute readAnnotationValue(Reader reader, int n) throws IOException {
        switch (n) {
            case 90: {
                return new Attribute.Constant(this.syms.booleanType, Boolean.parseBoolean(this.readPlainName(reader)) ? Integer.valueOf(1) : Integer.valueOf(0));
            }
            case 66: {
                return new Attribute.Constant(this.syms.byteType, Integer.parseInt(this.readPlainName(reader)));
            }
            case 83: {
                return new Attribute.Constant(this.syms.shortType, Integer.parseInt(this.readPlainName(reader)));
            }
            case 73: {
                return new Attribute.Constant(this.syms.intType, Integer.parseInt(this.readPlainName(reader)));
            }
            case 74: {
                return new Attribute.Constant(this.syms.longType, Long.parseLong(this.readPlainName(reader)));
            }
            case 67: {
                return new Attribute.Constant(this.syms.charType, Character.valueOf(this.readEscapedString(reader).charAt(0)).charValue());
            }
            case 70: {
                return new Attribute.Constant(this.syms.floatType, Float.valueOf(Float.parseFloat(this.readPlainName(reader))));
            }
            case 68: {
                return new Attribute.Constant(this.syms.doubleType, Double.parseDouble(this.readPlainName(reader)));
            }
            case 76: {
                return new Attribute.Constant(this.syms.stringType, this.readEscapedString(reader));
            }
            case 79: {
                return new ClassReader.EnumAttributeProxy(this.readType(reader, reader.read()), this.readNameIntoTable(reader));
            }
            case 80: {
                return this.readAnnotation(reader, reader.read());
            }
            case 91: {
                ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
                while ((n = reader.read()) != 59) {
                    listBuffer.append(this.readAnnotationValue(reader, n));
                }
                return new ClassReader.ArrayAttributeProxy(listBuffer.toList());
            }
            case 89: {
                return new Attribute.Class(this.types, this.readType(reader, reader.read()));
            }
        }
        throw new IllegalStateException("Completing: " + ((Symbol.ClassSymbol)this.currentOwner).flatname.toString() + ", read=" + (char)n + ":" + n);
    }

    protected void includeClassFile(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject, String string) {
        super.includeClassFile(packageSymbol, javaFileObject, string);
    }

    private static final class LoggingReader
    extends Reader {
        private Reader delegateTo;
        private StringBuilder logged = new StringBuilder();

        public LoggingReader(Reader reader) {
            this.delegateTo = reader;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = this.delegateTo.read(cArray, n, n2);
            this.logged.append(cArray, n, n3);
            return n3;
        }

        public void close() throws IOException {
        }
    }
}

