/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.SymbolDumper;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAnalyser {
    private final Index index;
    private final Map<Pair<String, String>, List<String>> references;
    private final Set<Pair<String, String>> toDelete;

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<Pair<String, String>, List<String>>();
        this.toDelete = new HashSet<Pair<String, String>>();
    }

    public void store() throws IOException {
        if (this.references.size() > 0 || this.toDelete.size() > 0) {
            this.index.store(this.references, this.toDelete);
            this.references.clear();
            this.toDelete.clear();
        }
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(Iterable<? extends CompilationUnitTree> iterable, JavacTaskImpl javacTaskImpl, JavaFileManager javaFileManager, JavaFileObject javaFileObject, Set<? super ElementHandle<TypeElement>> set, boolean[] blArray) throws IOException {
        Object object;
        Object object2;
        HashMap<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> hashMap = new HashMap<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>>();
        for (CompilationUnitTree object3 : iterable) {
            Object object4;
            Closeable closeable;
            object2 = new UsagesVisitor(javacTaskImpl, object3, javaFileManager, javaFileObject, set);
            ((UsagesVisitor)object2).scan((Tree)object3, (Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>>)hashMap);
            blArray[0] = blArray[0] | ((UsagesVisitor)object2).mainMethod;
            if (((UsagesVisitor)object2).sourceName == null || ((UsagesVisitor)object2).rsList == null || ((UsagesVisitor)object2).rsList.size() <= 0) continue;
            int n = ((UsagesVisitor)object2).sourceName.lastIndexOf(46);
            object = n == -1 ? "" : ((UsagesVisitor)object2).sourceName.substring(0, n);
            String string = (n == -1 ? ((UsagesVisitor)object2).sourceName : ((UsagesVisitor)object2).sourceName.substring(n + 1)) + '.' + "rs";
            FileObject fileObject = javaFileManager.getFileForOutput(StandardLocation.CLASS_OUTPUT, (String)object, string, javaFileObject);
            assert (fileObject != null);
            try {
                closeable = new BufferedReader(new InputStreamReader(fileObject.openInputStream(), "UTF-8"));
                try {
                    while ((object4 = ((BufferedReader)closeable).readLine()) != null) {
                        ((UsagesVisitor)object2).rsList.add(object4);
                    }
                }
                finally {
                    ((BufferedReader)closeable).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            closeable = new PrintWriter(new OutputStreamWriter(fileObject.openOutputStream(), "UTF-8"));
            try {
                object4 = ((UsagesVisitor)object2).rsList.iterator();
                while (object4.hasNext()) {
                    String string2 = (String)object4.next();
                    ((PrintWriter)closeable).println(string2);
                }
            }
            finally {
                ((PrintWriter)closeable).close();
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Pair)entry.getKey();
            Map map = (Map)entry.getValue();
            object = this.getClassReferences((Pair<String, String>)object2);
            for (Map.Entry entry2 : map.entrySet()) {
                object.add((String)DocumentUtil.encodeUsage((String)entry2.getKey(), (Set)entry2.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseUnitAndStore(CompilationUnitTree compilationUnitTree, JavacTaskImpl javacTaskImpl, JavaFileManager javaFileManager) throws IOException {
        try {
            HashMap<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> hashMap = new HashMap<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>>();
            ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
            UsagesVisitor usagesVisitor = new UsagesVisitor(javacTaskImpl, compilationUnitTree, javaFileManager, compilationUnitTree.getSourceFile(), arrayList);
            usagesVisitor.scan((Tree)compilationUnitTree, (Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>>)hashMap);
            for (Map.Entry entry : hashMap.entrySet()) {
                Pair pair = (Pair)entry.getKey();
                Map map = (Map)entry.getValue();
                List<String> list = this.getClassReferences(pair);
                for (Map.Entry entry2 : map.entrySet()) {
                    list.add(DocumentUtil.encodeUsage((String)entry2.getKey(), (Set)entry2.getValue()));
                }
            }
            this.index.store(this.references, arrayList);
        }
        catch (OutputFileManager.InvalidSourcePath invalidSourcePath) {
        }
        finally {
            this.references.clear();
        }
    }

    public void delete(Pair<String, String> pair) throws IOException {
        if (!this.index.isValid(false)) {
            return;
        }
        this.toDelete.add(pair);
    }

    public void delete(String string, String string2) throws IOException {
        this.delete(Pair.of(string, string2));
    }

    private List<String> getClassReferences(Pair<String, String> pair) {
        assert (pair != null);
        List<String> list = this.references.get(pair);
        if (list == null) {
            list = new LinkedList<String>();
            this.references.put(pair, list);
        }
        return list;
    }

    private static void dumpUsages(Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) throws IOException {
        assert (map != null);
        for (Map.Entry<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> entry : map.entrySet()) {
            System.out.println("Usages in class: " + entry.getKey());
            for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> entry2 : entry.getValue().entrySet()) {
                System.out.println("\t" + entry2.getKey() + "\t: " + entry2.getValue().toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UsagesVisitor
    extends TreeScanner<Void, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>>> {
        private final Stack<Pair<String, String>> activeClass;
        private JavaFileManager manager;
        private final JavacTaskImpl jt;
        private final Name errorName;
        private final CompilationUnitTree cu;
        private final Types types;
        private final TransTypes trans;
        private final JavaFileObject sibling;
        private final String sourceName;
        private final boolean signatureFiles;
        private final List<? super Pair<String, String>> topLevels;
        private final Set<? super ElementHandle<TypeElement>> newTypes;
        private final Set<String> imports;
        private final Set<String> staticImports;
        private boolean isStaticImport;
        private State state;
        private Element enclosingElement = null;
        private Set<String> rsList;
        private boolean mainMethod;

        public UsagesVisitor(JavacTaskImpl javacTaskImpl, CompilationUnitTree compilationUnitTree, JavaFileManager javaFileManager, JavaFileObject javaFileObject, Set<? super ElementHandle<TypeElement>> set) {
            assert (javacTaskImpl != null);
            assert (compilationUnitTree != null);
            assert (javaFileManager != null);
            assert (javaFileObject != null);
            this.activeClass = new Stack();
            this.imports = new HashSet<String>();
            this.staticImports = new HashSet<String>();
            this.jt = javacTaskImpl;
            this.errorName = Name.Table.instance((Context)javacTaskImpl.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(javacTaskImpl.getContext());
            this.trans = TransTypes.instance(javacTaskImpl.getContext());
            this.cu = compilationUnitTree;
            this.signatureFiles = true;
            this.manager = javaFileManager;
            this.sibling = javaFileObject;
            this.sourceName = this.manager.inferBinaryName(StandardLocation.SOURCE_PATH, this.sibling);
            this.topLevels = null;
            this.newTypes = set;
        }

        protected UsagesVisitor(JavacTaskImpl javacTaskImpl, CompilationUnitTree compilationUnitTree, JavaFileManager javaFileManager, JavaFileObject javaFileObject, List<? super Pair<String, String>> list) {
            assert (javacTaskImpl != null);
            assert (compilationUnitTree != null);
            assert (javaFileManager != null);
            assert (javaFileObject != null);
            this.activeClass = new Stack();
            this.imports = new HashSet<String>();
            this.staticImports = new HashSet<String>();
            this.jt = javacTaskImpl;
            this.errorName = Name.Table.instance((Context)javacTaskImpl.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(javacTaskImpl.getContext());
            this.trans = TransTypes.instance(javacTaskImpl.getContext());
            this.cu = compilationUnitTree;
            this.signatureFiles = false;
            this.manager = javaFileManager;
            this.sibling = javaFileObject;
            this.sourceName = this.manager.inferBinaryName(StandardLocation.SOURCE_PATH, this.sibling);
            this.topLevels = list;
            this.newTypes = null;
        }

        final Types getTypes() {
            return this.types;
        }

        final TransTypes getTransTypes() {
            return this.trans;
        }

        @Override
        public Void scan(Tree tree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            if (tree == null) {
                return null;
            }
            super.scan(tree, map);
            return null;
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            String string;
            super.visitCompilationUnit(compilationUnitTree, map);
            if (!this.imports.isEmpty() && (string = UsagesVisitor.getResourceName(compilationUnitTree)) != null) {
                String string2 = string + DocumentUtil.encodeKind(ElementKind.CLASS);
                Pair<String, Object> pair = Pair.of(string2, null);
                for (String string3 : this.imports) {
                    this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                }
                this.imports.clear();
                for (String string3 : this.staticImports) {
                    this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    this.addUsage(pair, string3, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                }
                this.staticImports.clear();
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.handleVisitIdentSelect(((JCTree.JCFieldAccess)memberSelectTree).sym, map);
            State state = this.state;
            this.state = State.OTHER;
            Void void_ = (Void)super.visitMemberSelect(memberSelectTree, map);
            this.state = state;
            return void_;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.handleVisitIdentSelect(((JCTree.JCIdent)identifierTree).sym, map);
            return (Void)super.visitIdentifier(identifierTree, map);
        }

        @Override
        public Void visitImport(ImportTree importTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.isStaticImport = importTree.isStatic();
            Void void_ = (Void)super.visitImport(importTree, map);
            this.isStaticImport = false;
            return void_;
        }

        private void handleVisitIdentSelect(Symbol symbol, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            String string;
            if (!this.activeClass.empty()) {
                if (symbol != null) {
                    String string2;
                    Object object;
                    if (symbol.kind == 31 && (((Symbol)(object = symbol.getEnclosingElement())).getKind().isClass() || ((Symbol)object).getKind().isInterface()) && (string2 = UsagesVisitor.encodeClassName((Symbol)object)) != null) {
                        this.addUsage(this.activeClass.peek(), string2, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    if (symbol.getKind().isClass() || symbol.getKind().isInterface()) {
                        object = UsagesVisitor.encodeClassName(symbol);
                        if (object != null) {
                            switch (this.state) {
                                case EXTENDS: {
                                    this.addUsage(this.activeClass.peek(), (String)object, map, ClassIndexImpl.UsageType.SUPER_CLASS);
                                    break;
                                }
                                case IMPLEMENTS: {
                                    this.addUsage(this.activeClass.peek(), (String)object, map, ClassIndexImpl.UsageType.SUPER_INTERFACE);
                                    break;
                                }
                                case OTHER: 
                                case GT: {
                                    this.addUsage(this.activeClass.peek(), (String)object, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                }
                            }
                        }
                    } else if (symbol.getKind().isField()) {
                        object = symbol.getEnclosingElement();
                        string2 = UsagesVisitor.encodeClassName((Symbol)object);
                        if (string2 != null) {
                            this.addUsage(this.activeClass.peek(), string2, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                        }
                    } else if ((symbol.getKind() == ElementKind.CONSTRUCTOR || symbol.getKind() == ElementKind.METHOD) && (string2 = UsagesVisitor.encodeClassName((Symbol)(object = symbol.getEnclosingElement()))) != null) {
                        this.addUsage(this.activeClass.peek(), string2, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    }
                }
            } else if (symbol != null && (symbol.getKind().isClass() || symbol.getKind().isInterface()) && (string = UsagesVisitor.encodeClassName(symbol)) != null) {
                if (this.isStaticImport) {
                    this.staticImports.add(string);
                } else {
                    this.imports.add(string);
                }
            }
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            this.scan(parameterizedTypeTree.getType(), map);
            State state = this.state;
            this.state = State.GT;
            this.scan(parameterizedTypeTree.getTypeArguments(), map);
            this.state = state;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dump(TypeElement typeElement, String string, Element element) {
            PrintWriter printWriter = null;
            if (this.rsList != null) {
                this.rsList.add(string);
            }
            try {
                JavaFileObject javaFileObject = this.manager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, JavaFileObject.Kind.CLASS, this.sibling);
                printWriter = new PrintWriter(new OutputStreamWriter(javaFileObject.openOutputStream(), "UTF-8"));
                SymbolDumper.dump(printWriter, this.types, this.trans, typeElement, element);
                printWriter.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }

        protected boolean shouldGenerate(String string, Symbol.ClassSymbol classSymbol) {
            if (!this.signatureFiles || string == null) {
                return false;
            }
            if (classSymbol.getQualifiedName().isEmpty()) {
                return true;
            }
            for (Element element = classSymbol.getEnclosingElement(); element != null && ((Symbol)element).getKind() != ElementKind.PACKAGE; element = ((Symbol)element).getEnclosingElement()) {
                if (((Symbol)element).getKind().isClass() || ((Symbol)element).getKind().isInterface()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitClass(ClassTree classTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            Object object;
            Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)classTree).sym;
            boolean bl = false;
            boolean bl2 = true;
            String string = null;
            if (classSymbol != null) {
                bl = this.hasErrorName(classSymbol);
                if (bl) {
                    if (this.activeClass.size() > 0) {
                        this.activeClass.push((Pair<String, String>)this.activeClass.get(0));
                        bl2 = false;
                    } else {
                        string = UsagesVisitor.getResourceName(this.cu);
                        if (string != null) {
                            object = string + DocumentUtil.encodeKind(ElementKind.CLASS);
                            Pair<Object, Object> pair = Pair.of(object, null);
                            if (this.activeClass.isEmpty()) {
                                if (this.topLevels != null) {
                                    this.topLevels.add(Pair.of(string, null));
                                }
                                for (String string2 : this.imports) {
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                }
                                this.imports.clear();
                                for (String string2 : this.staticImports) {
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                                    this.addUsage(pair, string2, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                                }
                                this.staticImports.clear();
                            }
                            this.activeClass.push(pair);
                            bl2 = false;
                            this.addUsage(pair, string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            if (this.newTypes != null) {
                                this.newTypes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string));
                            }
                        } else {
                            Logger.getLogger(SourceAnalyser.class.getName()).warning(String.format("Cannot resolve %s, ignoring whole subtree.\n", classSymbol.toString()));
                        }
                    }
                } else {
                    org.openide.filesystems.FileObject fileObject;
                    object = new StringBuilder();
                    ClassFileUtil.encodeClassName(classSymbol, (StringBuilder)object, '.');
                    string = ((StringBuilder)object).toString();
                    ElementKind elementKind = classSymbol.getKind();
                    ((StringBuilder)object).append(DocumentUtil.encodeKind(elementKind));
                    String string3 = ((StringBuilder)object).toString();
                    String string4 = null;
                    if (this.activeClass.isEmpty()) {
                        if (!string.equals(this.sourceName)) {
                            if (this.signatureFiles) {
                                this.rsList = new HashSet<String>();
                            }
                            try {
                                Object object2;
                                fileObject = URLMapper.findFileObject((URL)this.sibling.toUri().toURL());
                                if (fileObject != null && (object2 = ClassPath.getClassPath((org.openide.filesystems.FileObject)fileObject, (String)"classpath/source")) != null) {
                                    string4 = object2.getResourceName(fileObject, '/', true);
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                Exceptions.printStackTrace((Throwable)malformedURLException);
                            }
                        }
                    } else {
                        string4 = (String)this.activeClass.peek().second;
                    }
                    fileObject = Pair.of(string3, string4);
                    if (this.activeClass.isEmpty()) {
                        if (this.topLevels != null) {
                            this.topLevels.add(Pair.of(string, string4));
                        }
                        for (String string5 : this.imports) {
                            this.addUsage((Pair<String, String>)fileObject, string5, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                        this.imports.clear();
                        for (String string5 : this.staticImports) {
                            this.addUsage((Pair<String, String>)fileObject, string5, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            this.addUsage((Pair<String, String>)fileObject, string5, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                            this.addUsage((Pair<String, String>)fileObject, string5, map, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                        }
                        this.staticImports.clear();
                    }
                    this.activeClass.push((Pair<String, String>)fileObject);
                    bl2 = false;
                    this.addUsage((Pair<String, String>)fileObject, string, map, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    if (this.newTypes != null) {
                        this.newTypes.add(ElementHandleAccessor.INSTANCE.create(elementKind, string));
                    }
                }
            }
            if (!bl2) {
                object = this.enclosingElement;
                try {
                    this.enclosingElement = classSymbol;
                    this.scan((Tree)classTree.getModifiers(), map);
                    this.scan(classTree.getTypeParameters(), map);
                    this.state = bl ? State.OTHER : State.EXTENDS;
                    this.scan(classTree.getExtendsClause(), map);
                    this.state = bl ? State.OTHER : State.IMPLEMENTS;
                    this.scan(classTree.getImplementsClause(), map);
                    this.state = State.OTHER;
                    this.scan(classTree.getMembers(), map);
                    this.activeClass.pop();
                }
                finally {
                    this.enclosingElement = object;
                }
            }
            if (!bl && this.shouldGenerate(string, classSymbol)) {
                this.dump(classSymbol, string, this.enclosingElement);
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            String string;
            Symbol symbol;
            Symbol symbol2 = ((JCTree.JCNewClass)newClassTree).constructor;
            if (symbol2 != null && (symbol = symbol2.getEnclosingElement()) != null && symbol.getKind().isClass() && (string = UsagesVisitor.encodeClassName(symbol)) != null) {
                this.addUsage(this.activeClass.peek(), string, map, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            return (Void)super.visitNewClass(newClassTree, map);
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            List<? extends Tree> list = erroneousTree.getErrorTrees();
            for (Tree tree : list) {
                this.scan(tree, map);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitMethod(MethodTree methodTree, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map) {
            Element element = this.enclosingElement;
            try {
                this.enclosingElement = ((JCTree.JCMethodDecl)methodTree).sym;
                if (this.enclosingElement != null && this.enclosingElement.getKind() == ElementKind.METHOD) {
                    this.mainMethod |= SourceUtils.isMainMethod((ExecutableElement)this.enclosingElement);
                }
                Void void_ = (Void)super.visitMethod(methodTree, map);
                return void_;
            }
            finally {
                this.enclosingElement = element;
            }
        }

        private void addUsage(Pair<String, String> pair, String string, Map<Pair<String, String>, Map<String, Set<ClassIndexImpl.UsageType>>> map, ClassIndexImpl.UsageType usageType) {
            Set<ClassIndexImpl.UsageType> set;
            assert (string != null);
            assert (map != null);
            assert (usageType != null);
            Map<String, Set<ClassIndexImpl.UsageType>> map2 = map.get(pair);
            if (map2 == null) {
                map2 = new HashMap<String, Set<ClassIndexImpl.UsageType>>();
                map.put(pair, map2);
            }
            if ((set = map2.get(string)) == null) {
                set = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
                map2.put(string, set);
            }
            set.add(usageType);
        }

        private boolean hasErrorName(Symbol symbol) {
            while (symbol != null) {
                if (symbol.name == this.errorName) {
                    return true;
                }
                symbol = symbol.getEnclosingElement();
            }
            return false;
        }

        private static String encodeClassName(Symbol symbol) {
            assert (symbol instanceof Symbol.ClassSymbol);
            TypeElement typeElement = null;
            TypeMirror typeMirror = ((Symbol.ClassSymbol)symbol).asType();
            if (symbol.getEnclosingElement().getKind() == ElementKind.TYPE_PARAMETER) {
                TypeMirror typeMirror2;
                if (typeMirror.getKind() == TypeKind.ARRAY && (typeMirror2 = ((ArrayType)typeMirror).getComponentType()).getKind() == TypeKind.DECLARED) {
                    typeElement = (TypeElement)((DeclaredType)typeMirror2).asElement();
                }
            } else {
                typeElement = (TypeElement)((Object)symbol);
            }
            return typeElement == null ? null : ClassFileUtil.encodeClassName(typeElement);
        }

        private static String getResourceName(CompilationUnitTree compilationUnitTree) {
            URI uRI;
            JavaFileObject javaFileObject;
            if (compilationUnitTree instanceof JCTree.JCCompilationUnit && (javaFileObject = ((JCTree.JCCompilationUnit)compilationUnitTree).sourcefile) != null && (uRI = javaFileObject.toUri()) != null && uRI.isAbsolute()) {
                try {
                    ClassPath classPath;
                    org.openide.filesystems.FileObject fileObject = URLMapper.findFileObject((URL)uRI.toURL());
                    if (fileObject != null && (classPath = ClassPath.getClassPath((org.openide.filesystems.FileObject)fileObject, (String)"classpath/source")) != null) {
                        return classPath.getResourceName(fileObject, '.', false);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            EXTENDS,
            IMPLEMENTS,
            GT,
            OTHER;

        }
    }
}

