/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.model.LazyTreeLoader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.SymbolDumper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class TreeLoader
extends LazyTreeLoader {
    private static final Logger LOGGER = Logger.getLogger(TreeLoader.class.getName());
    public static boolean DISABLE_CONFINEMENT_TEST = false;
    private Context context;
    private ClasspathInfo cpInfo;
    private Map<Symbol.ClassSymbol, StringBuilder> couplingErrors;
    private boolean partialReparse;

    public static void preRegister(Context context, ClasspathInfo classpathInfo) {
        context.put(lazyTreeLoaderKey, new TreeLoader(context, classpathInfo));
    }

    public static TreeLoader instance(Context context) {
        LazyTreeLoader lazyTreeLoader = LazyTreeLoader.instance((Context)context);
        return lazyTreeLoader instanceof TreeLoader ? (TreeLoader)lazyTreeLoader : null;
    }

    private TreeLoader(Context context, ClasspathInfo classpathInfo) {
        this.context = context;
        this.cpInfo = classpathInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadTreeFor(Symbol.ClassSymbol classSymbol) {
        assert (DISABLE_CONFINEMENT_TEST || JavaSourceAccessor.getINSTANCE().isJavaCompilerLocked());
        if (classSymbol == null) return false;
        try {
            Iterator<Map.Entry<Symbol.ClassSymbol, StringBuilder>> iterator;
            boolean bl;
            FileObject fileObject = SourceUtils.getFile(classSymbol, this.cpInfo);
            JavacTaskImpl javacTaskImpl = this.context.get(JavacTaskImpl.class);
            if (fileObject == null) return false;
            if (javacTaskImpl == null) return false;
            Log.instance((Context)this.context).nerrors = 0;
            SourceFileObject sourceFileObject = FileObjects.nbFileObject(fileObject, null);
            Map<Symbol.ClassSymbol, StringBuilder> map = this.couplingErrors;
            try {
                this.couplingErrors = new HashMap<Symbol.ClassSymbol, StringBuilder>();
                javacTaskImpl.analyze(javacTaskImpl.enter(javacTaskImpl.parse(new JavaFileObject[]{sourceFileObject})));
                this.dumpSymFile(classSymbol);
                bl = true;
                Object var8_8 = null;
                iterator = this.couplingErrors.entrySet().iterator();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                Iterator<Map.Entry<Symbol.ClassSymbol, StringBuilder>> iterator2 = this.couplingErrors.entrySet().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        this.couplingErrors = map;
                        throw throwable;
                    }
                    Map.Entry<Symbol.ClassSymbol, StringBuilder> entry = iterator2.next();
                    this.logCouplingError(entry.getKey(), entry.getValue().toString());
                }
            }
            while (true) {
                if (!iterator.hasNext()) {
                    this.couplingErrors = map;
                    return bl;
                }
                Map.Entry<Symbol.ClassSymbol, StringBuilder> entry = iterator.next();
                this.logCouplingError(entry.getKey(), entry.getValue().toString());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return false;
    }

    public final void startPartialReparse() {
        this.partialReparse = true;
    }

    public final void endPartialReparse() {
        this.partialReparse = false;
    }

    public void couplingError(Symbol.ClassSymbol classSymbol, Tree tree) {
        if (this.partialReparse) {
            throw new CouplingAbort(classSymbol.classfile, tree);
        }
        StringBuilder stringBuilder = new StringBuilder("\n");
        switch (tree.getKind()) {
            case CLASS: {
                stringBuilder.append("CLASS: ").append(((ClassTree)tree).getSimpleName().toString());
                break;
            }
            case VARIABLE: {
                stringBuilder.append("VARIABLE: ").append(((VariableTree)tree).getName().toString());
                break;
            }
            case METHOD: {
                stringBuilder.append("METHOD: ").append(((MethodTree)tree).getName().toString());
                break;
            }
            case TYPE_PARAMETER: {
                stringBuilder.append("TYPE_PARAMETER: ").append(((TypeParameterTree)tree).getName().toString());
                break;
            }
            default: {
                stringBuilder.append("TREE: <unknown>");
            }
        }
        if (classSymbol != null && this.couplingErrors != null) {
            StringBuilder stringBuilder2 = this.couplingErrors.get(classSymbol);
            if (stringBuilder2 != null) {
                stringBuilder2.append((CharSequence)stringBuilder);
            } else {
                this.couplingErrors.put(classSymbol, stringBuilder);
            }
        } else {
            this.logCouplingError(classSymbol, stringBuilder.toString());
        }
    }

    private void logCouplingError(Symbol.ClassSymbol classSymbol, String string) {
        JavaFileObject javaFileObject = classSymbol != null ? classSymbol.classfile : null;
        String string2 = javaFileObject != null ? javaFileObject.toUri().toASCIIString() : "<unknown>";
        JavaFileObject javaFileObject2 = classSymbol != null ? classSymbol.sourcefile : null;
        String string3 = javaFileObject != null ? javaFileObject2.toUri().toASCIIString() : "<unknown>";
        LOGGER.log(Level.WARNING, "Coupling error:\nclass file: {0}\nsource file: {1}{2}\n", new Object[]{string2, string3, string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpSymFile(Symbol.ClassSymbol classSymbol) throws IOException {
        boolean bl;
        File file;
        PrintWriter printWriter;
        block22: {
            block21: {
                block20: {
                    printWriter = null;
                    file = null;
                    bl = false;
                    try {
                        String string;
                        String string2;
                        JavaFileManager javaFileManager = ClasspathInfoAccessor.getINSTANCE().getFileManager(this.cpInfo);
                        String string3 = null;
                        if (classSymbol.classfile != null) {
                            string3 = javaFileManager.inferBinaryName(StandardLocation.PLATFORM_CLASS_PATH, classSymbol.classfile);
                            if (string3 == null) {
                                string3 = javaFileManager.inferBinaryName(StandardLocation.CLASS_PATH, classSymbol.classfile);
                            }
                        } else if (classSymbol.sourcefile != null) {
                            string3 = javaFileManager.inferBinaryName(StandardLocation.SOURCE_PATH, classSymbol.sourcefile);
                        }
                        if (string3 == null) {
                            Object var14_7 = null;
                            if (printWriter != null) {
                                printWriter.close();
                            }
                            if (!bl) return;
                            if ($assertionsDisabled || file != null) break block20;
                            throw new AssertionError();
                        }
                        String string4 = classSymbol.classfile.toUri().toURL().toExternalForm();
                        int n = string4.lastIndexOf(FileObjects.convertPackage2Folder(string3));
                        assert (n > 0);
                        File file2 = Index.getClassFolder(new URL(string4.substring(0, n)));
                        n = string3.lastIndexOf(46);
                        if (n < 0) {
                            string2 = null;
                            string = string3;
                        } else {
                            string2 = string3.substring(0, n);
                            assert (string3.length() > n);
                            string = string3.substring(n + 1);
                        }
                        if (string2 != null && !(file2 = new File(file2, string2.replace('.', File.separatorChar))).exists()) {
                            file2.mkdirs();
                        }
                        if ((file = new File(file2, string + '.' + "sig")).exists()) {
                            break block21;
                        }
                        bl = true;
                        printWriter = new PrintWriter(file, "UTF-8");
                        Symbol symbol = classSymbol.owner.kind == true ? null : (classSymbol.owner.kind == 4 ? classSymbol.owner.owner : classSymbol.owner);
                        bl = SymbolDumper.dump(printWriter, Types.instance(this.context), TransTypes.instance(this.context), classSymbol, symbol);
                        break block22;
                    }
                    catch (Throwable throwable) {
                        Object var14_10 = null;
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        if (!bl) throw throwable;
                        assert (file != null);
                        file.delete();
                        throw throwable;
                    }
                }
                file.delete();
                return;
            }
            Object var14_8 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            if (!bl) return;
            assert (file != null);
            file.delete();
            return;
        }
        Object var14_9 = null;
        if (printWriter != null) {
            printWriter.close();
        }
        if (!bl) return;
        assert (file != null);
        file.delete();
    }
}

