/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.xml.parsers.DocumentBuilder;
import org.openide.actions.OpenAction;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.loaders.XMLDataObjectImpl;
import org.openide.loaders.XMLDataObjectInfoParser;
import org.openide.loaders.XMLEntityResolverChain;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.windows.CloneableOpenSupport;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDataObject
extends MultiDataObject {
    static final long serialVersionUID = 8757854986453256578L;
    @Deprecated
    public static final String XMLINFO_DTD_PUBLIC_ID_FORTE = "-//Forte for Java//DTD xmlinfo//EN";
    @Deprecated
    public static final String XMLINFO_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD xmlinfo//EN";
    public static final String MIME = "text/xml";
    public static final int STATUS_NOT = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final String PROP_DOCUMENT = "document";
    @Deprecated
    public static final String PROP_INFO = "info";
    private static ErrorPrinter errorHandler = new ErrorPrinter();
    private static XMLEntityResolverChain chainingEntityResolver;
    private static HashMap<String, Info> infos;
    private static Object emgrLock;
    private DelDoc doc;
    private int status;
    @Deprecated
    private EditorCookie editor = null;
    private XMLDataObjectInfoParser infoParser;
    static final Logger ERR;

    public XMLDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.getIP(), (Object)fileObject));
        this.status = 0;
        CookieSet.Factory factory = new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                if (clazz.isAssignableFrom(EditorCookie.class) || clazz.isAssignableFrom(OpenCookie.class) || clazz.isAssignableFrom(CloseCookie.class) || clazz.isAssignableFrom(PrintCookie.class)) {
                    if (XMLDataObject.this.editor == null) {
                        XMLDataObject.this.editor = XMLDataObject.this.createEditorCookie();
                    }
                    if (XMLDataObject.this.editor == null) {
                        return null;
                    }
                    return (T)(clazz.isAssignableFrom(XMLDataObject.this.editor.getClass()) ? (Node.Cookie)clazz.cast(XMLDataObject.this.editor) : null);
                }
                return null;
            }
        };
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(EditorCookie.class, factory);
        cookieSet.add(OpenCookie.class, factory);
        cookieSet.add(CloseCookie.class, factory);
        cookieSet.add(PrintCookie.class, factory);
        cookieSet.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject fileObject, String string) throws IOException {
                EditorCookie editorCookie = (EditorCookie)XMLDataObject.this.getCookieSet().getCookie(EditorCookie.class);
                if (editorCookie instanceof DataEditorSupport) {
                    ((DataEditorSupport)editorCookie).saveAs(fileObject, string);
                } else {
                    Logger.getLogger(XMLDataObject.class.getName()).log(Level.FINE, "'Save As' requires DataEditorSupport");
                }
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XMLDataObjectInfoParser getIP() {
        Object object = emgrLock;
        synchronized (object) {
            if (this.infoParser == null) {
                this.infoParser = new XMLDataObjectInfoParser(this);
            }
        }
        return this.infoParser;
    }

    @Override
    protected Node createNodeDelegate() {
        XMLNode xMLNode = new XMLNode(this);
        xMLNode.setShortDescription(NbBundle.getMessage(XMLDataObject.class, (String)"HINT_XMLDataObject"));
        return xMLNode;
    }

    @Deprecated
    protected void updateIconBase(String string) {
    }

    @Override
    protected void handleDelete() throws IOException {
        this.getIP().waitFinished();
        super.handleDelete();
    }

    @Override
    public HelpCtx getHelpCtx() {
        try {
            if (this.getPrimaryFile().getFileSystem().isDefault() && this.getCookie(InstanceCookie.class) != null) {
                return HelpCtx.DEFAULT_HELP;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return new HelpCtx(XMLDataObject.class);
    }

    @Override
    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        this.getIP().waitFinished();
        Object object = this.getIP().lookupCookie(clazz);
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("Query for " + clazz + " for " + this);
            ERR.fine("Gives a cake " + object + " for " + this);
        }
        if (object instanceof InstanceCookie) {
            object = this.ofCookie((InstanceCookie)object, clazz);
        }
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("After ofCookie: " + object + " for " + this);
        }
        if (object == null) {
            object = super.getCookie(clazz);
        }
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("getCookie returns " + object + " for " + this);
        }
        return (T)((Node.Cookie)clazz.cast(object));
    }

    private InstanceCookie ofCookie(InstanceCookie instanceCookie, Class<?> clazz) {
        if (instanceCookie instanceof InstanceCookie.Of) {
            return instanceCookie;
        }
        if (!clazz.isAssignableFrom(ICDel.class)) {
            return instanceCookie;
        }
        ICDel iCDel = new ICDel(this, instanceCookie);
        return iCDel;
    }

    private void notifyEx(Exception exception) {
        Exceptions.attachLocalizedMessage((Throwable)exception, (String)"Cannot resolve following class in xmlinfo.");
        Exceptions.printStackTrace((Throwable)exception);
    }

    @Deprecated
    protected EditorCookie createEditorCookie() {
        return new XMLEditorSupport(this);
    }

    private final void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    private final void removeSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().remove((Node.Cookie)saveCookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Document getDocument() throws IOException, SAXException {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("getDocument for " + this);
        }
        XMLDataObject xMLDataObject = this;
        synchronized (xMLDataObject) {
            DelDoc delDoc = this.doc;
            if (delDoc == null) {
                this.doc = delDoc = new DelDoc();
            }
            return delDoc.getProxyDocument();
        }
    }

    final void clearDocument() {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("clearDocument for " + this);
        }
        this.doc = null;
        this.firePropertyChange(PROP_DOCUMENT, null, null);
    }

    public final int getStatus() {
        return this.status;
    }

    @Deprecated
    public final Info getInfo() {
        return null;
    }

    @Deprecated
    public final synchronized void setInfo(Info info) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Document parsePrimaryFile() throws IOException, SAXException {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine("parsePrimaryFile for " + this);
        }
        String string = this.getPrimaryFile().getURL().toExternalForm();
        try {
            return XMLUtil.parse((InputSource)new InputSource(string), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
        }
        catch (IOException iOException) {
            Document document;
            InputStream inputStream = this.getPrimaryFile().getInputStream();
            try {
                document = XMLUtil.parse((InputSource)new InputSource(inputStream), (boolean)false, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)XMLDataObject.getSystemResolver());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return document;
        }
    }

    @Deprecated
    public static Document parse(URL uRL) throws IOException, SAXException {
        return XMLDataObject.parse(uRL, errorHandler, false);
    }

    @Deprecated
    public static Document parse(URL uRL, boolean bl) throws IOException, SAXException {
        return XMLDataObject.parse(uRL, errorHandler, bl);
    }

    @Deprecated
    public static Document parse(URL uRL, ErrorHandler errorHandler) throws IOException, SAXException {
        return XMLDataObject.parse(uRL, errorHandler, false);
    }

    @Deprecated
    public static Document parse(URL uRL, ErrorHandler errorHandler, boolean bl) throws IOException, SAXException {
        DocumentBuilder documentBuilder = XMLDataObjectImpl.makeBuilder(bl);
        documentBuilder.setErrorHandler(errorHandler);
        documentBuilder.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return documentBuilder.parse(new InputSource(uRL.toExternalForm()));
    }

    @Deprecated
    public static Parser createParser() {
        return XMLDataObject.createParser(false);
    }

    @Deprecated
    public static Parser createParser(boolean bl) {
        Parser parser = XMLDataObjectImpl.makeParser(bl);
        parser.setEntityResolver(XMLDataObject.getChainingEntityResolver());
        return parser;
    }

    @Deprecated
    public static Document createDocument() {
        XMLDataObject.deprecated();
        try {
            return XMLDataObjectImpl.makeBuilder(false).newDocument();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    @Deprecated
    public static void write(Document document, Writer writer) throws IOException {
        XMLDataObject.deprecated();
        try {
            Class<?> clazz = Class.forName("org.openide.xml.XMLUtilImpl");
            Method method = clazz.getDeclaredMethod("write", Document.class, Object.class, String.class);
            method.setAccessible(true);
            method.invoke(null, document, writer, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IOException("org.openide.xml.XMLUtilImpl.write() invocation failed.");
        }
    }

    @Deprecated
    public static void write(Document document, OutputStream outputStream, String string) throws IOException {
        XMLUtil.write((Document)document, (OutputStream)outputStream, (String)string);
    }

    @Deprecated
    public static InputSource createInputSource(URL uRL) throws IOException {
        return new InputSource(uRL.toExternalForm());
    }

    @Deprecated
    public static void registerCatalogEntry(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(string, string2);
    }

    @Deprecated
    public static void registerCatalogEntry(String string, String string2, ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("null public ID is not allowed.");
        }
        XMLDataObjectImpl.registerCatalogEntry(string, "nbres:/" + string2);
    }

    @Deprecated
    public static final boolean addEntityResolver(EntityResolver entityResolver) {
        return XMLDataObject.getChainingEntityResolver().addEntityResolver(entityResolver);
    }

    @Deprecated
    public static final EntityResolver removeEntityResolver(EntityResolver entityResolver) {
        return XMLDataObject.getChainingEntityResolver().removeEntityResolver(entityResolver);
    }

    private static synchronized XMLEntityResolverChain getChainingEntityResolver() {
        if (chainingEntityResolver == null) {
            chainingEntityResolver = new XMLEntityResolverChain();
            chainingEntityResolver.addEntityResolver(XMLDataObject.getSystemResolver());
        }
        return chainingEntityResolver;
    }

    private static EntityResolver getSystemResolver() {
        return EntityCatalog.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void registerInfo(String string, Info info) {
        HashMap<String, Info> hashMap = infos;
        synchronized (hashMap) {
            if (info == null) {
                infos.remove(string);
            } else {
                infos.put(string, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Info getRegisteredInfo(String string) {
        HashMap<String, Info> hashMap = infos;
        synchronized (hashMap) {
            Info info = infos.get(string);
            return info == null ? null : (Info)info.clone();
        }
    }

    private static void deprecated() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Exception("").printStackTrace(printWriter);
        printWriter.flush();
        String string = stringWriter.toString().trim();
        int n = string.indexOf("\n");
        int n2 = string.indexOf("\n", n + 1);
        while (string.indexOf("XMLDataObject", n + 1) > 0) {
            n = n2;
            n2 = string.indexOf("\n", n + 1);
        }
        String string2 = string.substring(n + 1, n2).trim();
        System.out.println("Warning: deprecated method called " + string2);
    }

    static Lookup createInfoLookup(XMLDataObject xMLDataObject, Info info) {
        return new InfoLkp(xMLDataObject, info);
    }

    private Node findNode() {
        Node node = (Node)this.getIP().lookupCookie(Node.class);
        if (node == null) {
            return new PlainDataNode();
        }
        return node;
    }

    static {
        infos = new HashMap();
        emgrLock = new Object();
        ERR = Logger.getLogger(XMLDataObject.class.getName());
    }

    private final class DelDoc
    implements InvocationHandler {
        private Reference<Document> xmlDocument;
        private final Document proxyDocument = (Document)Proxy.newProxyInstance(DelDoc.class.getClassLoader(), new Class[]{Document.class}, (InvocationHandler)this);

        DelDoc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Document getDocumentImpl(boolean bl) {
            DelDoc delDoc = this;
            synchronized (delDoc) {
                Document document;
                Document document2 = document = this.xmlDocument == null ? null : this.xmlDocument.get();
                if (document != null) {
                    return document;
                }
                if (!bl) {
                    return null;
                }
                XMLDataObject.this.status = 1;
                try {
                    Document document3 = XMLDataObject.this.parsePrimaryFile();
                    this.xmlDocument = new SoftReference<Document>(document3);
                    return document3;
                }
                catch (SAXException sAXException) {
                    ERR.log(Level.WARNING, null, sAXException);
                }
                catch (IOException iOException) {
                    ERR.log(Level.WARNING, null, iOException);
                }
                XMLDataObject.this.status = 3;
                Document document4 = XMLUtil.createDocument((String)"brokenDocument", null, null, null);
                this.xmlDocument = new SoftReference<Document>(document4);
                XMLDataObject.this.firePropertyChange(XMLDataObject.PROP_DOCUMENT, null, null);
                return document4;
            }
        }

        public Document getProxyDocument() {
            return this.proxyDocument;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("getDoctype") && objectArray == null) {
                return Proxy.newProxyInstance(DelDoc.class.getClassLoader(), new Class[]{DocumentType.class}, (InvocationHandler)this);
            }
            if (method.getName().equals("getPublicId") && objectArray == null) {
                Document document = this.getDocumentImpl(false);
                if (document != null) {
                    DocumentType documentType = document.getDoctype();
                    return documentType == null ? null : documentType.getPublicId();
                }
                return XMLDataObject.this.getIP().getPublicId();
            }
            return method.invoke((Object)this.getDocumentImpl(true), objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ICDel
    implements InstanceCookie.Of {
        private XMLDataObject obj;
        private InstanceCookie ic;

        public ICDel(XMLDataObject xMLDataObject, InstanceCookie instanceCookie) {
            this.obj = xMLDataObject;
            this.ic = instanceCookie;
        }

        public String instanceName() {
            return this.ic.instanceName();
        }

        public Class<?> instanceClass() throws IOException, ClassNotFoundException {
            return this.ic.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return this.ic.instanceCreate();
        }

        public boolean instanceOf(Class<?> clazz) {
            if (this.ic instanceof InstanceCookie.Of) {
                return ((InstanceCookie.Of)this.ic).instanceOf(clazz);
            }
            try {
                return clazz.isAssignableFrom(this.instanceClass());
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public int hashCode() {
            return 2 * this.obj.hashCode() + this.ic.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ICDel) {
                ICDel iCDel = (ICDel)object;
                return iCDel.obj == object && iCDel.ic == this.ic;
            }
            return false;
        }
    }

    final class XMLNode
    extends FilterNode {
        public XMLNode(XMLDataObject xMLDataObject2) {
            this(xMLDataObject2.findNode());
        }

        private XMLNode(Node node) {
            super(node, (Children)new FilterNode.Children(node));
        }

        final void update() {
            this.changeOriginal(XMLDataObject.this.findNode(), true);
        }
    }

    private final class PlainDataNode
    extends DataNode {
        public PlainDataNode() {
            super(XMLDataObject.this, Children.LEAF);
            this.setIconBaseWithExtension("org/openide/loaders/xmlObject.gif");
        }

        public Action getPreferredAction() {
            return SystemAction.get(OpenAction.class);
        }
    }

    private static final class InfoLkp
    extends AbstractLookup {
        public final Info info;

        public InfoLkp(XMLDataObject xMLDataObject, Info info) {
            this.info = info;
            Iterator<Class<?>> iterator = info.processorClasses();
            ArrayList<InfoPair> arrayList = new ArrayList<InfoPair>(info.processors.size());
            while (iterator.hasNext()) {
                Class<?> clazz = iterator.next();
                arrayList.add(new InfoPair(xMLDataObject, clazz));
            }
            this.setPairs(arrayList);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class InfoPair
        extends AbstractLookup.Pair {
            private Class<?> clazz;
            private Object obj;

            protected InfoPair(XMLDataObject xMLDataObject, Class<?> clazz) {
                this.obj = xMLDataObject;
                this.clazz = clazz;
            }

            protected boolean instanceOf(Class clazz) {
                Class clazz2 = clazz;
                Class<?> clazz3 = this.clazz;
                if (clazz3 == null) {
                    return clazz2.isInstance(this.obj);
                }
                return clazz2.isAssignableFrom(clazz3);
            }

            protected boolean creatorOf(Object object) {
                return this.obj == object;
            }

            public synchronized Object getInstance() {
                if (this.clazz == null) {
                    return this.obj;
                }
                XMLDataObject xMLDataObject = (XMLDataObject)this.obj;
                this.obj = null;
                Class<?> clazz = this.clazz;
                this.clazz = null;
                try {
                    if (Processor.class.isAssignableFrom(clazz)) {
                        this.obj = clazz.newInstance();
                        Processor processor = (Processor)this.obj;
                        processor.attachTo(xMLDataObject);
                        return this.obj;
                    }
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    for (int i = 0; i < constructorArray.length; ++i) {
                        Class<?>[] classArray = constructorArray[i].getParameterTypes();
                        if (classArray.length != 1 || classArray[0] != DataObject.class && classArray[0] != XMLDataObject.class) continue;
                        this.obj = constructorArray[i].newInstance(xMLDataObject);
                        return this.obj;
                    }
                    throw new InternalError("XMLDataObject processor class " + clazz + " invalid");
                }
                catch (InvocationTargetException invocationTargetException) {
                    xMLDataObject.notifyEx(invocationTargetException);
                }
                catch (InstantiationException instantiationException) {
                    xMLDataObject.notifyEx(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    xMLDataObject.notifyEx(illegalAccessException);
                }
                return this.obj;
            }

            public Class getType() {
                Class<?> clazz = this.clazz;
                return clazz != null ? clazz : this.obj.getClass();
            }

            public String getId() {
                return "Info[" + this.getType().getName();
            }

            public String getDisplayName() {
                return this.getType().getName();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static final class Info
    implements Cloneable {
        List<Class<?>> processors = new ArrayList();
        String iconBase = null;

        public Object clone() {
            Info info = new Info();
            for (Class<?> clazz : this.processors) {
                info.processors.add(clazz);
            }
            info.iconBase = this.iconBase;
            return info;
        }

        public synchronized void addProcessorClass(Class<?> clazz) {
            if (!Processor.class.isAssignableFrom(clazz)) {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                for (int i = 0; i < constructorArray.length; ++i) {
                    Class<?>[] classArray = constructorArray[i].getParameterTypes();
                    if (classArray.length != 1 || classArray[0] != DataObject.class && classArray[0] != XMLDataObject.class) continue;
                    constructorArray = null;
                    break;
                }
                if (constructorArray != null) {
                    throw new IllegalArgumentException();
                }
            }
            this.processors.add(clazz);
        }

        public boolean removeProcessorClass(Class<?> clazz) {
            return this.processors.remove(clazz);
        }

        public Iterator<Class<?>> processorClasses() {
            return this.processors.iterator();
        }

        public void setIconBase(String string) {
            this.iconBase = string;
        }

        public String getIconBase() {
            return this.iconBase;
        }

        public void write(Writer writer) throws IOException {
            throw new IOException("Not supported anymore");
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Info)) {
                return false;
            }
            Info info = (Info)object;
            return (this.iconBase != null && this.iconBase.equals(info.iconBase) || info.iconBase == this.iconBase) && ((Object)this.processors).equals(info.processors);
        }
    }

    @Deprecated
    public static interface Processor
    extends Node.Cookie {
        public void attachTo(XMLDataObject var1);
    }

    static final class Loader
    extends MultiFileLoader {
        static final long serialVersionUID = 3917883920409453930L;

        public Loader() {
            super("org.openide.loaders.XMLDataObject");
        }

        protected String actionsContext() {
            return "Loaders/text/xml/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlLoader_Name");
        }

        protected FileObject findPrimaryFile(FileObject fileObject) {
            String string = fileObject.getMIMEType();
            if (string.endsWith("/xml") || string.endsWith("+xml")) {
                return fileObject;
            }
            return null;
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException {
            return new XMLDataObject(fileObject, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
            return new FileEntry(multiDataObject, fileObject);
        }
    }

    static class NullHandler
    extends DefaultHandler
    implements LexicalHandler {
        static final NullHandler INSTANCE = new NullHandler();

        NullHandler() {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    static class ErrorPrinter
    implements ErrorHandler {
        ErrorPrinter() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            if (!DataObject.LOG.isLoggable(Level.FINE)) {
                return;
            }
            String string2 = NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlMessage", (Object[])new Object[]{string, sAXParseException.getMessage(), sAXParseException.getSystemId() == null ? "" : sAXParseException.getSystemId(), "" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()});
            DataObject.LOG.fine(string2);
        }

        public void error(SAXParseException sAXParseException) {
            this.message(NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlError"), sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) {
            this.message(NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlWarning"), sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
            this.message(NbBundle.getMessage(XMLDataObject.class, (String)"PROP_XmlFatalError"), sAXParseException);
        }
    }

    private static class XMLEditorSupport
    extends DataEditorSupport
    implements OpenCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie {
        public XMLEditorSupport(XMLDataObject xMLDataObject) {
            super(xMLDataObject, new XMLEditorEnv(xMLDataObject));
            if (xMLDataObject.getPrimaryFile().getMIMEType().indexOf("xml") == -1) {
                this.setMIMEType(XMLDataObject.MIME);
            }
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            if (this.getDataObject().getCookie(SaveCookie.class) == null) {
                ((XMLDataObject)this.getDataObject()).addSaveCookie(new Save());
                this.getDataObject().setModified(true);
            }
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            SaveCookie saveCookie = this.getDataObject().getCookie(SaveCookie.class);
            if (saveCookie != null) {
                ((XMLDataObject)this.getDataObject()).removeSaveCookie(saveCookie);
                this.getDataObject().setModified(false);
            }
        }

        private static class XMLEditorEnv
        extends DataEditorSupport.Env {
            private static final long serialVersionUID = 6593415381104273008L;

            public XMLEditorEnv(DataObject dataObject) {
                super(dataObject);
            }

            protected FileObject getFile() {
                return this.getDataObject().getPrimaryFile();
            }

            protected FileLock takeLock() throws IOException {
                return ((XMLDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
            }

            public CloneableOpenSupport findCloneableOpenSupport() {
                return (CloneableOpenSupport)this.getDataObject().getCookie(EditorCookie.class);
            }
        }

        class Save
        implements SaveCookie {
            Save() {
            }

            public void save() throws IOException {
                XMLEditorSupport.this.saveDocument();
                XMLEditorSupport.this.getDataObject().setModified(false);
            }
        }
    }
}

