/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync.live;

import java.io.PrintWriter;
import org.netbeans.modules.visualweb.insync.ParserAnnotation;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.Unit;
import org.netbeans.modules.visualweb.insync.beans.BeansUnit;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.openide.filesystems.FileObject;

public class LiveUnitWrapper
implements Unit {
    protected FacesModel model;
    protected BeansUnit sourceUnit;
    protected FileObject file;
    protected LiveUnit liveUnit;

    public LiveUnitWrapper(FacesModel facesModel, BeansUnit beansUnit, FileObject fileObject) {
        this.model = facesModel;
        this.sourceUnit = beansUnit;
        this.file = fileObject;
    }

    public void destroy() {
        if (this.liveUnit != null) {
            this.liveUnit.destroy();
            this.liveUnit = null;
        }
        this.liveUnit = null;
    }

    public void dumpTo(PrintWriter printWriter) {
        if (this.liveUnit == null) {
            return;
        }
        this.liveUnit.dumpTo(printWriter);
    }

    protected LiveUnit getCurrentLiveUnit() {
        return this.liveUnit;
    }

    public ParserAnnotation[] getErrors() {
        return this.sourceUnit.getErrors();
    }

    public LiveUnit getLiveUnit() {
        if (this.liveUnit == null) {
            this.liveUnit = new LiveUnit(this.model, this.sourceUnit, this.file);
            this.liveUnit.sync();
        }
        return this.liveUnit;
    }

    public Unit.State getState() {
        return this.sourceUnit.getState();
    }

    public boolean isLiveUnitInstantiated() {
        return this.liveUnit != null;
    }

    public boolean isWriteLocked() {
        if (this.liveUnit == null) {
            return this.sourceUnit.isWriteLocked();
        }
        return this.liveUnit.isWriteLocked();
    }

    public void readLock() {
        if (this.liveUnit == null) {
            this.sourceUnit.readLock();
            return;
        }
        this.liveUnit.readLock();
    }

    public void readUnlock() {
        if (this.liveUnit == null) {
            this.sourceUnit.readUnlock();
            return;
        }
        this.liveUnit.readUnlock();
    }

    public boolean sync() {
        boolean bl = this.liveUnit == null ? this.sourceUnit.sync() : this.liveUnit.sync();
        return bl;
    }

    public void writeLock(UndoEvent undoEvent) {
        if (this.liveUnit == null) {
            this.sourceUnit.writeLock(undoEvent);
            return;
        }
        this.liveUnit.writeLock(undoEvent);
    }

    public boolean writeUnlock(UndoEvent undoEvent) {
        if (this.liveUnit == null) {
            return this.sourceUnit.writeUnlock(undoEvent);
        }
        return this.liveUnit.writeUnlock(undoEvent);
    }
}

