/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.visualweb.insync.Model;
import org.netbeans.modules.visualweb.insync.SourceUnit;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;

public class UndoManager
implements UndoRedo {
    private final ArrayList undoStack = new ArrayList();
    private final ArrayList undoStackRemoved = new ArrayList();
    private int current = 0;
    private UndoEvent currentEvent;
    private int depth = 0;
    private ArrayList listenerList = new ArrayList(3);

    public UndoEvent getCurrentEvent() {
        return this.currentEvent;
    }

    public UndoEvent startUndoableTask(String string, Model model) {
        UndoEvent undoEvent;
        if (this.currentEvent != null) {
            ++this.depth;
            return this.currentEvent;
        }
        this.undoStackRemoved.clear();
        if (this.canRedo()) {
            for (int i = this.undoStack.size() - 1; i >= this.current; --i) {
                this.undoStackRemoved.add(0, this.undoStack.remove(i));
            }
        }
        this.currentEvent = undoEvent = new UndoEvent(string, model);
        this.undoStack.add(undoEvent);
        ++this.current;
        ++this.depth;
        return undoEvent;
    }

    public void finishUndoableTask(UndoEvent undoEvent) {
        --this.depth;
        if (this.depth > 0) {
            return;
        }
        if (undoEvent != null) {
            if (this.currentEvent == undoEvent) {
                this.currentEvent = null;
            }
            if (!undoEvent.hasChanges() && this.current > 0) {
                if (this.current != this.undoStack.size() || undoEvent != this.undoStack.get(this.current - 1)) {
                    ErrorManager.getDefault().log("org.netbeans.modules.visualweb.insync.UndoManager.finishUndoableTask: current event is not last in undo stack");
                } else {
                    this.undoStack.remove(undoEvent);
                    this.undoStack.addAll(this.undoStackRemoved);
                }
                --this.current;
            }
        }
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = null;
        for (int i = this.listenerList.size() - 1; i >= 0; --i) {
            ChangeListener changeListener = (ChangeListener)this.listenerList.get(i);
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            changeListener.stateChanged(changeEvent);
        }
    }

    public void notifyBufferEdited(SourceUnit sourceUnit) {
        if (this.currentEvent == null) {
            this.clearStack();
        }
    }

    public void notifyUndoableEditEvent(SourceUnit sourceUnit) {
        if (this.currentEvent != null) {
            this.currentEvent.notifyBufferUpdated(sourceUnit);
        } else {
            ErrorManager.getDefault().log("Unexpected undoable event with no current event");
        }
    }

    private void clearStack() {
        if (this.undoStack.size() > 0) {
            this.undoStack.clear();
            this.current = 0;
            this.fireStateChanged();
        }
    }

    public boolean canRedo() {
        return this.current < this.undoStack.size();
    }

    public boolean canUndo() {
        return this.current > 0;
    }

    public String getRedoPresentationName() {
        if (this.canRedo()) {
            UndoEvent undoEvent = (UndoEvent)this.undoStack.get(this.current);
            return undoEvent.getDescription();
        }
        return "";
    }

    public String getUndoPresentationName() {
        if (this.canUndo()) {
            UndoEvent undoEvent = (UndoEvent)this.undoStack.get(this.current - 1);
            return undoEvent.getDescription();
        }
        return "";
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(changeListener);
    }

    public void undo() throws CannotUndoException {
        UndoEvent undoEvent;
        --this.current;
        this.currentEvent = undoEvent = (UndoEvent)this.undoStack.get(this.current);
        undoEvent.undo();
        this.currentEvent = null;
        this.syncModel(undoEvent);
        this.fireStateChanged();
    }

    public void redo() throws CannotRedoException {
        UndoEvent undoEvent;
        this.currentEvent = undoEvent = (UndoEvent)this.undoStack.get(this.current);
        undoEvent.redo();
        this.currentEvent = null;
        ++this.current;
        this.syncModel(undoEvent);
        this.fireStateChanged();
    }

    private void syncModel(UndoEvent undoEvent) {
        Model model = undoEvent.getModel();
        model.sync();
        FacesModel facesModel = (FacesModel)model;
        facesModel.getMarkupUnit().setClean();
        facesModel.getJavaUnit().setClean();
    }
}

