/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.insync;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Utilities;

public class ParserAnnotation
extends Annotation
implements PropertyChangeListener {
    public static final ParserAnnotation[] EMPTY_ARRAY = new ParserAnnotation[0];
    private FileObject fobj;
    private final String message;
    private final int line;
    private final int column;
    private Line docline;
    private ParserAnnotation chained;
    private Icon icon;

    public ParserAnnotation(String string, FileObject fileObject, int n, int n2) {
        this.fobj = fileObject;
        this.message = string;
        this.line = n;
        this.column = n2;
    }

    public String getAnnotationType() {
        return "source-error";
    }

    public String getShortDescription() {
        if (this.chained != null) {
            return this.message + "\n\n" + this.chained.getShortDescription();
        }
        return this.message;
    }

    public FileObject getFileObject() {
        return this.fobj;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        return this.message;
    }

    public Icon getIcon() {
        Image image;
        if (this.icon == null && (image = Utilities.loadImage((String)"org/netbeans/modules/visualweb/insync/error-glyph.gif")) != null) {
            this.icon = image instanceof Icon ? (Icon)((Object)image) : new ImageIcon(image);
        }
        return this.icon;
    }

    public void chain(ParserAnnotation parserAnnotation) {
        if (this.chained != null) {
            this.chained.chain(parserAnnotation);
        } else {
            this.chained = parserAnnotation;
        }
    }

    protected void notifyAttached(Annotatable annotatable) {
        super.notifyAttached(annotatable);
        this.docline.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void notifyDetached(Annotatable annotatable) {
        super.notifyDetached(annotatable);
        this.docline.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void attachToLineSet(Line.Set set) {
        int n;
        this.docline = set.getCurrent(this.line - 1);
        char[] cArray = this.docline.getText().toCharArray();
        int n2 = cArray.length - 1;
        for (n = 0; n <= n2 && cArray[n] <= ' '; ++n) {
        }
        while (n <= n2 && cArray[n2] <= ' ') {
            --n2;
        }
        Line.Part part = n <= n2 ? this.docline.createPart(n, n2 - n + 1) : this.docline.createPart(0, cArray.length);
        this.attach((Annotatable)part);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null || string == "text") {
            this.detach();
        }
    }

    public String toString() {
        return "ParserAnnotation[" + this.fobj + "," + this.line + ":" + this.message + "]";
    }
}

