/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.server;

import com.tomsawyer.service.TSRMIService;
import com.tomsawyer.service.ds;
import com.tomsawyer.service.server.TSRMIHelper;
import com.tomsawyer.util.TSLicenseManager;
import java.io.PrintStream;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Hashtable;

public class TSRMIServiceImp
extends UnicastRemoteObject
implements TSRMIService {
    String serverName;
    boolean verbose = false;
    String host;
    Hashtable inBox = new Hashtable(10, 0.9f);
    Hashtable outBox = new Hashtable(10, 0.9f);
    static int idSeed = 0;
    ds serviceName = null;

    public TSRMIServiceImp(String[] stringArray) throws RemoteException {
        try {
            this.host = InetAddress.getLocalHost().getHostName() + ":1099";
        }
        catch (java.net.UnknownHostException unknownHostException) {
            throw new UnknownHostException(unknownHostException.getMessage());
        }
        this.serverName = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.charAt(0) == '-') {
                if ("-verbose".equals(string)) {
                    this.verbose = true;
                    continue;
                }
                if ("-host".equals(string)) {
                    if (i + 1 >= stringArray.length) continue;
                    this.host = stringArray[++i];
                    continue;
                }
                if ("-help".equals(string)) {
                    this.printHelpMessage(System.out);
                    System.exit(0);
                    continue;
                }
                System.out.println("Unrecognized parameter " + string);
                continue;
            }
            this.serverName = string;
        }
    }

    public TSRMIServiceImp(String[] stringArray, int n) throws RemoteException {
        super(n);
        try {
            this.host = InetAddress.getLocalHost().getHostName() + ":1099";
        }
        catch (java.net.UnknownHostException unknownHostException) {
            throw new UnknownHostException(unknownHostException.getMessage());
        }
        this.serverName = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.charAt(0) == '-') {
                if ("-verbose".equals(string)) {
                    this.verbose = true;
                    continue;
                }
                if ("-host".equals(string)) {
                    if (i + 1 >= stringArray.length) continue;
                    this.host = stringArray[++i];
                    continue;
                }
                if ("-serviceport".equals(string)) continue;
                if ("-help".equals(string)) {
                    this.printHelpMessage(System.out);
                    System.exit(0);
                    continue;
                }
                System.out.println("Unrecognized parameter " + string);
                continue;
            }
            this.serverName = string;
        }
    }

    public void setServiceName(ds ds2) {
        this.serviceName = ds2;
    }

    public ds getServiceName() {
        return this.serviceName;
    }

    protected void printHelpMessage(PrintStream printStream) {
        printStream.println("Use: java -Djava.security.policy=\"Service.policy\" com.tomsawyer.service.server.TSRMIServiceImp [-verbose] [-host HOST] ServerName");
        printStream.println();
        printStream.println("\t-verbose:\tRequest detailed log of server activities.");
        printStream.println("\t\t\tBy default the server operates in the quiet mode.");
        printStream.println("\t-host:\t\tRequest the server to bind to the specified host.");
        printStream.println("\t\t\tBy default the server binds to the local host on port 1099.");
        printStream.println("\tServerName:\tThe name used by clients when binding to this server.");
    }

    public synchronized String fetchData(Integer n) {
        String string = (String)this.inBox.get(n);
        this.report("Graph Manager data " + n + " fetched at " + new Date(System.currentTimeMillis()));
        this.inBox.put(n, new Long(System.currentTimeMillis()));
        return string;
    }

    public synchronized void storeData(Integer n, String string) {
        this.report("Graph Manager data " + n + " deposited at " + new Date(System.currentTimeMillis()));
        this.outBox.put(n, string);
        this.notifyAll();
    }

    public synchronized void waitForID(Integer n) {
        while (!this.outBox.containsKey(n)) {
            this.report("Request " + n + " suspended at " + new Date(System.currentTimeMillis()));
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.report("Request " + n + " ready at " + new Date(System.currentTimeMillis()));
        this.report(null);
    }

    public Integer getID() throws RemoteException {
        return new Integer(idSeed++);
    }

    public void store(Integer n, String string) throws RemoteException {
        this.report("Client data received at " + new Date(System.currentTimeMillis()));
        this.inBox.put(n, string);
        TSRMIHelper tSRMIHelper = this.getServerHelper(n);
        Thread thread = new Thread(tSRMIHelper);
        thread.setDaemon(true);
        thread.start();
    }

    public TSRMIHelper getServerHelper(Integer n) {
        return new TSRMIHelper(this, n);
    }

    public String fetch(Integer n) throws RemoteException {
        this.report("Client data requested at " + new Date(System.currentTimeMillis()));
        if (!this.outBox.containsKey(n)) {
            if (!this.inBox.containsKey(n)) {
                throw new RemoteException("Unknown ID: " + n);
            }
            this.waitForID(n);
            if (!this.outBox.containsKey(n)) {
                throw new RemoteException("Missing data for ID: " + n);
            }
        }
        String string = (String)this.outBox.get(n);
        this.inBox.remove(n);
        this.outBox.remove(n);
        return string;
    }

    public String getName() {
        return this.serverName;
    }

    public void report(String string) {
        this.report(System.out, string);
    }

    public void report(PrintStream printStream, String string) {
        if (this.isVerbose()) {
            if (string == null || string.length() <= 0) {
                printStream.println();
            } else {
                printStream.println(this.getName() + ": " + string);
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-serviceport".equals(stringArray[i])) continue;
            n = Integer.parseInt(stringArray[++i]);
            break;
        }
        TSLicenseManager.initTSSLicensing();
        try {
            TSRMIServiceImp tSRMIServiceImp = System.getProperty("java.version").charAt(2) >= '2' ? new TSRMIServiceImp(stringArray, n) : new TSRMIServiceImp(stringArray);
            System.out.println("Binding to " + tSRMIServiceImp.getHost());
            Naming.rebind("//" + tSRMIServiceImp.getHost() + "/" + tSRMIServiceImp.getName(), tSRMIServiceImp);
            tSRMIServiceImp.report("bound in registry");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

