/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout.jlayout;

import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.layout.TSSingleNodeListLayoutConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasDirectionConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasSpacingConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;

public class TSSequenceConstraint
extends TSSingleNodeListLayoutConstraint
implements TSHasSpacingConstraint,
TSHasDirectionConstraint {
    private int direction;
    private double spacing = 40.0;

    public TSSequenceConstraint() {
        this(-1, 0, 0);
    }

    public TSSequenceConstraint(int n, int n10, int n11) {
        super(n, n10);
        this.direction = n11;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        if (n != 0 && n != 2 && n != 1 && n != 3) {
            throw new RuntimeException("Invalid argument.");
        }
        int n10 = this.direction;
        this.direction = n;
        if (n10 != n) {
            this.fireConstraintChangedEvent();
        }
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double d) {
        double d2 = this.spacing;
        this.spacing = d;
        if (d2 != d) {
            this.fireConstraintChangedEvent();
        }
    }

    public boolean checkValidity() {
        return this.getNodeList().size() >= 2 && super.checkValidity();
    }

    public TSConstraint cloneWithAttributes() {
        TSSequenceConstraint tSSequenceConstraint = new TSSequenceConstraint(this.getStyle(), this.getPriority(), this.getDirection());
        tSSequenceConstraint.setSpacing(this.getSpacing());
        return tSSequenceConstraint;
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        if (tSConstraint instanceof TSSequenceConstraint) {
            this.direction = ((TSSequenceConstraint)tSConstraint).getDirection();
            this.spacing = ((TSSequenceConstraint)tSConstraint).getSpacing();
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("direction");
        this.setDirection(tSParser.getInt());
        tSParser.parseInputString("spacing");
        this.setSpacing(tSParser.getDouble());
    }
}

