/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout;

import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.TSHasNodesConstraint;
import com.tomsawyer.service.dk;
import com.tomsawyer.service.layout.TSLayoutConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class TSTwoNodeListsLayoutConstraint
extends TSLayoutConstraint
implements TSHasNodesConstraint {
    private dk firstNodes = new dk();
    private dk secondNodes = new dk();

    public TSTwoNodeListsLayoutConstraint() {
        this(-1, 0);
    }

    public TSTwoNodeListsLayoutConstraint(int n, int n10) {
        super(n, n10);
    }

    public List getFirstNodeList() {
        return Collections.unmodifiableList(this.firstNodes);
    }

    public List getSecondNodeList() {
        return Collections.unmodifiableList(this.secondNodes);
    }

    public void addNodeToFirstList(TSDNode tSDNode) {
        if (this.firstNodes.add(tSDNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void addNodeToSecondList(TSDNode tSDNode) {
        if (this.secondNodes.add(tSDNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void addNodeToFirstList(int n, TSDNode tSDNode) {
        this.firstNodes.add(n, tSDNode);
        this.fireConstraintChangedEvent();
    }

    public void addNodeToSecondList(int n, TSDNode tSDNode) {
        this.secondNodes.add(n, tSDNode);
        this.fireConstraintChangedEvent();
    }

    public void removeNode(TSNode tSNode) {
        this.onNodeDiscarded(tSNode);
    }

    public void onNodeRemoved(TSNode tSNode) {
        boolean bl = false;
        bl = this.firstNodes.remove(tSNode);
        if (bl |= this.secondNodes.remove(tSNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void removeNodeFromFirstList(TSDNode tSDNode) {
        if (this.firstNodes.remove(tSDNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void removeNodeFromSecondList(TSDNode tSDNode) {
        if (this.secondNodes.remove(tSDNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void onNodeInserted(TSNode tSNode) {
        boolean bl = false;
        if (this.firstNodes.c(tSNode)) {
            this.firstNodes.a(tSNode);
            bl = true;
        }
        if (this.secondNodes.c(tSNode)) {
            this.secondNodes.a(tSNode);
            bl = true;
        }
        if (bl) {
            this.fireConstraintChangedEvent();
        }
    }

    public void onNodeDiscarded(TSNode tSNode) {
        boolean bl = false;
        bl = this.firstNodes.b(tSNode);
        if (bl |= this.secondNodes.b(tSNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public boolean checkValidity() {
        TSDNode tSDNode;
        boolean bl;
        boolean bl2 = bl = this.firstNodes.size() > 0 && this.secondNodes.size() > 0;
        if (bl && (this.firstNodes.contains(null) || this.secondNodes.contains(null))) {
            bl = false;
        }
        Object object = this.firstNodes.iterator();
        while (object.hasNext() && bl) {
            tSDNode = (TSDNode)object.next();
            if (tSDNode.isOwned()) continue;
            bl = false;
        }
        object = this.secondNodes.iterator();
        while (object.hasNext() && bl) {
            tSDNode = (TSDNode)object.next();
            if (tSDNode.isOwned()) continue;
            bl = false;
        }
        if (bl) {
            object = new HashSet(this.firstNodes);
            object.addAll(this.secondNodes);
            bl = object.size() == this.firstNodes.size() + this.secondNodes.size();
        }
        return bl;
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        this.firstNodes = new dk();
        this.secondNodes = new dk();
        if (tSConstraint instanceof TSTwoNodeListsLayoutConstraint) {
            TSDNode tSDNode;
            Iterator iterator = ((TSTwoNodeListsLayoutConstraint)tSConstraint).getFirstNodeList().iterator();
            while (iterator.hasNext()) {
                tSDNode = (TSDNode)iterator.next();
                if (tSDNode.getUtilityObject() instanceof TSDNode) {
                    this.firstNodes.add(tSDNode.getUtilityObject());
                    continue;
                }
                this.firstNodes.add(tSDNode);
            }
            iterator = ((TSTwoNodeListsLayoutConstraint)tSConstraint).getSecondNodeList().iterator();
            while (iterator.hasNext()) {
                tSDNode = (TSDNode)iterator.next();
                if (tSDNode.getUtilityObject() instanceof TSDNode) {
                    this.secondNodes.add(tSDNode.getUtilityObject());
                    continue;
                }
                this.secondNodes.add(tSDNode);
            }
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        int n;
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("firstList");
        tSParser.parseOpenBracket();
        while (tSParser.getString().equals("node")) {
            n = tSParser.getInt();
            this.firstNodes.add(tSGraphObjectTable.get((long)n));
        }
        tSParser.pushBack();
        tSParser.parseCloseBracket();
        tSParser.parseInputString("secondList");
        tSParser.parseOpenBracket();
        while (tSParser.getString().equals("node")) {
            n = tSParser.getInt();
            this.secondNodes.add(tSGraphObjectTable.get((long)n));
        }
        tSParser.pushBack();
        tSParser.parseCloseBracket();
        this.setValid(this.checkValidity());
    }
}

