/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.ide;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.bpel.project.anttasks.ide.IdeBpelCatalogModel;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class IdeValidateBpelProjectTask
extends Task {
    private String mSourceDirectory;
    private String mProjectClassPath;
    private String mBuildDirectory;
    private String mBuildDependentProjectFilesDirectory;
    private File mSourceDir;
    private File mBuildDir;
    private Map mBpelFileNamesToFileInBuildDir = new HashMap();
    private boolean isFoundErrors = false;
    private boolean mAllowBuildWithError = false;
    private Logger logger = Logger.getLogger(IdeValidateBpelProjectTask.class.getName());
    private List<BPELFile> myBPELFiles;

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public void setRunValidation(String flag) {
        this.setAllowBuildWithError(flag);
        this.mAllowBuildWithError = !this.mAllowBuildWithError;
    }

    public void setAllowBuildWithError(String flag) {
        if (flag != null) {
            if (flag.equals("false")) {
                this.mAllowBuildWithError = false;
            } else if (flag.equals("true")) {
                this.mAllowBuildWithError = true;
            }
        }
    }

    public void setClasspathRef(Reference ref) {
    }

    public void setProjectClassPath(String projectClassPath) {
        this.mProjectClassPath = projectClassPath;
    }

    public void setBuildDependentProjectDir(String dependentProjectFilesDir) {
        this.mBuildDependentProjectFilesDirectory = dependentProjectFilesDir;
    }

    public boolean isFoundErrors() {
        return this.isFoundErrors;
    }

    public void execute() throws BuildException {
        if (this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for source files.");
        }
        if (this.mBuildDirectory == null) {
            throw new BuildException("No build directory is set.");
        }
        if (this.mBuildDependentProjectFilesDirectory == null) {
            throw new BuildException("No dependentProjectFiles directory is set.");
        }
        try {
            this.mSourceDir = new File(this.mSourceDirectory);
            CommandlineBpelProjectXmlCatalogProvider.getInstance().setSourceDirectory(this.mSourceDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project source directory " + this.mSourceDirectory, (Throwable)ex);
        }
        try {
            this.mBuildDir = new File(this.mBuildDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project build directory " + this.mBuildDirectory, (Throwable)ex);
        }
        this.myBPELFiles = new ArrayList<BPELFile>();
        this.processBpelFilesFolderInBuildDir(this.mBuildDir);
        this.processSourceDirs(Arrays.asList(this.mSourceDir));
    }

    private void processBpelFilesFolderInBuildDir(File folder) {
        File[] files = folder.listFiles(new Util.BpelFileFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                this.processBpelFilesInBuildDir(file);
                continue;
            }
            this.processBpelFilesFolderInBuildDir(file);
        }
    }

    private void processBpelFilesInBuildDir(File bpelFile) {
        String relativePath = Util.getRelativePath(this.mBuildDir, bpelFile);
        this.mBpelFileNamesToFileInBuildDir.put(relativePath, bpelFile);
    }

    private void processSourceDirs(List sourceDirs) {
        for (File sourceDir : sourceDirs) {
            this.processSourceDir(sourceDir);
        }
    }

    private void processSourceDir(File sourceDir) {
        this.processFileObject(sourceDir);
    }

    private void processFileObject(File file) {
        if (file.isDirectory()) {
            this.processFolder(file);
        }
    }

    private void processFolder(File fileDir) {
        File[] bpelFiles = fileDir.listFiles(new Util.BpelFileFilter());
        this.processBpelFiles(bpelFiles);
    }

    private void processBpelFiles(File[] bpelFiles) {
        for (int i = 0; i < bpelFiles.length; ++i) {
            if (bpelFiles[i].isFile()) {
                this.processBpelFile(bpelFiles[i]);
                continue;
            }
            this.processFolder(bpelFiles[i]);
        }
    }

    private void processBpelFile(File file) throws BuildException {
        BpelModel model = null;
        try {
            model = IdeBpelCatalogModel.getDefault().getBPELModel(file);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to get BPEL Model", e);
        }
        Process process = model.getProcess();
        if (process != null) {
            String qName = process.getName() + ", " + process.getTargetNamespace();
            BPELFile current = new BPELFile(file, this.mSourceDir, qName);
            for (BPELFile bpel : this.myBPELFiles) {
                if (!bpel.getQName().equals(qName) || this.mAllowBuildWithError) continue;
                throw new BuildException(" \nBPEL files " + bpel.getName() + " and " + current.getName() + "\n" + "have the same bpel process name and targetname space:\n" + qName + " \n \n");
            }
            this.myBPELFiles.add(current);
        }
        if (this.isBpelFileModified(file)) {
            this.loadAndValidateExistingBusinessProcess(file);
        }
    }

    private boolean isBpelFileModified(File bpelFile) {
        boolean modified = true;
        String relativePath = Util.getRelativePath(this.mSourceDir, bpelFile);
        File bpelFileInBuildDir = (File)this.mBpelFileNamesToFileInBuildDir.get(relativePath);
        if (bpelFileInBuildDir != null && bpelFileInBuildDir.lastModified() == bpelFile.lastModified()) {
            modified = false;
        }
        return modified;
    }

    private void validateBPEL(File bpel) throws BuildException {
        BpelModel model = null;
        try {
            model = IdeBpelCatalogModel.getDefault().getBPELModel(bpel);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to create BPEL Model", e);
        }
        Validation validation = new Validation();
        validation.validate((Model)model, Validation.ValidationType.COMPLETE);
        List col = validation.getValidationResult();
        boolean isError = false;
        for (Validator.ResultItem resultItem : col) {
            System.err.println(this.getValidationError(bpel, resultItem));
            System.err.println();
            if (resultItem.getType() != Validator.ResultType.ERROR) continue;
            isError = true;
        }
        if (isError) {
            throw new BuildException("Found validation error(s).");
        }
    }

    private String getValidationError(File bpelFile, Validator.ResultItem resultItem) {
        int lineNumber = 0;
        int columnNumber = 0;
        String errorDescription = resultItem.getDescription();
        String msgType = resultItem.getType().name();
        Component component = resultItem.getComponents();
        FileObject fileObj = null;
        File file = null;
        if (component == null) {
            columnNumber = resultItem.getColumnNumber();
            lineNumber = resultItem.getLineNumber();
            fileObj = (FileObject)resultItem.getModel().getModelSource().getLookup().lookup(FileObject.class);
        } else {
            lineNumber = Util.getLineNumber(component);
            columnNumber = Util.getColumnNumber(component);
            fileObj = (FileObject)component.getModel().getModelSource().getLookup().lookup(FileObject.class);
        }
        if (fileObj != null) {
            file = FileUtil.toFile((FileObject)fileObj);
        }
        return Util.getError(file, columnNumber, lineNumber, errorDescription, msgType);
    }

    private void loadAndValidateExistingBusinessProcess(File bpelFile) throws BuildException {
        block2: {
            try {
                this.validateBPEL(bpelFile);
            }
            catch (Throwable ex) {
                if (this.mAllowBuildWithError) break block2;
                StringWriter writer = new StringWriter();
                PrintWriter pWriter = new PrintWriter(writer);
                throw new BuildException(ex);
            }
        }
    }

    private static class BPELFile {
        private File myFile;
        private File myProject;
        private String myQName;

        public BPELFile(File file, File project, String qName) {
            this.myFile = file;
            this.myProject = project;
            this.myQName = qName;
        }

        public String getQName() {
            return this.myQName;
        }

        public String getName() {
            String path;
            String file = this.myFile.toString();
            if (file.startsWith(path = this.myProject.toString())) {
                return file.substring(path.length() + 1);
            }
            return file;
        }
    }
}

