/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.cli;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.project.CommandlineBpelProjectXmlCatalogProvider;
import org.netbeans.modules.bpel.project.anttasks.cli.CliBpelCatalogModel;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;

public class CliValidateBpelProjectDelegate
extends Task {
    private String mSourceDirectory;
    private String mProjectClassPath;
    private String mBuildDirectory;
    private String mBuildDependentProjectFilesDirectory;
    private File mSourceDir;
    private File mBuildDir;
    private Map mBpelFileNamesToFileInBuildDir = new HashMap();
    private boolean isFoundErrors = false;
    private boolean mAllowBuildWithError = false;

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public void setRunValidation(String flag) {
        this.setAllowBuildWithError(flag);
        this.mAllowBuildWithError = !this.mAllowBuildWithError;
    }

    public void setAllowBuildWithError(String flag) {
        if (flag != null) {
            if (flag.equals("false")) {
                this.mAllowBuildWithError = false;
            } else if (flag.equals("true")) {
                this.mAllowBuildWithError = true;
            }
        }
    }

    public void setClasspathRef(Reference ref) {
    }

    public void setProjectClassPath(String projectClassPath) {
        this.mProjectClassPath = projectClassPath;
    }

    public void setBuildDependentProjectDir(String dependentProjectFilesDir) {
        this.mBuildDependentProjectFilesDirectory = dependentProjectFilesDir;
    }

    public boolean isFoundErrors() {
        return this.isFoundErrors;
    }

    public void execute() throws BuildException {
        if (this.mSourceDirectory == null) {
            throw new BuildException("No directory is set for source files.");
        }
        if (this.mBuildDirectory == null) {
            throw new BuildException("No build directory is set.");
        }
        if (this.mBuildDependentProjectFilesDirectory == null) {
            throw new BuildException("No dependentProjectFiles directory is set.");
        }
        try {
            this.mSourceDir = new File(this.mSourceDirectory);
            CommandlineBpelProjectXmlCatalogProvider.getInstance().setSourceDirectory(this.mSourceDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project source directory " + this.mSourceDirectory, (Throwable)ex);
        }
        try {
            this.mBuildDir = new File(this.mBuildDirectory);
        }
        catch (Exception ex) {
            throw new BuildException("Failed to get File object for project build directory " + this.mBuildDirectory, (Throwable)ex);
        }
        this.processBuildDir(this.mBuildDir);
        this.processSourceDir(this.mSourceDir);
    }

    private void processBuildDir(File folder) {
        File[] files = folder.listFiles(new Util.BpelFileFilter());
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isFile()) {
                this.mBpelFileNamesToFileInBuildDir.put(Util.getRelativePath(this.mBuildDir, file), file);
                continue;
            }
            this.processBuildDir(file);
        }
    }

    private void processSourceDir(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles(new Util.BpelFileFilter());
            if (children == null) {
                return;
            }
            for (int i = 0; i < children.length; ++i) {
                this.processSourceDir(children[i]);
            }
        } else if (this.isModified(file)) {
            this.validate(file);
        }
    }

    private boolean isModified(File bpelFile) {
        boolean modified = true;
        String relativePath = Util.getRelativePath(this.mSourceDir, bpelFile);
        File bpelFileInBuildDir = (File)this.mBpelFileNamesToFileInBuildDir.get(relativePath);
        if (bpelFileInBuildDir != null && bpelFileInBuildDir.lastModified() == bpelFile.lastModified()) {
            modified = false;
        }
        return modified;
    }

    private void validate(File bpelFile) throws BuildException {
        block5: {
            try {
                BpelModel model = CliBpelCatalogModel.getDefault().getBPELModel(bpelFile.toURI());
                Validation validation = new Validation();
                validation.validate((Model)model, Validation.ValidationType.COMPLETE);
                List col = validation.getValidationResult();
                boolean isError = false;
                for (Validator.ResultItem resultItem : col) {
                    if (!this.mAllowBuildWithError && resultItem.getType() == Validator.ResultType.ERROR) {
                        System.out.println(this.getValidationError(resultItem));
                        System.out.println();
                    }
                    if (resultItem.getType() != Validator.ResultType.ERROR) continue;
                    isError = true;
                }
                if (isError) {
                    this.isFoundErrors = true;
                }
            }
            catch (Throwable e) {
                if (this.mAllowBuildWithError) break block5;
                throw new BuildException(e);
            }
        }
    }

    private String getValidationError(Validator.ResultItem resultItem) {
        int lineNumber = 0;
        int columnNumber = 0;
        String errorDescription = resultItem.getDescription();
        String msgType = resultItem.getType().name();
        Component component = resultItem.getComponents();
        File file = null;
        if (component == null) {
            columnNumber = resultItem.getColumnNumber();
            lineNumber = resultItem.getLineNumber();
            file = (File)resultItem.getModel().getModelSource().getLookup().lookup(File.class);
        } else {
            lineNumber = Util.getLineNumber(component);
            columnNumber = Util.getColumnNumber(component);
            file = (File)component.getModel().getModelSource().getLookup().lookup(File.class);
        }
        return Util.getError(file, columnNumber, lineNumber, errorDescription, msgType);
    }
}

