/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringElement;
import org.netbeans.modules.apisupport.refactoring.AbstractRefactoringPlugin;
import org.netbeans.modules.apisupport.refactoring.RetoucheUtils;
import org.netbeans.modules.apisupport.refactoring.Utility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NbMoveRefactoringPlugin
extends AbstractRefactoringPlugin {
    protected static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.refactoring");
    private static ThreadLocal semafor = new ThreadLocal();
    private Collection manifestRefactorings;
    private boolean firstManifestRefactoring = true;
    private HashMap oldManifests;
    private EditableManifest targetManifest;
    private Map packagePostfix = new HashMap();
    ArrayList<FileObject> filesToMove = new ArrayList();
    HashMap<FileObject, ElementHandle> classes;

    public NbMoveRefactoringPlugin(MoveRefactoring moveRefactoring) {
        super((AbstractRefactoring)moveRefactoring);
        this.manifestRefactorings = new ArrayList();
        this.oldManifests = new HashMap();
        this.setup(moveRefactoring.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public NbMoveRefactoringPlugin(RenameRefactoring renameRefactoring) {
        super((AbstractRefactoring)renameRefactoring);
        FileObject fileObject = (FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject != null) {
            this.setup(Collections.singletonList(fileObject), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)renameRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (semafor.get() != null) {
            return null;
        }
        semafor.set(new Object());
        Problem problem = null;
        try {
            this.initClasses();
            Object var3_3 = null;
            Object var4_5 = null;
            Object var5_6 = null;
            Object var6_7 = null;
            Lookup lookup = this.refactoring.getRefactoringSource();
            TreePathHandle treePathHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class);
            if (treePathHandle != null) {
                AbstractRefactoringPlugin.InfoHolder infoHolder = this.examineLookup(lookup);
                Project project = FileOwnerQuery.getOwner((FileObject)treePathHandle.getFileObject());
                if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
                    Problem problem2 = null;
                    return problem2;
                }
                if (infoHolder.isClass) {
                    this.checkManifest(project, infoHolder.fullName, refactoringElementsBag);
                    this.checkMetaInfServices(project, infoHolder.fullName, refactoringElementsBag);
                    this.checkLayer(project, infoHolder.fullName, refactoringElementsBag);
                }
                if (infoHolder.isMethod) {
                    this.checkMethodLayer(infoHolder, treePathHandle.getFileObject(), refactoringElementsBag);
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            semafor.set(null);
        }
        return problem;
    }

    protected RefactoringElementImplementation createMetaInfServicesRefactoring(String string, FileObject fileObject, int n) {
        return null;
    }

    protected RefactoringElementImplementation createManifestRefactoring(String string, FileObject fileObject, String string2, String string3, String string4) {
        return null;
    }

    protected final String[] loadMetaInfServices(Project project) {
        FileObject fileObject = Utility.findMetaInfServices(project);
        if (fileObject == null) {
            return new String[0];
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        String[] stringArray = new String[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            stringArray[i] = Utility.readFileIntoString(fileObjectArray[i]);
        }
        return stringArray;
    }

    private static String findPackageName(Project project, FileObject fileObject) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject) || !sourceGroupArray[i].contains(fileObject)) continue;
            return FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
        }
        return null;
    }

    private static FileObject createMetaInf(Project project) throws IOException {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("resources");
        if (sourceGroupArray == null) {
            sourceGroupArray = sources.getSourceGroups("java");
        }
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject = sourceGroupArray[i].getRootFolder().getFileObject("META-INF");
            if (fileObject == null) continue;
            return fileObject.createFolder("services");
        }
        return sourceGroupArray[0].getRootFolder().createFolder("META-INF").createFolder("services");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EditableManifest readManifest(FileObject fileObject) {
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            EditableManifest editableManifest = new EditableManifest(inputStream);
            return editableManifest;
        }
        catch (IOException iOException) {
            err.notify((Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    err.notify((Throwable)iOException);
                }
            }
        }
        return new EditableManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeManifest(FileObject fileObject, EditableManifest editableManifest) {
        OutputStream outputStream = null;
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            editableManifest.write(outputStream);
        }
        catch (IOException iOException) {
            err.notify((Throwable)iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    err.notify((Throwable)iOException);
                }
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    private void setup(Collection collection, String string, boolean bl) {
        for (FileObject fileObject : collection) {
            if (RetoucheUtils.isJavaFile(fileObject)) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                this.filesToMove.add(fileObject);
                continue;
            }
            if (!fileObject.isFolder()) {
                this.packagePostfix.put(fileObject, string.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fileObject)) continue;
            boolean bl2 = !"".equals(string);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                arrayList.add(fileObject2);
            }
            if (!bl) continue;
            this.setup(arrayList, string + (bl2 ? "." : "") + fileObject.getName(), true);
        }
    }

    String getNewPackageName() {
        if (this.refactoring instanceof MoveRefactoring) {
            return RetoucheUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
        }
        return ((RenameRefactoring)this.refactoring).getNewName();
    }

    String getTargetPackageName(FileObject fileObject) {
        if (this.refactoring instanceof RenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject fileObject2 = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
            FileObject fileObject3 = classPath.findOwnerRoot(fileObject2);
            String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2.getParent()).replace('/', '.');
            String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject.getParent()).replace('/', '.');
            String string3 = this.concat(string, this.getNewPackageName(), string2);
            return string3;
        }
        if (this.packagePostfix != null) {
            String string = (String)this.packagePostfix.get(fileObject);
            String string4 = this.concat(null, this.getNewPackageName(), string);
            return string4;
        }
        return this.getNewPackageName();
    }

    private String concat(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && !"".equals(string)) {
            string4 = string4 + string + ".";
        }
        string4 = string4 + string2;
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + ("".equals(string4) ? "" : ".") + string3;
        }
        return string4;
    }

    private void initClasses() {
        this.classes = new HashMap();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            final int n = i;
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> list = compilationController.getCompilationUnit().getTypeDecls();
                        for (Tree tree : list) {
                            if (tree.getKind() != Tree.Kind.CLASS || !((ClassTree)tree).getSimpleName().toString().equals(NbMoveRefactoringPlugin.this.filesToMove.get(n).getName())) continue;
                            NbMoveRefactoringPlugin.this.classes.put(NbMoveRefactoringPlugin.this.filesToMove.get(n), ElementHandle.create((Element)compilationController.getTrees().getElement(TreePath.getPath(compilationController.getCompilationUnit(), tree))));
                            return;
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public final class ServicesMoveRefactoringElement
    extends AbstractRefactoringElement {
        private String clazz;
        private String oldName;
        private Project project;

        public ServicesMoveRefactoringElement(String string, FileObject fileObject, Project project) {
            this.parentFile = fileObject;
            this.clazz = string;
            this.oldName = string;
            this.project = project;
        }

        public String getDisplayText() {
            return NbBundle.getMessage(NbMoveRefactoringPlugin.class, (String)"TXT_ServicesRename", (Object)this.name);
        }

        public void performChange() {
        }
    }

    public final class ManifestMoveRefactoringElement
    extends AbstractRefactoringElement {
        private String clazz;
        private String attrName;
        private String sectionName = null;
        private FileObject movedFile = null;

        public ManifestMoveRefactoringElement(String string, FileObject fileObject, String string2, String string3) {
            this.name = string2;
            this.clazz = string;
            this.parentFile = fileObject;
            this.attrName = string3;
        }

        public ManifestMoveRefactoringElement(String string, FileObject fileObject, String string2, String string3, String string4) {
            this(string, fileObject, string2, string3);
            this.sectionName = string4;
        }

        public ManifestMoveRefactoringElement(FileObject fileObject, String string, String string2, FileObject fileObject2) {
            this.name = string;
            this.parentFile = fileObject;
            this.attrName = string2;
            this.movedFile = fileObject2;
        }

        public String getDisplayText() {
            if (this.sectionName != null) {
                return NbBundle.getMessage(NbMoveRefactoringPlugin.class, (String)"TXT_ManifestSectionRename", (Object)this.name, (Object)this.sectionName);
            }
            return NbBundle.getMessage(NbMoveRefactoringPlugin.class, (String)"TXT_ManifestRename", (Object)this.name, (Object)this.attrName);
        }

        public void performChange() {
        }
    }
}

