/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class GlyphGutter
extends JComponent
implements Annotations.AnnotationsListener,
Accessible,
SettingsChangeListener,
SideBarFactory {
    private EditorUI editorUI;
    private BaseDocument document;
    private Annotations annos;
    private Image gutterButton;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight;
    private boolean init;
    private int glyphGutterWidth;
    private static final int glyphWidth = 16;
    private static final int glyphButtonWidth = 9;
    private static final int leftGap = 10;
    private static final int rightGap = 4;
    private boolean showLineNumbers = true;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private boolean drawOverLineNumbers = false;
    private int cachedCountOfAnnos = -1;
    private int cachedCountOfAnnosForLine = -1;
    private PropertyChangeListener annoTypesListener;
    private PropertyChangeListener editorUIListener;
    private GlyphGutterFoldHierarchyListener glyphGutterFoldHierarchyListener;
    private GutterMouseListener gutterMouseListener;
    private FoldHierarchy foldHierarchy;
    private volatile Map renderingHints = null;

    public GlyphGutter() {
    }

    public GlyphGutter(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.init = false;
        this.document = editorUI.getDocument();
        this.annos = this.document.getAnnotations();
        this.annos.addAnnotationsListener(this);
        this.init();
        this.update();
        Settings.addSettingsChangeListener(this);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)editorUI.getComponent());
        this.glyphGutterFoldHierarchyListener = new GlyphGutterFoldHierarchyListener();
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this.glyphGutterFoldHierarchyListener);
        this.editorUIListener = new EditorUIListener();
        editorUI.addPropertyChangeListener(this.editorUIListener);
        this.setOpaque(true);
    }

    private Map getRenderingHints() {
        if (this.renderingHints == null) {
            Object object = null;
            JTextComponent jTextComponent = this.editorUI.getComponent();
            if (jTextComponent != null && (object = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
                object = Settings.getValue(Utilities.getKitClass(jTextComponent), "rendering-hints");
            }
            this.renderingHints = object instanceof Map ? object : Collections.EMPTY_MAP;
        }
        return this.renderingHints;
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        if (this.editorUI == null) {
            return;
        }
        final JTextComponent jTextComponent = this.editorUI.getComponent();
        if (settingsChangeEvent == null || jTextComponent == null) {
            return;
        }
        String string = settingsChangeEvent.getSettingName();
        if (string == null || "rendering-hints".equals(string)) {
            this.renderingHints = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Rectangle rectangle = jTextComponent.getVisibleRect();
                if (rectangle != null) {
                    GlyphGutter.this.resize();
                }
            }
        });
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        if (this.editorUI == null) {
            return;
        }
        this.gutterButton = org.openide.util.Utilities.loadImage((String)"org/netbeans/editor/resources/glyphbutton.gif");
        this.setToolTipText("");
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(BaseKit.class).getString("ACSN_Glyph_Gutter"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(BaseKit.class).getString("ACSD_Glyph_Gutter"));
        this.gutterMouseListener = new GutterMouseListener();
        this.addMouseListener(this.gutterMouseListener);
        this.addMouseMotionListener(this.gutterMouseListener);
        this.annoTypesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName().equals("glyphsOverLineNumbers") || propertyChangeEvent.getPropertyName().equals("showGlyphGutter")) {
                    GlyphGutter.this.update();
                }
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public void update() {
        if (this.editorUI == null) {
            return;
        }
        Coloring coloring = this.editorUI.getColoringMap().get("line-number");
        Coloring coloring2 = this.editorUI.getDefaultColoring();
        if (coloring == null) {
            return;
        }
        this.backgroundColor = coloring.getBackColor() != null ? coloring.getBackColor() : coloring2.getBackColor();
        this.foreColor = coloring.getForeColor() != null ? coloring.getForeColor() : coloring2.getForeColor();
        if (coloring.getFont() != null) {
            Font font = coloring.getFont();
            this.font = font != null ? font.deriveFont((float)font.getSize() - 1.0f) : null;
        } else {
            this.font = coloring2.getFont();
            this.font = new Font("Monospaced", 0, this.font.getSize() - 1);
        }
        this.lineHeight = this.editorUI.getLineHeight();
        this.showLineNumbers = this.editorUI.lineNumberVisibleSetting;
        this.drawOverLineNumbers = AnnotationTypes.getTypes().isGlyphsOverLineNumbers();
        this.init = true;
        this.highestLineNumber = this.getLineCount();
        this.repaint();
        this.resize();
    }

    protected void resize() {
        Dimension dimension = new Dimension();
        dimension.width = this.glyphGutterWidth = this.getWidthDimension();
        dimension.height = this.getHeightDimension();
        dimension.height += 300 * this.lineHeight;
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLineCount() {
        int n;
        block6: {
            try {
                if (this.document != null) {
                    this.document.readLock();
                    try {
                        n = Utilities.getLineOffset(this.document, this.document.getLength()) + 1;
                        break block6;
                    }
                    finally {
                        this.document.readUnlock();
                    }
                }
                n = 1;
            }
            catch (BadLocationException badLocationException) {
                n = 1;
            }
        }
        return n;
    }

    protected int getDigitCount(int n) {
        return Integer.toString(n).length();
    }

    protected int getLineNumberWidth() {
        int n = 0;
        if (this.editorUI != null) {
            n += this.getDigitCount(this.highestLineNumber) * this.editorUI.getLineNumberDigitWidth();
        }
        return n;
    }

    protected int getWidthDimension() {
        int n = 0;
        if (this.showLineNumbers) {
            int n2 = this.getLineNumberWidth();
            n = 10 + n2 + 4;
        } else if (this.editorUI != null) {
            if (this.annos.isGlyphColumn() || AnnotationTypes.getTypes().isShowGlyphGutter().booleanValue()) {
                n += 16;
            }
            if (this.annos.isGlyphButtonColumn()) {
                n += 9;
            }
        }
        return n;
    }

    protected int getHeightDimension() {
        if (this.editorUI == null) {
            return 0;
        }
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return 0;
        }
        return this.highestLineNumber * this.lineHeight + (int)jTextComponent.getSize().getHeight();
    }

    void paintGutterForView(Graphics graphics, View view, int n) {
        int n2;
        if (this.editorUI == null) {
            return;
        }
        JTextComponent jTextComponent = this.editorUI.getComponent();
        if (jTextComponent == null) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
        graphics.setFont(this.font);
        graphics.setColor(this.foreColor);
        FontMetrics fontMetrics = FontMetricsCache.getFontMetrics(this.font, this);
        Element element = baseTextUI.getRootView(jTextComponent).getElement();
        int n3 = element.getElementIndex(view.getStartOffset());
        int n4 = this.annos.getNextLineWithAnnotation(n3);
        int n5 = fontMetrics.stringWidth(String.valueOf(n3 + 1));
        int n6 = this.annos.getNumberOfAnnotations(n3);
        AnnotationDesc annotationDesc = this.annos.getActiveAnnotation(n3);
        if (this.showLineNumbers) {
            n2 = 0;
            if (!(n3 != n4 || annotationDesc == null || annotationDesc.isDefaultGlyph() && n6 == 1 || annotationDesc.getGlyph() == null)) {
                n2 = 1;
            }
            if (n2 == 0 || !this.drawOverLineNumbers || this.drawOverLineNumbers && n3 != n4) {
                graphics.drawString(String.valueOf(n3 + 1), this.glyphGutterWidth - n5 - 4, n + this.editorUI.getLineAscent());
            }
        }
        if (n3 == n4) {
            int n7 = n2 = this.showLineNumbers ? this.getLineNumberWidth() : 0;
            if (this.drawOverLineNumbers) {
                n2 = this.getWidth() - 16;
                if (n6 > 1) {
                    n2 -= 9;
                }
            }
            if (!(annotationDesc == null || n6 == 1 && annotationDesc.isDefaultGlyph() || annotationDesc.getGlyph() == null)) {
                graphics.drawImage(annotationDesc.getGlyph(), n2, n + (this.lineHeight - annotationDesc.getGlyph().getHeight(null)) / 2 + 1, null);
            }
            if (n6 > 1 && annotationDesc.getGlyph() != null) {
                graphics.drawImage(this.gutterButton, n2 + 16 - 1, n + (this.lineHeight - annotationDesc.getGlyph().getHeight(null)) / 2, null);
            }
            n4 = this.annos.getNextLineWithAnnotation(n3 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        block14: {
            super.paintComponent(graphics);
            if (this.editorUI == null) {
                return;
            }
            Map map = this.getRenderingHints();
            if (!map.isEmpty()) {
                ((Graphics2D)graphics).setRenderingHints(map);
            }
            if (!this.init) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            JTextComponent jTextComponent = this.editorUI.getComponent();
            if (jTextComponent == null) {
                return;
            }
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            View view = Utilities.getDocumentView(jTextComponent);
            if (view == null) {
                return;
            }
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(SettingsDefaults.defaultGutterLine);
            graphics.drawLine(this.glyphGutterWidth - 1, rectangle.y, this.glyphGutterWidth - 1, rectangle.height + rectangle.y);
            AbstractDocument abstractDocument = (AbstractDocument)jTextComponent.getDocument();
            abstractDocument.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int n = baseTextUI.getPosFromY(rectangle.y);
                    int n2 = view.getViewIndex(n, Position.Bias.Forward);
                    int n3 = view.getViewCount();
                    if (n2 < 0 || n2 >= n3) break block14;
                    Rectangle rectangle2 = baseTextUI.modelToView(jTextComponent, view.getView(n2).getStartOffset());
                    int n4 = rectangle2 == null ? 0 : rectangle2.y;
                    int n5 = rectangle.y + rectangle.height;
                    for (int i = n2; i < n3; ++i) {
                        View view2 = view.getView(i);
                        this.paintGutterForView(graphics, view2, n4);
                        if ((n4 += this.editorUI.getLineHeight()) < n5) continue;
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    public void changedLine(int n) {
        JTextComponent jTextComponent;
        if (!this.init || this.editorUI == null) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        if (n > 0) {
            --n;
        }
        if ((jTextComponent = this.editorUI.getComponent()) != null) {
            BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
            try {
                Element element = jTextComponent.getDocument().getDefaultRootElement();
                if (n >= element.getElementCount()) {
                    return;
                }
                Element element2 = element.getElement(n);
                if (element2 == null) {
                    return;
                }
                int n2 = element2.getStartOffset();
                Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n2);
                if (rectangle == null) {
                    return;
                }
                this.repaint(0, rectangle.y, (int)this.getSize().getWidth(), 3 * this.lineHeight);
                this.checkSize();
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
    }

    public void changedAll() {
        if (!this.init || this.editorUI == null) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        try {
            int n = Utilities.getLineOffset(this.document, this.document.getLength()) + 1;
        }
        catch (BadLocationException badLocationException) {
            boolean bl = true;
        }
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                GlyphGutter.this.repaint();
                GlyphGutter.this.checkSize();
            }
        });
    }

    protected void checkSize() {
        int n = this.getLineCount();
        if (n != this.highestLineNumber) {
            this.highestLineNumber = n;
        }
        Dimension dimension = this.getPreferredSize();
        if (this.getWidthDimension() != dimension.width || this.getHeightDimension() > dimension.height) {
            this.resize();
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.editorUI == null) {
            return null;
        }
        int n = this.getLineFromMouseEvent(mouseEvent);
        if (this.annos.getNumberOfAnnotations(n) == 0) {
            return null;
        }
        if (this.isMouseOverCycleButton(mouseEvent) && this.annos.getNumberOfAnnotations(n) > 1) {
            return MessageFormat.format(NbBundle.getBundle(BaseKit.class).getString("cycling-glyph_tooltip"), new Integer(this.annos.getNumberOfAnnotations(n)));
        }
        if (this.isMouseOverGlyph(mouseEvent)) {
            return this.annos.getActiveAnnotation(n).getShortDescription();
        }
        return null;
    }

    private int getXPosOfGlyph(int n) {
        int n2;
        if (this.editorUI == null) {
            return 0;
        }
        int n3 = n2 = this.showLineNumbers ? this.getLineNumberWidth() : 0;
        if (this.drawOverLineNumbers) {
            n2 = this.getWidth() - 16;
            if (this.cachedCountOfAnnos == -1 || this.cachedCountOfAnnosForLine != n) {
                this.cachedCountOfAnnos = this.annos.getNumberOfAnnotations(n);
                this.cachedCountOfAnnosForLine = n;
            }
            if (this.cachedCountOfAnnos > 1) {
                n2 -= 9;
            }
        }
        return n2;
    }

    private boolean isMouseOverGlyph(MouseEvent mouseEvent) {
        int n = this.getLineFromMouseEvent(mouseEvent);
        return mouseEvent.getX() >= this.getXPosOfGlyph(n) && mouseEvent.getX() <= this.getXPosOfGlyph(n) + 16;
    }

    private boolean isMouseOverCycleButton(MouseEvent mouseEvent) {
        int n = this.getLineFromMouseEvent(mouseEvent);
        return mouseEvent.getX() >= this.getXPosOfGlyph(n) + 16 && mouseEvent.getX() <= this.getXPosOfGlyph(n) + 16 + 9;
    }

    public JComponent createSideBar(JTextComponent jTextComponent) {
        EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
        if (editorUI == null) {
            return null;
        }
        GlyphGutter glyphGutter = new GlyphGutter(editorUI);
        editorUI.setGlyphGutter(glyphGutter);
        return glyphGutter;
    }

    private int getLineFromMouseEvent(MouseEvent mouseEvent) {
        int n = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent jTextComponent = this.editorUI.getComponent();
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                int n2 = baseTextUI.viewToModel(jTextComponent, new Point(0, mouseEvent.getY()));
                n = Utilities.getLineOffset(this.document, n2);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return n;
    }

    class EditorUIListener
    implements PropertyChangeListener {
        EditorUIListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && "component".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == null) {
                GlyphGutter.this.editorUI.removePropertyChangeListener(GlyphGutter.this.editorUIListener);
                GlyphGutter.this.annos.removeAnnotationsListener(GlyphGutter.this);
                GlyphGutter.this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)GlyphGutter.this.glyphGutterFoldHierarchyListener);
                if (GlyphGutter.this.gutterMouseListener != null) {
                    GlyphGutter.this.removeMouseListener(GlyphGutter.this.gutterMouseListener);
                    GlyphGutter.this.removeMouseMotionListener(GlyphGutter.this.gutterMouseListener);
                }
                if (GlyphGutter.this.annoTypesListener != null) {
                    AnnotationTypes.getTypes().removePropertyChangeListener(GlyphGutter.this.annoTypesListener);
                }
                GlyphGutter.this.foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)GlyphGutter.this.glyphGutterFoldHierarchyListener);
                GlyphGutter.this.foldHierarchy = null;
                GlyphGutter.this.document = null;
                GlyphGutter.this.editorUI.removePropertyChangeListener(this);
                GlyphGutter.this.editorUI = null;
                GlyphGutter.this.annos = null;
            }
        }
    }

    class GlyphGutterFoldHierarchyListener
    implements FoldHierarchyListener {
        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
            GlyphGutter.this.repaint();
        }
    }

    class GutterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int dragStartLine;
        private int dragEndLine;
        private int currentEndLine;
        private boolean selectForward;

        GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            if (mouseEvent.getModifiers() == 16) {
                if (GlyphGutter.this.isMouseOverCycleButton(mouseEvent)) {
                    int n = GlyphGutter.this.getLineFromMouseEvent(mouseEvent);
                    mouseEvent.consume();
                    GlyphGutter.this.annos.activateNextAnnotation(n);
                } else {
                    Action[] actionArray = ImplementationProvider.getDefault().getGlyphGutterActions(GlyphGutter.this.editorUI.getComponent());
                    if (actionArray != null && actionArray.length > 0) {
                        Action action = actionArray[0];
                        if (action != null && action.isEnabled()) {
                            int n = -1;
                            int n2 = GlyphGutter.this.getLineFromMouseEvent(mouseEvent);
                            if (n2 == -1) {
                                return;
                            }
                            try {
                                n = Utilities.getLineOffset(GlyphGutter.this.document, GlyphGutter.this.editorUI.getComponent().getCaret().getDot());
                            }
                            catch (BadLocationException badLocationException) {
                                return;
                            }
                            if (n2 != n) {
                                int n3 = Utilities.getRowStartFromLineOffset(GlyphGutter.this.document, n2);
                                JumpList.checkAddEntry();
                                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(n3);
                            }
                            mouseEvent.consume();
                            action.actionPerformed(new ActionEvent(GlyphGutter.this.editorUI.getComponent(), 0, ""));
                            GlyphGutter.this.repaint();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (GlyphGutter.this.editorUI == null) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                int n = GlyphGutter.this.getLineFromMouseEvent(mouseEvent);
                int n2 = GlyphGutter.this.annos.getActiveAnnotation(n) != null ? GlyphGutter.this.annos.getActiveAnnotation(n).getOffset() : Utilities.getRowStartFromLineOffset(GlyphGutter.this.document, n);
                if (GlyphGutter.this.editorUI.getComponent().getCaret().getDot() != n2) {
                    JumpList.checkAddEntry();
                }
                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(n2);
                JPopupMenu jPopupMenu = GlyphGutter.this.annos.createPopupMenu(Utilities.getKit(GlyphGutter.this.editorUI.getComponent()), n);
                if (jPopupMenu != null) {
                    mouseEvent.consume();
                    jPopupMenu.show(GlyphGutter.this, mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                            GlyphGutter.this.editorUI.getComponent().requestFocus();
                        }

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                            GlyphGutter.this.editorUI.getComponent().requestFocus();
                        }

                        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                        }
                    });
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
            if (!mouseEvent.isConsumed() && (GlyphGutter.this.isMouseOverGlyph(mouseEvent) || GlyphGutter.this.isMouseOverCycleButton(mouseEvent))) {
                mouseEvent.consume();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
            if (!mouseEvent.isConsumed() && (GlyphGutter.this.isMouseOverGlyph(mouseEvent) || GlyphGutter.this.isMouseOverCycleButton(mouseEvent))) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

