/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Dialog;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.db.mysql.ServerInstance;
import org.netbeans.modules.db.mysql.ServerNodeProvider;
import org.netbeans.modules.db.mysql.Utils;
import org.netbeans.modules.db.mysql.ui.AdminPropertiesPanel;
import org.netbeans.modules.db.mysql.ui.BasePropertiesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesDialog {
    private static final Logger LOGGER = Logger.getLogger(PropertiesDialog.class.getName());
    private static final String HELP_CTX = PropertiesDialog.class.getName();
    private final JTabbedPane tabbedPane;
    private final BasePropertiesPanel basePanel;
    private final AdminPropertiesPanel adminPanel;
    private final ServerInstance server;

    public PropertiesDialog(ServerInstance serverInstance) {
        this.server = serverInstance;
        this.basePanel = new BasePropertiesPanel(serverInstance);
        this.adminPanel = new AdminPropertiesPanel(serverInstance);
        this.tabbedPane = PropertiesDialog.createTabbedPane(this.basePanel, this.adminPanel);
    }

    public boolean displayDialog() {
        return this.displayDialog(Tab.BASIC);
    }

    public boolean displayDialog(Tab tab) {
        boolean bl;
        DialogDescriptor dialogDescriptor = this.createDialogDescriptor();
        if (tab == Tab.ADMIN) {
            this.tabbedPane.setSelectedIndex(1);
        }
        if (bl = this.displayDialog(dialogDescriptor)) {
            this.updateServer();
        }
        return bl;
    }

    private static JTabbedPane createTabbedPane(JPanel jPanel, JPanel jPanel2) {
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.addTab(PropertiesDialog.getMessage("PropertiesDialog.BasePanelTitle"), null, jPanel, PropertiesDialog.getMessage("PropertiesDialog.BasePanelHint"));
        jTabbedPane.addTab(PropertiesDialog.getMessage("PropertiesDialog.AdminPanelTitle"), null, jPanel2, PropertiesDialog.getMessage("PropertiesDialog.AdminPanelHint"));
        jTabbedPane.getAccessibleContext().setAccessibleName(PropertiesDialog.getMessage("PropertiesDialog.ACS_Name"));
        jTabbedPane.getAccessibleContext().setAccessibleDescription(PropertiesDialog.getMessage("PropertiesDialog.ACS_Desc"));
        return jTabbedPane;
    }

    private DialogDescriptor createDialogDescriptor() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.tabbedPane, PropertiesDialog.getMessage("PropertiesDialog.Title"));
        dialogDescriptor.setHelpCtx(new HelpCtx(HELP_CTX));
        this.basePanel.setDialogDescriptor(dialogDescriptor);
        this.adminPanel.setDialogDescriptor(dialogDescriptor);
        return dialogDescriptor;
    }

    private boolean displayDialog(DialogDescriptor dialogDescriptor) {
        assert (SwingUtilities.isEventDispatchThread());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        return DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue());
    }

    private void updateServer() {
        boolean bl = this.needsReconnect();
        this.server.setHost(this.basePanel.getHost());
        this.server.setPort(this.basePanel.getPort());
        this.server.setUser(this.basePanel.getUser());
        this.server.setPassword(this.basePanel.getPassword());
        this.server.setSavePassword(this.basePanel.getSavePassword());
        this.server.setAdminPath(this.adminPanel.getAdminPath());
        this.server.setAdminArgs(this.adminPanel.getAdminArgs());
        this.server.setStartPath(this.adminPanel.getStartPath());
        this.server.setStartArgs(this.adminPanel.getStartArgs());
        this.server.setStopPath(this.adminPanel.getStopPath());
        this.server.setStopArgs(this.adminPanel.getStopArgs());
        ServerNodeProvider serverNodeProvider = ServerNodeProvider.getDefault();
        if (!serverNodeProvider.isRegistered()) {
            serverNodeProvider.setRegistered(true);
        } else if (bl) {
            this.server.connectAsync();
        }
    }

    public boolean needsReconnect() {
        return !Utils.stringEquals(this.server.getHost(), this.basePanel.getHost()) || !Utils.stringEquals(this.server.getPort(), this.basePanel.getPort()) || !Utils.stringEquals(this.server.getUser(), this.basePanel.getUser()) || !Utils.stringEquals(this.server.getPassword(), this.basePanel.getPassword());
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(PropertiesDialog.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tab {
        BASIC,
        ADMIN;

    }
}

