/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.AdministerAction;
import org.netbeans.modules.db.mysql.ConnectServerAction;
import org.netbeans.modules.db.mysql.CreateDatabaseAction;
import org.netbeans.modules.db.mysql.DatabaseModel;
import org.netbeans.modules.db.mysql.DatabaseNode;
import org.netbeans.modules.db.mysql.PropertiesAction;
import org.netbeans.modules.db.mysql.ServerInstance;
import org.netbeans.modules.db.mysql.ServerNodeProvider;
import org.netbeans.modules.db.mysql.StartAction;
import org.netbeans.modules.db.mysql.StopAction;
import org.netbeans.modules.db.mysql.Utils;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class ServerNode
extends AbstractNode
implements ChangeListener,
Comparable {
    private final ServerInstance server;
    private static final String ICON = "org/netbeans/modules/db/mysql/resources/catalog.gif";
    private static final HelpCtx HELP_CONTEXT = new HelpCtx(ServerNode.class.getName());

    public static ServerNode create(ServerInstance serverInstance) {
        ChildFactory childFactory = new ChildFactory(serverInstance);
        return new ServerNode(childFactory, serverInstance);
    }

    private ServerNode(ChildFactory childFactory, ServerInstance serverInstance) {
        super(Children.create((org.openide.nodes.ChildFactory)childFactory, (boolean)true));
        this.server = serverInstance;
        this.setName("");
        this.setDisplayName(serverInstance.getDisplayName());
        this.setShortDescription(serverInstance.getShortDescription());
        this.setIconBaseWithExtension(ICON);
        this.registerListeners();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == ServerInstance.class) {
            return this.server;
        }
        return super.getCookie(clazz);
    }

    public HelpCtx getHelpCtx() {
        return HELP_CONTEXT;
    }

    private void registerListeners() {
        ServerInstance.getDefault().addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)ServerInstance.getDefault()));
        this.stateChanged(new ChangeEvent(ServerInstance.getDefault()));
    }

    public void stateChanged(ChangeEvent changeEvent) {
        String string = this.getDisplayName();
        this.setDisplayName(this.server.getDisplayName());
        this.fireNameChange(string, this.getDisplayName());
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return super.getActions(bl);
        }
        return new SystemAction[]{SystemAction.get(CreateDatabaseAction.class), SystemAction.get(StartAction.class), SystemAction.get(StopAction.class), SystemAction.get(ConnectServerAction.class), SystemAction.get(DeleteAction.class), SystemAction.get(AdministerAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        ServerNodeProvider.getDefault().setRegistered(false);
    }

    public int compareTo(Object object) {
        Node node = (Node)object;
        return this.getDisplayName().compareTo(node.getDisplayName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceComparator
    implements Comparator<DatabaseModel>,
    Serializable {
        private InstanceComparator() {
        }

        @Override
        public int compare(DatabaseModel databaseModel, DatabaseModel databaseModel2) {
            return databaseModel.getDisplayName().compareTo(databaseModel2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<DatabaseModel>
    implements ChangeListener {
        private static final Comparator<DatabaseModel> COMPARATOR = new InstanceComparator();
        private final ServerInstance server;

        public ChildFactory(ServerInstance serverInstance) {
            this.server = serverInstance;
            serverInstance.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)serverInstance));
            this.stateChanged(new ChangeEvent(serverInstance));
        }

        protected Node createNodeForKey(DatabaseModel databaseModel) {
            return new DatabaseNode(databaseModel);
        }

        protected boolean createKeys(List<DatabaseModel> list) {
            ArrayList<DatabaseModel> arrayList = new ArrayList<DatabaseModel>();
            try {
                arrayList.addAll(this.server.getDatabases());
            }
            catch (DatabaseException databaseException) {
                Utils.displayError(NbBundle.getMessage(ServerNode.class, (String)"MSG_UnableToGetDatabaseList"), (Exception)((Object)databaseException));
                return true;
            }
            Collections.sort(arrayList, COMPARATOR);
            list.addAll(arrayList);
            return true;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.refresh(false);
        }
    }
}

