/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.netbeans.modules.db.mysql.Utils;
import org.openide.util.NbPreferences;

public class MySQLOptions {
    private String adminPassword;
    private static final Logger LOGGER = Logger.getLogger(MySQLOptions.class.getName());
    private static final MySQLOptions DEFAULT = new MySQLOptions();
    static final String PROP_MYSQL_LOCATION = "location";
    static final String PROP_HOST = "host";
    static final String PROP_PORT = "port";
    static final String PROP_ADMINUSER = "adminuser";
    static final String PROP_ADMINPWD = "adminpwd";
    static final String PROP_SAVEPWD = "savepwd";
    static final String PROP_DBDIR = "dbdir";
    static final String PROP_CONN_REGISTERED = "conn-registered";
    static final String PROP_PROVIDER_REGISTERED = "provider-registered";
    static final String PROP_PROVIDER_REMOVED = "provider-removed";
    static final String PROP_ADMIN_PATH = "admin-path";
    static final String PROP_START_PATH = "start-path";
    static final String PROP_STOP_PATH = "stop-path";
    static final String PROP_ADMIN_ARGS = "admin-args";
    static final String PROP_START_ARGS = "start-args";
    static final String PROP_STOP_ARGS = "stop-args";
    static final String PROP_COMMANDS_CONFIRMED = "commands-confirmed";
    static final String PROP_CONNECT_TIMEOUT = "connect-timeout";
    static final String PROP_REFRESH_THREAD_SLEEP_INTERVAL = "refresh-thread-sleep-interval";
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static final String DEFAULT_PORT = "3306";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_ADMIN_USER = "root";
    private static final String DEFAULT_ADMIN_PASSWORD = "";
    private static final String DEFAULT_CONNECT_TIMEOUT = "15000";
    private static final long DEFAULT_REFRESH_THREAD_SLEEP_INTERVAL = 3000L;
    private CopyOnWriteArrayList<PropertyChangeListener> listeners = new CopyOnWriteArrayList();

    public static MySQLOptions getDefault() {
        return DEFAULT;
    }

    private MySQLOptions() {
        if (Utils.isEmpty(this.getConnectTimeout())) {
            this.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putProperty(String string, String string2) {
        String string3;
        MySQLOptions mySQLOptions = this;
        synchronized (mySQLOptions) {
            string3 = this.getProperty(string);
            if (string2 != null) {
                NbPreferences.forModule(MySQLOptions.class).put(string, string2);
            } else {
                NbPreferences.forModule(MySQLOptions.class).remove(string);
            }
        }
        this.notifyPropertyChange(string, string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putProperty(String string, boolean bl) {
        boolean bl2;
        MySQLOptions mySQLOptions = this;
        synchronized (mySQLOptions) {
            bl2 = this.getBooleanProperty(string);
            NbPreferences.forModule(MySQLOptions.class).putBoolean(string, bl);
        }
        this.notifyPropertyChange(string, bl2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putProperty(String string, long l, long l2) {
        long l3;
        MySQLOptions mySQLOptions = this;
        synchronized (mySQLOptions) {
            l3 = this.getLongProperty(string, l2);
            NbPreferences.forModule(MySQLOptions.class).putLong(string, l);
        }
        this.notifyPropertyChange(string, l3, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearProperty(String string) {
        String string2;
        MySQLOptions mySQLOptions = this;
        synchronized (mySQLOptions) {
            string2 = this.getProperty(string);
            NbPreferences.forModule(MySQLOptions.class).remove(string);
        }
        this.notifyPropertyChange(string, string2, null);
    }

    protected final String getProperty(String string) {
        return NbPreferences.forModule(MySQLOptions.class).get(string, DEFAULT_ADMIN_PASSWORD);
    }

    protected final boolean getBooleanProperty(String string) {
        return NbPreferences.forModule(MySQLOptions.class).getBoolean(string, false);
    }

    protected final long getLongProperty(String string, long l) {
        return NbPreferences.forModule(MySQLOptions.class).getLong(string, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    private void notifyPropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public String getHost() {
        return this.getProperty(PROP_HOST);
    }

    public void setHost(String string) {
        this.putProperty(PROP_HOST, string);
    }

    public String getPort() {
        return this.getProperty(PROP_PORT);
    }

    public void setPort(String string) {
        this.putProperty(PROP_PORT, string);
    }

    public String getAdminUser() {
        return this.getProperty(PROP_ADMINUSER);
    }

    public void setAdminUser(String string) {
        this.putProperty(PROP_ADMINUSER, string);
    }

    public synchronized String getAdminPassword() {
        if (this.isSavePassword()) {
            return this.getProperty(PROP_ADMINPWD);
        }
        return this.adminPassword;
    }

    public synchronized void setAdminPassword(String string) {
        if (string == null) {
            string = DEFAULT_ADMIN_PASSWORD;
        }
        this.adminPassword = string;
        if (this.isSavePassword()) {
            this.putProperty(PROP_ADMINPWD, string);
        }
    }

    public void clearAdminPassword() {
        this.clearProperty(PROP_ADMINPWD);
    }

    public boolean isSavePassword() {
        return this.getBooleanProperty(PROP_SAVEPWD);
    }

    public void setSavePassword(boolean bl) {
        this.putProperty(PROP_SAVEPWD, bl);
        if (!bl) {
            this.clearAdminPassword();
        } else {
            this.putProperty(PROP_ADMINPWD, this.adminPassword);
        }
    }

    public void setConnectionRegistered(boolean bl) {
        this.putProperty(PROP_CONN_REGISTERED, bl);
    }

    public boolean isConnectionRegistered() {
        return this.getBooleanProperty(PROP_CONN_REGISTERED);
    }

    public void setProviderRegistered(boolean bl) {
        if (this.isProviderRegistered() && !bl) {
            this.setProviderRemoved(true);
        } else if (bl) {
            this.setProviderRemoved(false);
        }
        this.putProperty(PROP_PROVIDER_REGISTERED, bl);
    }

    public boolean isProviderRegistered() {
        return this.getBooleanProperty(PROP_PROVIDER_REGISTERED);
    }

    private void setProviderRemoved(boolean bl) {
        this.putProperty(PROP_PROVIDER_REMOVED, bl);
    }

    public boolean isProviderRemoved() {
        return this.getBooleanProperty(PROP_PROVIDER_REMOVED);
    }

    public String getStartPath() {
        return this.getProperty(PROP_START_PATH);
    }

    public void setStartPath(String string) {
        this.putProperty(PROP_START_PATH, string);
    }

    public String getStartArgs() {
        return this.getProperty(PROP_START_ARGS);
    }

    public void setStartArgs(String string) {
        this.putProperty(PROP_START_ARGS, string);
    }

    public String getStopPath() {
        return this.getProperty(PROP_STOP_PATH);
    }

    public void setStopPath(String string) {
        this.putProperty(PROP_STOP_PATH, string);
    }

    public String getStopArgs() {
        return this.getProperty(PROP_STOP_ARGS);
    }

    public void setStopArgs(String string) {
        this.putProperty(PROP_STOP_ARGS, string);
    }

    public String getAdminPath() {
        return this.getProperty(PROP_ADMIN_PATH);
    }

    public void setAdminPath(String string) {
        this.putProperty(PROP_ADMIN_PATH, string);
    }

    public String getAdminArgs() {
        return this.getProperty(PROP_ADMIN_ARGS);
    }

    public void setAdminArgs(String string) {
        this.putProperty(PROP_ADMIN_ARGS, string);
    }

    public boolean isAdminCommandsConfirmed() {
        return this.getBooleanProperty(PROP_COMMANDS_CONFIRMED);
    }

    public void setAdminCommandsConfirmed(boolean bl) {
        this.putProperty(PROP_COMMANDS_CONFIRMED, bl);
    }

    public String getConnectTimeout() {
        return this.getProperty(PROP_CONNECT_TIMEOUT);
    }

    public void setConnectTimeout(String string) {
        this.putProperty(PROP_CONNECT_TIMEOUT, string);
    }

    public long getRefreshThreadSleepInterval() {
        return this.getLongProperty(PROP_REFRESH_THREAD_SLEEP_INTERVAL, 3000L);
    }

    public void setRefreshThreadSleepInterval(long l) {
        this.putProperty(PROP_REFRESH_THREAD_SLEEP_INTERVAL, l, 3000L);
    }

    public static String getDriverClass() {
        return DRIVER_CLASS;
    }

    public static String getDefaultPort() {
        return DEFAULT_PORT;
    }

    public static String getDefaultAdminPassword() {
        return DEFAULT_ADMIN_PASSWORD;
    }

    public static String getDefaultAdminUser() {
        return DEFAULT_ADMIN_USER;
    }

    public static String getDefaultHost() {
        return DEFAULT_HOST;
    }
}

