/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.DatabaseUtils;
import org.netbeans.modules.db.mysql.DbExplorerConnectionListener;
import org.netbeans.modules.db.mysql.Installation;
import org.netbeans.modules.db.mysql.InstallationSupport;
import org.netbeans.modules.db.mysql.MySQLOptions;
import org.netbeans.modules.db.mysql.ServerNodeProvider;
import org.netbeans.modules.db.mysql.Utils;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class ModuleInstaller
extends ModuleInstall {
    private static final Logger LOGGER = Logger.getLogger(ModuleInstaller.class.getName());
    private static final MySQLOptions options = MySQLOptions.getDefault();

    public void restored() {
        if (options.isConnectionRegistered() && options.isProviderRegistered()) {
            return;
        }
        WindowManager.getDefault().invokeWhenUIReady((Runnable)new RegisterMySQL());
    }

    private static final class RegisterMySQL
    implements Runnable {
        private JDBCDriver jdbcDriver;

        private RegisterMySQL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post((Runnable)this);
                return;
            }
            ProgressHandle progressHandle = ProgressHandleFactory.createSystemHandle((String)NbBundle.getMessage(ModuleInstaller.class, (String)"MSG_RegisterMySQL"));
            progressHandle.start();
            try {
                this.findAndRegisterMySQL();
            }
            finally {
                progressHandle.finish();
            }
        }

        private void findAndRegisterMySQL() {
            this.jdbcDriver = DatabaseUtils.getJDBCDriver();
            if (this.jdbcDriver == null) {
                return;
            }
            this.registerConnectionListener();
            this.findAndRegisterInstallation();
            this.findAndRegisterRunningServer();
        }

        private void registerConnectionListener() {
            ConnectionManager.getDefault().addConnectionListener((ConnectionListener)new DbExplorerConnectionListener());
        }

        private void findAndRegisterRunningServer() {
            String string;
            DatabaseConnection databaseConnection = this.findDatabaseConnection();
            if (databaseConnection != null) {
                options.setAdminUser(databaseConnection.getUser());
                options.setAdminPassword(databaseConnection.getPassword());
                DatabaseUtils.URLParser uRLParser = new DatabaseUtils.URLParser(databaseConnection.getDatabaseURL());
                options.setHost(uRLParser.getHost());
                options.setPort(uRLParser.getPort());
                options.setConnectionRegistered(true);
                this.registerProvider(true);
                return;
            }
            String string2 = options.getHost();
            if (Utils.isEmpty(string2)) {
                string2 = MySQLOptions.getDefaultHost();
            }
            if ((string = options.getPort()) == null || string.length() == 0) {
                string = MySQLOptions.getDefaultPort();
            }
            String string3 = MySQLOptions.getDefaultAdminUser();
            String string4 = MySQLOptions.getDefaultAdminPassword();
            String string5 = DatabaseUtils.getURL(string2, string);
            DatabaseUtils.ConnectStatus connectStatus = DatabaseUtils.testConnection(string5, string3, string4);
            if (connectStatus == DatabaseUtils.ConnectStatus.CONNECT_SUCCEEDED || connectStatus == DatabaseUtils.ConnectStatus.SERVER_RUNNING) {
                options.setHost(string2);
                options.setPort(string);
                options.setAdminUser(string3);
                options.setAdminPassword(string4);
                this.registerConnection(string2, string, string3);
                this.registerProvider(true);
            }
        }

        private void findAndRegisterInstallation() {
            Installation installation = InstallationSupport.detectInstallation();
            if (installation == null) {
                return;
            }
            String[] stringArray = installation.getAdminCommand();
            if (Utils.isValidExecutable(stringArray[0], true) || Utils.isValidURL(stringArray[0], true)) {
                options.setAdminPath(stringArray[0]);
                options.setAdminArgs(stringArray[1]);
            }
            if (Utils.isValidExecutable((stringArray = installation.getStartCommand())[0], true)) {
                options.setStartPath(stringArray[0]);
                options.setStartArgs(stringArray[1]);
            }
            if (Utils.isValidExecutable((stringArray = installation.getStopCommand())[0], true)) {
                options.setStopPath(stringArray[0]);
                options.setStopArgs(stringArray[1]);
            }
            options.setPort(installation.getDefaultPort());
            options.setProviderRegistered(true);
        }

        private DatabaseConnection findDatabaseConnection() {
            DatabaseConnection[] databaseConnectionArray;
            for (DatabaseConnection databaseConnection : databaseConnectionArray = ConnectionManager.getDefault().getConnections()) {
                if (!databaseConnection.getDriverClass().equals(MySQLOptions.getDriverClass())) continue;
                return databaseConnection;
            }
            return null;
        }

        private void registerConnection(String string, String string2, String string3) {
            if (options.isConnectionRegistered()) {
                return;
            }
            String string4 = DatabaseUtils.getURL(string, string2);
            DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)this.jdbcDriver, (String)string4, (String)string3, null, null, (boolean)false);
            try {
                ConnectionManager.getDefault().addConnection(databaseConnection);
                options.setConnectionRegistered(true);
            }
            catch (DatabaseException databaseException) {
                LOGGER.log(Level.INFO, "Unable to register default connection for MySQL", databaseException);
            }
        }

        private void registerProvider(boolean bl) {
            ServerNodeProvider.getDefault().setRegistered(bl);
        }
    }
}

