/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtractSuperclassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractSuperclassRefactoring refactoring;
    private ElementHandle<TypeElement> classHandle;
    private String pkgName;

    ExtractSuperclassRefactoringPlugin(ExtractSuperclassRefactoring extractSuperclassRefactoring) {
        this.refactoring = extractSuperclassRefactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)this.refactoring.getSourceType().getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 2);
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle treePathHandle = this.refactoring.getSourceType();
            Problem problem = ExtractSuperclassRefactoringPlugin.isElementAvail(treePathHandle, (CompilationInfo)compilationController);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            if (!RetoucheUtils.isElementInOpenProject(treePathHandle.getFileObject())) {
                Problem problem3 = new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem3;
            }
            Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
            if (element == null || element.getKind() != ElementKind.CLASS) {
                Problem problem4 = new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem4;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)element));
            PackageElement packageElement = (PackageElement)compilationController.getElementUtilities().outermostTypeElement(element).getEnclosingElement();
            this.pkgName = packageElement.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem5 = null;
            return problem5;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] fileObjectArray;
        Problem problem = null;
        String string = this.refactoring.getSuperClassName();
        if (!Utilities.isJavaIdentifier((String)string)) {
            problem = ExtractSuperclassRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)string));
            return problem;
        }
        FileObject fileObject = this.refactoring.getSourceType().getFileObject();
        FileObject fileObject2 = fileObject.getParent();
        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
            if (fileObject3.isVirtual() || !fileObject3.getName().equals(string) || !"java".equals(fileObject3.getExt())) continue;
            problem = ExtractSuperclassRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)string, (Object)this.pkgName));
            return problem;
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        MemberInfo<ElementHandle<? extends Element>>[] memberInfoArray = this.refactoring.getMembers();
        if (memberInfoArray.length == 0) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_MembersNotAvailable"));
        }
        return super.checkParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement typeElement = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)compilationController);
        assert (typeElement != null);
        HashSet<? extends Element> hashSet = new HashSet<Element>(typeElement.getEnclosedElements());
        this.fireProgressListenerStart(2, this.refactoring.getMembers().length);
        try {
            for (MemberInfo<ElementHandle<? extends Element>> memberInfo : this.refactoring.getMembers()) {
                ElementHandle<? extends Element> elementHandle;
                Problem problem = null;
                switch (memberInfo.getGroup()) {
                    case FIELD: {
                        elementHandle = memberInfo.getElementHandle();
                        VariableElement variableElement = (VariableElement)elementHandle.resolve((CompilationInfo)compilationController);
                        problem = this.checkFieldParameter(compilationController, variableElement, hashSet);
                        break;
                    }
                    case METHOD: {
                        ElementHandle<? extends Element> elementHandle2 = memberInfo.getElementHandle();
                        ExecutableElement executableElement = (ExecutableElement)elementHandle2.resolve((CompilationInfo)compilationController);
                        problem = this.checkMethodParameter(compilationController, executableElement, hashSet);
                    }
                }
                if (problem != null) {
                    elementHandle = problem;
                    return elementHandle;
                }
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private Problem checkFieldParameter(CompilationController compilationController, VariableElement variableElement, Set<? extends Element> set) throws IOException {
        if (variableElement == null) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (compilationController.getElementUtilities().isSynthetic((Element)variableElement) || variableElement.getKind() != ElementKind.FIELD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)variableElement.toString()));
        }
        if (!set.contains(variableElement)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)variableElement.toString()));
        }
        return null;
    }

    private Problem checkMethodParameter(CompilationController compilationController, ExecutableElement executableElement, Set<? extends Element> set) throws IOException {
        if (executableElement == null) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (compilationController.getElementUtilities().isSynthetic((Element)executableElement) || executableElement.getKind() != ElementKind.METHOD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)executableElement.toString()));
        }
        if (!set.contains(executableElement)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)executableElement.toString()));
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        FileObject fileObject = this.refactoring.getSourceType().getFileObject();
        try {
            refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CreateSuperclassElement(this.refactoring, fileObject.getParent(), this.classHandle));
            UpdateClassTask.create(refactoringElementsBag, fileObject, this.refactoring, this.classHandle);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return null;
    }

    private static List<TypeMirror> findUsedGenericTypes(CompilationInfo compilationInfo, TypeElement typeElement, ExtractSuperclassRefactoring extractSuperclassRefactoring) {
        List<TypeMirror> list = RetoucheUtils.resolveTypeParamsAsTypes(typeElement.getTypeParameters());
        if (list.isEmpty()) {
            return list;
        }
        Types types = compilationInfo.getTypes();
        ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(list.size());
        TypeMirror typeMirror = typeElement.getSuperclass();
        RetoucheUtils.findUsedGenericTypes(types, list, arrayList, typeMirror);
        MemberInfo<ElementHandle<? extends Element>>[] memberInfoArray = extractSuperclassRefactoring.getMembers();
        for (int i = 0; i < memberInfoArray.length && !list.isEmpty(); ++i) {
            AnnotatedConstruct annotatedConstruct;
            TypeMirrorHandle typeMirrorHandle;
            if (memberInfoArray[i].getGroup() == MemberInfo.Group.METHOD) {
                typeMirrorHandle = memberInfoArray[i].getElementHandle();
                annotatedConstruct = (ExecutableElement)typeMirrorHandle.resolve(compilationInfo);
                RetoucheUtils.findUsedGenericTypes(types, list, arrayList, annotatedConstruct.getReturnType());
                Iterator<? extends VariableElement> iterator = annotatedConstruct.getParameters().iterator();
                while (iterator.hasNext() && !list.isEmpty()) {
                    VariableElement variableElement = iterator.next();
                    RetoucheUtils.findUsedGenericTypes(types, list, arrayList, variableElement.asType());
                }
                continue;
            }
            if (memberInfoArray[i].getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
            typeMirrorHandle = (TypeMirrorHandle)memberInfoArray[i].getElementHandle();
            annotatedConstruct = typeMirrorHandle.resolve(compilationInfo);
            RetoucheUtils.findUsedGenericTypes(types, list, arrayList, (TypeMirror)annotatedConstruct);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateClassTask
    implements CancellableTask<WorkingCopy> {
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private UpdateClassTask(ExtractSuperclassRefactoring extractSuperclassRefactoring, ElementHandle<TypeElement> elementHandle) {
            this.sourceType = elementHandle;
            this.refactoring = extractSuperclassRefactoring;
        }

        public static void create(RefactoringElementsBag refactoringElementsBag, FileObject fileObject, ExtractSuperclassRefactoring extractSuperclassRefactoring, ElementHandle<TypeElement> elementHandle) throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new UpdateClassTask(extractSuperclassRefactoring, elementHandle));
            List list = modificationResult.getDifferences(fileObject);
            for (ModificationResult.Difference difference : list) {
                refactoringElementsBag.add((AbstractRefactoring)extractSuperclassRefactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
            }
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(Collections.singletonList(modificationResult)));
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            List<Tree> list;
            Object object22;
            AbstractCollection abstractCollection;
            Tree tree2;
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement typeElement = (TypeElement)this.sourceType.resolve((CompilationInfo)workingCopy);
            assert (typeElement != null);
            ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            List list2 = ExtractSuperclassRefactoringPlugin.findUsedGenericTypes((CompilationInfo)workingCopy, typeElement, this.refactoring);
            if (list2.isEmpty()) {
                tree2 = treeMaker.Identifier((CharSequence)this.refactoring.getSuperClassName());
            } else {
                abstractCollection = new ArrayList(list2.size());
                for (Object object22 : list2) {
                    list = treeMaker.Type((TypeMirror)object22);
                    abstractCollection.add((ExpressionTree)((Object)list));
                }
                tree2 = treeMaker.ParameterizedType((Tree)treeMaker.Identifier((CharSequence)this.refactoring.getSuperClassName()), abstractCollection);
            }
            abstractCollection = new HashSet();
            HashSet hashSet = new HashSet();
            abstractCollection.addAll(this.getMembers2Remove((CompilationInfo)workingCopy, this.refactoring.getMembers()));
            hashSet.addAll(this.getImplements2Remove((CompilationInfo)workingCopy, this.refactoring.getMembers(), typeElement));
            object22 = new ArrayList();
            for (Tree tree3 : classTree.getMembers()) {
                if (abstractCollection.contains(tree3)) continue;
                object22.add(tree3);
            }
            list = UpdateClassTask.resolveImplements(classTree.getImplementsClause(), hashSet);
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), tree2, list, (List)object22);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }

        private List<Tree> getMembers2Remove(CompilationInfo compilationInfo, MemberInfo[] memberInfoArray) {
            if (memberInfoArray == null || memberInfoArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Tree> arrayList = new ArrayList<Tree>(memberInfoArray.length);
            for (MemberInfo memberInfo : memberInfoArray) {
                Tree tree;
                Element element;
                ElementHandle elementHandle;
                if (memberInfo.getGroup() == MemberInfo.Group.FIELD) {
                    elementHandle = (ElementHandle)memberInfo.getElementHandle();
                    element = (VariableElement)elementHandle.resolve(compilationInfo);
                    assert (element != null);
                    tree = compilationInfo.getTrees().getTree(element);
                    assert (tree != null);
                    arrayList.add(tree);
                    continue;
                }
                if (memberInfo.getGroup() != MemberInfo.Group.METHOD || memberInfo.isMakeAbstract()) continue;
                elementHandle = (ElementHandle)memberInfo.getElementHandle();
                element = (ExecutableElement)elementHandle.resolve(compilationInfo);
                assert (element != null);
                tree = compilationInfo.getTrees().getTree((ExecutableElement)element);
                assert (tree != null);
                arrayList.add(tree);
            }
            return arrayList;
        }

        private List<Tree> getImplements2Remove(CompilationInfo compilationInfo, MemberInfo[] memberInfoArray, TypeElement typeElement) {
            Object object;
            if (memberInfoArray == null || memberInfoArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(memberInfoArray.length);
            for (MemberInfo memberInfo : memberInfoArray) {
                if (memberInfo.getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                TypeMirrorHandle object2 = (TypeMirrorHandle)memberInfo.getElementHandle();
                object = object2.resolve(compilationInfo);
                arrayList.add((TypeMirror)object);
            }
            ClassTree classTree = compilationInfo.getTrees().getTree(typeElement);
            ArrayList<Tree> arrayList2 = new ArrayList<Tree>();
            Types types = compilationInfo.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                object = compilationInfo.getTrees().getPath(compilationInfo.getCompilationUnit(), tree);
                TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror((TreePath)object);
                for (TypeMirror typeMirror2 : arrayList) {
                    if (!types.isSameType(typeMirror2, typeMirror)) continue;
                    arrayList2.add(tree);
                    continue block1;
                }
            }
            return arrayList2;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> list, Set<Tree> set) {
            ArrayList<Tree> arrayList;
            if (list == null) {
                arrayList = new ArrayList<Tree>(1);
            } else {
                arrayList = new ArrayList(list.size() + 1);
                arrayList.addAll(list);
            }
            if (set != null && !set.isEmpty()) {
                arrayList.removeAll(set);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CreateSuperclassElement
    extends SimpleRefactoringElementImplementation
    implements CancellableTask<WorkingCopy> {
        private final URL folderURL;
        private URL superClassURL;
        private final String superClassName;
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private CreateSuperclassElement(ExtractSuperclassRefactoring extractSuperclassRefactoring, FileObject fileObject, ElementHandle<TypeElement> elementHandle) {
            this.refactoring = extractSuperclassRefactoring;
            this.folderURL = URLMapper.findURL((FileObject)fileObject, (int)0);
            this.superClassName = extractSuperclassRefactoring.getSuperClassName();
            this.sourceType = elementHandle;
        }

        public void performChange() {
            try {
                FileObject fileObject = URLMapper.findFileObject((URL)this.folderURL);
                if (fileObject == null) {
                    return;
                }
                FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Class.java");
                DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, this.superClassName);
                this.superClassURL = URLMapper.findURL((FileObject)dataObject2.getPrimaryFile(), (int)0);
                this.refactoring.getContext().add((Object)dataObject2.getPrimaryFile());
                JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject2.getPrimaryFile());
                javaSource.runModificationTask((Task)this).commit();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void undoChange() {
            FileObject fileObject = null;
            if (this.superClassURL != null) {
                fileObject = URLMapper.findFileObject((URL)this.superClassURL);
            }
            if (fileObject != null) {
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public String getText() {
            return NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"TXT_ExtractSC_CreateSC", (Object)this.superClassName);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.folderURL);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            FileObject fileObject = this.superClassURL == null ? null : URLMapper.findFileObject((URL)this.superClassURL);
            return fileObject != null ? Lookups.singleton((Object)fileObject) : Lookup.EMPTY;
        }

        public void cancel() {
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.RESOLVED);
            ClassTree classTree = CreateSuperclassElement.findClass((CompilationInfo)workingCopy, this.superClassName);
            boolean bl = false;
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            List list = ExtractSuperclassRefactoringPlugin.findUsedGenericTypes((CompilationInfo)workingCopy, (TypeElement)this.sourceType.resolve((CompilationInfo)workingCopy), this.refactoring);
            ArrayList<TypeParameterTree> arrayList = new ArrayList<TypeParameterTree>(list.size());
            TypeElement typeElement = (TypeElement)this.sourceType.resolve((CompilationInfo)workingCopy);
            for (TypeParameterElement object22 : typeElement.getTypeParameters()) {
                TypeMirror typeMirror = object22.asType();
                for (TypeMirror typeMirror2 : list) {
                    MemberInfo<ElementHandle<? extends Element>> memberInfo;
                    if (!workingCopy.getTypes().isSameType(typeMirror, typeMirror2) || (memberInfo = workingCopy.getTrees().getTree(object22)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                    arrayList.add((TypeParameterTree)((Object)memberInfo));
                }
            }
            ArrayList arrayList2 = new ArrayList();
            ArrayList<Tree> arrayList3 = new ArrayList<Tree>();
            CreateSuperclassElement.addConstructors(workingCopy, typeElement, arrayList2);
            for (MemberInfo<ElementHandle<? extends Element>> memberInfo : this.refactoring.getMembers()) {
                Tree tree;
                AnnotatedConstruct annotatedConstruct;
                ElementHandle elementHandle;
                if (memberInfo.getGroup() == MemberInfo.Group.FIELD) {
                    elementHandle = (ElementHandle)memberInfo.getElementHandle();
                    annotatedConstruct = (VariableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                    tree = (VariableTree)workingCopy.getTrees().getTree((Element)annotatedConstruct);
                    VariableTree variableTree = (VariableTree)generatorUtilities.importComments(tree, workingCopy.getTrees().getPath((Element)annotatedConstruct).getCompilationUnit());
                    variableTree = (VariableTree)generatorUtilities.importFQNs((Tree)variableTree);
                    arrayList2.add(variableTree);
                    continue;
                }
                if (memberInfo.getGroup() == MemberInfo.Group.METHOD) {
                    elementHandle = (ElementHandle)memberInfo.getElementHandle();
                    annotatedConstruct = (ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                    tree = workingCopy.getTrees().getTree((ExecutableElement)annotatedConstruct);
                    if (memberInfo.isMakeAbstract() && !annotatedConstruct.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        tree = treeMaker.Method(CreateSuperclassElement.makeAbstract(treeMaker, tree.getModifiers()), (CharSequence)tree.getName(), tree.getReturnType(), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), (BlockTree)null, null);
                        tree = (MethodTree)generatorUtilities.importFQNs(tree);
                        RetoucheUtils.copyJavadoc((Element)annotatedConstruct, tree, workingCopy);
                    } else {
                        tree = (MethodTree)generatorUtilities.importComments(tree, workingCopy.getTrees().getPath((Element)annotatedConstruct).getCompilationUnit());
                        tree = (MethodTree)generatorUtilities.importFQNs(tree);
                    }
                    bl |= tree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT);
                    arrayList2.add(tree);
                    continue;
                }
                if (memberInfo.getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                elementHandle = (TypeMirrorHandle)memberInfo.getElementHandle();
                annotatedConstruct = elementHandle.resolve((CompilationInfo)workingCopy);
                arrayList3.add(treeMaker.Type((TypeMirror)annotatedConstruct));
                bl |= true;
            }
            Tree tree = CreateSuperclassElement.makeSuperclass(treeMaker, typeElement);
            ModifiersTree modifiersTree = bl ? CreateSuperclassElement.makeAbstract(treeMaker, classTree.getModifiers()) : classTree.getModifiers();
            modifiersTree = (ModifiersTree)generatorUtilities.importFQNs((Tree)modifiersTree);
            ClassTree classTree2 = treeMaker.Class(modifiersTree, (CharSequence)classTree.getSimpleName(), arrayList, tree, arrayList3, Collections.emptyList());
            classTree2 = GeneratorUtilities.get((WorkingCopy)workingCopy).insertClassMembers(classTree2, (Iterable)arrayList2);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }

        private static ClassTree findClass(CompilationInfo compilationInfo, String string) {
            for (Tree tree : compilationInfo.getCompilationUnit().getTypeDecls()) {
                if (Tree.Kind.CLASS != tree.getKind() || compilationInfo.getTreeUtilities().isInterface((ClassTree)tree) || compilationInfo.getTreeUtilities().isAnnotation((ClassTree)tree) || compilationInfo.getTreeUtilities().isEnum((ClassTree)tree) || !string.contentEquals(((ClassTree)tree).getSimpleName())) continue;
                return (ClassTree)tree;
            }
            throw new IllegalStateException("wrong template, cannot find the class in " + compilationInfo.getFileObject());
        }

        private static ModifiersTree makeAbstract(TreeMaker treeMaker, ModifiersTree modifiersTree) {
            if (modifiersTree.getFlags().contains((Object)Modifier.ABSTRACT)) {
                return modifiersTree;
            }
            HashSet<Modifier> hashSet = new HashSet<Modifier>(modifiersTree.getFlags());
            hashSet.add(Modifier.ABSTRACT);
            hashSet.remove((Object)Modifier.FINAL);
            return treeMaker.Modifiers(hashSet, modifiersTree.getAnnotations());
        }

        private static Tree makeSuperclass(TreeMaker treeMaker, TypeElement typeElement) {
            DeclaredType declaredType = (DeclaredType)typeElement.getSuperclass();
            TypeElement typeElement2 = (TypeElement)declaredType.asElement();
            return typeElement2.getSuperclass().getKind() == TypeKind.NONE ? null : treeMaker.Type((TypeMirror)declaredType);
        }

        private static void addConstructors(WorkingCopy workingCopy, TypeElement typeElement, List<Tree> list) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            HashSet<Element> hashSet = new HashSet<Element>();
            for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
                StatementTree statementTree;
                Iterator<? extends StatementTree> iterator;
                TreePath treePath;
                MethodTree methodTree;
                if (workingCopy.getElementUtilities().isSynthetic((Element)executableElement) || (methodTree = (MethodTree)((treePath = workingCopy.getTrees().getPath(executableElement)) != null ? treePath.getLeaf() : null)) == null || !(iterator = methodTree.getBody().getStatements().iterator()).hasNext() || (statementTree = iterator.next()).getKind() != Tree.Kind.EXPRESSION_STATEMENT) continue;
                ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)statementTree;
                boolean bl = workingCopy.getTreeUtilities().isSynthetic(workingCopy.getTrees().getPath(treePath.getCompilationUnit(), expressionStatementTree));
                ExpressionTree expressionTree = expressionStatementTree.getExpression();
                TreePath treePath2 = workingCopy.getTrees().getPath(treePath.getCompilationUnit(), expressionTree);
                Element element = workingCopy.getTrees().getElement(treePath2);
                if (element == null || element.getKind() != ElementKind.CONSTRUCTOR || !hashSet.add(element)) continue;
                MethodTree methodTree2 = (MethodTree)workingCopy.getTrees().getTree(element);
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree;
                BlockTree blockTree = bl ? treeMaker.Block(Collections.emptyList(), false) : treeMaker.Block(Collections.singletonList(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), methodInvocationTree.getMethodSelect(), CreateSuperclassElement.params2Arguments(treeMaker, methodTree2.getParameters())))), false);
                MethodTree methodTree3 = treeMaker.Constructor(methodTree2.getModifiers(), methodTree2.getTypeParameters(), methodTree2.getParameters(), methodTree2.getThrows(), blockTree);
                methodTree3 = (MethodTree)generatorUtilities.importFQNs((Tree)methodTree3);
                list.add(methodTree3);
            }
        }

        private static List<? extends ExpressionTree> params2Arguments(TreeMaker treeMaker, List<? extends VariableTree> list) {
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IdentifierTree> arrayList = new ArrayList<IdentifierTree>(list.size());
            for (VariableTree variableTree : list) {
                arrayList.add(treeMaker.Identifier((CharSequence)variableTree.getName()));
            }
            return arrayList;
        }
    }
}

