/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.api;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.swing.Icon;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.UiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemberInfo<H> {
    private H member;
    private String htmlText;
    private Icon icon;
    private Group group;
    private Set<Modifier> modifiers;
    private boolean makeAbstract;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    private MemberInfo(H h, String string, String string2, Icon icon) {
        this.member = h;
        this.htmlText = string2;
        this.icon = icon;
        this.name = string;
    }

    public H getElementHandle() {
        return this.member;
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public static <T extends TypeMirror> MemberInfo<TypeMirrorHandle<T>> create(T t, Tree tree, CompilationInfo compilationInfo) {
        MemberInfo<TypeMirrorHandle<T>> memberInfo = new MemberInfo<TypeMirrorHandle<T>>(TypeMirrorHandle.create(t), tree.toString(), "implements " + tree.toString(), UiUtils.getElementIcon((ElementKind)ElementKind.INTERFACE, null));
        memberInfo.group = Group.IMPLEMENTS;
        return memberInfo;
    }

    public static <T extends Element> MemberInfo<ElementHandle<T>> create(T t, CompilationInfo compilationInfo) {
        String string = "%name%";
        Group group = Group.TYPE;
        if (t.getKind() == ElementKind.FIELD) {
            string = string + " : %type%";
            group = Group.FIELD;
        } else if (t.getKind() == ElementKind.METHOD) {
            string = string + "%parameters% : %type%";
            group = Group.METHOD;
        }
        MemberInfo<ElementHandle<T>> memberInfo = new MemberInfo<ElementHandle<T>>(ElementHandle.create(t), t.getSimpleName().toString(), UiUtils.getHeader(t, (CompilationInfo)compilationInfo, (String)string), UiUtils.getDeclarationIcon(t));
        memberInfo.modifiers = t.getModifiers();
        memberInfo.group = group;
        return memberInfo;
    }

    public static <T extends Element> MemberInfo<ElementHandle<T>> create(T t, CompilationInfo compilationInfo, Group group) {
        MemberInfo<ElementHandle<T>> memberInfo = new MemberInfo<ElementHandle<T>>(ElementHandle.create(t), t.getSimpleName().toString(), UiUtils.getHeader(t, (CompilationInfo)compilationInfo, (String)"%name%"), UiUtils.getDeclarationIcon(t));
        memberInfo.group = group;
        memberInfo.modifiers = t.getModifiers();
        return memberInfo;
    }

    public static MemberInfo<TreePathHandle> create(TreePath treePath, CompilationInfo compilationInfo) {
        String string = "%name%";
        Group group = null;
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element.getKind() == ElementKind.FIELD) {
            string = string + " : %type%";
            group = Group.FIELD;
        } else if (element.getKind() == ElementKind.METHOD) {
            string = string + "%parameters% : %type%";
            group = Group.METHOD;
        } else if (element.getKind().isInterface()) {
            group = Group.IMPLEMENTS;
            string = "implements " + string;
        }
        MemberInfo<TreePathHandle> memberInfo = new MemberInfo<TreePathHandle>(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), element.getSimpleName().toString(), UiUtils.getHeader((Element)element, (CompilationInfo)compilationInfo, (String)string), UiUtils.getDeclarationIcon((Element)element));
        memberInfo.modifiers = element.getModifiers();
        memberInfo.group = group;
        return memberInfo;
    }

    private MemberInfo(H h, String string, Icon icon, String string2, Group group, Set<Modifier> set, boolean bl) {
        this.member = h;
        this.htmlText = string;
        this.icon = icon;
        this.name = string2;
        this.group = group;
        this.modifiers = set;
        this.makeAbstract = bl;
    }

    public static <T extends TypeMirror> MemberInfo<TypeMirrorHandle<T>> createImplements(TypeMirrorHandle typeMirrorHandle, String string, Icon icon, String string2) {
        return new MemberInfo<TypeMirrorHandle<T>>(typeMirrorHandle, string, icon, string2, Group.IMPLEMENTS, Collections.<Modifier>emptySet(), false);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean equals(Object object) {
        if (object instanceof MemberInfo && ((MemberInfo)object).member instanceof ElementHandle) {
            return ((ElementHandle)((MemberInfo)object).member).signatureEquals((ElementHandle)this.member);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public boolean isMakeAbstract() {
        return this.makeAbstract;
    }

    public void setMakeAbstract(Boolean bl) {
        this.makeAbstract = bl;
    }

    public String toString() {
        return this.htmlText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Group {
        IMPLEMENTS,
        METHOD,
        FIELD,
        TYPE;

    }
}

