/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.wizard.FindWizardPanel;
import org.netbeans.modules.mobility.cldcplatform.wizard.SearchRunnable;
import org.netbeans.modules.mobility.cldcplatform.wizard.WindowsRegistryReader;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class FindPanel
extends JPanel
implements SearchRunnable.Notifier {
    static File DEFAULT_DIR = null;
    static final String PROP_PLATFORM_FOLDERS = "PlatformFolders";
    private static final String ALREADY_INSTALLED = NbBundle.getMessage(FindPanel.class, (String)"msg_already_installed");
    private final DefaultListModel platformsListModel = new DefaultListModel();
    private final CheckListener checkListener = new CheckListener();
    private final FoldersRenderer foldersRenderer = new FoldersRenderer();
    private final Set<File> selectedFolders = new HashSet<File>();
    private final Set<File> installedFolders = new HashSet<File>();
    private final FindWizardPanel wizardPanel;
    private RequestProcessor.Task searchTask;
    private SearchRunnable searchRunnable;
    private Set<File> visitedDirectories = null;
    private WizardDescriptor wizardDescriptor;
    private JButton jButton1;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JList platformsList;

    public FindPanel(FindWizardPanel findWizardPanel) {
        JavaPlatform[] javaPlatformArray;
        this.wizardPanel = findWizardPanel;
        for (JavaPlatform javaPlatform : javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            for (FileObject fileObject : javaPlatform.getInstallFolders()) {
                this.installedFolders.add(FileUtil.toFile((FileObject)fileObject));
            }
        }
        this.initComponents();
        this.platformsList.addMouseListener(this.checkListener);
        this.platformsList.addKeyListener(this.checkListener);
    }

    public void showError(String string) {
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.platformsList = new JList();
        this.jButton1 = new JButton();
        this.setName(NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Platforms"));
        this.setPreferredSize(new Dimension(540, 450));
        this.setLayout(new GridBagLayout());
        this.jLabel5.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Select_Platforms"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindPanel.class, (String)"ACSD_FindPanel_Select_Platform"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 150));
        this.platformsList.setModel(this.platformsListModel);
        this.platformsList.setSelectionMode(0);
        this.platformsList.setCellRenderer(this.foldersRenderer);
        this.jScrollPane1.setViewportView(this.platformsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Find_More"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindPanel.class, (String)"ACSD_FindPanel_Find_More"));
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        Object object;
        if (this.searchTask != null && !this.searchTask.isFinished()) {
            return;
        }
        if (DEFAULT_DIR == null && ((File[])(object = File.listRoots())).length > 0) {
            DEFAULT_DIR = object[0];
        }
        object = new JFileChooser(DEFAULT_DIR);
        ((JFileChooser)object).setDialogType(0);
        ((JFileChooser)object).setFileSelectionMode(1);
        ((JFileChooser)object).setMultiSelectionEnabled(false);
        ((JFileChooser)object).setControlButtonsAreShown(true);
        ((JFileChooser)object).setDialogTitle(NbBundle.getMessage(FindPanel.class, (String)"Title_FindPanel_Choose_To_Search"));
        if (((JFileChooser)object).showDialog(this, NbBundle.getMessage(FindPanel.class, (String)"LBL_FindPanel_Search")) == 0) {
            this.searchRunnable = new SearchRunnable((SearchRunnable.Notifier)this, ((JFileChooser)object).getSelectedFile(), -1);
            this.jButton1.setEnabled(false);
            this.showError(NbBundle.getMessage(FindPanel.class, (String)"WARN_SearchInProgress"));
            this.searchTask = RequestProcessor.getDefault().post((Runnable)this.searchRunnable);
        }
        DEFAULT_DIR = ((JFileChooser)object).getSelectedFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        if (this.visitedDirectories == null) {
            this.visitedDirectories = new HashSet<File>();
            this.jButton1.setEnabled(false);
            DefaultListModel defaultListModel = this.platformsListModel;
            synchronized (defaultListModel) {
                this.platformsListModel.clear();
            }
            this.showError(NbBundle.getMessage(FindPanel.class, (String)"WARN_SearchInProgress"));
            this.searchRunnable = new SearchRunnable((SearchRunnable.Notifier)this, WindowsRegistryReader.traverseRegistry(), 3);
            this.searchTask = RequestProcessor.getDefault().post((Runnable)this.searchRunnable);
        }
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        if (this.searchRunnable != null) {
            this.searchRunnable.stop();
            this.searchTask.waitFinished();
            this.searchRunnable = null;
            this.searchTask = null;
        }
        wizardDescriptor.putProperty(PROP_PLATFORM_FOLDERS, this.selectedFolders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPossiblePlatformFound(File file) {
        if (this.visitedDirectories.contains(file)) {
            return;
        }
        this.visitedDirectories.add(file);
        if (!this.installedFolders.contains(file)) {
            this.selectedFolders.add(file);
        }
        DefaultListModel defaultListModel = this.platformsListModel;
        synchronized (defaultListModel) {
            this.platformsListModel.addElement(file);
        }
        int n = this.platformsListModel.size() - 1;
        Rectangle rectangle = this.platformsList.getCellBounds(n, n);
        if (rectangle != null) {
            this.platformsList.scrollRectToVisible(rectangle);
        }
        this.wizardPanel.fireChanged();
    }

    public void notifySearchFinished() {
        this.jButton1.setEnabled(true);
        this.wizardPanel.fireChanged();
        if (this.platformsListModel.isEmpty()) {
            this.jButton1ActionPerformed(null);
        }
    }

    public boolean isValid() {
        if (this.selectedFolders.isEmpty()) {
            this.showError(NbBundle.getMessage(FindPanel.class, (String)"ERR_NothingSelected"));
            return false;
        }
        this.showError(null);
        return true;
    }

    private class FoldersRenderer
    extends JCheckBox
    implements ListCellRenderer {
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public FoldersRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? FindPanel.this.platformsList.getSelectionBackground() : FindPanel.this.platformsList.getBackground());
            this.setForeground(bl ? FindPanel.this.platformsList.getSelectionForeground() : FindPanel.this.platformsList.getForeground());
            Border border = null;
            if (bl2) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
            this.setBorder(border != null ? border : this.emptyBorder);
            this.setSelected(FindPanel.this.selectedFolders.contains(object));
            if (FindPanel.this.installedFolders.contains(object)) {
                this.setText(object.toString() + ALREADY_INSTALLED);
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class CheckListener
    implements MouseListener,
    KeyListener {
        CheckListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getX() < 20) {
                this.check();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                this.check();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void check() {
            File file = (File)FindPanel.this.platformsList.getSelectedValue();
            if (file != null) {
                if (!FindPanel.this.selectedFolders.remove(file)) {
                    FindPanel.this.selectedFolders.add(file);
                }
                FindPanel.this.platformsList.repaint();
                FindPanel.this.wizardPanel.fireChanged();
            }
        }
    }
}

